/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.PegasusPurchaseServiceFacade;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobLine;
import com.thebeastshop.pegasus.service.purchase.service.PrdcJobLineService;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;

/**
 * @author Eric.Lou
 * @version $Id: PrdcJobLineVO.java, v 0.1 2016-01-04 上午10:37
 */
public class PrdcJobLineVO extends PrdcJobLine implements Serializable {

    private PegasusPurchaseServiceFacade pcsFacade =  PegasusPurchaseServiceFacade.getInstance();

    // constructor
    public PrdcJobLineVO(){}

    //base
    private Long id;
    private String skuCode;

    // self
    private String skuName;

    /**
     * 创建时配方数量
     */

    // manual generate

    // auto generate
    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getSkuCode() {
        return skuCode;
    }

    @Override
    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    //others
    /**
     *获取WMS实际消耗
     * @return
     */
    public Integer getRealConsumeAmount(){
        if (EmptyUtil.isEmpty(this.skuCode) || NumberUtil.isNullOrZero(this.id)) return null;
        return pcsFacade.getJobLineRealConsumeAmount(this.id,this.skuCode);
    }


    /**
     * 耗材类型
     */
    public static final Integer MATERIAL_TYPE_MAIN = 1;//主耗材

    public static final Integer MATERIAL_TYPE_AUXILIARY = 2;//符耗材
}
