package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.model.PcsSkuAutoApproveBgm;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 财务自动审批规则参数设置
 * @author xw
 * @create 2018-11-22 15:19
 */
public class PcsSkuFinanceAutoApproveRuleVO extends PcsSkuFinanceAutoApproveRule {

    public static final String ENTITY_ID_LOG = "FINANCE_AUTO_APPROVE_RULE";
    public static final String ENTITY_CLASS_LOG = "PcsSkuFinanceAutoApproveRuleVO";

    // 自动审批类型 1原材料 2半成品
    public static final Integer AUTO_APPROVE_TYPE_RAW_MATERIAL = 1;
    public static final Integer AUTO_APPROVE_TYPE_SEMIFINISHED_PRODUCT = 2;
    public static final String AUTO_APPROVE_TYPE_RAW_MATERIAL_STR = "原材料";
    public static final String AUTO_APPROVE_TYPE_SEMIFINISHED_PRODUCT_STR = "半成品";

    public static final Map<Integer,String> AUTO_APPROVE_TYPE_MAP = new HashMap<Integer,String>(){{
        put(AUTO_APPROVE_TYPE_RAW_MATERIAL, AUTO_APPROVE_TYPE_RAW_MATERIAL_STR);
        put(AUTO_APPROVE_TYPE_SEMIFINISHED_PRODUCT, AUTO_APPROVE_TYPE_SEMIFINISHED_PRODUCT_STR);
    }};

    // 0成本自动审批 1普通商品 2赠品 3试用装
    public static final Integer ZERO_COST_AUTO_APPROVE_GENERAL_GOODS = 1;
    public static final Integer ZERO_COST_AUTO_APPROVE_GIFT = 2;
    public static final Integer ZERO_COST_AUTO_APPROVE_SAMPLE_SACK = 3;
    public static final String ZERO_COST_AUTO_APPROVE_GENERAL_GOODS_STR = "普通商品";
    public static final String ZERO_COST_AUTO_APPROVE_GIFT_STR = "赠品";
    public static final String ZERO_COST_AUTO_APPROVE_SAMPLE_SACK_STR = "试用装";

    public static final Map<Integer,String> ZERO_COST_AUTO_APPROVE_MAP = new HashMap<Integer,String>(){{
        put(ZERO_COST_AUTO_APPROVE_GENERAL_GOODS, ZERO_COST_AUTO_APPROVE_GENERAL_GOODS_STR);
        put(ZERO_COST_AUTO_APPROVE_GIFT, ZERO_COST_AUTO_APPROVE_GIFT_STR);
        put(ZERO_COST_AUTO_APPROVE_SAMPLE_SACK, ZERO_COST_AUTO_APPROVE_SAMPLE_SACK_STR);
    }};

    // sku采购模式【1代销 2经销非进口 3经销进口跨境 4经销进口非跨境】
    public static final Integer SALE_PROXY = 1;
    public static final Integer SALE_NO_IMPORTED = 2;
    public static final Integer SALE_IMPORTED_CROSS_BORDER = 3;
    public static final Integer SALE_IMPORTED_NO_CROSS_BORDER = 4;

    public static final String SALE_PROXY_STR = "代销";
    public static final String SALE_NO_IMPORTED_STR = "经销非进口";
    public static final String SALE_IMPORTED_CROSS_BORDER_STR = "经销进口跨境";
    public static final String SALE_IMPORTED_NO_CROSS_BORDER_STR = "经销进口非跨境";

    // SKU成本上浮  取值key
    public static final Integer SKU_COST_RISE_UNDER = 1;
    // 耗材成本上浮 取值key
    public static final Integer MATERIAL_COST_RISE_UNDER = 2;

    private Long id;

    private List<String> categoryNames;

    private String autoApproveTypesStr;

    private String zeroCostAutoApprovesStr;

    private List<PcsSkuAutoApproveBgm> skuAutoApproveBgms;

    private List<PcsSkuAutoApproveBgmVO> skuAutoApproveBgmVOs;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<String> getCategoryNames() {
        return categoryNames;
    }

    public void setCategoryNames(List<String> categoryNames) {
        this.categoryNames = categoryNames;
    }

    @Override
    public String toString() {
        return "PcsSkuFinanceAutoApproveRuleVO{" +
                "categoryName=" + categoryNames +
                '}';
    }

    public String toCustomString() {
        return "更新{" +
                "自动审批品类=" + this.categoryNames + "," +
                " 自动审批类型=" + this.getAutoApproveTypesStr() +
                " 0成本自动审批=" + this.getZeroCostAutoApprovesStr() +
                " 成本上浮低于=" + this.getCostRiseUnderPercent() + "," +
                " 耗材成本上浮低于=" + this.getMaterialCostRiseUnderPercent() +
                "}";
    }

    public String getCostRiseUnderPercent() {
        if (EmptyUtil.isNotEmpty(this.getCostRiseUnder())){
            return new BigDecimal(this.getCostRiseUnder()).multiply(new BigDecimal(100)).setScale(BigDecimal.ROUND_UP)+"%";
        }
        return "";
    }

    public String getMaterialCostRiseUnderPercent() {
        if (EmptyUtil.isNotEmpty(this.getMaterialCostRiseUnder())){
            return new BigDecimal(this.getMaterialCostRiseUnder()).multiply(new BigDecimal(100)).setScale(BigDecimal.ROUND_UP)+"%";
        }
        return "";
    }

    public String getAutoApproveTypesStr() {
        if (EmptyUtil.isEmpty(autoApproveTypesStr) && EmptyUtil.isNotEmpty(this.getAutoApproveTypes())){
            autoApproveTypesStr = "";
            if (this.getAutoApproveTypes().contains(AUTO_APPROVE_TYPE_RAW_MATERIAL)){
                autoApproveTypesStr += AUTO_APPROVE_TYPE_RAW_MATERIAL_STR+",";
            }
            if (this.getAutoApproveTypes().contains(AUTO_APPROVE_TYPE_SEMIFINISHED_PRODUCT)){
                autoApproveTypesStr += AUTO_APPROVE_TYPE_SEMIFINISHED_PRODUCT_STR+",";
            }
        }
        if (autoApproveTypesStr == null){
            autoApproveTypesStr = "";
        }
        return autoApproveTypesStr;
    }

    public void setAutoApproveTypesStr(String autoApproveTypesStr) {
        this.autoApproveTypesStr = autoApproveTypesStr;
    }

    public String getZeroCostAutoApprovesStr() {
        if (EmptyUtil.isEmpty(zeroCostAutoApprovesStr) && EmptyUtil.isNotEmpty(this.getZeroCostAutoApproves())){
            zeroCostAutoApprovesStr = "";
            if (this.getZeroCostAutoApproves().contains(ZERO_COST_AUTO_APPROVE_GENERAL_GOODS)){
                zeroCostAutoApprovesStr += ZERO_COST_AUTO_APPROVE_GENERAL_GOODS_STR+",";
            }
            if (this.getZeroCostAutoApproves().contains(ZERO_COST_AUTO_APPROVE_GIFT)){
                zeroCostAutoApprovesStr += ZERO_COST_AUTO_APPROVE_GIFT_STR+",";
            }
            if (this.getZeroCostAutoApproves().contains(ZERO_COST_AUTO_APPROVE_SAMPLE_SACK)){
                zeroCostAutoApprovesStr += ZERO_COST_AUTO_APPROVE_SAMPLE_SACK_STR+",";
            }
        }
        if (zeroCostAutoApprovesStr == null){
            zeroCostAutoApprovesStr = "";
        }
        return zeroCostAutoApprovesStr;
    }

    public void setZeroCostAutoApprovesStr(String zeroCostAutoApprovesStr) {
        this.zeroCostAutoApprovesStr = zeroCostAutoApprovesStr;
    }

    public List<PcsSkuAutoApproveBgm> getSkuAutoApproveBgms() {
        return skuAutoApproveBgms;
    }

    public void setSkuAutoApproveBgms(List<PcsSkuAutoApproveBgm> skuAutoApproveBgms) {
        this.skuAutoApproveBgms = skuAutoApproveBgms;
    }

    public List<PcsSkuAutoApproveBgmVO> getSkuAutoApproveBgmVOs() {
        return skuAutoApproveBgmVOs;
    }

    public void setSkuAutoApproveBgmVOs(List<PcsSkuAutoApproveBgmVO> skuAutoApproveBgmVOs) {
        this.skuAutoApproveBgmVOs = skuAutoApproveBgmVOs;
    }
}
