package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCertificate;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCertificateSpecial;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import com.thebeastshop.pegasus.util.vo.FileResponseVO;

import java.util.List;

/**
 * Created by Administrator on 2016/11/22.
 */
public class PcsSkuCertificateVO extends PcsSkuCertificate {

    //是否有中文标签
    final public static Integer HAS_TAG_YES = 1;//是，有

    final public static Integer HAS_TAG_NO = 0;//否，没有

    //0取消1通过2特殊放行3未审核
    final public static Integer CHECK_STATUS_CANCLE = 0;

    final public static Integer CHECK_STATUS_PASS = 1;

    final public static Integer CHECK_STATUS_SPECAL_PASS = 2;

    final public static Integer CHECK_STATUS_NOT_AUDITED = 3;

    //是否提交：0没提交1已提交
    final public static Integer SUBMIT_STATUS_NOT_SUBMIT = 0;

    final public static Integer SUBMIT_STATUS_SUBMITTED = 1;

    //是否进口:0进口非 1进口
    final public static Integer IMPORT_NO = 0;

    final public static Integer IMPORT_YES = 1;

    //标签类型: 1中文标签 2简易标签
    final public static Integer CER_TYPE_NORMAL = 1;

    final public static Integer CER_TYPE_SIMPLE = 2;

    //是否需要生产日期1是0否
    final public static Integer NEED_PROD_DATE_YES = 1;

    final public static Integer NEED_PROD_DATE_NO = 0;

    //是否需要打印小程序码1是0否
    final public static Integer PRINT_MP_CODE_YES = 1;

    final public static Integer PRINT_MP_CODE_NO = 0;

    private List<PcsSkuCertificateFieldVO> fieldList;//合格证标签字段

    private List<PcsSkuCertificateSpecial> specialList;//合格证特殊维护字段

    private String barCode;//批次码

    private String skuName;//sku名
    private String skuImg;//sku图片

    private String skuBrandName;//品牌名

    private String skuCategoryFullName;//品类全名

    private String skuCategoryName;//品类名

    private String skuPlaceOfOrigin;//产地

    private Integer skuIsImported;//进口

    private String skuBuyerName;//采购员

    private Integer skuType; // sku类型

    private Integer shelfLife; // 保质期

    // 配方ID
    private Long recipeId;
    // 耗材ID
    private Long materialId;

    private List<CommFileRef> commFileRefs;

    private List<FileResponseVO> fileList;

    private String mPCodeUrl;

    // 模版间距
    private String tplMarginTop;
    private String tplSideMargin;
    private String tplLineHeight;

    public List<FileResponseVO> getFileList() {
        return fileList;
    }

    public void setFileList(List<FileResponseVO> fileList) {
        this.fileList = fileList;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public List<PcsSkuCertificateFieldVO> getFieldList() {
        return fieldList;
    }

    public void setFieldList(List<PcsSkuCertificateFieldVO> fieldList) {
        this.fieldList = fieldList;
    }

    public List<PcsSkuCertificateSpecial> getSpecialList() {
        return specialList;
    }

    public void setSpecialList(List<PcsSkuCertificateSpecial> specialList) {
        this.specialList = specialList;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getSkuImg() {
        return skuImg;
    }

    public void setSkuImg(String skuImg) {
        this.skuImg = skuImg;
    }

    public String getSkuBuyerName() {
        return skuBuyerName;
    }

    public void setSkuBuyerName(String skuBuyerName) {
        this.skuBuyerName = skuBuyerName;
    }

    public String getSkuBrandName() {
        return skuBrandName;
    }

    public void setSkuBrandName(String skuBrandName) {
        this.skuBrandName = skuBrandName;
    }

    public String getSkuCategoryFullName() {
        return skuCategoryFullName;
    }

    public void setSkuCategoryFullName(String skuCategoryFullName) {
        this.skuCategoryFullName = skuCategoryFullName;
    }

    public String getSkuPlaceOfOrigin() {
        return skuPlaceOfOrigin;
    }

    public void setSkuPlaceOfOrigin(String skuPlaceOfOrigin) {
        this.skuPlaceOfOrigin = skuPlaceOfOrigin;
    }

    public Integer getSkuIsImported() {
        return skuIsImported;
    }

    public void setSkuIsImported(Integer skuIsImported) {
        this.skuIsImported = skuIsImported;
    }

    public String getSkuCategoryName() {
        return skuCategoryName;
    }

    public void setSkuCategoryName(String skuCategoryName) {
        this.skuCategoryName = skuCategoryName;
    }

    public Integer getSkuType() {
        return skuType;
    }

    public void setSkuType(Integer skuType) {
        this.skuType = skuType;
    }

    public Integer getShelfLife() {
        return shelfLife;
    }

    public void setShelfLife(Integer shelfLife) {
        this.shelfLife = shelfLife;
    }

    public String getSkuTypeStr() {
        return this.getSkuType()==null?"":
                this.getSkuType().equals(1)?"原材料":
                        this.getSkuType().equals(2)?"半成品":
                                this.getSkuType().equals(3)?"成品":"";
    }

    public String getCheckStatusStr() {
        return this.getCheckStatus()==null?"高风险":
                this.getCheckStatus().equals(0)?"取消":
                    this.getCheckStatus().equals(1)?"无风险":
                        this.getCheckStatus().equals(2)?"低风险":
                                this.getCheckStatus().equals(3)?"高风险":"";
    }

    public String getCerTypeStr() {
        return this.getCerType()==null?"":
                this.getCerType().equals(1)?"中文标签":
                this.getCerType().equals(2)?"简易标签":"";
    }

    public String getIsHasTagStr() {
        return this.getIsHasTag()==null?"":
                this.getIsHasTag().equals(HAS_TAG_YES)?"是":
                        this.getIsHasTag().equals(HAS_TAG_NO)?"否":"";
    }

    public String getNeedProdDateStr() {
        return this.getNeedProdDate()==null?"否":
                this.getNeedProdDate().equals(NEED_PROD_DATE_YES)?"是":
                        this.getNeedProdDate().equals(NEED_PROD_DATE_NO)?"否":"";
    }

    public String getmPCodeUrl() {
        return mPCodeUrl;
    }

    public void setmPCodeUrl(String mPCodeUrl) {
        this.mPCodeUrl = mPCodeUrl;
    }

    public String getTplMarginTop() {
        return tplMarginTop;
    }

    public void setTplMarginTop(String tplMarginTop) {
        this.tplMarginTop = tplMarginTop;
    }

    public String getTplSideMargin() {
        return tplSideMargin;
    }

    public void setTplSideMargin(String tplSideMargin) {
        this.tplSideMargin = tplSideMargin;
    }

    public String getTplLineHeight() {
        return tplLineHeight;
    }

    public void setTplLineHeight(String tplLineHeight) {
        this.tplLineHeight = tplLineHeight;
    }

    public Long getRecipeId() {
        return recipeId;
    }

    public void setRecipeId(Long recipeId) {
        this.recipeId = recipeId;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public List<CommFileRef> getCommFileRefs() {
        return commFileRefs;
    }

    public void setCommFileRefs(List<CommFileRef> commFileRefs) {
        this.commFileRefs = commFileRefs;
    }
}
