package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseReturn;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class PcsPurchaseReturnVO extends PcsPurchaseReturn implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8366299747374087879L;
	

	private List<PcsPurchaseReturnSkuVO> returnSkuVOList;
	
	private boolean saveDraft;
	
	private String poCode;
	
	private String createOperatorName;
	
	private String supplierNameCn;
	
	private String districtFullName;
	
	//退货金额
	private BigDecimal returnAmount;
	
	//实际退货金额
	private BigDecimal actualReturnAmount;
	
	//状态对应的中文
	private String returnStatusName;

    // 逻辑仓
    private String warehouseName;
    // 物理仓
    private String physicalWarehouseName;

    // 创建来源
    private String originType;

    private boolean checked;

    private String cityFullName;

    private Integer commodityStatus;//商品状态

    // QC采购残次处理时，创建的采退单
    public static final String ORIGIN_TYPE_QC_DEFECTIVE_PROCESS = "QC_DEFECTIVE_PROCESS";
    //采购单 币种汇率
    public BigDecimal purchaseCurrencyRate;

	public BigDecimal getReturnAmount() {
		returnAmount = new BigDecimal(0);
		if(EmptyUtil.isNotEmpty(returnSkuVOList)) {
			for(PcsPurchaseReturnSkuVO pcsPurchaseReturnSkuVO : returnSkuVOList) {
				returnAmount = returnAmount.add(new BigDecimal(pcsPurchaseReturnSkuVO.getExpectedQuantity() == null ? 0 : pcsPurchaseReturnSkuVO.getExpectedQuantity()).
						multiply(pcsPurchaseReturnSkuVO.getReturnUnitPrice() == null ? new BigDecimal(0) : pcsPurchaseReturnSkuVO.getReturnUnitPrice()));
			}
		}
		return returnAmount;
	}


	public void setReturnAmount(BigDecimal returnAmount) {
		this.returnAmount = returnAmount;
	}


	public BigDecimal getActualReturnAmount() {
		actualReturnAmount = new BigDecimal(0);
		if(EmptyUtil.isNotEmpty(returnSkuVOList)) {
			for(PcsPurchaseReturnSkuVO pcsPurchaseReturnSkuVO : returnSkuVOList) {
				actualReturnAmount = actualReturnAmount.add(new BigDecimal(pcsPurchaseReturnSkuVO.getRealityQuantity() == null ? 0 : pcsPurchaseReturnSkuVO.getRealityQuantity()).
						multiply(pcsPurchaseReturnSkuVO.getReturnUnitPrice() == null ? new BigDecimal(0) : pcsPurchaseReturnSkuVO.getReturnUnitPrice()));
			}
		}
		return actualReturnAmount;
	}


	public void setActualReturnAmount(BigDecimal actualReturnAmount) {
		this.actualReturnAmount = actualReturnAmount;
	}


	public String getDistrictFullName() {
		return districtFullName;
	}


	public void setDistrictFullName(String districtFullName) {
		this.districtFullName = districtFullName;
	}


	public String getPoCode() {
		return poCode;
	}


	public void setPoCode(String poCode) {
		this.poCode = poCode;
	}


	public String getCreateOperatorName() {
		return createOperatorName;
	}


	public void setCreateOperatorName(String createOperatorName) {
		this.createOperatorName = createOperatorName;
	}


	public String getSupplierNameCn() {
		return supplierNameCn;
	}


	public void setSupplierNameCn(String supplierNameCn) {
		this.supplierNameCn = supplierNameCn;
	}


	public boolean isSaveDraft() {
		return saveDraft;
	}


	public void setSaveDraft(boolean saveDraft) {
		this.saveDraft = saveDraft;
	}


	public List<PcsPurchaseReturnSkuVO> getReturnSkuVOList() {
		return returnSkuVOList;
	}


	public void setReturnSkuVOList(List<PcsPurchaseReturnSkuVO> returnSkuVOList) {
		this.returnSkuVOList = returnSkuVOList;
	}

	public String getLogisticsPaymentSideStr(){
		return LOGISTICS_PAYMENT_SIDE_SENDER_PAY.equals(getLogisticsPaymentSide())?"寄方付":
				LOGISTICS_PAYMENT_SIDE_RECIPIENT_PAY.equals(getLogisticsPaymentSide())?"收方付":"";
	}

	public static List<KeyValueVO> getALLLogisticsPaymentSide(){
		List<KeyValueVO> list = new ArrayList<>();
		list.add(new KeyValueVO(LOGISTICS_PAYMENT_SIDE_SENDER_PAY.toString(),"寄方付"));
		list.add(new KeyValueVO(LOGISTICS_PAYMENT_SIDE_RECIPIENT_PAY.toString(),"收方付"));
		return list;
	}


	public String getReturnStatusName() {
		switch(this.getReturnStatus()) {
			case  1 :
				return "草稿";
			case  2 :
				return "待审批";
			case  3 :
				return "已驳回";
			case  4 :
				return "待发送";
			case  12 :
				return "已完成";
			case  -1 :
				return "已取消";
			case  -2 :
				return "出库取消";
				
				default:
					
					break;
		}
		return returnStatusName;
	}

	public void setReturnStatusName(String returnStatusName) {
		this.returnStatusName = returnStatusName;
	}

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public String getOriginType() {
        return originType;
    }

    public void setOriginType(String originType) {
        this.originType = originType;
    }

    public boolean isChecked() {
        return checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

	public Integer getCommodityStatus() {
		return commodityStatus;
	}

	public void setCommodityStatus(Integer commodityStatus) {
		this.commodityStatus = commodityStatus;
	}

	public String getCityFullName() {
        return cityFullName;
    }

    public void setCityFullName(String cityFullName) {
        this.cityFullName = cityFullName;
    }

	public BigDecimal getPurchaseCurrencyRate() {
		return purchaseCurrencyRate;
	}

	public void setPurchaseCurrencyRate(BigDecimal purchaseCurrencyRate) {
		this.purchaseCurrencyRate = purchaseCurrencyRate;
	}
}
