package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseReturnSku;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.wms.vo.WhWarehouseVO;

import java.math.BigDecimal;

public class PcsPurchaseReturnSkuVO extends PcsPurchaseReturnSku {

	private BigDecimal costPrice;
	  
	private BigDecimal unitPrice;
	  
	private Integer quantity; //需求数量
	  
	private String skuNameCn;
	
	//实际已退良品数量汇总
	private Integer goodRealityQuantity;
	
	//实际已退残次数量汇总
	private Integer wasteRealityQuantity;

    // 已收待定
    private Integer receivedHoldPendingQuantity;
    // 已退待定
    private Integer refundedHoldPendingQuantity;

    // 其它已退 not in(0, 1, 8)
    private Integer otherRefundedQuantity;

    //实际已退待定数量汇总
    private Integer holdPendingRealityQuantity;

    // 实际已退其它数量
    private Integer otherRealityQuantity;

/*	// 税率(poLine中的调整税率，如果为空，则取税率)
    private BigDecimal taxRate;

    // 【税前金额】=实际采退金额/（1+税率）
    private BigDecimal taxRatebeforePrice;*/

    private String skuTypeName;

	public String getSkuNameCn() {
		return skuNameCn;
	}

	public void setSkuNameCn(String skuNameCn) {
		this.skuNameCn = skuNameCn;
	}

	public BigDecimal getCostPrice() {
		return costPrice;
	}

	public void setCostPrice(BigDecimal costPrice) {
		this.costPrice = costPrice;
	}

	public BigDecimal getUnitPrice() {
		return unitPrice;
	}

	public void setUnitPrice(BigDecimal unitPrice) {
		this.unitPrice = unitPrice;
	}

	public Integer getQuantity() {
		return quantity;
	}

	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}

	public Integer getGoodRealityQuantity() {
		return goodRealityQuantity;
	}

	public void setGoodRealityQuantity(Integer goodRealityQuantity) {
		this.goodRealityQuantity = goodRealityQuantity;
	}

	public Integer getWasteRealityQuantity() {
		return wasteRealityQuantity;
	}

	public void setWasteRealityQuantity(Integer wasteRealityQuantity) {
		this.wasteRealityQuantity = wasteRealityQuantity;
	}

    public Integer getReceivedHoldPendingQuantity() {
        return receivedHoldPendingQuantity;
    }

    public void setReceivedHoldPendingQuantity(Integer receivedHoldPendingQuantity) {
        this.receivedHoldPendingQuantity = receivedHoldPendingQuantity;
    }

    public Integer getRefundedHoldPendingQuantity() {
        return refundedHoldPendingQuantity;
    }

    public void setRefundedHoldPendingQuantity(Integer refundedHoldPendingQuantity) {
        this.refundedHoldPendingQuantity = refundedHoldPendingQuantity;
    }

    public Integer getOtherRefundedQuantity() {
        return otherRefundedQuantity;
    }

    public void setOtherRefundedQuantity(Integer otherRefundedQuantity) {
        this.otherRefundedQuantity = otherRefundedQuantity;
    }

    public Integer getHoldPendingRealityQuantity() {
        return holdPendingRealityQuantity;
    }

    public void setHoldPendingRealityQuantity(Integer holdPendingRealityQuantity) {
        this.holdPendingRealityQuantity = holdPendingRealityQuantity;
    }

    public Integer getOtherRealityQuantity() {
        return otherRealityQuantity;
    }

    public void setOtherRealityQuantity(Integer otherRealityQuantity) {
        this.otherRealityQuantity = otherRealityQuantity;
    }

    public String getSkuTypeName() {
        if (EmptyUtil.isEmpty(skuTypeName)){
            if (EmptyUtil.isEmpty(this.getSkuType())){
                skuTypeName = "";
            }else{
                skuTypeName = WhWarehouseVO.getSkuStatusName(Integer.parseInt(this.getSkuType().toString()));
            }
        }
        return skuTypeName;
    }

    public void setSkuTypeName(String skuTypeName) {
        this.skuTypeName = skuTypeName;
    }
}