/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.vo;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoCreditNote;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrderCost;
import com.thebeastshop.pegasus.service.purchase.util.DateUtils;
import com.thebeastshop.pegasus.util.annotation.ObjectChangeLog;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import com.thebeastshop.pegasus.util.vo.CommFileVO;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsPurchaseOrderVO.java, v 0.1 2015-08-10 09:50
 */
@ExcelTemplate
@ExcelSheet(value = "sheet1")
public class PcsPurchaseOrderVO implements Serializable {

    /**
	 *
	 */
	private static final long serialVersionUID = 3915697649422132053L;

	// constructor
    public PcsPurchaseOrderVO() {

    }

    public PcsPurchaseOrderVO(Long id, Integer financeStatus) {
		super();
		this.id = id;
		this.financeStatus = financeStatus;
	}

	// original
    private Long id;

    @ExcelColumn(name="供应商编码")
    @Min(value = 0)
    @NotNull
    private Long supplierId;

    private String code;

    @ExcelColumn(name="目标仓库编码")
//    @NotNull
    private String warehouseCode;

    private Integer purchaseOrderStatus;

    private Date createTime;

    private Long createOperatorId;

    private String createOperatorName;

    private Date auditTime;

    private Date finishedTime;

  
    private BigDecimal otherFee;

    private BigDecimal otherFeeTaxRate;

    @ExcelColumn(name="要求交货日期")
    @ObjectChangeLog(name = "要求交货日期")
    private Date askDeliveryDate;

   
    private String purchaseCurrencyCode;

    @ExcelColumn(name="币种")
    @NotNull
    private String purchaseCurrencyDesc;

    private BigDecimal totalAmount;

    private BigDecimal totalAmountAfterTax;

    private Integer isReceivedAll;

    private String remark;

    // self
    private String supplierName;

    private String supplierNameCn;

    private String warehouseName;

    private String whetherConsignment;//采购模式


    //@ExcelColumnList(from = 5, to = -1, type = PcsPoLineVO.class, columnFiled = "skuCode", valueField = "quantity")
    private List<PcsPoLineVO> pcsPoLineVOList;
    //删除的行ID
    private List<Long> delLineIds;

    private boolean saveDraft;
    
    //收货计划列表
    private List<PcsPoPlanVO> pcsPoPlanVOList;

    // po贷记单据
    private List<PcsPoCreditNote> pcsPoCreditNotes;

    private List<PcsPoCreditNoteVO> pcsPoCreditNoteVOs;

    // po单上的 其它附件
    private List<CommFileRef> otherAttachmentList;

    private BigDecimal taxes;
    
    private Short crossBorderFlag;
    
    private Short includeShipment;
    
   /* @ExcelColumn(name="是否包含运费")
    @NotNull*/
    private String includeShipmentCN;
    
    private BigDecimal logisticsCost;
    
    // 财务状态
    private Integer financeStatus;

    // 待付款
    public static final Integer FINANCE_STATUS_WAIT_PAYMENT = 1;
    // 付款中
    public static final Integer FINANCE_STATUS_IN_THE_PAYMENT = 2;
    // 已付款
    public static final Integer FINANCE_STATUS_WAIT_PAYMENT_DONE = 3;

    // 已付金额
    private BigDecimal paidAmount;
    //采购单成本中心name
    @ExcelColumn(name="成本中心")
    @NotNull
    private String purchaseOrderCostCenterName;
    //采购单成本中心id
    private Integer purchaseOrderCostCenter;
    //采购单和鲜花采购单关联字段
    private String purchaseKey;

    private List<PcsPurchaseOrderCost> orderCostList;
    
    private BigDecimal rate;
    
    
     // 采购单费用列表
    private List<PcsPurchaseOrderCost> pcsPoCostList;

    // 采购单POP费用列表
    private List<PcsPoPlanCostVO> pcsPopCostVOList;
    
     /**采购单费用相关字段***/
    // 采购单费用ID
    private Integer poCostId;
    // 采购单费用类型
    private Integer costType;
    // 税后金额
    private BigDecimal afterTaxesAmount;
    // 税前金额
    private BigDecimal preTaxesAmount;
    // 税率
    private BigDecimal taxRate;
    // 调整的实际金额(税后)
    private BigDecimal adjustAfterTaxAmount;
    // 调整的实际金额(税后) 是否为空标志
    private BigDecimal adjustAfterTaxAmountFlag;
    // 调整的实际金额(税前)
    private BigDecimal adjustPreTaxAmount;
    // 调整的实际税率
    private BigDecimal adjustActualTaxrate;
    
    
    @ExcelColumn(name="模具税率%(填写整数)")
    private BigDecimal moldRate;
    
    @ExcelColumn(name="制版税率%(填写整数)")
    private BigDecimal plateRate;

    @ExcelColumn(name="运费税率%(填写整数)")
    private BigDecimal freightRate;

    @ExcelColumn(name="其它费用税率%(填写整数)")
    private BigDecimal otherRate;
    @ExcelColumn(name="模具费")
    @Min(0)
    private BigDecimal moldCost;
    
    @ExcelColumn(name="制版费")
    @Min(0)
    private BigDecimal plateCost;

    private Date lastSubmitTime;
    @ExcelColumn(name="运费")
    @Min(0)
    private BigDecimal freightCost;

    @ExcelColumn(name="其它费用")
    @Min(0)
    private BigDecimal otherCost;

    private String lastApproverName;
    
    private String lastAuditRemark;
    
    private Integer lastApprover;

    // 采购单所属物理仓类型
    private Integer physicalWarehouseType;
    // 采购单所属逻辑仓类型
    private Integer warehouseType;

    @ExcelColumn(name="目标物理仓编码")
    @NotNull
    private String physicalWarehouseCode;
    private String physicalWarehouseName;

    private boolean canModifyAmount = false;

    private boolean secondSubmit = false;

    private Boolean needCustomsArrange;

    @ExcelColumn(name = "关务安排")
    @NotNull
    private String needCustomsArrangeDesc;

    @ExcelColumn(name = "Delivery Terms")
    private String deliveryTerms;

    @ExcelColumn(name = "自动创建POP")
    @NotNull
    private String autoBuildPopStr;

    private String contractAttachments;//合同附件

    private List<CommFileVO> contractAttachmentList;

    private String skuCode;
    private Short printProgress; //用印进度
    private Date orderActualConfirmTime;
    private Integer poStatusBeforeSubmit;

    //是否自动生成POP
    private Boolean autoBuildPop;

    //过量交货限度
    private BigDecimal overDeliveryLimitRate;

    @ExcelColumn(name = "过量交货限度")
    private String overDeliveryLimitRateDesc;

    private List<PcsFinancePaymentVO> financePaymentList;

    private List<PcsPurchaseReturnVO> purchaseReturnList;

    private List<PcsFinancePaymentVO> financeCostAdjustList;//费用调整

    private boolean auditPassOnce = false;//审核通过至少一次
    //币种汇率
    private BigDecimal purchaseCurrencyRate;

    private Date newAskDeliveryDate;
    private Long submitUserId;
    /**
     * 采购入库可选仓调整
     * rule = 1 可选逻辑仓逻辑：
     * 所属物理仓WAREHOUSE_TYPE=2，只显示WAREHOUSE_TYPE=9的逻辑仓
     * 所属物理仓WAREHOUSE_TYPE!=2，只显示WAREHOUSE_TYPE=1的逻辑仓
     */
    public static final Integer FILTER_WAREHOUSE_BY_RULE_1 = 1;

    // 判断采购单为 待付款
    public static boolean checkPoOrderWaitPayment(PcsPurchaseOrderVO poVO){
        if (FINANCE_STATUS_IN_THE_PAYMENT.equals(poVO.getFinanceStatus())
                || FINANCE_STATUS_WAIT_PAYMENT_DONE.equals(poVO.getFinanceStatus())){
            return false;
        }
        return true;
    }

    public String getHasBeenWaiting() {
    	String hasBeenWaiting = "";
    	if(EmptyUtil.isEmpty(lastSubmitTime)) {
    		hasBeenWaiting =  "0天0小时";
    	} else {
    		hasBeenWaiting = DateUtils.workDays(DateUtil.format(lastSubmitTime, "yyyy-MM-dd HH:mm:ss"), 
    				DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
    	}
		return hasBeenWaiting;
	}
    public String getIncludeShipmentCN() {
		return includeShipmentCN;
	}

	public void setIncludeShipmentCN(String includeShipmentCN) {
		this.includeShipmentCN = includeShipmentCN;
	}

	public BigDecimal getMoldRate() {
		return moldRate;
	}

	public void setMoldRate(BigDecimal moldRate) {
		this.moldRate = moldRate;
	}

	public BigDecimal getPlateRate() {
		return plateRate;
	}

	public void setPlateRate(BigDecimal plateRate) {
		this.plateRate = plateRate;
	}

	public BigDecimal getFreightRate() {
		return freightRate;
	}

	public void setFreightRate(BigDecimal freightRate) {
		this.freightRate = freightRate;
	}

	public BigDecimal getMoldCost() {
		return moldCost;
	}

	public void setMoldCost(BigDecimal moldCost) {
		this.moldCost = moldCost;
	}

	public BigDecimal getPlateCost() {
		return plateCost;
	}

	public void setPlateCost(BigDecimal plateCost) {
		this.plateCost = plateCost;
	}

	public BigDecimal getFreightCost() {
		return freightCost;
	}

	public void setFreightCost(BigDecimal freightCost) {
		this.freightCost = freightCost;
	}
	
	public String getLastApproverName() {
		return lastApproverName;
	}

	public void setLastApproverName(String lastApproverName) {
		this.lastApproverName = lastApproverName;
	}

	public String getLastAuditRemark() {
		return lastAuditRemark;
	}

    public BigDecimal getOtherRate() {
        return otherRate;
    }

    public void setOtherRate(BigDecimal otherRate) {
        this.otherRate = otherRate;
    }

    public BigDecimal getOtherCost() {
        return otherCost;
    }

    public void setOtherCost(BigDecimal otherCost) {
        this.otherCost = otherCost;
    }

    public void setLastAuditRemark(String lastAuditRemark) {
		this.lastAuditRemark = lastAuditRemark;
	}

	public Integer getLastApprover() {
		return lastApprover;
	}

	public void setLastApprover(Integer lastApprover) {
		this.lastApprover = lastApprover;
	}

	public Date getLastSubmitTime() {
		return lastSubmitTime;
	}

	public void setLastSubmitTime(Date lastSubmitTime) {
		this.lastSubmitTime = lastSubmitTime;
	}

	public List<PcsPurchaseOrderCost> getPcsPoCostList() {
		return pcsPoCostList;
	}

	public void setPcsPoCostList(List<PcsPurchaseOrderCost> pcsPoCostList) {
		this.pcsPoCostList = pcsPoCostList;
	}

	public List<PcsPoPlanCostVO> getPcsPopCostVOList() {
		return pcsPopCostVOList;
	}

	public void setPcsPopCostVOList(List<PcsPoPlanCostVO> pcsPopCostVOList) {
		this.pcsPopCostVOList = pcsPopCostVOList;
	}

	public Integer getPoCostId() {
		return poCostId;
	}

	public void setPoCostId(Integer poCostId) {
		this.poCostId = poCostId;
	}

	public Integer getCostType() {
		return costType;
	}

	public void setCostType(Integer costType) {
		this.costType = costType;
	}

	public BigDecimal getAfterTaxesAmount() {
		return afterTaxesAmount;
	}

	public void setAfterTaxesAmount(BigDecimal afterTaxesAmount) {
		this.afterTaxesAmount = afterTaxesAmount;
	}

    public BigDecimal getOverDeliveryLimitRate() {
        return overDeliveryLimitRate;
    }

    public void setOverDeliveryLimitRate(BigDecimal overDeliveryLimitRate) {
        this.overDeliveryLimitRate = overDeliveryLimitRate;
    }

    public String getWhetherConsignment() {
        return whetherConsignment;
    }

    public void setWhetherConsignment(String whetherConsignment) {
        this.whetherConsignment = whetherConsignment;
    }

    public BigDecimal getPreTaxesAmount() {
		return preTaxesAmount;
	}

	public void setPreTaxesAmount(BigDecimal preTaxesAmount) {
		this.preTaxesAmount = preTaxesAmount;
	}

	public BigDecimal getTaxRate() {
		return taxRate;
	}

	public void setTaxRate(BigDecimal taxRate) {
		this.taxRate = taxRate;
	}

	public BigDecimal getAdjustAfterTaxAmount() {
		return adjustAfterTaxAmount;
	}

	public void setAdjustAfterTaxAmount(BigDecimal adjustAfterTaxAmount) {
		this.adjustAfterTaxAmount = adjustAfterTaxAmount;
	}

	public BigDecimal getAdjustPreTaxAmount() {
		return adjustPreTaxAmount;
	}

	public void setAdjustPreTaxAmount(BigDecimal adjustPreTaxAmount) {
		this.adjustPreTaxAmount = adjustPreTaxAmount;
	}

	public BigDecimal getAdjustActualTaxrate() {
		return adjustActualTaxrate;
	}

	public void setAdjustActualTaxrate(BigDecimal adjustActualTaxrate) {
		this.adjustActualTaxrate = adjustActualTaxrate;
	}

	public BigDecimal getRate() {
		return rate;
	}

	public void setRate(BigDecimal rate) {
		this.rate = rate;
	}

	public List<PcsPurchaseOrderCost> getOrderCostList() {
		return orderCostList;
	}

	public void setOrderCostList(List<PcsPurchaseOrderCost> orderCostList) {
		this.orderCostList = orderCostList;
	}


    public String getPurchaseOrderCostCenterName() {
        return purchaseOrderCostCenterName;
    }

    public void setPurchaseOrderCostCenterName(String purchaseOrderCostCenterName) {
        this.purchaseOrderCostCenterName = purchaseOrderCostCenterName;
    }

    public Integer getPurchaseOrderCostCenter() {
		return purchaseOrderCostCenter;
	}

	public void setPurchaseOrderCostCenter(Integer purchaseOrderCostCenter) {
		this.purchaseOrderCostCenter = purchaseOrderCostCenter;
	}

	public BigDecimal getTaxes() {
		return taxes;
	}

	public void setTaxes(BigDecimal taxes) {
		this.taxes = taxes;
	}


	public Short getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public void setCrossBorderFlag(Short crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}



	public Short getIncludeShipment() {
		return includeShipment;
	}

	public void setIncludeShipment(Short includeShipment) {
		this.includeShipment = includeShipment;
	}

	public BigDecimal getLogisticsCost() {
		return logisticsCost;
	}

	public void setLogisticsCost(BigDecimal logisticsCost) {
		this.logisticsCost = logisticsCost;
	}

	public List<PcsPoPlanVO> getPcsPoPlanVOList() {
		return pcsPoPlanVOList;
	}

	public void setPcsPoPlanVOList(List<PcsPoPlanVO> pcsPoPlanVOList) {
		this.pcsPoPlanVOList = pcsPoPlanVOList;
	}

    public List<PcsPoCreditNote> getPcsPoCreditNotes() {
        return pcsPoCreditNotes;
    }

    public void setPcsPoCreditNotes(List<PcsPoCreditNote> pcsPoCreditNotes) {
        this.pcsPoCreditNotes = pcsPoCreditNotes;
    }

    public List<PcsPoCreditNoteVO> getPcsPoCreditNoteVOs() {
        return pcsPoCreditNoteVOs;
    }

    public void setPcsPoCreditNoteVOs(List<PcsPoCreditNoteVO> pcsPoCreditNoteVOs) {
        this.pcsPoCreditNoteVOs = pcsPoCreditNoteVOs;
    }

    public List<CommFileRef> getOtherAttachmentList() {
        return otherAttachmentList;
    }

    public void setOtherAttachmentList(List<CommFileRef> otherAttachmentList) {
        this.otherAttachmentList = otherAttachmentList;
    }

    // manual generate
    public String getPurchaseOrderStatusName(){
        return purchaseOrderStatus == null ? "" :
                purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT) ? "草稿" :
                        purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT) ? "待审核" :
                                purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT) ? "已驳回" :
                                        purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE) ? "收货中" :
                                                purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH) ? "已完成" : 
                                                	purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE) ? "待收货" : "";
    }

    // auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Integer getPurchaseOrderStatus() {
        return purchaseOrderStatus;
    }

    public void setPurchaseOrderStatus(Integer purchaseOrderStatus) {
        this.purchaseOrderStatus = purchaseOrderStatus;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getCreateOperatorId() {
        return createOperatorId;
    }

    public void setCreateOperatorId(Long createOperatorId) {
        this.createOperatorId = createOperatorId;
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public void setCreateOperatorName(String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Date getFinishedTime() {
        return finishedTime;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public BigDecimal getOtherFee() {
        return otherFee;
    }

    public void setOtherFee(BigDecimal otherFee) {
        this.otherFee = otherFee;
    }

    public BigDecimal getOtherFeeTaxRate() {
        return otherFeeTaxRate;
    }

    public void setOtherFeeTaxRate(BigDecimal otherFeeTaxRate) {
        this.otherFeeTaxRate = otherFeeTaxRate;
    }

    public Date getAskDeliveryDate() {
        return askDeliveryDate;
    }

    public void setAskDeliveryDate(Date askDeliveryDate) {
        this.askDeliveryDate = askDeliveryDate;
    }

    public String getPurchaseCurrencyCode() {
        return purchaseCurrencyCode;
    }

    public void setPurchaseCurrencyCode(String purchaseCurrencyCode) {
        this.purchaseCurrencyCode = purchaseCurrencyCode;
    }

    public String getPurchaseCurrencyDesc() {
        return purchaseCurrencyDesc;
    }

    public void setPurchaseCurrencyDesc(String purchaseCurrencyDesc) {
        this.purchaseCurrencyDesc = purchaseCurrencyDesc;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getTotalAmountAfterTax() {
        return totalAmountAfterTax;
    }

    public void setTotalAmountAfterTax(BigDecimal totalAmountAfterTax) {
        this.totalAmountAfterTax = totalAmountAfterTax;
    }

    public Integer getIsReceivedAll() {
        return isReceivedAll;
    }

    public void setIsReceivedAll(Integer isReceivedAll) {
        this.isReceivedAll = isReceivedAll;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierNameCn() {
        return supplierNameCn;
    }

    public void setSupplierNameCn(String supplierNameCn) {
        this.supplierNameCn = supplierNameCn;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public List<PcsPoLineVO> getPcsPoLineVOList() {
        return pcsPoLineVOList;
    }

    public void setPcsPoLineVOList(List<PcsPoLineVO> pcsPoLineVOList) {
        this.pcsPoLineVOList = pcsPoLineVOList;
    }

    public boolean isSaveDraft() {
        return saveDraft;
    }

    public void setSaveDraft(boolean saveDraft) {
        this.saveDraft = saveDraft;
    }

	public Integer getFinanceStatus() {
		return financeStatus;
	}

	public void setFinanceStatus(Integer financeStatus) {
		this.financeStatus = financeStatus;
	}

	public BigDecimal getPaidAmount() {
		return paidAmount;
	}

	public void setPaidAmount(BigDecimal paidAmount) {
		this.paidAmount = paidAmount;
	}

    public String getPurchaseKey() {
        return purchaseKey;
    }

    public void setPurchaseKey(String purchaseKey) {
        this.purchaseKey = purchaseKey;
    }

    public BigDecimal getAdjustAfterTaxAmountFlag() { return adjustAfterTaxAmountFlag; }

    public void setAdjustAfterTaxAmountFlag(BigDecimal adjustAfterTaxAmountFlag) { this.adjustAfterTaxAmountFlag = adjustAfterTaxAmountFlag; }

    public Integer getPhysicalWarehouseType() {
        return physicalWarehouseType;
    }

    public void setPhysicalWarehouseType(Integer physicalWarehouseType) {
        this.physicalWarehouseType = physicalWarehouseType;
    }

    public Integer getWarehouseType() {
        return warehouseType;
    }

    public void setWarehouseType(Integer warehouseType) {
        this.warehouseType = warehouseType;
    }

    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public boolean isCanModifyAmount() {
        return canModifyAmount;
    }

    public void setCanModifyAmount(boolean canModifyAmount) {
        this.canModifyAmount = canModifyAmount;
    }

    public boolean isSecondSubmit() {
        return secondSubmit;
    }

    public void setSecondSubmit(boolean secondSubmit) {
        this.secondSubmit = secondSubmit;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Boolean getNeedCustomsArrange() {
        return needCustomsArrange;
    }

    public void setNeedCustomsArrange(Boolean needCustomsArrange) {
        this.needCustomsArrange = needCustomsArrange;
    }

    public String getDeliveryTerms() {
        return deliveryTerms;
    }

    public void setDeliveryTerms(String deliveryTerms) {
        this.deliveryTerms = deliveryTerms;
    }

    public String getContractAttachments() {
        return contractAttachments;
    }

    public void setContractAttachments(String contractAttachments) {
        this.contractAttachments = contractAttachments;
    }

    public List<CommFileVO> getContractAttachmentList() {
        if (EmptyUtil.isNotEmpty(contractAttachments)) {
          return JSON.parseArray(contractAttachments, CommFileVO.class);
        }
        return new ArrayList<CommFileVO>();
    }

    public void setContractAttachmentList(List<CommFileVO> contractAttachmentList) {
        this.contractAttachmentList = contractAttachmentList;
    }

    @NotNull
    public String getNeedCustomsArrangeDesc() {
        return needCustomsArrangeDesc;
    }

    public void setNeedCustomsArrangeDesc(@NotNull String needCustomsArrangeDesc) {
        this.needCustomsArrangeDesc = needCustomsArrangeDesc;
    }

  public Short getPrintProgress() {
    return printProgress;
  }

  public void setPrintProgress(Short printProgress) {
    this.printProgress = printProgress;
  }

  public Date getOrderActualConfirmTime() {
    return orderActualConfirmTime;
  }

  public void setOrderActualConfirmTime(Date orderActualConfirmTime) {
    this.orderActualConfirmTime = orderActualConfirmTime;
  }

  public Boolean getAutoBuildPop() {
    return autoBuildPop;
  }

  public void setAutoBuildPop(Boolean autoBuildPop) {
    this.autoBuildPop = autoBuildPop;
  }

    public List<PcsFinancePaymentVO> getFinancePaymentList() {
        return financePaymentList;
    }

    public void setFinancePaymentList(List<PcsFinancePaymentVO> financePaymentList) {
        this.financePaymentList = financePaymentList;
    }

    public List<PcsPurchaseReturnVO> getPurchaseReturnList() {
        return purchaseReturnList;
    }

    public void setPurchaseReturnList(List<PcsPurchaseReturnVO> purchaseReturnList) {
        this.purchaseReturnList = purchaseReturnList;
    }

    public List<PcsFinancePaymentVO> getFinanceCostAdjustList() {
        return financeCostAdjustList;
    }

    public void setFinanceCostAdjustList(List<PcsFinancePaymentVO> financeCostAdjustList) {
        this.financeCostAdjustList = financeCostAdjustList;
    }

    public boolean isAuditPassOnce() {
        return auditPassOnce;
    }

    public void setAuditPassOnce(boolean auditPassOnce) {
        this.auditPassOnce = auditPassOnce;
    }

    public String getAutoBuildPopStr() {
    return autoBuildPopStr;
  }

  public void setAutoBuildPopStr(String autoBuildPopStr) {
    this.autoBuildPopStr = autoBuildPopStr;
  }

  public Integer getPoStatusBeforeSubmit() {
    return poStatusBeforeSubmit;
  }

  public void setPoStatusBeforeSubmit(Integer poStatusBeforeSubmit) {
    this.poStatusBeforeSubmit = poStatusBeforeSubmit;
  }

  public String getOverDeliveryLimitRateDesc() {
    return overDeliveryLimitRateDesc;
  }

  public void setOverDeliveryLimitRateDesc(String overDeliveryLimitRateDesc) {
    this.overDeliveryLimitRateDesc = overDeliveryLimitRateDesc;
  }

  public BigDecimal getPurchaseCurrencyRate() {
    return purchaseCurrencyRate;
  }

  public void setPurchaseCurrencyRate(BigDecimal purchaseCurrencyRate) {
    this.purchaseCurrencyRate = purchaseCurrencyRate;
  }

  public Date getNewAskDeliveryDate() {
    return newAskDeliveryDate;
  }

  public void setNewAskDeliveryDate(Date newAskDeliveryDate) {
    this.newAskDeliveryDate = newAskDeliveryDate;
  }

  public List<Long> getDelLineIds() {
      return delLineIds;
  }

  public void setDelLineIds(List<Long> delLineIds) {
      this.delLineIds = delLineIds;
  }

  public Long getSubmitUserId() {
    return submitUserId;
  }

  public void setSubmitUserId(Long submitUserId) {
    this.submitUserId = submitUserId;
  }
}
