package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.enums.PoCostTypeExtEnum;
import com.thebeastshop.pegasus.service.purchase.enums.PoFinancePaymentModeEnum;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrderCost;

import java.util.*;

public class PcsPurchaseOrderCostVO extends PcsPurchaseOrderCost {

    public static final Short COST_TYPE_MOLD = 1;//模具费
    public static final Short COST_TYPE_PLATE = 2;//制版费
    public static final Short COST_TYPE_FREIGHT = 3;//运费
    public static final Short COST_TYPE_OTHER = 4;//其它费用

    // 采购单币种 人民币
    public static final String PO_CURRENCY_FOR_CNY = "CNY";

    // 采购单费用
    public static final List<Integer> PO_COST_TYPE_LIST = new ArrayList<Integer>(){{
        add(COST_TYPE_MOLD.intValue());
        add(COST_TYPE_PLATE.intValue());
        add(COST_TYPE_FREIGHT.intValue());
        add(COST_TYPE_OTHER.intValue());
    }};

    public static final Map<Integer,String> PO_COST_TYPE_MAP = new HashMap<Integer,String>(){{
        put(COST_TYPE_MOLD.intValue(), "模具费");
        put(COST_TYPE_PLATE.intValue(), "制版费");
        put(COST_TYPE_FREIGHT.intValue(), "运费");
        put(COST_TYPE_OTHER.intValue(), "其它费用");
    }};

    // 采购单 扩展的费用类型
    public static final Map<Integer,String> PO_COST_TYPE_EXT_MAP = new HashMap<Integer,String>(){{
        put(PoCostTypeExtEnum.payment_for_goods.getKey(), PoCostTypeExtEnum.payment_for_goods.getValue());
        /*put(PoCostTypeExtEnum.ocean_freight.getKey(), PoCostTypeExtEnum.ocean_freight.getValue());
        put(PoCostTypeExtEnum.air_freight.getKey(), PoCostTypeExtEnum.air_freight.getValue());
        put(PoCostTypeExtEnum.customs_clearance_fee.getKey(), PoCostTypeExtEnum.customs_clearance_fee.getValue());
        put(PoCostTypeExtEnum.tariff.getKey(), PoCostTypeExtEnum.tariff.getValue());
        put(PoCostTypeExtEnum.added_value_tax.getKey(), PoCostTypeExtEnum.added_value_tax.getValue());
        put(PoCostTypeExtEnum.consumption_tax.getKey(), PoCostTypeExtEnum.consumption_tax.getValue());
        put(PoCostTypeExtEnum.other_cost.getKey(), PoCostTypeExtEnum.other_cost.getValue());
        */
    }};

    public static String getCostTypeName(Short costType){
        return COST_TYPE_MOLD.equals(costType)?"模具费":
                COST_TYPE_PLATE.equals(costType)?"制版费":
                        COST_TYPE_FREIGHT.equals(costType)?"运费":
                                COST_TYPE_OTHER.equals(costType)?"其它费用":"";
    }

    public String getCostTypeName(){
        return getCostTypeName(getCostType());
    }
}
