package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlower;
import org.apache.commons.lang.StringUtils;

/**
 * @Author: ljj
 * @Description:${todo}(用一句话描述该文件做什么)
 * @Date: 2018/12/7 16:15
 * @Version 1.0
 */
public class PcsPurchaseFlowerVO extends PcsPurchaseFlower {

    private String typeName;

    private String unitName;

    private String placeOfOriginName;

    private String seasonName;

    private String statusName;

    private String storeLevelNames;

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getPlaceOfOriginName() {
        return getPlaceOfOriginName(getPlaceOfOrigin());
    }

    public static String getPlaceOfOriginName(Integer placeOfOrigin){
        return placeOfOrigin == null ? "" :
                placeOfOrigin.equals(PcsPurchaseFlower.PLACE_OF_ORIGIN_MIC) ? "国产" :
                        placeOfOrigin.equals(PcsPurchaseFlower.PLACE_OF_ORIGIN_IMPORT) ? "进口" :"";
    }

    public void setPlaceOfOriginName(String placeOfOriginName) {
        this.placeOfOriginName = placeOfOriginName;
    }

    public String getSeasonName() {
        return getSeasonName(getSeason());
    }

    public static String getSeasonName(String season){
        String finaliyStr = "";
        StringBuilder sb = new StringBuilder("");
        if (StringUtils.isNotEmpty(season)) {
            String[] seasonsArray = season.split(",");
            if (seasonsArray.length>0) {
                for (String seasons : seasonsArray) {
                    if ("1".equals(seasons)) {
                        sb.append("春,");
                    } else if ("2".equals(seasons)) {
                        sb.append("夏,");
                    } else if ("3".equals(seasons)) {
                        sb.append("秋,");
                    } else if ("4".equals(seasons)) {
                        sb.append("冬,");
                    }
                }
                finaliyStr = sb.toString();
                finaliyStr = finaliyStr.substring(0,finaliyStr.length()-1);
            }
        }
        return finaliyStr;
    }

    public void setSeasonName(String seasonName) {
        this.seasonName = seasonName;
    }

    public String getStoreLevelNames() {
        return storeLevelNames;
    }

    public void setStoreLevelNames(String storeLevelNames) {
        this.storeLevelNames = storeLevelNames;
    }

    public String getStatusName() {
        return getStatusName(getStatus());
    }

    public static String getStatusName(Integer statusName){
        return statusName == null ? "" :
                statusName.equals(PcsPurchaseFlower.STATUS_ENABLE) ? "启用" :
                        statusName.equals(PcsPurchaseFlower.STATUS_FORBIDDEN) ? "禁用" :"";
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }
}
