package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.enums.PoPrintProgressEnum;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class PcsPoProgressTrackingExportVO  implements Serializable {

  private String poCode;
  private Date poCreateTime;//采购单创建时间
  private String poRemark;//采购单备注
  private Short crossBorderFlag;//是否进口
  private String tradeForm;//贸易形式
  private String poSupplierName;//采购单供应商
  private String physicalWarehouseName;//收货物理仓
  private String poBrandName;//采购单品牌
  private String chineseLabel;//中文标签
  private BigDecimal totalAmount;//采购单金额
  private Date askDeliveryDate;//要求交货日期
  private boolean isFirstOrder;//是否首单
  private BigDecimal purchaseCurrencyRate;//采购单汇率

  private Short printProgress; //用印进度
  private String printProgressCNDesc; //用印进度中文描述
  private Date orderActualConfirmTime;
  private Date orderPlanConfirmTime;//订单计划确认时间
  private Date notifySupplierDeliveryTime;
  private Date supplierActualDeliveryTime;
  private Date supplierStockUpTime; //供应商备货时间

  private Integer purchaseOrderStatus;
  private Boolean needCustomsArrange;
  private String storageStatus;

  private Long supplierId;
  private String createOperatorName;

  private List<PcsPoProgressTrackingDetailVO> lines;

  public Date getPoCreateTime() {
    return poCreateTime;
  }

  public void setPoCreateTime(Date poCreateTime) {
    this.poCreateTime = poCreateTime;
  }

  public String getPoRemark() {
    return poRemark;
  }

  public void setPoRemark(String poRemark) {
    this.poRemark = poRemark;
  }

  public Short getCrossBorderFlag() {
    return crossBorderFlag;
  }

  public void setCrossBorderFlag(Short crossBorderFlag) {
    this.crossBorderFlag = crossBorderFlag;
  }

  public String getTradeForm() {
    return tradeForm;
  }

  public void setTradeForm(String tradeForm) {
    this.tradeForm = tradeForm;
  }

  public String getPoSupplierName() {
    return poSupplierName;
  }

  public void setPoSupplierName(String poSupplierName) {
    this.poSupplierName = poSupplierName;
  }

  public String getPoBrandName() {
    return poBrandName;
  }

  public void setPoBrandName(String poBrandName) {
    this.poBrandName = poBrandName;
  }

  public BigDecimal getTotalAmount() {
    return totalAmount;
  }

  public void setTotalAmount(BigDecimal totalAmount) {
    this.totalAmount = totalAmount;
  }

  public Short getPrintProgress() {
    return printProgress;
  }

  public void setPrintProgress(Short printProgress) {
    this.printProgress = printProgress;
  }

  public Date getOrderActualConfirmTime() {
    return orderActualConfirmTime;
  }

  public void setOrderActualConfirmTime(Date orderActualConfirmTime) {
    this.orderActualConfirmTime = orderActualConfirmTime;
  }

  public Date getNotifySupplierDeliveryTime() {
    return notifySupplierDeliveryTime;
  }

  public void setNotifySupplierDeliveryTime(Date notifySupplierDeliveryTime) {
    this.notifySupplierDeliveryTime = notifySupplierDeliveryTime;
  }

  public Date getSupplierActualDeliveryTime() {
    return supplierActualDeliveryTime;
  }

  public void setSupplierActualDeliveryTime(Date supplierActualDeliveryTime) {
    this.supplierActualDeliveryTime = supplierActualDeliveryTime;
  }

  public String getPurchaseOrderStatusName(){
    return purchaseOrderStatus == null ? "" :
            purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT) ? "草稿" :
                    purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT) ? "待审核" :
                            purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT) ? "已驳回" :
                                    purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE) ? "收货中" :
                                            purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH) ? "已完成" :
                                                    purchaseOrderStatus.equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE) ? "待收货" : "";
  }

  public String getChineseLabel() {
    return chineseLabel;
  }

  public void setChineseLabel(String chineseLabel) {
    this.chineseLabel = chineseLabel;
  }


  public String getPoCode() {
    return poCode;
  }

  public void setPoCode(String poCode) {
    this.poCode = poCode;
  }

  public String getPrintProgressCNDesc() {
    return PoPrintProgressEnum.getVal(printProgress);
  }

  public void setPrintProgressCNDesc(String printProgressCNDesc) {
    this.printProgressCNDesc = printProgressCNDesc;
  }

  public Integer getPurchaseOrderStatus() {
    return purchaseOrderStatus;
  }

  public void setPurchaseOrderStatus(Integer purchaseOrderStatus) {
    this.purchaseOrderStatus = purchaseOrderStatus;
  }

  public Boolean getNeedCustomsArrange() {
    return needCustomsArrange;
  }

  public void setNeedCustomsArrange(Boolean needCustomsArrange) {
    this.needCustomsArrange = needCustomsArrange;
  }

  public String getStorageStatus() {
    return storageStatus;
  }

  public void setStorageStatus(String storageStatus) {
    this.storageStatus = storageStatus;
  }

  public Date getOrderPlanConfirmTime() {
    return orderPlanConfirmTime;
  }

  public void setOrderPlanConfirmTime(Date orderPlanConfirmTime) {
    this.orderPlanConfirmTime = orderPlanConfirmTime;
  }

  public Date getSupplierStockUpTime() {
    return supplierStockUpTime;
  }

  public void setSupplierStockUpTime(Date supplierStockUpTime) {
    this.supplierStockUpTime = supplierStockUpTime;
  }

  public String getPhysicalWarehouseName() {
    return physicalWarehouseName;
  }

  public void setPhysicalWarehouseName(String physicalWarehouseName) {
    this.physicalWarehouseName = physicalWarehouseName;
  }

  public Date getAskDeliveryDate() {
    return askDeliveryDate;
  }

  public void setAskDeliveryDate(Date askDeliveryDate) {
    this.askDeliveryDate = askDeliveryDate;
  }

  public boolean isFirstOrder() {
    return isFirstOrder;
  }

  public void setFirstOrder(boolean firstOrder) {
    isFirstOrder = firstOrder;
  }

  public BigDecimal getPurchaseCurrencyRate() {
    return purchaseCurrencyRate;
  }

  public void setPurchaseCurrencyRate(BigDecimal purchaseCurrencyRate) {
    this.purchaseCurrencyRate = purchaseCurrencyRate;
  }

  public List<PcsPoProgressTrackingDetailVO> getLines() {
    return lines;
  }

  public void setLines(List<PcsPoProgressTrackingDetailVO> lines) {
    this.lines = lines;
  }

  public Long getSupplierId() {
    return supplierId;
  }

  public void setSupplierId(Long supplierId) {
    this.supplierId = supplierId;
  }

  public String getCreateOperatorName() {
    return createOperatorName;
  }

  public void setCreateOperatorName(String createOperatorName) {
    this.createOperatorName = createOperatorName;
  }
}
