/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.vo;
import com.thebeastshop.pegasus.service.purchase.enums.PoLogisticsEnum;
import com.thebeastshop.pegasus.service.purchase.enums.PoPStatusEnum;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanCost;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.vo.FileResponseVO;
import com.thebeastshop.wms.vo.WhJitPackageSkuReferenceVO;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoPlanVO.java, v 0.1 2015-08-10 09:58
 */
public class PcsPoPlanVO extends PcsPoPlan implements Serializable {

    // constructor
    public PcsPoPlanVO() {

    }

    private String poCode;

    private List<String> codes;

    private String receiveDateStr;

    private List<PcsPoPlanLineVO> pcsPoPlanLineVOList;

    private List<PcsPoPlanCost> pcsPoPlanCosts;

    private List<PcsPoPlanVO> poPlanVOs;

    private Boolean hasFillFee = false;// 是否已填费用

    private String skuCode;

    private String skuName;

    private String physicalWarehouseCode;

    private String warehouseCode;

    private String physicalWarehouseName;

    private String warehouseName;

    // pop附件列表
    private List<String> attachments;

    List<FileResponseVO> attachmentList;

    // 采购员
    private String createOperatorName;
    private String createOperatorEmail;
    //PO创建人邮箱
    private String poCreatorEmail;
    //入库邮件收件人列表
    private List<String> popInStorageEmailReceivers;
    private String buyerEmailAddress;

    // 邮件提醒标志
    private String warnFlagStr;

    private Boolean isFetch;

    // 计划数
    private Integer planedQuantity;
    // 良品数
    private Integer quantity;
    // 残次数
    private Integer wasteQuantity;
    //高捷入库单号
    private String goldjetInboundNum;

    private String oldBillOfLading;
    //物流单状态
    private Integer logisticsBillStatus;

    // 物流单号
    private String logisticsBillCode;

    private String logisticsBillStatusDesc;

    private boolean defectiveGratterZero;

    // 定时任务触发
    public static final int SEND_POP_EMAIL_ORIGIN_CRON = 1;
    // 采购入库完成后，待定数量>0 触发
    public static final int SEND_POP_EMAIL_ORIGIN_HOLD_PENDING = 2;

    private int sendPopEmailOrigin;

    private boolean onlySendBuyerEmail;

    // qc 质检信息
    private Date qcCreateTime;
    private Integer qcReceiveAmount;
    private String qcRemark;

    private Long qcId;
    // 系统强制处理日期
    private Date systemProcessTime;
    //是否有待定数
    private boolean hasUndeterminedQuantity;

    List<WhJitPackageSkuReferenceVO> referenceList;

    private String createOperatorAvatar;//头像

	public Boolean getHasFillFee() {
		return hasFillFee;
	}

	public void setHasFillFee(Boolean hasFillFee) {
		this.hasFillFee = hasFillFee;
	}

    public static final Map<Integer, String> POP_STATUS_MAP = new HashMap<Integer, String>(){{
        put(PoPStatusEnum.PLAN_STATUS_WAITING_RECEIVE.getKey(), PoPStatusEnum.PLAN_STATUS_WAITING_RECEIVE.getValue());
        put(PoPStatusEnum.PLAN_STATUS_WAITING_IN.getKey(), PoPStatusEnum.PLAN_STATUS_WAITING_IN.getValue());
        put(PoPStatusEnum.PLAN_STATUS_ALREADY_IN.getKey(), PoPStatusEnum.PLAN_STATUS_ALREADY_IN.getValue());
        put(PoPStatusEnum.PLAN_STATUS_FINISHED.getKey(), PoPStatusEnum.PLAN_STATUS_FINISHED.getValue());
        put(PoPStatusEnum.PLAN_STATUS_CLOSED.getKey(), PoPStatusEnum.PLAN_STATUS_CLOSED.getValue());
        put(PoPStatusEnum.PLAN_STATUS_WAITING.getKey(), PoPStatusEnum.PLAN_STATUS_WAITING.getValue());
    }};

	// manual generate
    public String getPlanStatusName() {
        if (EmptyUtil.isEmpty(this.getPlanStatus())){
            return "";
        }
        return POP_STATUS_MAP.get(this.getPlanStatus());
    }

    public String getPoCode() {
        return poCode;
    }

    public void setPoCode(String poCode) {
        this.poCode = poCode;
    }

    public List<String> getCodes() {
        return codes;
    }

    public void setCodes(List<String> codes) {
        this.codes = codes;
    }

    public String getReceiveDateStr() {
        return receiveDateStr;
    }

    public void setReceiveDateStr(String receiveDateStr) {
        this.receiveDateStr = receiveDateStr;
    }

    public List<PcsPoPlanLineVO> getPcsPoPlanLineVOList() {
        return pcsPoPlanLineVOList;
    }

    public void setPcsPoPlanLineVOList(List<PcsPoPlanLineVO> pcsPoPlanLineVOList) {
        this.pcsPoPlanLineVOList = pcsPoPlanLineVOList;
    }

    public List<PcsPoPlanCost> getPcsPoPlanCosts() {
        return pcsPoPlanCosts;
    }

    public void setPcsPoPlanCosts(List<PcsPoPlanCost> pcsPoPlanCosts) {
        this.pcsPoPlanCosts = pcsPoPlanCosts;
    }

    public List<PcsPoPlanVO> getPoPlanVOs() {
        return poPlanVOs;
    }

    public void setPoPlanVOs(List<PcsPoPlanVO> poPlanVOs) {
        this.poPlanVOs = poPlanVOs;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getPhysicalWarehouseName() {
        return physicalWarehouseName;
    }

    public void setPhysicalWarehouseName(String physicalWarehouseName) {
        this.physicalWarehouseName = physicalWarehouseName;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public List<String> getAttachments() {
        return attachments;
    }

    public void setAttachments(List<String> attachments) {
        this.attachments = attachments;
    }

    public List<FileResponseVO> getAttachmentList() {
        return attachmentList;
    }

    public void setAttachmentList(List<FileResponseVO> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public String getCreateOperatorName() {
        return createOperatorName;
    }

    public void setCreateOperatorName(String createOperatorName) {
        this.createOperatorName = createOperatorName;
    }

    public String getCreateOperatorEmail() {
        return createOperatorEmail;
    }

    public void setCreateOperatorEmail(String createOperatorEmail) {
        this.createOperatorEmail = createOperatorEmail;
    }

    public String getBuyerEmailAddress() {
        return buyerEmailAddress;
    }

    public void setBuyerEmailAddress(String buyerEmailAddress) {
        this.buyerEmailAddress = buyerEmailAddress;
    }

    public String getWarnFlagStr() {
        return warnFlagStr;
    }

    public void setWarnFlagStr(String warnFlagStr) {
        this.warnFlagStr = warnFlagStr;
    }

    public Boolean getFetch() {
        return isFetch;
    }

    public void setFetch(Boolean fetch) {
        isFetch = fetch;
    }

    public Integer getPlanedQuantity() {
        return planedQuantity;
    }

    public void setPlanedQuantity(Integer planedQuantity) {
        this.planedQuantity = planedQuantity;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Integer getWasteQuantity() {
        return wasteQuantity;
    }

    public void setWasteQuantity(Integer wasteQuantity) {
        this.wasteQuantity = wasteQuantity;
    }

    public String getGoldjetInboundNum() {
        return goldjetInboundNum;
    }

    public void setGoldjetInboundNum(String goldjetInboundNum) {
        this.goldjetInboundNum = goldjetInboundNum;
    }

    public String getOldBillOfLading() {
        return oldBillOfLading;
    }

    public void setOldBillOfLading(String oldBillOfLading) {
        this.oldBillOfLading = oldBillOfLading;
    }

    public boolean isDefectiveGratterZero() {
        return defectiveGratterZero;
    }

    public void setDefectiveGratterZero(boolean defectiveGratterZero) {
        this.defectiveGratterZero = defectiveGratterZero;
    }

    public int getSendPopEmailOrigin() {
        return sendPopEmailOrigin;
    }

    public void setSendPopEmailOrigin(int sendPopEmailOrigin) {
        this.sendPopEmailOrigin = sendPopEmailOrigin;
    }

    public boolean isOnlySendBuyerEmail() {
        return onlySendBuyerEmail;
    }

    public void setOnlySendBuyerEmail(boolean onlySendBuyerEmail) {
        this.onlySendBuyerEmail = onlySendBuyerEmail;
    }

    public Date getQcCreateTime() {
        return qcCreateTime;
    }

    public void setQcCreateTime(Date qcCreateTime) {
        this.qcCreateTime = qcCreateTime;
    }

    public Integer getQcReceiveAmount() {
        return qcReceiveAmount;
    }

    public void setQcReceiveAmount(Integer qcReceiveAmount) {
        this.qcReceiveAmount = qcReceiveAmount;
    }

    public String getQcRemark() {
        return qcRemark;
    }

    public void setQcRemark(String qcRemark) {
        this.qcRemark = qcRemark;
    }

    public Long getQcId() {
        return qcId;
    }

    public void setQcId(Long qcId) {
        this.qcId = qcId;
    }

    public Date getSystemProcessTime() {
        return systemProcessTime;
    }

    public void setSystemProcessTime(Date systemProcessTime) {
        this.systemProcessTime = systemProcessTime;
    }

    public Integer getLogisticsBillStatus() {
        return logisticsBillStatus;
    }

    public void setLogisticsBillStatus(Integer logisticsBillStatus) {
        this.logisticsBillStatus = logisticsBillStatus;
    }

    public String getLogisticsBillCode() {
        return logisticsBillCode;
    }

    public void setLogisticsBillCode(String logisticsBillCode) {
        this.logisticsBillCode = logisticsBillCode;
    }

    public String getLogisticsBillStatusDesc() {
        if (logisticsBillStatus == null) {
            return "";
        }
        return PoLogisticsEnum.getStatusName(logisticsBillStatus);
    }

    public void setLogisticsBillStatusDesc(String logisticsBillStatusDesc) {
        this.logisticsBillStatusDesc = logisticsBillStatusDesc;
    }

    public boolean isHasUndeterminedQuantity() {
        return hasUndeterminedQuantity;
    }

    public void setHasUndeterminedQuantity(boolean hasUndeterminedQuantity) {
        this.hasUndeterminedQuantity = hasUndeterminedQuantity;
    }

    public String getCreateOperatorAvatar() {
        return createOperatorAvatar;
    }

    public void setCreateOperatorAvatar(String createOperatorAvatar) {
        this.createOperatorAvatar = createOperatorAvatar;
    }

    public List<WhJitPackageSkuReferenceVO> getReferenceList() {
        return referenceList;
    }

    public void setReferenceList(List<WhJitPackageSkuReferenceVO> referenceList) {
        this.referenceList = referenceList;
    }

    public String getPoCreatorEmail() {
        return poCreatorEmail;
    }

    public void setPoCreatorEmail(String poCreatorEmail) {
        this.poCreatorEmail = poCreatorEmail;
    }

    public List<String> getPopInStorageEmailReceivers() {
        return popInStorageEmailReceivers;
    }

    public void setPopInStorageEmailReceivers(List<String> popInStorageEmailReceivers) {
        this.popInStorageEmailReceivers = popInStorageEmailReceivers;
    }
}
