package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.util.annotation.ObjectChangeLog;
import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@ExcelTemplate
@ExcelSheet("Sheet1")
public class PcsPoPlanLogisticsBillVO implements Serializable {

    private static final long serialVersionUID = -7788130732464424593L;

    private Integer id;
    private Long popId;
    private String popCode;
    private Long poId;
    private String poCode;
    private Long poCreator;
    private String poCreatorName;

    @ExcelColumn(name = "Country of departure")
    @ObjectChangeLog(name = "Country of departure")
    private String countryOfDeparture;

    @ExcelColumn(name = "Port of Destination")
    @ObjectChangeLog(name = "Port of Destination")
    private String portOfDestination;

    @ExcelColumn(name = "Dangerous  Goods")
    @ObjectChangeLog(name = "Dangerous  Goods")
    private String isDangerousGoodsCN;

    @ObjectChangeLog(name = "Dangerous  Goods")
    private Boolean isDangerousGoods;

    @ObjectChangeLog(name = "No.of Cartons")
    @ExcelColumn(name = "No.of Cartons")
    @Min(0)
    //@Pattern(regexp = "", message = "No.of Cartons 格式错误")
    private Integer cartonQuantity;

    @ObjectChangeLog(name = "No.of Pallets")
    @ExcelColumn(name = "No.of Pallets")
    @Min(0)
    //@Pattern(regexp = "^[1-9]\\d*$", message = "No.of Pallets 格式错误")
    private Integer palletQuantity;

    @ObjectChangeLog(name = "Pallet  Material")
    @ExcelColumn(name = "Pallet  Material")
    private String palletMaterial;

    @ObjectChangeLog(name = "Total CBM(m³)")
    @ExcelColumn(name = "Total CBM(m³)")
    @Min(0)
    private Float totalCbm;

    @ObjectChangeLog(name = "Gross Weight(kg)")
    @ExcelColumn(name = "Gross Weight(kg)")
    @Min(0)
    private Float crossWeight;

    @ObjectChangeLog(name = "Pick up address")
    @ExcelColumn(name = "Pick up address")
    private String pickUpAddress;

    @ObjectChangeLog(name = "Contact")
    @ExcelColumn(name = "Contact")
    private String contact;

    @ObjectChangeLog(name = "Tel")
    @ExcelColumn(name = "Tel")
    private String tel;

    @ObjectChangeLog(name = "E-mail")
    @ExcelColumn(name = "E-mail")
    private String eMail;

    @ObjectChangeLog(name = "EDD")
    @ExcelColumn(name = "EDD")
    private Date edd;

    @ObjectChangeLog(name = "Mode of Shippment")
    @ExcelColumn(name = "Mode of Shippment")
    private String shippmentMode;
    private Date expectArrivalTime;
    private Date submitApplicationTime;
    private String shipmentPort;
    private String destinationPort;
    private Date pickUpTime;
    private Date confirmDeliveryTime;
    private String billNo;
    private Float billNoBillingWeight;
    private Date estimatedDepartureTime;
    private Date actualDepartureTime;
    private Date estimatedArrivalTime;
    private Date actualArrivalTime;
    private Date changeOrderTime;
    private Date customsApprovalTime;
    private Date customsReleaseTime;
    private Date estimatedDeliveryTime;
    private Date actualDeliveryTime;
    private Date updateTime;
    private Integer billStatus;
    private Long creator;
    private String creatorName;
    private Date createTime;

    //货值
    private BigDecimal goodsValue;
    private BigDecimal tariff;//关税
    private BigDecimal vat;//增值税
    private BigDecimal consumptionTaxAmount;//消费税
    private Date requestPaymentTime;
    private String remark;
    private String internationalAgent;
    private BigDecimal internationalFee;
    private String internalAgent;
    //国内段费用
    private BigDecimal internalFee;
    private List<PcsPoPlanLineVO> popLines;
    private String attachments;
    private String supplierName;
    private String buyerName;
    private List<String> noticeAddressList;

    private boolean isSave = true;

    public boolean isSave() {
        return isSave;
    }

    public void setSave(boolean save) {
        isSave = save;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Integer getId() {
        return id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.id
     *
     * @param id the value for t_pcs_po_plan_logistics_bill.id
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.pop_code
     *
     * @return the value of t_pcs_po_plan_logistics_bill.pop_code
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public String getPopCode() {
        return popCode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.pop_code
     *
     * @param popCode the value for t_pcs_po_plan_logistics_bill.pop_code
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setPopCode(String popCode) {
        this.popCode = popCode == null ? null : popCode.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.po_code
     *
     * @return the value of t_pcs_po_plan_logistics_bill.po_code
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public String getPoCode() {
        return poCode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.po_code
     *
     * @param poCode the value for t_pcs_po_plan_logistics_bill.po_code
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setPoCode(String poCode) {
        this.poCode = poCode == null ? null : poCode.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.country_of_departure
     *
     * @return the value of t_pcs_po_plan_logistics_bill.country_of_departure
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public String getCountryOfDeparture() {
        return countryOfDeparture;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.country_of_departure
     *
     * @param countryOfDeparture the value for t_pcs_po_plan_logistics_bill.country_of_departure
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setCountryOfDeparture(String countryOfDeparture) {
        this.countryOfDeparture = countryOfDeparture == null ? null : countryOfDeparture.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.port_of_destination
     *
     * @return the value of t_pcs_po_plan_logistics_bill.port_of_destination
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public String getPortOfDestination() {
        return portOfDestination;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.port_of_destination
     *
     * @param portOfDestination the value for t_pcs_po_plan_logistics_bill.port_of_destination
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setPortOfDestination(String portOfDestination) {
        this.portOfDestination = portOfDestination == null ? null : portOfDestination.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.is_dangerous _goods
     *
     * @return the value of t_pcs_po_plan_logistics_bill.is_dangerous _goods
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Boolean getIsDangerousGoods() {
        return isDangerousGoods;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.is_dangerous _goods
     *
     * @param isDangerousGoods the value for t_pcs_po_plan_logistics_bill.is_dangerous _goods
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setIsDangerousGoods(Boolean isDangerousGoods) {
        this.isDangerousGoods = isDangerousGoods;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.carton_quantity
     *
     * @return the value of t_pcs_po_plan_logistics_bill.carton_quantity
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Integer getCartonQuantity() {
        return cartonQuantity;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.carton_quantity
     *
     * @param cartonQuantity the value for t_pcs_po_plan_logistics_bill.carton_quantity
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setCartonQuantity(Integer cartonQuantity) {
        this.cartonQuantity = cartonQuantity;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.pallet_quantity
     *
     * @return the value of t_pcs_po_plan_logistics_bill.pallet_quantity
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Integer getPalletQuantity() {
        return palletQuantity;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.pallet_quantity
     *
     * @param palletQuantity the value for t_pcs_po_plan_logistics_bill.pallet_quantity
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setPalletQuantity(Integer palletQuantity) {
        this.palletQuantity = palletQuantity;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.pallet_material
     *
     * @return the value of t_pcs_po_plan_logistics_bill.pallet_material
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public String getPalletMaterial() {
        return palletMaterial;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.pallet_material
     *
     * @param palletMaterial the value for t_pcs_po_plan_logistics_bill.pallet_material
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setPalletMaterial(String palletMaterial) {
        this.palletMaterial = palletMaterial == null ? null : palletMaterial.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.total_cbm
     *
     * @return the value of t_pcs_po_plan_logistics_bill.total_cbm
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Float getTotalCbm() {
        return totalCbm;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.total_cbm
     *
     * @param totalCbm the value for t_pcs_po_plan_logistics_bill.total_cbm
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setTotalCbm(Float totalCbm) {
        this.totalCbm = totalCbm;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.cross_weight
     *
     * @return the value of t_pcs_po_plan_logistics_bill.cross_weight
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Float getCrossWeight() {
        return crossWeight;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.cross_weight
     *
     * @param crossWeight the value for t_pcs_po_plan_logistics_bill.cross_weight
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setCrossWeight(Float crossWeight) {
        this.crossWeight = crossWeight;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.pick_up_address
     *
     * @return the value of t_pcs_po_plan_logistics_bill.pick_up_address
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public String getPickUpAddress() {
        return pickUpAddress;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.pick_up_address
     *
     * @param pickUpAddress the value for t_pcs_po_plan_logistics_bill.pick_up_address
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setPickUpAddress(String pickUpAddress) {
        this.pickUpAddress = pickUpAddress == null ? null : pickUpAddress.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.contact
     *
     * @return the value of t_pcs_po_plan_logistics_bill.contact
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public String getContact() {
        return contact;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.contact
     *
     * @param contact the value for t_pcs_po_plan_logistics_bill.contact
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setContact(String contact) {
        this.contact = contact == null ? null : contact.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.tel
     *
     * @return the value of t_pcs_po_plan_logistics_bill.tel
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public String getTel() {
        return tel;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.tel
     *
     * @param tel the value for t_pcs_po_plan_logistics_bill.tel
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setTel(String tel) {
        this.tel = tel == null ? null : tel.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.e_mail
     *
     * @return the value of t_pcs_po_plan_logistics_bill.e_mail
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */

    public String geteMail() {
        return eMail;
    }

    public void seteMail(String eMail) {
        this.eMail = eMail;
    }

    public void setEMail(String eMail) {
        this.eMail = eMail;
    }
    public String isEMail() {
        return eMail;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.edd
     *
     * @return the value of t_pcs_po_plan_logistics_bill.edd
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getEdd() {
        return edd;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.edd
     *
     * @param edd the value for t_pcs_po_plan_logistics_bill.edd
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setEdd(Date edd) {
        this.edd = edd;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.shippment_mode
     *
     * @return the value of t_pcs_po_plan_logistics_bill.shippment_mode
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public String getShippmentMode() {
        return shippmentMode;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.shippment_mode
     *
     * @param shippmentMode the value for t_pcs_po_plan_logistics_bill.shippment_mode
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setShippmentMode(String shippmentMode) {
        this.shippmentMode = shippmentMode == null ? null : shippmentMode.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.expect_arrival_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.expect_arrival_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getExpectArrivalTime() {
        return expectArrivalTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.expect_arrival_time
     *
     * @param expectArrivalTime the value for t_pcs_po_plan_logistics_bill.expect_arrival_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setExpectArrivalTime(Date expectArrivalTime) {
        this.expectArrivalTime = expectArrivalTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.submit_application_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.submit_application_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getSubmitApplicationTime() {
        return submitApplicationTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.submit_application_time
     *
     * @param submitApplicationTime the value for t_pcs_po_plan_logistics_bill.submit_application_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setSubmitApplicationTime(Date submitApplicationTime) {
        this.submitApplicationTime = submitApplicationTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.shipment_port
     *
     * @return the value of t_pcs_po_plan_logistics_bill.shipment_port
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public String getShipmentPort() {
        return shipmentPort;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.shipment_port
     *
     * @param shipmentPort the value for t_pcs_po_plan_logistics_bill.shipment_port
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setShipmentPort(String shipmentPort) {
        this.shipmentPort = shipmentPort == null ? null : shipmentPort.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.destination_port
     *
     * @return the value of t_pcs_po_plan_logistics_bill.destination_port
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public String getDestinationPort() {
        return destinationPort;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.destination_port
     *
     * @param destinationPort the value for t_pcs_po_plan_logistics_bill.destination_port
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setDestinationPort(String destinationPort) {
        this.destinationPort = destinationPort == null ? null : destinationPort.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.pick_up_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.pick_up_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getPickUpTime() {
        return pickUpTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.pick_up_time
     *
     * @param pickUpTime the value for t_pcs_po_plan_logistics_bill.pick_up_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setPickUpTime(Date pickUpTime) {
        this.pickUpTime = pickUpTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.confirm_delivery_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.confirm_delivery_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getConfirmDeliveryTime() {
        return confirmDeliveryTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.confirm_delivery_time
     *
     * @param confirmDeliveryTime the value for t_pcs_po_plan_logistics_bill.confirm_delivery_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setConfirmDeliveryTime(Date confirmDeliveryTime) {
        this.confirmDeliveryTime = confirmDeliveryTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.bill_no
     *
     * @return the value of t_pcs_po_plan_logistics_bill.bill_no
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public String getBillNo() {
        return billNo;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.bill_no
     *
     * @param billNo the value for t_pcs_po_plan_logistics_bill.bill_no
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setBillNo(String billNo) {
        this.billNo = billNo == null ? null : billNo.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.bill_no_billing_weight
     *
     * @return the value of t_pcs_po_plan_logistics_bill.bill_no_billing_weight
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Float getBillNoBillingWeight() {
        return billNoBillingWeight;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.bill_no_billing_weight
     *
     * @param billNoBillingWeight the value for t_pcs_po_plan_logistics_bill.bill_no_billing_weight
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setBillNoBillingWeight(Float billNoBillingWeight) {
        this.billNoBillingWeight = billNoBillingWeight;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.estimated_departure_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.estimated_departure_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getEstimatedDepartureTime() {
        return estimatedDepartureTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.estimated_departure_time
     *
     * @param estimatedDepartureTime the value for t_pcs_po_plan_logistics_bill.estimated_departure_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setEstimatedDepartureTime(Date estimatedDepartureTime) {
        this.estimatedDepartureTime = estimatedDepartureTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.actual_departure_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.actual_departure_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getActualDepartureTime() {
        return actualDepartureTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.actual_departure_time
     *
     * @param actualDepartureTime the value for t_pcs_po_plan_logistics_bill.actual_departure_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setActualDepartureTime(Date actualDepartureTime) {
        this.actualDepartureTime = actualDepartureTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.estimated_arrival_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.estimated_arrival_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getEstimatedArrivalTime() {
        return estimatedArrivalTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.estimated_arrival_time
     *
     * @param estimatedArrivalTime the value for t_pcs_po_plan_logistics_bill.estimated_arrival_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setEstimatedArrivalTime(Date estimatedArrivalTime) {
        this.estimatedArrivalTime = estimatedArrivalTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.actual_arrival_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.actual_arrival_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getActualArrivalTime() {
        return actualArrivalTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.actual_arrival_time
     *
     * @param actualArrivalTime the value for t_pcs_po_plan_logistics_bill.actual_arrival_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setActualArrivalTime(Date actualArrivalTime) {
        this.actualArrivalTime = actualArrivalTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.change_order_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.change_order_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getChangeOrderTime() {
        return changeOrderTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.change_order_time
     *
     * @param changeOrderTime the value for t_pcs_po_plan_logistics_bill.change_order_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setChangeOrderTime(Date changeOrderTime) {
        this.changeOrderTime = changeOrderTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.customs_approval_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.customs_approval_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getCustomsApprovalTime() {
        return customsApprovalTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.customs_approval_time
     *
     * @param customsApprovalTime the value for t_pcs_po_plan_logistics_bill.customs_approval_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setCustomsApprovalTime(Date customsApprovalTime) {
        this.customsApprovalTime = customsApprovalTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.customs_release_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.customs_release_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getCustomsReleaseTime() {
        return customsReleaseTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.customs_release_time
     *
     * @param customsReleaseTime the value for t_pcs_po_plan_logistics_bill.customs_release_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setCustomsReleaseTime(Date customsReleaseTime) {
        this.customsReleaseTime = customsReleaseTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.estimated_delivery_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.estimated_delivery_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getEstimatedDeliveryTime() {
        return estimatedDeliveryTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.estimated_delivery_time
     *
     * @param estimatedDeliveryTime the value for t_pcs_po_plan_logistics_bill.estimated_delivery_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setEstimatedDeliveryTime(Date estimatedDeliveryTime) {
        this.estimatedDeliveryTime = estimatedDeliveryTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.actual_delivery_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.actual_delivery_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getActualDeliveryTime() {
        return actualDeliveryTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.actual_delivery_time
     *
     * @param actualDeliveryTime the value for t_pcs_po_plan_logistics_bill.actual_delivery_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setActualDeliveryTime(Date actualDeliveryTime) {
        this.actualDeliveryTime = actualDeliveryTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.update_time
     *
     * @return the value of t_pcs_po_plan_logistics_bill.update_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.update_time
     *
     * @param updateTime the value for t_pcs_po_plan_logistics_bill.update_time
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column t_pcs_po_plan_logistics_bill.bill_status
     *
     * @return the value of t_pcs_po_plan_logistics_bill.bill_status
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public Integer getBillStatus() {
        return billStatus;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column t_pcs_po_plan_logistics_bill.bill_status
     *
     * @param billStatus the value for t_pcs_po_plan_logistics_bill.bill_status
     *
     * @mbggenerated Thu Sep 13 16:12:07 CST 2018
     */
    public void setBillStatus(Integer billStatus) {
        this.billStatus = billStatus;
    }

    public Long getCreator() {
        return creator;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getRequestPaymentTime() {
        return requestPaymentTime;
    }

    public void setRequestPaymentTime(Date requestPaymentTime) {
        this.requestPaymentTime = requestPaymentTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getGoodsValue() {
        return goodsValue;
    }

    public void setGoodsValue(BigDecimal goodsValue) {
        this.goodsValue = goodsValue;
    }

    public BigDecimal getTariff() {
        return tariff;
    }

    public void setTariff(BigDecimal tariff) {
        this.tariff = tariff;
    }

    public BigDecimal getVat() {
        return vat;
    }

    public void setVat(BigDecimal vat) {
        this.vat = vat;
    }

    public String getInternationalAgent() {
        return internationalAgent;
    }

    public void setInternationalAgent(String internationalAgent) {
        this.internationalAgent = internationalAgent;
    }

    public BigDecimal getInternationalFee() {
        return internationalFee;
    }

    public void setInternationalFee(BigDecimal internationalFee) {
        this.internationalFee = internationalFee;
    }

    public String getInternalAgent() {
        return internalAgent;
    }

    public void setInternalAgent(String internalAgent) {
        this.internalAgent = internalAgent;
    }

    public BigDecimal getInternalFee() {
        return internalFee;
    }

    public void setInternalFee(BigDecimal internalFee) {
        this.internalFee = internalFee;
    }

    public List<PcsPoPlanLineVO> getPopLines() {
        return popLines;
    }

    public void setPopLines(List<PcsPoPlanLineVO> popLines) {
        this.popLines = popLines;
    }

    public String getAttachments() {
        return attachments;
    }

    public void setAttachments(String attachments) {
        this.attachments = attachments;
    }

    public Long getPopId() {
        return popId;
    }

    public void setPopId(Long popId) {
        this.popId = popId;
    }

    public Long getPoId() {
        return poId;
    }

    public void setPoId(Long poId) {
        this.poId = poId;
    }

    public String getIsDangerousGoodsCN() {
        return isDangerousGoodsCN;
    }

    public void setIsDangerousGoodsCN(String isDangerousGoodsCN) {
        this.isDangerousGoodsCN = isDangerousGoodsCN;
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public Long getPoCreator() {
        return poCreator;
    }

    public void setPoCreator(Long poCreator) {
        this.poCreator = poCreator;
    }

  public List<String> getNoticeAddressList() {
    return noticeAddressList;
  }

  public void setNoticeAddressList(List<String> noticeAddressList) {
    this.noticeAddressList = noticeAddressList;
  }

    public String getCreatorName() {
        return creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getPoCreatorName() {
        return poCreatorName;
    }

    public void setPoCreatorName(String poCreatorName) {
        this.poCreatorName = poCreatorName;
    }

    public BigDecimal getConsumptionTaxAmount() {
        return consumptionTaxAmount;
    }

    public void setConsumptionTaxAmount(BigDecimal consumptionTaxAmount) {
        this.consumptionTaxAmount = consumptionTaxAmount;
    }
}