/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import com.thebeastshop.wms.vo.WhJitPackageSkuReferenceVO;
import com.thebeastshop.wms.vo.WhWarehouseVO;
import com.thebeastshop.wms.vo.WhWmsQcProcessDetailVO;
import com.thebeastshop.wms.vo.WhWmsReceiveShelvesDetailVO;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoPlanLineVO.java, v 0.1 2015-08-10 10:01
 */
public class PcsPoPlanLineVO extends PcsPurchaseOrder implements Serializable {

    // constructor
    public PcsPoPlanLineVO() {

    }

    // qc待定处理日志
    public static final String COMM_LOG_ENTITY_NAME_HOLD_PENDING = "QcHoldPendingProcessLog";

    // original
    private Long id;

    private Long poPlanId;

    private Long qcId;

    private String primaryKey;

    private String skuCode;

    private Integer planedQuantity;

    private Integer qpb;//quantity per box,每箱件数

    private Integer qb;//quantity box,总箱数

    private Integer quantity;//qpb*qb=quantity,总件数

    private Integer wasteQuantity;

    private Integer qcQuantity;

    private Integer qcWasteQuantity;

    // 同一个pop所有的质检数量
    private Integer allQcQuantity;

    private Integer processedQuantity;

    private Integer skuStatus;

    private String skuStatusName;

    private String wastePic;
    
    private Date prodDate;// 生产日期
    
    private Integer sign;//分货完成标记(默认0-否)：0-否 1-是
    
    private Integer assignedNumber;//已分配数
    
    private List<WhJitPackageSkuReferenceVO> jitPackageSkuReferenceList;

    // self
    private String skuName;

    private String skuNameCn;

    // sku 保质期
    private Integer shelfLife;

    private String referenceCode;//来单关联包裹号

    private Set<String> referenceCodes;//来单关联包裹号

    private BigDecimal unitPrice;
    
    private BigDecimal unitPriceAfterTax;
    
    private Long poId;//ID
    //PO创建人
    private Long poCreator;

    private String poCode;

    private String physicalWarehouseCode;

    private String packageCode;//包裹号
    
    private Integer planStatus;//收货计划状态，0待收货1待入库2已入库3已完成4已关闭5入库中
    
    private String whCommandCode;//指令code
    
    private String warehouseCode;//pop收货仓

    // 轻残数量
    private Integer mildDamagedQuantity;
    // 中残数量
    private Integer moderateDamagedQuantity;
    // 重残数量
    private Integer severeDamagedQuantity;

    // 转良数量
    private Integer nonDefectiveQuantity;
    // 采退数量
    private Integer purchaseReturnQuantity;

    // 剩余待定数量 [待定数量-(轻+中+重)]
    private Integer surplusHoldPendingQuantity;


    private String hsCode;
    private String placeOfOrigin;//sku原产国
    private String material;//材质
    private String purpose;//用途
    private String skuImg;

    // manual generate

    private String popCode;
    private String buyerRealName;
    private String buyerNickName;
    private String buyerEmailAddress;
    private Integer processStatus;
    private String processStatusName;
    private Date processTime;
    private Long processUserId;
    private String processReason;
    private String defectiveReason;
    private Integer defectiveQuantity;
    private String qcSkuImg;
    private Integer allDefectiveQuantity;
    // 首次质检时间
    private Date firstQcTime;
    // 质检时间
    private Date qcTime;

    // sku是否自产
    private Integer isMadeBySelf;

    private boolean fetchScmQcDefectiveDetail;

    private List<CommFileRef> commFileRefs;

    private List<CommFileRef> qcCommFileRefs;

    private WhWmsQcProcessDetailVO whWmsQcProcessDetailVO;

    private List<WhWmsReceiveShelvesDetailVO> receiveShelvesDetailVOs;

    private List<WhWmsReceiveShelvesDetailVO> scmReceiveShelvesDetailVOs;

    // 采退
    private PcsPurchaseReturnVO pcsPurchaseReturnVO;

    private Integer defectiveAllQuantity;
    private String barcode;

    private BigDecimal netWeight;//净重
    private BigDecimal weight;//毛重
    private Date expirationDate;//截止日期
    private String skuBarandName;

    //残次图片
    private String skuWasteImages;
    //残次原因
    private String skuWasteReasons;


    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public String getHsCode() {
        return hsCode;
    }

    public void setHsCode(String hsCode) {
        this.hsCode = hsCode;
    }

    public BigDecimal getUnitPrice() {
		return unitPrice;
	}

	public String getWarehouseCode() {
		return warehouseCode;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

    public Integer getMildDamagedQuantity() {
        return mildDamagedQuantity;
    }

    public void setMildDamagedQuantity(Integer mildDamagedQuantity) {
        this.mildDamagedQuantity = mildDamagedQuantity;
    }

    public Integer getModerateDamagedQuantity() {
        return moderateDamagedQuantity;
    }

    public void setModerateDamagedQuantity(Integer moderateDamagedQuantity) {
        this.moderateDamagedQuantity = moderateDamagedQuantity;
    }

    public Integer getSevereDamagedQuantity() {
        return severeDamagedQuantity;
    }

    public void setSevereDamagedQuantity(Integer severeDamagedQuantity) {
        this.severeDamagedQuantity = severeDamagedQuantity;
    }

    public Integer getNonDefectiveQuantity() {
        return nonDefectiveQuantity;
    }

    public void setNonDefectiveQuantity(Integer nonDefectiveQuantity) {
        this.nonDefectiveQuantity = nonDefectiveQuantity;
    }

    public Integer getPurchaseReturnQuantity() {
        return purchaseReturnQuantity;
    }

    public void setPurchaseReturnQuantity(Integer purchaseReturnQuantity) {
        this.purchaseReturnQuantity = purchaseReturnQuantity;
    }

    public Integer getSurplusHoldPendingQuantity() {
        return surplusHoldPendingQuantity;
    }

    public void setSurplusHoldPendingQuantity(Integer surplusHoldPendingQuantity) {
        this.surplusHoldPendingQuantity = surplusHoldPendingQuantity;
    }

    public String getWhCommandCode() {
		return whCommandCode;
	}

	public void setWhCommandCode(String whCommandCode) {
		this.whCommandCode = whCommandCode;
	}

	public List<WhJitPackageSkuReferenceVO> getJitPackageSkuReferenceList() {
		return jitPackageSkuReferenceList;
	}

	public void setJitPackageSkuReferenceList(List<WhJitPackageSkuReferenceVO> jitPackageSkuReferenceList) {
		this.jitPackageSkuReferenceList = jitPackageSkuReferenceList;
	}

	public String getPackageCode() {
		return packageCode;
	}

	public void setPackageCode(String packageCode) {
		this.packageCode = packageCode;
	}

	public Integer getPlanStatus() {
		return planStatus;
	}

	public void setPlanStatus(Integer planStatus) {
		this.planStatus = planStatus;
	}

	public Integer getSign() {
		return sign;
	}

	public void setSign(Integer sign) {
		this.sign = sign;
	}

	public Integer getAssignedNumber() {
		return assignedNumber;
	}

	public void setAssignedNumber(Integer assignedNumber) {
		this.assignedNumber = assignedNumber;
	}

	public void setUnitPrice(BigDecimal unitPrice) {
		this.unitPrice = unitPrice;
	}

	public BigDecimal getUnitPriceAfterTax() {
		return unitPriceAfterTax;
	}

	public void setUnitPriceAfterTax(BigDecimal unitPriceAfterTax) {
		this.unitPriceAfterTax = unitPriceAfterTax;
	}

	public Long getPoId() {
		return poId;
	}

	public void setPoId(Long poId) {
		this.poId = poId;
	}

    public String getPoCode() {
        return poCode;
    }

    public void setPoCode(String poCode) {
        this.poCode = poCode;
    }

    @Override
    public String getPhysicalWarehouseCode() {
        return physicalWarehouseCode;
    }

    @Override
    public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
        this.physicalWarehouseCode = physicalWarehouseCode;
    }

    // auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPoPlanId() {
        return poPlanId;
    }

    public void setPoPlanId(Long poPlanId) {
        this.poPlanId = poPlanId;
    }

    public Long getQcId() {
        return qcId;
    }

    public void setQcId(Long qcId) {
        this.qcId = qcId;
    }

    public String getPrimaryKey() {
        return primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getPlanedQuantity() {
        return planedQuantity;
    }

    public void setPlanedQuantity(Integer planedQuantity) {
        this.planedQuantity = planedQuantity;
    }

    public Integer getQpb() {
        return qpb;
    }

    public void setQpb(Integer qpb) {
        this.qpb = qpb;
    }

    public Integer getQb() {
        return qb;
    }

    public void setQb(Integer qb) {
        this.qb = qb;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Integer getWasteQuantity() {
        return wasteQuantity;
    }

    public void setWasteQuantity(Integer wasteQuantity) {
        this.wasteQuantity = wasteQuantity;
    }

    public Integer getQcQuantity() {
        return qcQuantity;
    }

    public void setQcQuantity(Integer qcQuantity) {
        this.qcQuantity = qcQuantity;
    }

    public Integer getQcWasteQuantity() {
        return qcWasteQuantity;
    }

    public void setQcWasteQuantity(Integer qcWasteQuantity) {
        this.qcWasteQuantity = qcWasteQuantity;
    }

    public Integer getAllQcQuantity() {
        return allQcQuantity;
    }

    public void setAllQcQuantity(Integer allQcQuantity) {
        this.allQcQuantity = allQcQuantity;
    }

    public Integer getProcessedQuantity() {
        return processedQuantity;
    }

    public void setProcessedQuantity(Integer processedQuantity) {
        this.processedQuantity = processedQuantity;
    }

    public Integer getSkuStatus() {
        return skuStatus;
    }

    public void setSkuStatus(Integer skuStatus) {
        this.skuStatus = skuStatus;
    }

    public String getSkuStatusName() {
        if (EmptyUtil.isEmpty(skuStatusName) && EmptyUtil.isNotEmpty(skuStatus)){
            skuStatusName = WhWarehouseVO.getSkuStatusName(skuStatus);
            if (fetchScmQcDefectiveDetail && skuStatus == 28){
                skuStatusName = "采退";
            }
        }
        return skuStatusName;
    }

    public void setSkuStatusName(String skuStatusName) {
        this.skuStatusName = skuStatusName;
    }

    public String getWastePic() {
        return wastePic;
    }

    public void setWastePic(String wastePic) {
        this.wastePic = wastePic;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getSkuNameCn() {
        return skuNameCn;
    }

    public void setSkuNameCn(String skuNameCn) {
        this.skuNameCn = skuNameCn;
    }

    public Integer getShelfLife() {
        return shelfLife;
    }

    public void setShelfLife(Integer shelfLife) {
        this.shelfLife = shelfLife;
    }

    public String getReferenceCode() {
        return referenceCode;
    }

    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public Set<String> getReferenceCodes() {
        return referenceCodes;
    }

    public void setReferenceCodes(Set<String> referenceCodes) {
        this.referenceCodes = referenceCodes;
    }

    public Date getProdDate() {
        return prodDate;
    }

    public void setProdDate(Date prodDate) {
        this.prodDate = prodDate;
    }

    public String getPopCode() {
        return popCode;
    }

    public void setPopCode(String popCode) {
        this.popCode = popCode;
    }

    public String getBuyerRealName() {
        return buyerRealName;
    }

    public void setBuyerRealName(String buyerRealName) {
        this.buyerRealName = buyerRealName;
    }

    public String getBuyerNickName() {
        return buyerNickName;
    }

    public void setBuyerNickName(String buyerNickName) {
        this.buyerNickName = buyerNickName;
    }

    public String getBuyerEmailAddress() {
        return buyerEmailAddress;
    }

    public void setBuyerEmailAddress(String buyerEmailAddress) {
        this.buyerEmailAddress = buyerEmailAddress;
    }

    public Integer getProcessStatus() {
        return processStatus;
    }

    public void setProcessStatus(Integer processStatus) {
        this.processStatus = processStatus;
    }

    public String getProcessStatusName() {
        if (EmptyUtil.isEmpty(processStatusName)){
            if (EmptyUtil.isNotEmpty(this.processStatus)){
                processStatusName = WhWmsQcProcessDetailVO.DEFECTIVE_PROCESS_STATUS_MAP.get(this.processStatus);
                processStatusName = processStatusName!=null?processStatusName:"待处理";
            }else{
                processStatusName = "待处理";
            }
        }
        return processStatusName;
    }

    public void setProcessStatusName(String processStatusName) {
        this.processStatusName = processStatusName;
    }

    public Date getProcessTime() {
        return processTime;
    }

    public void setProcessTime(Date processTime) {
        this.processTime = processTime;
    }

    public Long getProcessUserId() {
        return processUserId;
    }

    public void setProcessUserId(Long processUserId) {
        this.processUserId = processUserId;
    }

    public String getProcessReason() {
        return processReason;
    }

    public void setProcessReason(String processReason) {
        this.processReason = processReason;
    }

    public String getDefectiveReason() {
        return defectiveReason;
    }

    public void setDefectiveReason(String defectiveReason) {
        this.defectiveReason = defectiveReason;
    }

    public Integer getDefectiveQuantity() {
        return defectiveQuantity;
    }

    public void setDefectiveQuantity(Integer defectiveQuantity) {
        this.defectiveQuantity = defectiveQuantity;
    }

    public String getSkuImg() {
        return skuImg;
    }

    public void setSkuImg(String skuImg) {
        this.skuImg = skuImg;
    }

    public String getQcSkuImg() {
        return qcSkuImg;
    }

    public void setQcSkuImg(String qcSkuImg) {
        this.qcSkuImg = qcSkuImg;
    }

    public Integer getAllDefectiveQuantity() {
        return allDefectiveQuantity;
    }

    public void setAllDefectiveQuantity(Integer allDefectiveQuantity) {
        this.allDefectiveQuantity = allDefectiveQuantity;
    }

    public Date getFirstQcTime() {
        return firstQcTime;
    }

    public void setFirstQcTime(Date firstQcTime) {
        this.firstQcTime = firstQcTime;
    }

    public Date getQcTime() {
        return qcTime;
    }

    public void setQcTime(Date qcTime) {
        this.qcTime = qcTime;
    }

    public Integer getIsMadeBySelf() {
        return isMadeBySelf;
    }

    public void setIsMadeBySelf(Integer isMadeBySelf) {
        this.isMadeBySelf = isMadeBySelf;
    }

    public boolean isFetchScmQcDefectiveDetail() {
        return fetchScmQcDefectiveDetail;
    }

    public void setFetchScmQcDefectiveDetail(boolean fetchScmQcDefectiveDetail) {
        this.fetchScmQcDefectiveDetail = fetchScmQcDefectiveDetail;
    }

    public List<CommFileRef> getCommFileRefs() {
        return commFileRefs;
    }

    public void setCommFileRefs(List<CommFileRef> commFileRefs) {
        this.commFileRefs = commFileRefs;
    }

    public List<CommFileRef> getQcCommFileRefs() {
        return qcCommFileRefs;
    }

    public void setQcCommFileRefs(List<CommFileRef> qcCommFileRefs) {
        this.qcCommFileRefs = qcCommFileRefs;
    }

    public WhWmsQcProcessDetailVO getWhWmsQcProcessDetailVO() {
        return whWmsQcProcessDetailVO;
    }

    public void setWhWmsQcProcessDetailVO(WhWmsQcProcessDetailVO whWmsQcProcessDetailVO) {
        this.whWmsQcProcessDetailVO = whWmsQcProcessDetailVO;
    }

    public List<WhWmsReceiveShelvesDetailVO> getReceiveShelvesDetailVOs() {
        return receiveShelvesDetailVOs;
    }

    public void setReceiveShelvesDetailVOs(List<WhWmsReceiveShelvesDetailVO> receiveShelvesDetailVOs) {
        this.receiveShelvesDetailVOs = receiveShelvesDetailVOs;
    }

    public List<WhWmsReceiveShelvesDetailVO> getScmReceiveShelvesDetailVOs() {
        return scmReceiveShelvesDetailVOs;
    }

    public void setScmReceiveShelvesDetailVOs(List<WhWmsReceiveShelvesDetailVO> scmReceiveShelvesDetailVOs) {
        this.scmReceiveShelvesDetailVOs = scmReceiveShelvesDetailVOs;
    }

    public PcsPurchaseReturnVO getPcsPurchaseReturnVO() {
        return pcsPurchaseReturnVO;
    }

    public void setPcsPurchaseReturnVO(PcsPurchaseReturnVO pcsPurchaseReturnVO) {
        this.pcsPurchaseReturnVO = pcsPurchaseReturnVO;
    }

    public Integer getDefectiveAllQuantity() {
        return defectiveAllQuantity;
    }

    public void setDefectiveAllQuantity(Integer defectiveAllQuantity) {
        this.defectiveAllQuantity = defectiveAllQuantity;
    }

    public String getPlaceOfOrigin() {
        return placeOfOrigin;
    }

    public void setPlaceOfOrigin(String placeOfOrigin) {
        this.placeOfOrigin = placeOfOrigin;
    }

    public String getMaterial() {
        return material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public String getPurpose() {
        return purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getBarcode() {
        return barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public Long getPoCreator() {
        return poCreator;
    }

    public void setPoCreator(Long poCreator) {
        this.poCreator = poCreator;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getSkuBarandName() {
        return skuBarandName;
    }

    public void setSkuBarandName(String skuBarandName) {
        this.skuBarandName = skuBarandName;
    }

    public String getSkuWasteImages() {
        return skuWasteImages;
    }

    public void setSkuWasteImages(String skuWasteImages) {
        this.skuWasteImages = skuWasteImages;
    }

    public String getSkuWasteReasons() {
        return skuWasteReasons;
    }

    public void setSkuWasteReasons(String skuWasteReasons) {
        this.skuWasteReasons = skuWasteReasons;
    }
}
