/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoLineVO.java, v 0.1 2015-08-10 09:54
 */
@ExcelTemplate
@ExcelSheet(value = "sheet1")
public class PcsPoLineVO implements Serializable {

    // constructor
    public PcsPoLineVO() {

    }

    // original
    private Long id;

    private Long poId;

    @ExcelColumn(name="skucode")
    @NotNull
    private String skuCode;

    @ExcelColumn(name="数量")
    @NotNull
    private Integer quantity;

    @ExcelColumn(name="单价")
    @NotNull
    private BigDecimal unitPrice;

    private BigDecimal totalPrice;

    @ExcelColumn(name="税率%(填写整数)")
    @NotNull
    private BigDecimal taxRate;


    private String taxRateDesc;

    private BigDecimal unitPriceAfterTax;

    private BigDecimal totalPriceAfterTax;
    // self
    private String skuName;

    private String skuNameCn;
    //SKU人民币成本
    private BigDecimal skuCostPrice;

    //SKU外币成本
	private BigDecimal currencyCostPrice;
	//SKU币种
	private String skuExchangeCurrency;

    private String skuPicFileId;
    
    private String skuCustomMadeCode;

    private Integer skuQuantity;

    private Integer skuStatus;

    // 待定数量
    private Integer skuWasteQuantity;
    // 剩余待定数量 [待定数量-(轻+中+重+转良+采退)]
    private Integer surplusHoldPendingQuantity;
    // 轻残数量
    private Integer mildDamagedQuantity;
    // 中残数量
    private Integer moderateDamagedQuantity;
    // 重残数量
    private Integer severeDamagedQuantity;
    // 转良数量
    private Integer nonDefectiveQuantity;
    // 采退数量
    private Integer purchaseReturnQuantity;

    private Integer maxPlanReceiveNum;
    
    /*待入库数量*/
    private Integer toStorageQuantity;
    // manual generate
    
    //首次售价审核是否通过
    private Boolean firstAuditPass;
    
    private Integer planStatus;//计划状态，0待收货1待入库2已入库3已完成4已关闭5入库中
    
    @ExcelColumn(name="售价")
    @Min(value = 0)
    //@NotNull
    private BigDecimal salesPrice;

    private Integer isJit;//sku是否是来单制作
    
    private Integer canCustomize;//是否为定制商品(0-不是 1-是)

    //xll create(财务预算明细需要)
    private String POCode;

    private String skuCategoryName;
    
    private Integer whetherConsignment;
    
     // 调整后的单价,税后单价  为null则取 UNIT_PRICE
    private BigDecimal adjustUnitPrice;
    // 调整后的税率
    private BigDecimal adjustTaxRate;

    // 调整后的单价,获取是否为null
    private BigDecimal adjustUnitPriceFlag;
    // 调整后的税率，获取是否为null
    private BigDecimal adjustTaxRateFlag;

    // sku 是否需要生产日期1是0否
    private Integer needProdDate;
    
    private String packageCode;//包裹号
    
    private Date payTime;//支付时间
    
    private Date deliveryTime;//预计发货日期
    
    private String channelName;//渠道
    
    private String warehouseName;//包裹发货仓
    
    private String remark;//包裹备注
    
    private Integer cancleQuantity;//取消数量
    
    private Integer sl;//商品数量-取消数量
    
    private String popCode;//采购单收货计划编码
    
    private String whCommandCode;//仓库指令编码
    
    private Date planedSendDate;//计划发货日期
    
    private Date planedReceiveDate;//计划收货日期
    
    private Date receiveDate;//实际收货日期
    
    private Integer referenceType;//单据类型 1:加工单 2:采购单,3调拨单,4来单加工单
    
    private Integer referenceStatus;//状态 1待处理,0取消,2完成
    
    private Date planedDeliveryDate;//预计发货日期
    
    private String dispatchWarehouseCode;//包裹发货仓
    
    private String warehouseCode;//收货仓
    
    private Integer planedQuantity;//计划数量
    
    private Integer cutStatus;//商品取消状态，默认0是没有取消
    
    private Integer quantityA;//关联数量
    
    private Integer quantityB;//商品数量
    
    private Integer quantityC;//取消数量

    private Date askDeliveryDate;
    private String purchaseCurrencyCode;
    private String placeOfOrigin;
    private String specification;
    private String barcode;
    private Integer crossBorderFlag;

    private boolean deleteCurrentLine = false;

   public Integer getQuantityA() {
		return quantityA;
	}

	public void setQuantityA(Integer quantityA) {
		this.quantityA = quantityA;
	}

	public Integer getQuantityB() {
		return quantityB;
	}

	public void setQuantityB(Integer quantityB) {
		this.quantityB = quantityB;
	}

	public Integer getQuantityC() {
		return quantityC;
	}

	public void setQuantityC(Integer quantityC) {
		this.quantityC = quantityC;
	}

	public Integer getCancleQuantity() {
		return cancleQuantity;
	}

	public void setCancleQuantity(Integer cancleQuantity) {
		this.cancleQuantity = cancleQuantity;
	}

	public Integer getCutStatus() {
		return cutStatus;
	}

	public void setCutStatus(Integer cutStatus) {
		this.cutStatus = cutStatus;
	}

	public Integer getPlanedQuantity() {
		return planedQuantity;
	}

	public void setPlanedQuantity(Integer planedQuantity) {
		this.planedQuantity = planedQuantity;
	}

	public String getPopCode() {
		return popCode;
	}

	public void setPopCode(String popCode) {
		this.popCode = popCode;
	}

	public String getWhCommandCode() {
		return whCommandCode;
	}

	public void setWhCommandCode(String whCommandCode) {
		this.whCommandCode = whCommandCode;
	}

	public Date getPlanedSendDate() {
		return planedSendDate;
	}

	public void setPlanedSendDate(Date planedSendDate) {
		this.planedSendDate = planedSendDate;
	}

	public Date getPlanedReceiveDate() {
		return planedReceiveDate;
	}

	public void setPlanedReceiveDate(Date planedReceiveDate) {
		this.planedReceiveDate = planedReceiveDate;
	}

	public Date getReceiveDate() {
		return receiveDate;
	}

	public void setReceiveDate(Date receiveDate) {
		this.receiveDate = receiveDate;
	}

	public Integer getReferenceType() {
		return referenceType;
	}

	public void setReferenceType(Integer referenceType) {
		this.referenceType = referenceType;
	}

	public Integer getReferenceStatus() {
		return referenceStatus;
	}

	public void setReferenceStatus(Integer referenceStatus) {
		this.referenceStatus = referenceStatus;
	}

	public Date getPlanedDeliveryDate() {
		return planedDeliveryDate;
	}

	public void setPlanedDeliveryDate(Date planedDeliveryDate) {
		this.planedDeliveryDate = planedDeliveryDate;
	}

	public String getDispatchWarehouseCode() {
		return dispatchWarehouseCode;
	}

	public void setDispatchWarehouseCode(String dispatchWarehouseCode) {
		this.dispatchWarehouseCode = dispatchWarehouseCode;
	}

	public String getWarehouseCode() {
		return warehouseCode;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public Integer getCanCustomize() {
		return canCustomize;
	}

	public void setCanCustomize(Integer canCustomize) {
		this.canCustomize = canCustomize;
	}

	public String getPackageCode() {
		return packageCode;
	}

	public void setPackageCode(String packageCode) {
		this.packageCode = packageCode;
	}

	public Date getPayTime() {
		return payTime;
	}

	public void setPayTime(Date payTime) {
		this.payTime = payTime;
	}

	public Date getDeliveryTime() {
		return deliveryTime;
	}

	public void setDeliveryTime(Date deliveryTime) {
		this.deliveryTime = deliveryTime;
	}

	public String getChannelName() {
		return channelName;
	}

	public void setChannelName(String channelName) {
		this.channelName = channelName;
	}

	public String getWarehouseName() {
		return warehouseName;
	}

	public void setWarehouseName(String warehouseName) {
		this.warehouseName = warehouseName;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public Integer getSl() {
		return sl;
	}

	public void setSl(Integer sl) {
		this.sl = sl;
	}

	public String getSkuCustomMadeCode() {
		return skuCustomMadeCode;
	}

	public void setSkuCustomMadeCode(String skuCustomMadeCode) {
		this.skuCustomMadeCode = skuCustomMadeCode;
	}

	public Integer getWhetherConsignment() {
		return whetherConsignment;
	}

	public void setWhetherConsignment(Integer whetherConsignment) {
		this.whetherConsignment = whetherConsignment;
	}

    public Integer getPlanStatus() {
		return planStatus;
	}

	public void setPlanStatus(Integer planStatus) {
		this.planStatus = planStatus;
	}

	public Boolean getFirstAuditPass() {
		return firstAuditPass;
	}

	public void setFirstAuditPass(Boolean firstAuditPass) {
		this.firstAuditPass = firstAuditPass;
	}

	public Integer getToStorageQuantity() {
		return toStorageQuantity;
	}

	public void setToStorageQuantity(Integer toStorageQuantity) {
		this.toStorageQuantity = toStorageQuantity;
	}

	public Integer getMaxPlanReceiveNum() {
		return maxPlanReceiveNum;
	}

	public void setMaxPlanReceiveNum(Integer maxPlanReceiveNum) {
		this.maxPlanReceiveNum = maxPlanReceiveNum;
	}

	// auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPoId() {
        return poId;
    }

    public void setPoId(Long poId) {
        this.poId = poId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getTaxRateDesc() {
        return taxRateDesc;
    }

    public void setTaxRateDesc(String taxRateDesc) {
        this.taxRateDesc = taxRateDesc;
    }

    public BigDecimal getUnitPriceAfterTax() {
        return unitPriceAfterTax;
    }

    public void setUnitPriceAfterTax(BigDecimal unitPriceAfterTax) {
        this.unitPriceAfterTax = unitPriceAfterTax;
    }

    public BigDecimal getTotalPriceAfterTax() {
        return totalPriceAfterTax;
    }

    public void setTotalPriceAfterTax(BigDecimal totalPriceAfterTax) {
        this.totalPriceAfterTax = totalPriceAfterTax;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public BigDecimal getSkuCostPrice() {
        return skuCostPrice;
    }

    public void setSkuCostPrice(BigDecimal skuCostPrice) {
        this.skuCostPrice = skuCostPrice;
    }

    public String getSkuPicFileId() {
        return skuPicFileId;
    }

    public void setSkuPicFileId(String skuPicFileId) {
        this.skuPicFileId = skuPicFileId;
    }

    public String getSkuNameCn() {
        return skuNameCn;
    }

    public void setSkuNameCn(String skuNameCn) {
        this.skuNameCn = skuNameCn;
    }

    public Integer getSkuQuantity() {
        return skuQuantity;
    }

    public void setSkuQuantity(Integer skuQuantity) {
        this.skuQuantity = skuQuantity;
    }

    public Integer getSkuStatus() {
        return skuStatus;
    }

    public void setSkuStatus(Integer skuStatus) {
        this.skuStatus = skuStatus;
    }

    public Integer getSkuWasteQuantity() {
        return skuWasteQuantity;
    }

    public void setSkuWasteQuantity(Integer skuWasteQuantity) {
        this.skuWasteQuantity = skuWasteQuantity;
    }

    public Integer getSurplusHoldPendingQuantity() {
        return surplusHoldPendingQuantity;
    }

    public void setSurplusHoldPendingQuantity(Integer surplusHoldPendingQuantity) {
        this.surplusHoldPendingQuantity = surplusHoldPendingQuantity;
    }

    public Integer getMildDamagedQuantity() {
        return mildDamagedQuantity;
    }

    public void setMildDamagedQuantity(Integer mildDamagedQuantity) {
        this.mildDamagedQuantity = mildDamagedQuantity;
    }

    public Integer getModerateDamagedQuantity() {
        return moderateDamagedQuantity;
    }

    public void setModerateDamagedQuantity(Integer moderateDamagedQuantity) {
        this.moderateDamagedQuantity = moderateDamagedQuantity;
    }

    public Integer getSevereDamagedQuantity() {
        return severeDamagedQuantity;
    }

    public void setSevereDamagedQuantity(Integer severeDamagedQuantity) {
        this.severeDamagedQuantity = severeDamagedQuantity;
    }

    public Integer getNonDefectiveQuantity() {
        return nonDefectiveQuantity;
    }

    public void setNonDefectiveQuantity(Integer nonDefectiveQuantity) {
        this.nonDefectiveQuantity = nonDefectiveQuantity;
    }

    public Integer getPurchaseReturnQuantity() {
        return purchaseReturnQuantity;
    }

    public void setPurchaseReturnQuantity(Integer purchaseReturnQuantity) {
        this.purchaseReturnQuantity = purchaseReturnQuantity;
    }

    public BigDecimal getSalesPrice() {
		return salesPrice;
	}

	public void setSalesPrice(BigDecimal salesPrice) {
		this.salesPrice = salesPrice;
	}

	public String getPOCode() {
		return POCode;
	}

	public void setPOCode(String pOCode) {
		POCode = pOCode;
	}

    public Integer getIsJit() {
        return isJit;
    }

    public void setIsJit(Integer isJit) {
        this.isJit = isJit;
    }

	public String getSkuCategoryName() {
		return skuCategoryName;
	}

	public void setSkuCategoryName(String skuCategoryName) {
		this.skuCategoryName = skuCategoryName;
	}
	
	  public BigDecimal getAdjustUnitPrice() { return adjustUnitPrice; }

    public void setAdjustUnitPrice(BigDecimal adjustUnitPrice) { this.adjustUnitPrice = adjustUnitPrice; }

    public BigDecimal getAdjustTaxRate() { return adjustTaxRate; }

    public void setAdjustTaxRate(BigDecimal adjustTaxRate) { this.adjustTaxRate = adjustTaxRate; }

    public BigDecimal getAdjustUnitPriceFlag() {
        return adjustUnitPriceFlag;
    }

    public void setAdjustUnitPriceFlag(BigDecimal adjustUnitPriceFlag) {
        this.adjustUnitPriceFlag = adjustUnitPriceFlag;
    }

    public BigDecimal getAdjustTaxRateFlag() {
        return adjustTaxRateFlag;
    }

    public void setAdjustTaxRateFlag(BigDecimal adjustTaxRateFlag) {
        this.adjustTaxRateFlag = adjustTaxRateFlag;
    }

    public Integer getNeedProdDate() {
        return needProdDate;
    }

    public void setNeedProdDate(Integer needProdDate) {
        this.needProdDate = needProdDate;
    }

	public BigDecimal getCurrencyCostPrice() {
		return currencyCostPrice;
	}

	public void setCurrencyCostPrice(BigDecimal currencyCostPrice) {
		this.currencyCostPrice = currencyCostPrice;
	}

	public String getSkuExchangeCurrency() {
		return skuExchangeCurrency;
	}

	public void setSkuExchangeCurrency(String skuExchangeCurrency) {
		this.skuExchangeCurrency = skuExchangeCurrency;
	}

    public Date getAskDeliveryDate() {
        return askDeliveryDate;
    }

    public void setAskDeliveryDate(Date askDeliveryDate) {
        this.askDeliveryDate = askDeliveryDate;
    }

    public String getPurchaseCurrencyCode() {
        return purchaseCurrencyCode;
    }

    public void setPurchaseCurrencyCode(String purchaseCurrencyCode) {
        this.purchaseCurrencyCode = purchaseCurrencyCode;
    }

    public String getPlaceOfOrigin() {
        return placeOfOrigin;
    }

    public void setPlaceOfOrigin(String placeOfOrigin) {
        this.placeOfOrigin = placeOfOrigin;
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public String getBarcode() {
        return barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public Integer getCrossBorderFlag() {
      return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
      this.crossBorderFlag = crossBorderFlag;
    }

    public boolean isDeleteCurrentLine() {
        return deleteCurrentLine;
    }

    public void setDeleteCurrentLine(boolean deleteCurrentLine) {
        this.deleteCurrentLine = deleteCurrentLine;
    }

    @Override
	public String toString() {
		return "PcsPoLineVO [id=" + id + ", poId=" + poId + ", skuCode=" + skuCode + ", quantity=" + quantity
				+ ", unitPrice=" + unitPrice + ", totalPrice=" + totalPrice + ", taxRate=" + taxRate + ", taxRateDesc="
				+ taxRateDesc + ", unitPriceAfterTax=" + unitPriceAfterTax + ", totalPriceAfterTax="
				+ totalPriceAfterTax + ", skuName=" + skuName + ", skuNameCn=" + skuNameCn + ", skuCostPrice="
				+ skuCostPrice + ", skuPicFileId=" + skuPicFileId + ", skuCustomMadeCode=" + skuCustomMadeCode
				+ ", skuQuantity=" + skuQuantity + ", skuWasteQuantity=" + skuWasteQuantity + ", maxPlanReceiveNum="
				+ maxPlanReceiveNum + ", toStorageQuantity=" + toStorageQuantity + ", firstAuditPass=" + firstAuditPass
				+ ", planStatus=" + planStatus + ", salesPrice=" + salesPrice + ", isJit=" + isJit + ", POCode="
				+ POCode + ", skuCategoryName=" + skuCategoryName + ", whetherConsignment=" + whetherConsignment
				+ ", adjustUnitPrice=" + adjustUnitPrice + ", adjustTaxRate=" + adjustTaxRate + ", adjustUnitPriceFlag="
				+ adjustUnitPriceFlag + ", adjustTaxRateFlag=" + adjustTaxRateFlag + ", needProdDate=" + needProdDate
				+ ", packageCode=" + packageCode + ", payTime=" + payTime + ", deliveryTime=" + deliveryTime
				+ ", channelName=" + channelName + ", warehouseName=" + warehouseName + ", remark=" + remark + ", sl="
				+ sl + "]";
	}
}

