package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.model.PcsPoCreditNote;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.model.CommFileRef;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xw
 * @create 2019-03-07 14:26
 */
public class PcsPoCreditNoteVO extends PcsPoCreditNote implements Serializable {

    // 未使用
    public static final int STATUS_NO_USE = 0;
    // 使用中
    public static final int STATUS_IN_USE = 1;
    // 已使用
    public static final int STATUS_USEED = 2;

    public static final Map<Integer, String> STATUS_MAP = new HashMap<Integer, String>(){{
        put(STATUS_NO_USE, "未使用");
        put(STATUS_IN_USE, "使用中");
        put(STATUS_USEED, "已使用");
    }};

    // 可用金额
    private BigDecimal usableAmount;

    private List<CommFileRef> attachmentList;

    private String statusName;

    public BigDecimal getUsableAmount() {
        return usableAmount;
    }

    public void setUsableAmount(BigDecimal usableAmount) {
        this.usableAmount = usableAmount;
    }

    public List<CommFileRef> getAttachmentList() {
        return attachmentList;
    }

    public void setAttachmentList(List<CommFileRef> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public String getStatusName() {
        if (EmptyUtil.isEmpty(this.getStatus())){
            return "";
        }
        return STATUS_MAP.get(this.getStatus());
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }
}
