package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.enums.PoFinancePaymentModeEnum;
import com.thebeastshop.pegasus.service.purchase.model.PcsFinancePayment;
import com.thebeastshop.pegasus.util.vo.CommDictionaryVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*******************************************************************************
 * javaBeans
 * t_pcs_finance_payment --> PcsFinancePayment 
 * <table explanation>
 * @author 2016-09-13 15:28:41
 *
 */
public class PcsFinancePaymentVO extends PcsFinancePayment implements java.io.Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * 财务付款类型  1:采购单付款、2:费用调整
     */
    public static final Integer TYPE_PURCHASE_ORDER = 1;

    public static final Integer TYPE_PURCHASE_ORDER_COST_ADJUST = 2;

    /**
     * 采购单 财务付款 费用类型标识
     * 目前包含5部分：采购单费用、扩展费用、物流费用、税金费用、其它费用
     */
    // 采购单费用
    public static final String PO_COST_TYPE_FLAG_PO = "PO_COST";
    // 采购单扩展费用 by PoCostTypeExtEnum
    public static final String PO_COST_TYPE_FLAG_PO_EXT = "PO_COST_EXT";
    // pop物流费用类型
    public static final String PO_COST_TYPE_FLAG_SHIPMENT_TYPE = CommDictionaryVO.DICT_TYPE_SHIPMENT_TYPE;
    // pop税金类型
    public static final String PO_COST_TYPE_FLAG_TAX_TYPE = CommDictionaryVO.DICT_TYPE_TAX_TYPE;
    // pop其它费用类型
    public static final String PO_COST_TYPE_FLAG_OTHER_FEE_TYPE = CommDictionaryVO.DICT_TYPE_OTHER_FEE_TYPE;

    // 使用采购单币种的选项
    public static final List<String> PURCHASE_CURRENCY_FLAGS = new ArrayList<String>() {{
        add(PO_COST_TYPE_FLAG_PO);
        add(PO_COST_TYPE_FLAG_PO_EXT);
    }};

    private BigDecimal balanceAmountTemp;

    // 付款总金额
    private BigDecimal totalAmount;

    // 可用金额
    private BigDecimal poUsableAmount;

    // 费用类型名称
    private String poCostTypeName;

    // 付款人名称
    private String payerName;

    private String poCode;

    // 使用Credit Note抵扣 或 转PO单付款时，记录对应PO单付款信息
    // private PcsFinancePaymentVO refPoFPVO;

    // 采购单支付方式
    public static final Map<Integer, String> PO_PAYMENT_MODE_MAP = new LinkedHashMap<Integer, String>() {{
        put(PoFinancePaymentModeEnum.payment.getKey(), PoFinancePaymentModeEnum.payment.getValue());
        put(PoFinancePaymentModeEnum.refund.getKey(), PoFinancePaymentModeEnum.refund.getValue());
        put(PoFinancePaymentModeEnum.credit_note.getKey(), PoFinancePaymentModeEnum.credit_note.getValue());
        put(PoFinancePaymentModeEnum.by_po_code.getKey(), PoFinancePaymentModeEnum.by_po_code.getValue());
    }};

    public BigDecimal getBalanceAmountTemp() {
        return balanceAmountTemp;
    }

    public void setBalanceAmountTemp(BigDecimal balanceAmountTemp) {
        this.balanceAmountTemp = balanceAmountTemp;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getPoUsableAmount() {
        return poUsableAmount;
    }

    public void setPoUsableAmount(BigDecimal poUsableAmount) {
        this.poUsableAmount = poUsableAmount;
    }

    public String getPayerName() {
        return payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }

    public String getPoCostTypeName() {
        return poCostTypeName;
    }

    public void setPoCostTypeName(String poCostTypeName) {
        this.poCostTypeName = poCostTypeName;
    }

    public String getPoCode() {
        return poCode;
    }

    public void setPoCode(String poCode) {
        this.poCode = poCode;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}