package com.thebeastshop.pegasus.service.purchase.vo;

import java.security.Key;
import java.util.*;

import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTpl;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

public class PcsCertificateTplVO extends PcsCertificateTpl{
	
	final static Integer TYPE_COMMON_USE_YES = 1;

	final public static Integer TYPE_COMMON_USE_NO = 0;

	final public static String TPL_SPECIAL_TYPE_TEXTILE = "1";//纺织品维护方法

	final public static String TPL_SPECIAL_TYPE_CAUTIONS_IN_USE = "2";//使用警告

	final public static String TPL_SPECIAL_TYPE_CAUTIONS_IN_USE_CODE = "CAUTIONS_IN_USE";//使用警告

	final public static List<String> TEXTILE_WASHINGDATALIST = new ArrayList<>();
	final public static Map<String,String> TEXTILE_WASHING_DATAMAP = new TreeMap<>();

	final public static List<String> TEXTILE_BLEACHDATALIST = new ArrayList<>();
    final public static Map<String,String> TEXTILE_BLEACH_DATAMAP = new TreeMap<>();

	final public static List<String> TEXTILE_NATURALDRYINGDATALIST = new ArrayList<>();
    final public static Map<String,String> TEXTILE_NATURAL_DRYING_DATAMAP = new TreeMap<>();

    final public static List<String> TEXTILE_TURNDRYINGDATALIST = new ArrayList<>();
    final public static Map<String,String> TEXTILE_TURNDRYING_DATAMAP = new TreeMap<>();

    final public static List<String> TEXTILE_IRONINGDATALIST = new ArrayList<>();
    final public static Map<String,String> TEXTILE_IRONING_DATAMAP = new TreeMap<>();

    final public static List<String> TEXTILE_PROFESSIONALMAINTENANCEDATALIST = new ArrayList<>();
    final public static Map<String,String> TEXTILE_PROFESSIONAL_MAINTENANCE_DATAMAP = new TreeMap<>();

    static {
		//纺织品特殊维护方法字段值
		String[] washingData = {"u153","u155","u157","u159","u161","u163","u165","u167","u169","u171","u173","u175","u177","u179"};//水洗
		String[] washingDataName = {"不可水洗","手洗","非常缓水洗30","缓水洗30","水洗30","非常缓水洗40","缓水洗40","水洗40","缓水洗50","水洗50","缓水洗60","水洗60","水洗70","水洗95"};//水洗
        int index = 0;
        for(String value : washingData){
			TEXTILE_WASHINGDATALIST.add(value);
            TEXTILE_WASHING_DATAMAP.put(value,washingDataName[index]);
            index++;
		}

		String[] bleachData = {"u191","u189","u187"};//漂白
		String[] bleachDataName = {"不可漂白","仅氧漂","任何漂"};//漂白
        index = 0;
		for(String value : bleachData){
			TEXTILE_BLEACHDATALIST.add(value);
            TEXTILE_BLEACH_DATAMAP.put(value,bleachDataName[index]);
            index++;
		}

		String[] naturalDryingData = {"u203","u205","u207","u201","u209","u211","u213","u215"};//自然干燥
		String[] naturalDryingDataName = {"悬挂晾干","悬挂滴干","阴凉悬挂晾干","阴凉悬挂滴干","平摊晾干","平摊滴干","阴凉平摊晾干","阴凉平摊滴干"};//自然干燥
        index = 0;
		for(String value : naturalDryingData){
			TEXTILE_NATURALDRYINGDATALIST.add(value);
            TEXTILE_NATURAL_DRYING_DATAMAP.put(value,naturalDryingDataName[index]);
            index++;
		}

		String[] turnDryingData = {"u199","u221","u219"};//翻转干燥
		String[] turnDryingDataName = {"不可翻干","低温翻干","常规翻干"};//翻转干燥
        index = 0;
		for(String value : turnDryingData){
			TEXTILE_TURNDRYINGDATALIST.add(value);
            TEXTILE_TURNDRYING_DATAMAP.put(value,turnDryingDataName[index]);
            index++;
		}

		String[] ironingData = {"u227","u229","u231","u233"};//熨烫
		String[] ironingDataName = {"不可熨烫","低温熨烫","中温熨烫","高温熨烫"};//熨烫
        index = 0;
		for(String value : ironingData){
			TEXTILE_IRONINGDATALIST.add(value);
            TEXTILE_IRONING_DATAMAP.put(value,ironingDataName[index]);
            index++;
		}

		String[] professionalMaintenanceData = {"u241","u243","u245","u239","u247","u249","u251","u253"};//专业维护
		String[] professionalMaintenanceDataName = {"不可干洗","常规干洗","缓和干洗","常规碳氢干洗","缓和碳氢干洗","常规湿洗","缓和湿洗","非常缓和湿洗"};//专业维护
        index = 0;
		for(String value : professionalMaintenanceData){
			TEXTILE_PROFESSIONALMAINTENANCEDATALIST.add(value);
            TEXTILE_PROFESSIONAL_MAINTENANCE_DATAMAP.put(value,professionalMaintenanceDataName[index]);
            index++;
		}
	}

	private List<Long> categoryIds;
	
	private List<PcsCertificateTplFieldVO> tplFieldVOList;

    private Date createTime;
    private Long createUserId;


	public List<Long> getCategoryIds() {
		return categoryIds;
	}

	public void setCategoryIds(List<Long> categoryIds) {
		this.categoryIds = categoryIds;
	}

	public List<PcsCertificateTplFieldVO> getTplFieldVOList() {
		return tplFieldVOList;
	}

	public void setTplFieldVOList(List<PcsCertificateTplFieldVO> tplFieldVOList) {
		this.tplFieldVOList = tplFieldVOList;
	}

    @Override
    public Long getCreateUserId() {
        return createUserId;
    }

    @Override
    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getTypeStr(){
		return TYPE_COMMON_USE_YES.equals(getType())?"是":
					TYPE_COMMON_USE_NO.equals(getType())?"否":"";
	}

	public String getTplSpecialTypeStr(){
		String specialType = getTplSpecialType();
        String specialTypeStr = "";
        if (EmptyUtil.isEmpty(specialType)){
            return "";
        }
        if (specialType.contains(",")){
            String[] types = specialType.split(",");
            for (String type : types){
                specialTypeStr += getTplSpecialTypeStr(type)+",";
            }
            if (specialTypeStr.endsWith(",")){
                specialTypeStr = specialTypeStr.substring(0,specialTypeStr.lastIndexOf(","));
            }
        }else{
            specialTypeStr = getTplSpecialTypeStr(specialType);
        }
		return specialTypeStr;
	}

    public String getTplSpecialTypeStr(String specialType){
        if (EmptyUtil.isEmpty(specialType)){
            return "";
        }
        return TPL_SPECIAL_TYPE_TEXTILE.equals(specialType)?"纺织品维护方法":
                TPL_SPECIAL_TYPE_CAUTIONS_IN_USE.equals(specialType)?"使用警告":"";
    }

	public static List<KeyValueVO> getAllSpecialType(){
		List<KeyValueVO> list = new ArrayList<>();
		list.add(new KeyValueVO(TPL_SPECIAL_TYPE_TEXTILE,"纺织品维护方法"));
		list.add(new KeyValueVO(TPL_SPECIAL_TYPE_CAUTIONS_IN_USE,"使用警告"));
		return list;
	}

}
