package com.thebeastshop.pegasus.service.purchase.vo;

import java.util.ArrayList;
import java.util.List;

import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTplField;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

public class PcsCertificateTplFieldVO extends PcsCertificateTplField{

	final public static String SHOW_TYPE_TAG_IMPORT = "11";

	final public static String SHOW_TYPE_TAG_UONIMPORT = "10";

	final public static String SHOW_TYPE_NOTAG_IMPORT = "01";

	final public static String SHOW_TYPE_NOTAG_UONIMPORT = "00";

	final public static Integer PRINT_YES = 1;

	final public static Integer PRINT_NO = 0;

	final public static Integer WRITE_TYPE_INPUT = 1;

	final public static Integer WRITE_TYPE_SYSTEM = 2;

	final public static Integer WRITE_TYPE_SKUINFO = 3;

    public static final String FILED_TYPE_PROD_DATE = "生产日期";

    // 字段所在位置区域  1 标题 2 内容
    public static final Integer FILED_POSITION_TITLE = 1;

    public static final Integer FILED_POSITION_CONTENT = 2;

	private PcsCertificateTplFieldDicVO certificateTplFieldDicVO;
	
	private List<PcsCertificateTplFieldTypesetVO> fieldTypesetList;

	private PcsCertificateTplFieldTypesetVO currFieldTypeset;

	public List<PcsCertificateTplFieldTypesetVO> getFieldTypesetList() {
		return fieldTypesetList;
	}

	public void setFieldTypesetList(
			List<PcsCertificateTplFieldTypesetVO> fieldTypesetList) {
		this.fieldTypesetList = fieldTypesetList;
	}

    public PcsCertificateTplFieldTypesetVO getCurrFieldTypeset() {
        return currFieldTypeset;
    }

    public void setCurrFieldTypeset(PcsCertificateTplFieldTypesetVO currFieldTypeset) {
        this.currFieldTypeset = currFieldTypeset;
    }

    public PcsCertificateTplFieldDicVO getCertificateTplFieldDicVO() {
		return certificateTplFieldDicVO;
	}

	public void setCertificateTplFieldDicVO(PcsCertificateTplFieldDicVO certificateTplFieldDicVO) {
		this.certificateTplFieldDicVO = certificateTplFieldDicVO;
	}

	public String getIsPrintStr(){
		Integer isPrint = getIsPrint();
		return isPrint == null?"":
				isPrint.equals(PRINT_YES)?"是":
					isPrint.equals(PRINT_NO)?"否":"";
	}

	public String getShowTypeStr(){
		String str = "",showType = getShowType();
		if(contain(showType,SHOW_TYPE_TAG_IMPORT)){
			str += "有标签&进口|";
		}
		if(contain(showType,SHOW_TYPE_TAG_UONIMPORT)){
			str += "有标签&非进口|";
		}
		if(contain(showType,SHOW_TYPE_NOTAG_IMPORT)){
			str += "无标签&进口|";
		}
		if(contain(showType,SHOW_TYPE_NOTAG_UONIMPORT)){
			str += "无标签&非进口|";
		}
		if(EmptyUtil.isNotEmpty(str)){
			return str.substring(0,str.length()-1);
		}
		return "不展示";
	}

	public String getWriteTypeStr(){
		Integer wirteType = getWriteType();
		return WRITE_TYPE_INPUT.equals(wirteType)?"手动填写":
					WRITE_TYPE_SYSTEM.equals(wirteType)?"系统获取":
							WRITE_TYPE_SKUINFO.equals(wirteType)?"手动填写":"";
	}

    public String getPositionStr(){
        Integer position = getPosition();
        return FILED_POSITION_TITLE.equals(position)?"标题":
                FILED_POSITION_CONTENT.equals(position)?"内容":"";
    }

    public static String getPositionStrByKey(Integer position){
        return FILED_POSITION_TITLE.equals(position)?"标题":
                FILED_POSITION_CONTENT.equals(position)?"内容":"";
    }

	private boolean contain(String container,String pattern){
		if(EmptyUtil.isEmpty(container)){
			return false;
		}
		return container.indexOf(pattern)>-1?true:false;
	}

	public static List<KeyValueVO> getAllShowType(){
		List<KeyValueVO> list = new ArrayList<>();
		list.add(new KeyValueVO(SHOW_TYPE_TAG_IMPORT,"有标签&进口"));
		list.add(new KeyValueVO(SHOW_TYPE_TAG_UONIMPORT,"有标签&非进口"));
		list.add(new KeyValueVO(SHOW_TYPE_NOTAG_IMPORT,"无标签&进口"));
		list.add(new KeyValueVO(SHOW_TYPE_NOTAG_UONIMPORT,"无标签&非进口"));
		return list;
	}

    public static List<KeyValueVO> getAllFieldPositionList(){
        List<KeyValueVO> list = new ArrayList<>();
        list.add(new KeyValueVO(FILED_POSITION_TITLE.toString(),"标题"));
        list.add(new KeyValueVO(FILED_POSITION_CONTENT.toString(),"内容"));
        return list;
    }

}
