package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTplFieldTypeset;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

import java.util.ArrayList;
import java.util.List;

public class PcsCertificateTplFieldTypesetVO extends PcsCertificateTplFieldTypeset{

    private String cerName;

    // 占半行
    public final static Integer SHOW_TYOE_HALFLINE = 1;
    // 占单行
    public final static Integer SHOW_TYOE_SINGLELINE = 2;
    // 右上角
    public final static Integer SHOW_TYOE_TOPRIGHTCORNER = 3;
    // 居中
    public final static Integer SHOW_TYOE_CENTER= 4;
    // 左半行
    public final static Integer SHOW_TYOE_LEFT_HALFLINE= 5;
    // 左单行
    public final static Integer SHOW_TYOE_LEFT_SINGLELINE= 6;
    // 右半行
    public final static Integer SHOW_TYOE_RIGHT_HALFLINE= 7;
    // 右单行
    public final static Integer SHOW_TYOE_RIGHT_SINGLELINE= 8;

    public String getShowTypeStr(){
        Integer showType = getShowType();
        return SHOW_TYOE_HALFLINE.equals(showType)?"占半行":
                    SHOW_TYOE_SINGLELINE.equals(showType)?"占单行":
                        SHOW_TYOE_TOPRIGHTCORNER.equals(showType)?"右上角":
                                SHOW_TYOE_LEFT_HALFLINE.equals(showType)?"左半行":
                                SHOW_TYOE_LEFT_SINGLELINE.equals(showType)?"左单行":
                                        SHOW_TYOE_RIGHT_HALFLINE.equals(showType)?"右半行":
                                                SHOW_TYOE_RIGHT_SINGLELINE.equals(showType)?"右单行":
                                SHOW_TYOE_CENTER.equals(showType)?"居中":"";
    }

    public static List<KeyValueVO> getAllTypesetShowTypeList(){
        List<KeyValueVO> list = new ArrayList<>();
        list.add(new KeyValueVO(SHOW_TYOE_HALFLINE.toString(),"占半行"));
        list.add(new KeyValueVO(SHOW_TYOE_SINGLELINE.toString(),"占单行"));
        list.add(new KeyValueVO(SHOW_TYOE_TOPRIGHTCORNER.toString(),"右上角"));
        list.add(new KeyValueVO(SHOW_TYOE_CENTER.toString(),"居中"));
        return list;
    }

    public static List<KeyValueVO> getCustomTypesetShowTypeList(){
        List<KeyValueVO> list = new ArrayList<>();
        list.add(new KeyValueVO(SHOW_TYOE_CENTER.toString(),"居中"));
        list.add(new KeyValueVO(SHOW_TYOE_LEFT_HALFLINE.toString(),"左半行"));
        list.add(new KeyValueVO(SHOW_TYOE_LEFT_SINGLELINE.toString(),"左单行"));
        list.add(new KeyValueVO(SHOW_TYOE_RIGHT_HALFLINE.toString(),"右半行"));
        list.add(new KeyValueVO(SHOW_TYOE_RIGHT_SINGLELINE.toString(),"右单行"));
        return list;
    }

    public String getCerName() {
        return cerName;
    }

    public void setCerName(String cerName) {
        this.cerName = cerName;
    }
}
