package com.thebeastshop.pegasus.service.purchase.vo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateField;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.vo.KeyValueVO;

public class PcsCertificateFieldVO extends PcsCertificateField{
	
	private String sysDefaultValue;//系统默认值
	
	private PcsCertificateSkuFieldVO fieldInfo;
	
	public String getSize4070Name(){
		return getSizeName(this.getSize4070());
	}
	
	public String getSize5070Name(){
		return getSizeName(this.getSize5070());
	}
	
	public String getSize6080Name(){
		return getSizeName(this.getSize6080());
	}
	
	private String getSizeName(Integer value){
		if(TYPESETTING_HALF_LINE.equals(value)){
			return "占半行";
		}
		if(TYPESETTING_ONE_LINE.equals(value)){
			return "占单行";
		}
		if(TYPESETTING_RIGHT_HEAD.equals(value)){
			return "右上角";
		}		
		return "";
	}
	
	public String getIsPrintName(){
		return EmptyUtil.isEmpty(this.getIsPrint())?"":(PRINT_NEED.equals(this.getIsPrint())?"是":"否");
	}
	
	public String getShowTypeName(){
		String showType = this.getShowType();
		if(EmptyUtil.isEmpty(showType)){
			return "不展示";
		}
		String[] types = showType.split(",");
		List<String> typeList = Arrays.asList(types);
		if(typeList.contains(EIDT_SHOW_TYPE_TAG_IMPORT.toString())
				&&typeList.contains(EIDT_SHOW_TYPE_TAG_NONIMPORT.toString())
				&&typeList.contains(EIDT_SHOW_TYPE_NONTAG_IMPORT.toString())
				&&typeList.contains(EIDT_SHOW_TYPE_NONTAG_NONIMPORT.toString())
				){
			return "所有情况均展示";
		}
		StringBuilder buf = new StringBuilder();
		for(String type : types){
			if(EIDT_SHOW_TYPE_TAG_IMPORT.toString().equals(type)){
				buf.append("有标签&进口|");
				continue;
			}
			if(EIDT_SHOW_TYPE_TAG_NONIMPORT.toString().equals(type)){
				buf.append("有标签&非进口|");
				continue;
			}
			if(EIDT_SHOW_TYPE_NONTAG_IMPORT.toString().equals(type)){
				buf.append("无标签&进口|");
				continue;
			}
			if(EIDT_SHOW_TYPE_NONTAG_NONIMPORT.toString().equals(type)){
				buf.append("无标签&非进口|");
				continue;
			}
		}
		return buf.substring(0, buf.length()-1);
	}
	
	public String getWriteTypeName(){
		return EmptyUtil.isEmpty(this.getWriteType())?"":(WRITE_TYPE_INPUT.equals(this.getWriteType())?"手动填写":"系统获取");
	}
	
	//是否删除1是,0否
	final public static Integer DELETE_YES = 1;
	
	final public static Integer DELETE_NO = 0;
	
	//排版方式1半行，2一行，3右上角
	final public static Integer TYPESETTING_HALF_LINE = 1;
	
	final public static Integer TYPESETTING_ONE_LINE = 2;
	
	final public static Integer TYPESETTING_RIGHT_HEAD = 3;
	
	//是否打印1是0否
	final public static Integer PRINT_NEED = 1;
	
	final public static Integer PRINT_UNNEED = 0;
	
	//编辑页默认展示
	final public static Integer EIDT_SHOW_TYPE_TAG_IMPORT = 1;//有标签&进口
	
	final public static Integer EIDT_SHOW_TYPE_TAG_NONIMPORT = 2;//有标签&非进口
	
	final public static Integer EIDT_SHOW_TYPE_NONTAG_IMPORT = 3;//无标签&进口
	
	final public static Integer EIDT_SHOW_TYPE_NONTAG_NONIMPORT = 4;//无标签&非进口
	
	//填写方式
	final public static Integer WRITE_TYPE_INPUT = 1;//手写 
	
	final public static Integer WRITE_TYPE_SYS = 2;//系统获取
	
	//final public static Integer WRITE_TYPE_INPUT_SKU = 3;//手动输入单从sku信息获取
	
	//打印字体大小
	final public static Integer print_font_size_7 = 7;//7磅
	
	final public static Integer print_font_size_18= 18;//18磅
	
	public static List<KeyValueVO> getAllTypesetings(){
		List<KeyValueVO> list = new ArrayList<>();
		list.add(new KeyValueVO(TYPESETTING_HALF_LINE.toString(),"占半行"));
		list.add(new KeyValueVO(TYPESETTING_ONE_LINE.toString(),"占单行"));
		list.add(new KeyValueVO(TYPESETTING_RIGHT_HEAD.toString(),"右上角"));
		return list;
	}
	
	public static List<KeyValueVO> getAllFontSizes(){
		List<KeyValueVO> list = new ArrayList<>();
		list.add(new KeyValueVO(print_font_size_7.toString(),"7磅"));
		list.add(new KeyValueVO(print_font_size_18.toString(),"18磅"));
		return list;
	}
	
	public static List<KeyValueVO> getAllPrints(){
		List<KeyValueVO> list = new ArrayList<>();
		list.add(new KeyValueVO(PRINT_NEED.toString(),"是"));
		list.add(new KeyValueVO(PRINT_UNNEED.toString(),"否"));
		return list;
	}
	
	public static List<KeyValueVO> getAllEditShowTypes(){
		List<KeyValueVO> list = new ArrayList<>();
		list.add(new KeyValueVO(EIDT_SHOW_TYPE_TAG_IMPORT.toString(),"有标签&进口"));
		list.add(new KeyValueVO(EIDT_SHOW_TYPE_TAG_NONIMPORT.toString(),"有标签&非进口"));
		list.add(new KeyValueVO(EIDT_SHOW_TYPE_NONTAG_IMPORT.toString(),"无标签&进口"));
		list.add(new KeyValueVO(EIDT_SHOW_TYPE_NONTAG_NONIMPORT.toString(),"无标签&非进口"));
		return list;
	}

	public PcsCertificateSkuFieldVO getFieldInfo() {
		return fieldInfo;
	}

	public void setFieldInfo(PcsCertificateSkuFieldVO fieldInfo) {
		this.fieldInfo = fieldInfo;
	}

	public String getSysDefaultValue() {
		return sysDefaultValue;
	}

	public void setSysDefaultValue(String sysDefaultValue) {
		this.sysDefaultValue = sysDefaultValue;
	}
	


}
