package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelSheet;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 基础税率VO
 * @author Gary
 * @createTime 2018/5/8
 */
@ExcelSheet("sheet1")
@ExcelTemplate
public class PcsBaseTaxRateVO {

    private Integer id;
    @ExcelColumn(name = "税号")
    @NotNull
    private String taxId;
    @ExcelColumn(name = "新税号")
    private String newTaxId;
    @ExcelColumn(name = "商品名称")
    private String productName;
    //申报要素
    @ExcelColumn(name = "申报要素")
    private String declareElement;
    //最惠国进口税率
    @ExcelColumn(name = "最惠国进口税率")
    private String bestImportTaxRate;
    //普通进口税率
    @ExcelColumn(name = "普通进口税率")
    private String ordinaryImportTaxRate;
    //出口关税率
    @ExcelColumn(name = "出口关税率")
    private String exportTariffRate;
    //消费税率
    @ExcelColumn(name = "消费税率")
    private String consumptionTaxRate;

    //sku消费税率
    private BigDecimal skuSaleTax;
    //出口退税率
    @ExcelColumn(name = "出口退税率")
    private String exportReturnTariffRate;
    //增值税率
    @ExcelColumn(name = "增值税率")
    @NotNull
    private String vatRate;

    //sku增值税率
    private BigDecimal skuVatRate;
    //海关监管条件
    @ExcelColumn(name = "海关监管条件")
    private String customsSupervisionConditions;
    //商品描述
    @ExcelColumn(name = "商品描述")
    private String productDesc;
    //法定第一单位
    @ExcelColumn(name = "法定第一单位")
    @NotNull
    private String legalFirstUnit;

    private String goodsLegalUnitcode;

    //法定第二单位
    @ExcelColumn(name = "法定第二单位")
    private String legalSecondUnit;

    private String secondLegalUnitcode;
    //检验检疫类别
    @ExcelColumn(name = "检验检疫类别")
    private String quarantineCategory;
    //暂定进口税率
    @ExcelColumn(name = "暂定进口税率")
    private String tentativeImportTaxRate;
    //暂定出口税率
    @ExcelColumn(name = "暂定出口税率")
    private String tentativeExportTaxRate;
    //备注
    @ExcelColumn(name = "备注")
    private String remark;

    private Boolean active;
    private Date gmtCreate;
    private Long createUserId;
    private String createUserName;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTaxId() {
        return taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public String getNewTaxId() {
        return newTaxId;
    }

    public void setNewTaxId(String newTaxId) {
        this.newTaxId = newTaxId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getDeclareElement() {
        return declareElement;
    }

    public void setDeclareElement(String declareElement) {
        this.declareElement = declareElement;
    }

    public String getBestImportTaxRate() {
        return bestImportTaxRate;
    }

    public void setBestImportTaxRate(String bestImportTaxRate) {
        this.bestImportTaxRate = bestImportTaxRate;
    }

    public String getOrdinaryImportTaxRate() {
        return ordinaryImportTaxRate;
    }

    public void setOrdinaryImportTaxRate(String ordinaryImportTaxRate) {
        this.ordinaryImportTaxRate = ordinaryImportTaxRate;
    }

    public String getExportTariffRate() {
        return exportTariffRate;
    }

    public void setExportTariffRate(String exportTariffRate) {
        this.exportTariffRate = exportTariffRate;
    }

    public String getConsumptionTaxRate() {
        return consumptionTaxRate;
    }

    public void setConsumptionTaxRate(String consumptionTaxRate) {
        this.consumptionTaxRate = consumptionTaxRate;
    }

    public String getExportReturnTariffRate() {
        return exportReturnTariffRate;
    }

    public void setExportReturnTariffRate(String exportReturnTariffRate) {
        this.exportReturnTariffRate = exportReturnTariffRate;
    }

    public String getVatRate() {
        return vatRate;
    }

    public void setVatRate(String vatRate) {
        this.vatRate = vatRate;
    }

    public String getCustomsSupervisionConditions() {
        return customsSupervisionConditions;
    }

    public void setCustomsSupervisionConditions(String customsSupervisionConditions) {
        this.customsSupervisionConditions = customsSupervisionConditions;
    }

    public String getProductDesc() {
        return productDesc;
    }

    public void setProductDesc(String productDesc) {
        this.productDesc = productDesc;
    }

    public String getLegalFirstUnit() {
        return legalFirstUnit;
    }

    public void setLegalFirstUnit(String legalFirstUnit) {
        this.legalFirstUnit = legalFirstUnit;
    }

    public String getLegalSecondUnit() {
        return legalSecondUnit;
    }

    public void setLegalSecondUnit(String legalSecondUnit) {
        this.legalSecondUnit = legalSecondUnit;
    }

    public String getQuarantineCategory() {
        return quarantineCategory;
    }

    public void setQuarantineCategory(String quarantineCategory) {
        this.quarantineCategory = quarantineCategory;
    }

    public String getTentativeImportTaxRate() {
        return tentativeImportTaxRate;
    }

    public void setTentativeImportTaxRate(String tentativeImportTaxRate) {
        this.tentativeImportTaxRate = tentativeImportTaxRate;
    }

    public String getTentativeExportTaxRate() {
        return tentativeExportTaxRate;
    }

    public void setTentativeExportTaxRate(String tentativeExportTaxRate) {
        this.tentativeExportTaxRate = tentativeExportTaxRate;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Boolean getActive() {
        return active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public BigDecimal getSkuSaleTax() {
        return skuSaleTax;
    }

    public void setSkuSaleTax(BigDecimal skuSaleTax) {
        this.skuSaleTax = skuSaleTax;
    }

    public BigDecimal getSkuVatRate() {
        return skuVatRate;
    }

    public void setSkuVatRate(BigDecimal skuVatRate) {
        this.skuVatRate = skuVatRate;
    }

    public String getGoodsLegalUnitcode() {
        return goodsLegalUnitcode;
    }

    public void setGoodsLegalUnitcode(String goodsLegalUnitcode) {
        this.goodsLegalUnitcode = goodsLegalUnitcode;
    }

    public String getSecondLegalUnitcode() {
        return secondLegalUnitcode;
    }

    public void setSecondLegalUnitcode(String secondLegalUnitcode) {
        this.secondLegalUnitcode = secondLegalUnitcode;
    }
}