package com.thebeastshop.pegasus.service.purchase.vo;

import com.thebeastshop.pegasus.service.purchase.model.FpcsConsumableAllot;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by Gary on 2017/4/14.
 */
public class FpcsConsumableAllotVO extends FpcsConsumableAllot implements Serializable {

  private static final long serialVersionUID = 4502927030716310364L;

  private  Integer serviceLevel;

  //退市日
  private Date delistingDate;

  //当 SKU 重要等级为”1/2/3“时，商品状态显示【在售】；当 SKU 重要等级为”4“时，商品状态显示为【退市】
  private String serviceLevelDesc;

  private Integer lastMonthApplyQuantity;

  private Integer thisMonthApplyQuantity;

  public Integer getLastMonthApplyQuantity() {
    return lastMonthApplyQuantity;
  }

  public void setLastMonthApplyQuantity(Integer lastMonthApplyQuantity) {
    this.lastMonthApplyQuantity = lastMonthApplyQuantity;
  }

  public Integer getThisMonthApplyQuantity() {
    return thisMonthApplyQuantity;
  }

  public void setThisMonthApplyQuantity(Integer thisMonthApplyQuantity) {
    this.thisMonthApplyQuantity = thisMonthApplyQuantity;
  }

  public Integer getServiceLevel() {
    return serviceLevel;
  }

  public void setServiceLevel(Integer serviceLevel) {
    this.serviceLevel = serviceLevel;
  }

  public Date getDelistingDate() {
    return delistingDate;
  }

  public void setDelistingDate(Date delistingDate) {
    this.delistingDate = delistingDate;
  }

  public  String getServiceLevelDesc() {
    if (EmptyUtil.isNotEmpty(serviceLevel) && serviceLevel == 4) {
      return "退市";
    } else {
      return "在售";
    }
  }
}
