/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.util;

import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.apache.commons.lang.StringUtils;

/**
 * @author Eric.Lou
 * @version $Id: PrdcJobLineUtil.java, v 0.1 2016-01-06 下午5:21
 */
public class PrdcJobLineUtil {

    /**
     * 生成CODE
     *
     * @param jobCode    JOBCODE
     * @param jobLineCode 最大的JOBLINECODE(完整编号)
     * @return
     */
    public static String generatePackageSkuCode(String jobCode, String jobLineCode) {
        if (EmptyUtil.isEmpty(jobCode)) {
            throw new RuntimeException("JOB编号不能为空");
        }
        if (EmptyUtil.isEmpty(jobLineCode)) {
            return getJobLineCode(jobCode, 1);
        } else {
            if (!jobLineCode.contains(jobCode)) {
                throw new RuntimeException("JOBLINE编号不包含JOB编号");
            }
            String suffixCode = jobLineCode.substring(jobLineCode.indexOf(jobCode) + jobCode.length());
            Integer maxId = Integer.valueOf(suffixCode);
            return getJobLineCode(jobCode, ++maxId);
        }
    }

    /***
     * JOBLINE编码，JOB编码+4位顺序号
     * @param jobCode job编号
     * @param index 顺序。从1开始
     * @return
     */
    public static String getJobLineCode(String jobCode,Integer index){
        if(StringUtils.isBlank(jobCode)){
            jobCode= "";
        }
        if(index<10){
            jobCode=jobCode+"000"+index;
        }else if(index>10&&index<100){
            jobCode=jobCode+"00"+index;
        }else if(index>=100&&index<1000){
            jobCode=jobCode+"0"+index;
        }else{
            jobCode=jobCode+index;
        }
        return jobCode;
    }

}
