package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.cond.PurchaseFlowerReceiveOrderCond;
import com.thebeastshop.pegasus.service.purchase.cond.PurchaseFlowerSupplierReportCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseFlowerReceiveOrderItemMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseFlowerReceiveOrderMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlowerReceiveOrderItem;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlowerReceiveOrderItemExample;
import com.thebeastshop.pegasus.service.purchase.service.PurchaseFlowerReceiveOrderService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseFlowerReceiveOrderItemVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseFlowerReceiveOrderVO;
import com.thebeastshop.pegasus.service.purchase.vo.PurchaseFlowerSupplierReportVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.thebeastshop.common.Pagination;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: ljj
 * @Description:${todo}(用一句话描述该文件做什么)
 * @Date: 2019/1/23 17:41
 * @Version 1.0
 */

@Service("purchaseFlowerReceiveOrderService")
public class PurchaseFlowerReceiveOrderServiceImpl implements PurchaseFlowerReceiveOrderService {


    @Autowired
    private PcsPurchaseFlowerReceiveOrderMapper pcsPurchaseFlowerReceiveOrderMapper;

    @Autowired
    private PcsPurchaseFlowerReceiveOrderItemMapper pcsPurchaseFlowerReceiveOrderItemMapper;


    @Override
    public Pagination<PcsPurchaseFlowerReceiveOrderVO> findByCond(PurchaseFlowerReceiveOrderCond cond) {
        Pagination<PcsPurchaseFlowerReceiveOrderVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int count = pcsPurchaseFlowerReceiveOrderMapper.countByCond(cond);
        page.setRecord(count);
        if(!NumberUtil.isNullOrZero(count)){
            List<PcsPurchaseFlowerReceiveOrderVO> flowerVOList = pcsPurchaseFlowerReceiveOrderMapper.findByCond(cond);
            page.setResultList(flowerVOList);
        }
        return page;
    }

    @Override
    public List<PcsPurchaseFlowerReceiveOrderVO> findByCondForExportExcel(PurchaseFlowerReceiveOrderCond cond) {
        cond.setPagenum(Integer.MAX_VALUE);
        List<PcsPurchaseFlowerReceiveOrderVO> receiveOrderVOS = pcsPurchaseFlowerReceiveOrderMapper.findByCond(cond);
        if (CollectionUtils.isNotEmpty(receiveOrderVOS)) {
            for (PcsPurchaseFlowerReceiveOrderVO pcsPurchaseFlowerReceiveOrderVO : receiveOrderVOS) {
                PcsPurchaseFlowerReceiveOrderItemExample example = new PcsPurchaseFlowerReceiveOrderItemExample();
                example.createCriteria().andReceivePlanIdEqualTo(pcsPurchaseFlowerReceiveOrderVO.getId());
                List<PcsPurchaseFlowerReceiveOrderItem> purchaseFlowerPlanItems = pcsPurchaseFlowerReceiveOrderItemMapper.selectByExample(example);
                for (PcsPurchaseFlowerReceiveOrderItem purchaseFlowerPlanItemVO : purchaseFlowerPlanItems) {
                    purchaseFlowerPlanItemVO.setTbIdStr("skuLine_"+purchaseFlowerPlanItemVO.getPurchaseFlowerCode()+"-"+purchaseFlowerPlanItemVO.getUseChannel());
                }
                pcsPurchaseFlowerReceiveOrderVO.setReceiveOrderItems(BeanUtil.buildListFrom(purchaseFlowerPlanItems,PcsPurchaseFlowerReceiveOrderItemVO.class));
            }
        }
        return receiveOrderVOS;
    }

    @Override
    public Integer addOrEditPurchaseFlowerReceiveOrder(PcsPurchaseFlowerReceiveOrderVO pcsPurchaseFlowerReceiveOrderVO) {
        if ( null == pcsPurchaseFlowerReceiveOrderVO.getId()) {
            pcsPurchaseFlowerReceiveOrderMapper.insert(pcsPurchaseFlowerReceiveOrderVO);
            final Map<String, Object> params = new HashMap<String, Object>();
            params.put("id", pcsPurchaseFlowerReceiveOrderVO.getId());
            String receiveCode = CodeGenerator.getInstance().generate("PCS_REC_CODE", params);
            PcsPurchaseFlowerReceiveOrderVO updateVO = new PcsPurchaseFlowerReceiveOrderVO();
            updateVO.setId(pcsPurchaseFlowerReceiveOrderVO.getId());
            updateVO.setCode(receiveCode);
            updateVO.setStatus(1);
            pcsPurchaseFlowerReceiveOrderMapper.updateByPrimaryKeySelective(updateVO);
            if (CollectionUtils.isNotEmpty(pcsPurchaseFlowerReceiveOrderVO.getReceiveOrderItems())) {
                for (PcsPurchaseFlowerReceiveOrderItem pcsPurchaseFlowerReceiveOrderItem : pcsPurchaseFlowerReceiveOrderVO.getReceiveOrderItems()) {
                    pcsPurchaseFlowerReceiveOrderItem.setReceivePlanId(pcsPurchaseFlowerReceiveOrderVO.getId());
                }
            }
            return pcsPurchaseFlowerReceiveOrderItemMapper.batchInsert(pcsPurchaseFlowerReceiveOrderVO.getReceiveOrderItems());
        } else {
            pcsPurchaseFlowerReceiveOrderMapper.updateByPrimaryKeySelective(pcsPurchaseFlowerReceiveOrderVO);
            PcsPurchaseFlowerReceiveOrderItemExample example = new PcsPurchaseFlowerReceiveOrderItemExample();
            example.createCriteria().andReceivePlanIdEqualTo(pcsPurchaseFlowerReceiveOrderVO.getId());
            pcsPurchaseFlowerReceiveOrderItemMapper.deleteByExample(example);
            return pcsPurchaseFlowerReceiveOrderItemMapper.batchInsert(pcsPurchaseFlowerReceiveOrderVO.getReceiveOrderItems());
        }
    }

    @Override
    public PcsPurchaseFlowerReceiveOrderVO findById(Integer id) {
        PcsPurchaseFlowerReceiveOrderVO pcsPurchaseFlowerReceiveOrderVO =pcsPurchaseFlowerReceiveOrderMapper.findById(id);
        PcsPurchaseFlowerReceiveOrderItemExample example = new PcsPurchaseFlowerReceiveOrderItemExample();
        example.createCriteria().andReceivePlanIdEqualTo(id);
        List<PcsPurchaseFlowerReceiveOrderItem> pPcsPurchaseFlowerReceiveOrderItems = pcsPurchaseFlowerReceiveOrderItemMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(pPcsPurchaseFlowerReceiveOrderItems)) {
            pcsPurchaseFlowerReceiveOrderVO.setReceiveOrderItems(BeanUtil.buildListFrom(pPcsPurchaseFlowerReceiveOrderItems,PcsPurchaseFlowerReceiveOrderItemVO.class));
            for (PcsPurchaseFlowerReceiveOrderItemVO receiveOrderItemVO : pcsPurchaseFlowerReceiveOrderVO.getReceiveOrderItems()) {
                receiveOrderItemVO.setTbIdStr("skuLine_"+receiveOrderItemVO.getPurchaseFlowerCode()+"-"+receiveOrderItemVO.getUseChannel());
            }
        }
        return pcsPurchaseFlowerReceiveOrderVO;
    }

    @Override
    public Pagination<PurchaseFlowerSupplierReportVO> findSupplierReportByCond(PurchaseFlowerSupplierReportCond cond) throws ParseException {
        Pagination<PurchaseFlowerSupplierReportVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int count = pcsPurchaseFlowerReceiveOrderMapper.countSupplierReportByCond(cond);
        page.setRecord(count);
        if(!NumberUtil.isNullOrZero(count)){
            List<PurchaseFlowerSupplierReportVO> flowerVOList = pcsPurchaseFlowerReceiveOrderMapper.findSupplierReportByCond(cond);
            if (CollectionUtils.isNotEmpty(flowerVOList)) {
                NumberFormat nf=NumberFormat.getPercentInstance();
                for (PurchaseFlowerSupplierReportVO purchaseFlowerSupplierReportVO : flowerVOList) {
                    Number costRate = nf.parse(purchaseFlowerSupplierReportVO.getRate());
                    BigDecimal b = BigDecimal.valueOf(costRate.doubleValue()).add(BigDecimal.ONE);
                    purchaseFlowerSupplierReportVO.setCostBeforeTax(purchaseFlowerSupplierReportVO.getAmount().multiply(b));
                }
            }
            page.setResultList(flowerVOList);
        }
        return page;
    }

    public static void main(String[] args) throws ParseException {
        String str="34.2%";//字符串类型的百分数
        NumberFormat nf=NumberFormat.getPercentInstance();//NumberFormat是一个工厂，可以直接getXXX创建，而getPercentInstance()
        Number m=nf.parse(str);//提供了带有 ParsePosition 和 FieldPosition 的
        System.out.println(m.doubleValue());
    }
}
