package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.cond.PurchaseFlowerPlanCond;
import com.thebeastshop.pegasus.service.purchase.dao.PurchaseFlowerPlanItemMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PurchaseFlowerPlanMapper;
import com.thebeastshop.pegasus.service.purchase.model.PurchaseFlowerPlanItemExample;
import com.thebeastshop.pegasus.service.purchase.service.PurchaseFlowerPlanService;
import com.thebeastshop.pegasus.service.purchase.vo.PurchaseFlowerPlanItemVO;
import com.thebeastshop.pegasus.service.purchase.vo.PurchaseFlowerPlanVO;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.thebeastshop.common.Pagination;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: ljj
 * @Description:${todo}(用一句话描述该文件做什么)
 * @Date: 2018/12/18 0:43
 * @Version 1.0
 */
@Service("purchaseFlowerPlanService")
public class PurchaseFlowerPlanServiceImpl implements PurchaseFlowerPlanService {

    @Autowired
    private PurchaseFlowerPlanMapper purchaseFlowerPlanMapper;

    @Autowired
    private PurchaseFlowerPlanItemMapper purchaseFlowerPlanItemMapper;

    @Override
    public Pagination<PurchaseFlowerPlanVO> findByCond(PurchaseFlowerPlanCond cond) {
        Pagination<PurchaseFlowerPlanVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int count = purchaseFlowerPlanMapper.countByCond(cond);
        page.setRecord(count);
        if(!NumberUtil.isNullOrZero(count)){
            List<PurchaseFlowerPlanVO> flowerVOList = purchaseFlowerPlanMapper.findByCond(cond);
            if (CollectionUtils.isNotEmpty(flowerVOList)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
                for (PurchaseFlowerPlanVO purchaseFlowerPlanVO : flowerVOList) {
                    purchaseFlowerPlanVO.setPlanReceiveDateStr(sdf.format(purchaseFlowerPlanVO.getPlanReceiveDate()));
                }
            }
            page.setResultList(flowerVOList);
        }
        return page;
    }

    @Override
    public List<PurchaseFlowerPlanVO> findByCondForExportExcel(PurchaseFlowerPlanCond cond) {
        cond.setPagenum(Integer.MAX_VALUE);
        List<PurchaseFlowerPlanVO> purchaseFlowerPlanVOS = purchaseFlowerPlanMapper.findByCond(cond);
        if (CollectionUtils.isNotEmpty(purchaseFlowerPlanVOS)) {
            for (PurchaseFlowerPlanVO purchaseFlowerPlanVO : purchaseFlowerPlanVOS) {
                List<PurchaseFlowerPlanItemVO> purchaseFlowerPlanItems = purchaseFlowerPlanItemMapper.findByPlanId(purchaseFlowerPlanVO.getId());
                for (PurchaseFlowerPlanItemVO purchaseFlowerPlanItemVO : purchaseFlowerPlanItems) {
                    purchaseFlowerPlanItemVO.setTbIdStr("skuLine_"+purchaseFlowerPlanItemVO.getPurchaseFlowerCode()+"-"+purchaseFlowerPlanItemVO.getUseChannel());
                }
                purchaseFlowerPlanVO.setPurchaseFlowerPlanItemVOS(purchaseFlowerPlanItems);
            }
        }
        return purchaseFlowerPlanVOS;
    }

    @Override
    @Transactional
    public Integer addOrEditPurchaseFlowerPlan(PurchaseFlowerPlanVO purchaseFlowerPlanVO) {
        if ( null == purchaseFlowerPlanVO.getId()) {
            purchaseFlowerPlanVO.setCreateTime(new Date());
            purchaseFlowerPlanMapper.insert(purchaseFlowerPlanVO);
            final Map<String, Object> params = new HashMap<String, Object>();
            params.put("id", purchaseFlowerPlanVO.getId());
            String flowerCode = CodeGenerator.getInstance().generate("PCS_POP_CODE", params);
            PurchaseFlowerPlanVO updateVO = new PurchaseFlowerPlanVO();
            updateVO.setId(purchaseFlowerPlanVO.getId());
            updateVO.setCode(flowerCode);
            updateVO.setStatus(1);
            purchaseFlowerPlanMapper.updateByPrimaryKeySelective(updateVO);
            if (CollectionUtils.isNotEmpty(purchaseFlowerPlanVO.getPurchaseFlowerPlanItemVOS())) {
                for (PurchaseFlowerPlanItemVO purchaseFlowerPlanItemVO : purchaseFlowerPlanVO.getPurchaseFlowerPlanItemVOS()) {
                    purchaseFlowerPlanItemVO.setPurchasePlanId(purchaseFlowerPlanVO.getId());
                }
            }
            return purchaseFlowerPlanItemMapper.batchInsert(purchaseFlowerPlanVO.getPurchaseFlowerPlanItemVOS());
        } else {
            purchaseFlowerPlanMapper.updateByPrimaryKeySelective(purchaseFlowerPlanVO);
            PurchaseFlowerPlanItemExample example = new PurchaseFlowerPlanItemExample();
            example.createCriteria().andPurchasePlanIdEqualTo(purchaseFlowerPlanVO.getId());
            purchaseFlowerPlanItemMapper.deleteByExample(example);
            return purchaseFlowerPlanItemMapper.batchInsert(purchaseFlowerPlanVO.getPurchaseFlowerPlanItemVOS());
        }
    }

    @Override
    public PurchaseFlowerPlanVO findById(Integer id) {
        PurchaseFlowerPlanVO purchaseFlowerPlanVO = purchaseFlowerPlanMapper.findById(id);
        if (purchaseFlowerPlanVO!=null) {
            List<PurchaseFlowerPlanItemVO> purchaseFlowerPlanItems = purchaseFlowerPlanItemMapper.findByPlanId(id);
            for (PurchaseFlowerPlanItemVO purchaseFlowerPlanItemVO : purchaseFlowerPlanItems) {
                purchaseFlowerPlanItemVO.setTbIdStr("skuLine_"+purchaseFlowerPlanItemVO.getPurchaseFlowerCode()+"-"+purchaseFlowerPlanItemVO.getUseChannel());
            }
            purchaseFlowerPlanVO.setPurchaseFlowerPlanItemVOS(purchaseFlowerPlanItems);
        }
        return purchaseFlowerPlanVO;
    }
}
