package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeSkuCond;
import com.thebeastshop.pegasus.service.purchase.dao.PrdcRecipeSkuMapper;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeSku;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeSkuExample;
import com.thebeastshop.pegasus.service.purchase.service.PrdcRecipeSkuService;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * com.thebeastshop.pegasus.service.purchase.service.impl
 *
 * @author xwei
 * @create 2017-08-18 20:02
 */
@Service("prdcRecipeSkuService")
public class PrdcRecipeSkuServiceImpl implements PrdcRecipeSkuService {

    @Autowired
    private PrdcRecipeSkuMapper prdcRecipeSkuMapper;

    @Override
    public PrdcRecipeSkuVO findRecipeSkuVOById(Long id) {
        PrdcRecipeSku prdcRecipeSku = prdcRecipeSkuMapper.selectByPrimaryKey(id);
        return BeanUtil.buildFrom(prdcRecipeSku,PrdcRecipeSkuVO.class);
    }

    @Override
    public List<PrdcRecipeSkuVO> findRecipeSkuVOByRecipeId(Long recipeId) {
        PrdcRecipeSkuExample example = new PrdcRecipeSkuExample();
        example.createCriteria().andRecipeIdEqualTo(recipeId);
        List<PrdcRecipeSku> prdcRecipeSkus = prdcRecipeSkuMapper.selectByExample(example);
        return BeanUtil.buildListFrom(prdcRecipeSkus,PrdcRecipeSkuVO.class);
    }

    @Override
    public List<PrdcRecipeSkuVO> findRecipeSkuVOByCond(String skuCode, Long recipeId) {
        PrdcRecipeSkuExample example = new PrdcRecipeSkuExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode).andRecipeIdEqualTo(recipeId);
        List<PrdcRecipeSku> prdcRecipeSkus = prdcRecipeSkuMapper.selectByExample(example);
        return BeanUtil.buildListFrom(prdcRecipeSkus,PrdcRecipeSkuVO.class);
    }

    @Override
    public List<PrdcRecipeSkuVO> findRecipeSkuVOByCond(PrdcRecipeSkuCond cond) {
        PrdcRecipeSkuExample example = new PrdcRecipeSkuExample();
        PrdcRecipeSkuExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(cond.getSkuCode())){
            criteria.andSkuCodeEqualTo(cond.getSkuCode());
        }else if(CollectionUtils.isNotEmpty(cond.getSkuCodes())){
            criteria.andSkuCodeIn(cond.getSkuCodes());
        }
        if (EmptyUtil.isNotEmpty(cond.getRecipeId())){
            criteria.andRecipeIdEqualTo(cond.getRecipeId());
        }else if(CollectionUtils.isNotEmpty(cond.getRecipeIds())){
            criteria.andRecipeIdIn(cond.getRecipeIds());
        }
        List<PrdcRecipeSku> prdcRecipeSkus = prdcRecipeSkuMapper.selectByExample(example);
        return BeanUtil.buildListFrom(prdcRecipeSkus,PrdcRecipeSkuVO.class);
    }

    @Override
    public Long create(PrdcRecipeSkuVO vo) {
        PrdcRecipeSku prdcRecipeSku = BeanUtil.buildFrom(vo,PrdcRecipeSku.class);
        if (EmptyUtil.isNotEmpty(prdcRecipeSku)){
            int result = prdcRecipeSkuMapper.insert(prdcRecipeSku);
            return Long.parseLong(result+"");
        }
        return 0L;
    }

    @Override
    public Boolean update(PrdcRecipeSkuVO vo) {
        PrdcRecipeSku prdcRecipeSku = BeanUtil.buildFrom(vo,PrdcRecipeSku.class);
        if (prdcRecipeSku != null && EmptyUtil.isNotEmpty(vo.getId())){
            return prdcRecipeSkuMapper.updateByPrimaryKeySelective(prdcRecipeSku)>0;
        }
        return null;
    }

    @Override
    public Boolean deleteRecipeSku(String skuCode, Long recipeId) {
        PrdcRecipeSkuExample example = new PrdcRecipeSkuExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode).andRecipeIdEqualTo(recipeId);
        return prdcRecipeSkuMapper.deleteByExample(example)>0;
    }

    @Override
    public Boolean deleteRecipeSku(Long id) {
        return prdcRecipeSkuMapper.deleteByPrimaryKey(id)>0;
    }
}
