/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.common.Pagination;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.message.service.EmailSendService;
import com.thebeastshop.message.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcJobCond;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeCond;
import com.thebeastshop.pegasus.service.purchase.dao.*;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.*;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobLineExample.Criteria;
import com.thebeastshop.pegasus.service.purchase.service.PrdcJobService;
import com.thebeastshop.pegasus.service.purchase.service.PrdcRecipeService;
import com.thebeastshop.pegasus.service.purchase.util.PrdcJobLineUtil;
import com.thebeastshop.pegasus.service.purchase.vo.*;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SOccupyResultVO;
import com.thebeastshop.wms.cond.PhyWhStockCond;
import com.thebeastshop.wms.sservice.*;
import com.thebeastshop.wms.vo.*;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.math.BigDecimal;
import java.util.*;

/**
 * @author Eric.Lou
 * @version $Id: PrdcJobServiceImpl.java, v 0.1 2016-01-04 上午11:18
 */
@Service("prdcJobService")

public class PrdcJobServiceImpl implements PrdcJobService {

    private static Logger log = LoggerFactory.getLogger(PrdcJobServiceImpl.class);

    @Autowired
    private McPcsSkuService mcPcsSkuService;

    @Autowired
    private PrdcRecipeService prdcRecipeService;

    @Autowired
    private PrdcJobMapper prdcJobMapper;

    @Autowired
    private PrdcJobLineMapper prdcJobLineMapper;

    @Autowired
    private PrdcPreJobMapper prdcPreJobMapper;

    @Autowired
    private PrdcPreJobLineMapper prdcPreJobLineMapper;

    @Autowired
    private PrdcRecipeMaterialMapper prdcRecipeMaterialMapper;

    @Autowired
    private PcsFlowerRecipeSkuMapper pcsFlowerRecipeSkuMapper;
    @Autowired
    private PcsFlowerDeliveryRecipeMapper pcsFlowerDeliveryRecipeMapper;

    private PegasusUtilFacade utilFacade = PegasusUtilFacade.getInstance();
    public static Map<String,WhWarehouseVO> warehouseMap = new HashMap<>();
    public static Map<String,WhPhysicalWarehouseVO> whPhysicalWarehouseMap = new HashMap<>();
    public static Map<String,WhWarehouseGroupVO> whGroupMap = new HashMap<>();
    @Autowired
    private SStockService sStockService;
    @Autowired
    private SWhInfoService sWhInfoService;

    @Autowired
    private SWhInvService sWhInvService;

    @Autowired
    private SWhAllotService sWhAllotService;

    @Autowired
    private SWhWmsSkuStockService sWhWmsSkuStockService;

    @Autowired
    private SWhWmsPrdcJobTaskService sWhWmsPrdcJobTaskService;

    @Autowired
    private SWhJitPackageSkuReferenceService sWhJitPackageSkuReferenceService;

    @Autowired
    private WWhCommandService wWhCommandService;

    @Autowired
    private SWhWarehouseGroupService sWhWarehouseGroupService;

    @Autowired
    private EmailSendService emailSendService;

    @Override
    public PrdcJobVO findJobVOById(Long id) {
        PrdcJobCond cond = new PrdcJobCond();
        cond.setJobId(id);
        cond.setCurrpage(1);
        List<PrdcJobVO> prdcJobVOList = findJobVOByCond(cond, true);
        PrdcJobVO prdcJobVO = null;
        if (CollectionUtils.isNotEmpty(prdcJobVOList)) {
            prdcJobVO =  prdcJobVOList.get(0);
            WhPhysicalWarehouseVO whPhysicalWarehouseVO = sWhInfoService.findPhysicalWarehouseByCode(prdcJobVO.getPhysicalWarehouseCode());
            if(whPhysicalWarehouseVO != null){
                prdcJobVO.setPhysicalWarehouseName(whPhysicalWarehouseVO.getName());
                prdcJobVO.setWhPhysicalWarehouse(whPhysicalWarehouseVO);
            }
            WhWarehouseVO whWarehouseVO = sWhInfoService.findWarehouseByCode(prdcJobVO.getWarehouseCode());
            if(whWarehouseVO != null){
                prdcJobVO.setWarehouseName(whWarehouseVO.getName());
            }
        }
        return prdcJobVO;
    }

    @Override
    public PrdcJobVO findJobVOByCode(String code) {
        PrdcJobExample example = new PrdcJobExample();
        example.createCriteria().andCodeEqualTo(code);
        List<PrdcJob> jobs = prdcJobMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(jobs)) return null;
        List<PrdcJobVO> jobVOs = BeanUtil.buildListFrom(jobs, PrdcJobVO.class);
        PrdcJobVO jobVO = jobVOs.get(0);
        jobVO.setPrdcJobLineVOList(findJobLineVOByJobId(jobVO.getId()));
        return jobVO;
    }

    @Override
    public List<PrdcJobVO> findPrdcJobVO(boolean cascade) {
        List<PrdcJobVO> list = prdcJobMapper.findPrdcJobVO();
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        } else {
            return list;
        }
    }

    @Override
    public List<PrdcJobVO> findJobVOByRecipeId(Long recipeId, Boolean cascade) {
        PrdcJobCond cond = new PrdcJobCond();
        cond.setRecipeId(recipeId);
        cond.setCurrpage(null);
        List<PrdcJobVO> prdcJobVOList = findJobVOByCond(cond, cascade);
        if (CollectionUtils.isEmpty(prdcJobVOList)) {
            return Collections.emptyList();
        } else {
            return prdcJobVOList;
        }
    }

    @Override
    public Map<String, WhRecipeInvVO> caculateRecipeAmountForAssemble(List<String> skuCodes, String warehouseCode) {
        Map<String, WhRecipeInvVO> map = new HashMap<>();
        PrdcRecipeCond cond = new PrdcRecipeCond();
        cond.setSkuCodes(skuCodes);
        List<PrdcRecipeVO> recipeList = prdcRecipeService.findRecipeVOByCond(cond, true);
        if (EmptyUtil.isNotEmpty(recipeList)) {
            List<String> materialSkuCodes = new ArrayList<>();
            for (PrdcRecipeVO recipeVO : recipeList) {
                for (PrdcRecipeMaterialVO materialVO : recipeVO.getRecipeMaterialVOList()) {
                    materialSkuCodes.add(materialVO.getSkuCode());
                }
            }
            //配方sku库存
            Map<String, WhInvVO> skuInvMap = sWhInvService.findCanUseQttBySkuCodesAndWarehouseCode(materialSkuCodes, warehouseCode);
            for (PrdcRecipeVO recipeVO : recipeList) {
                WhRecipeInvVO recipeInvVO = buildZeroReceipeInvVO(recipeVO.getSkuCode(), warehouseCode);
                recipeInvVO.setRecipeExist(true);
                recipeInvVO.setCustomization(PrdcRecipeVO.isCustomization(recipeVO.getCustomization()));
                List<WhRecipeInvVO.WhMaterialRecipeInvVO> materialSkuInvList = new ArrayList<>();
                for (PrdcRecipeMaterialVO materialVO : recipeVO.getRecipeMaterialVOList()) {
                    WhRecipeInvVO.WhMaterialRecipeInvVO materialRecipeInvVO = new WhRecipeInvVO.WhMaterialRecipeInvVO();
                    materialRecipeInvVO.setSkuCode(materialVO.getSkuCode());
                    materialRecipeInvVO.setRecipeAmount(materialVO.getQuantity());
                    materialRecipeInvVO.setWarehouseCode(warehouseCode);
                    WhInvVO invVO = skuInvMap.get(materialVO.getSkuCode());
                    if (NullUtil.isNull(invVO)) {
                        invVO = buildZeroInvVO(materialVO.getSkuCode(), warehouseCode);
                    }
                    materialRecipeInvVO.setSkuInvVO(invVO);
                    materialSkuInvList.add(materialRecipeInvVO);
                }
                recipeInvVO.setMaterialSkuInvList(materialSkuInvList);
                map.put(recipeVO.getSkuCode(), recipeInvVO);
            }
        }

        for (String skuCode : skuCodes) {
            WhRecipeInvVO recipeInvVO = map.get(skuCode);
            if (NullUtil.isNull(recipeInvVO)) {
                map.put(skuCode, buildZeroReceipeInvVO(skuCode, warehouseCode));
            }
        }
        return map;
    }

    @Override
    @Transactional
    public boolean batchCreatePrdcJobOrAllot(List<PrdcJobVO> jobList, List<WhAllotRcdVO> allotList) throws Exception {
        List<WhInvOccupyVO> whJobOccupyList = new ArrayList<>();
        List<WhJitPackageSkuReferenceVO> jobreferenceVOList = new ArrayList<>();
        if (EmptyUtil.isNotEmpty(jobList)) {
            for (PrdcJobVO vo : jobList) {
                savePrdcJobAndGetOccupyList(vo, whJobOccupyList);
                buildWhJitPackageSkuReference(vo);
                if (EmptyUtil.isNotEmpty(vo.getJitPackageSkuReferenceList())) {
                    jobreferenceVOList.addAll(vo.getJitPackageSkuReferenceList());
                }
            }
        }
        return sWhAllotService.createAllotRcdAndPrdcJobOccupy(allotList, whJobOccupyList, jobreferenceVOList);
    }

    @Override
    public void sendCusShortMailEmail(List<WhPackageInvVO> packageInvList, String moreInfo) {
        if (EmptyUtil.isEmpty(packageInvList)) {
            return;
        }
        CommGlobalConfig config = utilFacade.findConfigByKey("orderNotice.cusShortMail");
        if (NullUtil.isNull(config) || EmptyUtil.isEmpty(config.getConfigValue())) {
            return;
        }
        List<String> toAddressList = Arrays.asList(config.getConfigValue().split(","));
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(toAddressList);
        emailVO.setSubject("定制商品加工耗材不足");
        emailVO.setContent(buildCusShortMailContent(packageInvList, moreInfo));
        emailSendService.send(emailVO);
    }

    private String buildCusShortMailContent(List<WhPackageInvVO> packageInvList, String moreInfo) {
        List<String> skuCodes = new ArrayList<>();
        //成品sku
        for (WhPackageInvVO packageInvVO : packageInvList) {
            skuCodes.add(packageInvVO.getSkuCode());
        }
        Map<String, PrdcRecipeVO> recipeVOMap = getRecipeVOMap(skuCodes, true);
        //耗材sku
        for (PrdcRecipeVO recipeVO : recipeVOMap.values()) {
            for (PrdcRecipeMaterialVO materialVO : recipeVO.getRecipeMaterialVOList()) {
                skuCodes.add(materialVO.getSkuCode());
            }
        }
        Map<String, PcsSkuVO> skuMap = getSkuMap(skuCodes, false);
        StringBuilder buffer = new StringBuilder();
        if (EmptyUtil.isNotEmpty(moreInfo)) {
            buffer.append(moreInfo).append("<br/>");
        }
        PcsSkuVO skuVO = null;
        for (WhPackageInvVO packageInvVO : packageInvList) {
            skuVO = skuMap.get(packageInvVO.getSkuCode());
            buffer.append("包裹号:").append(packageInvVO.getPackageCode()).append("<br/>")
                    .append("定制SKU:")
                    .append("[").append(packageInvVO.getSkuCode()).append("]")
                    .append(NullUtil.isNull(skuVO) ? "" : skuVO.getNameCn()).append("<br/>");
            PrdcRecipeVO recipeVO = recipeVOMap.get(packageInvVO.getSkuCode());
            if (NullUtil.isNotNull(recipeVO)) {
                for (PrdcRecipeMaterialVO materialVO : recipeVO.getRecipeMaterialVOList()) {
                    skuVO = skuMap.get(materialVO.getSkuCode());
                    buffer.append(String.format("耗材SKU:[%s]%s",
                            materialVO.getSkuCode(), NullUtil.isNull(skuVO) ? "" : skuVO.getNameCn()))
                            .append("<br/>");
                }
            }
            buffer.append("<br/>");
        }
        return buffer.toString();
    }


    private Map<String, PcsSkuVO> getSkuMap(List<String> skuCodes, boolean cascade) {
        List<PcsSkuVO> skuList = mcPcsSkuService.findSkuByCodes(skuCodes, cascade);
        Map<String, PcsSkuVO> skuMap = new HashMap<>();
        if (EmptyUtil.isNotEmpty(skuList)) {
            for (PcsSkuVO sku : skuList) {
                skuMap.put(sku.getCode(), sku);
            }
        }
        return skuMap;
    }

    @Override
    public boolean buildAllotOrPrdcJob(List<WhPackageInvVO> packageInvList, final List<PrdcJobVO> jobList, final List<WhAllotRcdVO> allotList) {
        if (EmptyUtil.isEmpty(packageInvList)) {
            return false;
        }
        List<String> skuCodes = new ArrayList<>();
        for (WhPackageInvVO packageInvVO : packageInvList) {
            skuCodes.add(packageInvVO.getSkuCode());
        }
        Map<String, PrdcRecipeVO> recipeVOMap = getRecipeVOMap(skuCodes, true);
        for (WhPackageInvVO packageInvVO : packageInvList) {
            PrdcRecipeVO recipeVO = recipeVOMap.get(packageInvVO.getSkuCode());
            if (NullUtil.isNull(recipeVO)) {
                throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("[%s]配方不存在", packageInvVO.getSkuCode()));
            }
            if (!isCustomizatonRecipe(recipeVO)) {
                throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("[%s]配方不是定制配方", packageInvVO.getSkuCode()));
            }
            WhPhysicalWarehouseVO processingPhyWh = sWhInfoService.findPhysicalWarehouseByCode(recipeVO.getProcessingWarehouse());
            if (NullUtil.isNull(processingPhyWh)) {
                throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("[%s]物理仓不存在", recipeVO.getProcessingWarehouse()));
            }
            WhWarehouseVO dispatchWarehouse = sWhInfoService.findWarehouseByCode(packageInvVO.getDispatchWarehouseCode());
            if (NullUtil.isNull(dispatchWarehouse)) {
                throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED,
                        String.format("[%s]逻辑仓不存在", packageInvVO.getDispatchWarehouseCode()));
            }
            if (NullUtil.isNotNull(processingPhyWh.getWarehouseGroupId())
                    && processingPhyWh.getWarehouseGroupId().equals(dispatchWarehouse.getWarehouseGroupId())) {
                //创建加工单-同一分组
                jobList.add(buildPrdcJob(packageInvVO, recipeVO));
            } else {
                //创建调拨单
                allotList.add(buildWhAllot(packageInvVO, recipeVO));
            }
        }
        return true;
    }


    private WhAllotRcdVO buildWhAllot(WhPackageInvVO packageInvVO, PrdcRecipeVO recipeVO) {
        WhPhysicalWarehouseVO processingPhyWh = sWhInfoService.findPhysicalWarehouseByCode(recipeVO.getProcessingWarehouse());
        if (NullUtil.isNull(processingPhyWh)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, String.format("[%s]加工仓不存在", recipeVO.getProcessingWarehouse()));
        }
        if (NullUtil.isNull(processingPhyWh.getCityId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, String.format("[%s]加工仓所属地区未设置", recipeVO.getProcessingWarehouse()));
        }
        Date now = DateUtil.getNow();
        WhAllotRcdVO allotRcd = new WhAllotRcdVO();
        //加工仓默认良品出库仓
        WhWarehouseVO targetWarehouse = sWhInfoService.findDefaultOutNondefectiveWarehouseByPhyWhCode(recipeVO.getProcessingWarehouse());
        allotRcd.setTargetWarehouseCode(targetWarehouse.getCode());
        allotRcd.setTargetPhysicalWarehouseCode(recipeVO.getProcessingWarehouse());
        allotRcd.setSourceWarehouseCode(packageInvVO.getDispatchWarehouseCode());
        if (NullUtil.isNull(packageInvVO.getPlanedDeliveryDate())) {
            allotRcd.setEstimatedAllocationDate(DateUtil.addDay(now, 1));
        } else {
            allotRcd.setEstimatedAllocationDate(DateUtil.addDay(packageInvVO.getPlanedDeliveryDate(), 1));
        }
        allotRcd.setAllotType(WhAllotRcdVO.TYPE_CUSTOMIZE_OUT);
        allotRcd.setAllotStatus(WhAllotRcdVO.STATUS_WAIT_FOR_CONFIRMATION);
        allotRcd.setCreateTime(now);
        allotRcd.setRemark("定制加工商品仓库外加工");
        allotRcd.setNeedConfirm(true);
        if (NullUtil.isNull(packageInvVO.getQuantity())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, String.format("[%s]成品数量不可为空", packageInvVO.getSkuCode()));
        }
        Map<String, Integer> skuQuantityMap = new HashMap<>();
        List<WhAllotRcdSkuVO> whAllotRcdSkuList = new ArrayList<>();
        for (PrdcRecipeMaterialVO recipeMaterialVO : recipeVO.getRecipeMaterialVOList()) {
            //填充调拨耗材
            Integer quantity = (int) computeJobLineQuantity(packageInvVO.getQuantity(), recipeMaterialVO.getQuantity());
            WhAllotRcdSkuVO rcdSku = new WhAllotRcdSkuVO();
            rcdSku.setSkuCode(recipeMaterialVO.getSkuCode());
            rcdSku.setQuantity(quantity);
            whAllotRcdSkuList.add(rcdSku);
            skuQuantityMap.put(recipeMaterialVO.getSkuCode(), quantity);
        }
        allotRcd.setWhAllotRcdSkuList(whAllotRcdSkuList);
        List<WhJitPackageSkuReferenceVO> refList = new ArrayList<>();
        WhJitPackageSkuReferenceVO referenceVO = new WhJitPackageSkuReferenceVO();
        referenceVO.setPackageCode(packageInvVO.getPackageCode());
        referenceVO.setSkuCode(packageInvVO.getSkuCode());
        referenceVO.setPackageSkuId(packageInvVO.getPakcageSkuId());
        referenceVO.setType(WhJitPackageSkuReferenceVO.TYPE_WH_ALLOT);
        referenceVO.setStatus(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        referenceVO.setCustomizationContent(packageInvVO.getCustomizationContent());
        referenceVO.setCreateUserId(1L);
        referenceVO.setCreateTime(now);
        refList.add(referenceVO);
        allotRcd.setJitPackageSkuReferenceVOs(refList);
        //计算调拨发货仓
        WhPhysicalWarehouseVO sourcePhyWh = sWhWmsSkuStockService.computeDispatchPhysicalWarehouse(packageInvVO.getDispatchWarehouseCode(), skuQuantityMap, processingPhyWh.getCityId());
        if (NullUtil.isNull(sourcePhyWh)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, String.format("[%s][%s]物理仓库存不足"
                    , packageInvVO.getDispatchWarehouseCode(), packageInvVO.getSkuCode()));
        }
        allotRcd.setSourcePhysicalWarehouseCode(sourcePhyWh.getCode());
        return allotRcd;
    }

    private PrdcJobVO buildPrdcJob(WhPackageInvVO packageInvVO, PrdcRecipeVO recipeVO) {
        Date now = DateUtil.getNow();
        PrdcJobVO jobVO = new PrdcJobVO();
        jobVO.setWarehouseCode(packageInvVO.getDispatchWarehouseCode());//包裹发货仓
        jobVO.setPhysicalWarehouseCode(recipeVO.getProcessingWarehouse());//加工物理仓
        jobVO.setJobType(PrdcJobVO.JOB_TYPE_ASSEMBLE);
        jobVO.setSkuCode(packageInvVO.getSkuCode());
        jobVO.setRecipeId(recipeVO.getId());
        jobVO.setEstQuantity(packageInvVO.getQuantity());
        jobVO.setPlanStatus(PrdcJobVO.PLAN_STATUS_CONFIRM);
        jobVO.setEstDoneDate(DateUtil.addDay(now, 1));
        jobVO.setRemark("定制商品加工");
        jobVO.setCreateOperatorId(1L);
        jobVO.setCreateOperatorName("系统");
        jobVO.setCreateTime(now);
        List<WhJitPackageSkuReferenceVO> refList = new ArrayList<>();
        WhJitPackageSkuReferenceVO referenceVO = new WhJitPackageSkuReferenceVO();
        referenceVO.setPackageCode(packageInvVO.getPackageCode());
        referenceVO.setSkuCode(packageInvVO.getSkuCode());
        referenceVO.setPackageSkuId(packageInvVO.getPakcageSkuId());
        referenceVO.setType(WhJitPackageSkuReferenceVO.TYPE_PRDC_JOB);
        referenceVO.setStatus(WhJitPackageSkuReferenceVO.STATUS_PROCESSING);
        referenceVO.setCustomizationContent(packageInvVO.getCustomizationContent());
        referenceVO.setCreateUserId(1L);
        referenceVO.setCreateTime(now);
        refList.add(referenceVO);
        jobVO.setJitPackageSkuReferenceList(refList);
        bulidJobLine(jobVO, recipeVO);
        return jobVO;
    }

    public void bulidJobLine(PrdcJobVO jobVO, PrdcRecipeVO recipeVO) {
        if (NullUtil.isNull(jobVO) || NullUtil.isNull(jobVO.getEstQuantity())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, String.format("[%s]加工数量不可为空", jobVO.getSkuCode()));
        }
        List<PrdcJobLineVO> prdcJobLineVOList = new ArrayList<>();
        for (PrdcRecipeMaterialVO recipeMaterialVO : recipeVO.getRecipeMaterialVOList()) {
            PrdcJobLineVO lineVO = new PrdcJobLineVO();
            lineVO.setSkuCode(recipeMaterialVO.getSkuCode());
            lineVO.setMaterialType(recipeMaterialVO.getMaterialType());
            lineVO.setRecipeAmount(recipeMaterialVO.getQuantity());
            lineVO.setQuantity(computeJobLineQuantity(jobVO.getEstQuantity(), recipeMaterialVO.getQuantity()));
            prdcJobLineVOList.add(lineVO);
        }
        jobVO.setPrdcJobLineVOList(prdcJobLineVOList);
    }

    private float computeJobLineQuantity(Integer needQuantity, Float recipeQuantity) {
        return (float) Math.ceil(recipeQuantity * needQuantity);
    }

    private boolean isCustomizatonRecipe(PrdcRecipeVO recipeVO) {
        if (NullUtil.isNotNull(recipeVO.getCustomization()) && recipeVO.getCustomization() == PegasusConstants.YES) {
            return true;
        }
        return false;
    }


    private Map<String, PrdcRecipeVO> getRecipeVOMap(List<String> skuCodes, boolean cascade) {
        PrdcRecipeCond cond = new PrdcRecipeCond();
        cond.setSkuCodes(skuCodes);
        Map<String, PrdcRecipeVO> recipeVOMap = new HashMap<>();
        List<PrdcRecipeVO> recipeList = prdcRecipeService.findRecipeVOByCond(cond, cascade);
        if (EmptyUtil.isNotEmpty(recipeList)) {
            for (PrdcRecipeVO recipeVO : recipeList) {
                recipeVOMap.put(recipeVO.getSkuCode(), recipeVO);
            }
        }
        return recipeVOMap;
    }

    private WhRecipeInvVO buildZeroReceipeInvVO(String skuCode, String warehouseCode) {
        WhRecipeInvVO recipeInvVO = new WhRecipeInvVO();
        recipeInvVO.setSkuCode(skuCode);
        recipeInvVO.setWarehouseCode(warehouseCode);
        return recipeInvVO;
    }

    private WhInvVO buildZeroInvVO(String skuCode, String warehouseCode) {
        WhInvVO invVO = new WhInvVO();
        invVO.setSkuCode(skuCode);
        invVO.setWarehouseCode(warehouseCode);
        invVO.setQuantityInOccupy(0);
        invVO.setQuantityInRcd(0);
        return invVO;
    }

    @Override
    public List<PrdcJobLineVO> findJobLineVOByJobId(Long jobId) {
        PrdcJobLineExample example = new PrdcJobLineExample();
        example.createCriteria().andJobIdEqualTo(jobId);
        List<PrdcJobLine> prdcJobLineList = prdcJobLineMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(prdcJobLineList)) {
            return Collections.emptyList();
        } else {
            List<PrdcJobLineVO> prdcJobLineVOList = BeanUtil.buildListFrom(prdcJobLineList, PrdcJobLineVO.class);
            for (PrdcJobLineVO prdcJobLineVO : prdcJobLineVOList) {
                PcsSkuVO skuVO = mcPcsSkuService.findByCode(prdcJobLineVO.getSkuCode());
                if (skuVO == null) {
                    log.error("SKU {} is NULL!", prdcJobLineVO.getSkuCode());
                } else {
                    prdcJobLineVO.setSkuName(skuVO.getNameCn());
                }
            }
            return prdcJobLineVOList;
        }
    }

    public Map<Long, List<PrdcJobLineVO>> findJobLineVOByJobIds(List<Long> jobIds) {
        Map<Long, List<PrdcJobLineVO>> jobMap = new HashMap<>();
        if (EmptyUtil.isEmpty(jobIds)) {
            return jobMap;
        }
        PrdcJobLineExample example = new PrdcJobLineExample();
        example.createCriteria().andJobIdIn(jobIds);
        List<PrdcJobLine> prdcJobLineList = prdcJobLineMapper.selectByExample(example);
        if (EmptyUtil.isNotEmpty(prdcJobLineList)) {
            List<PrdcJobLineVO> prdcJobLineVOList = BeanUtil.buildListFrom(prdcJobLineList, PrdcJobLineVO.class);
            List<String> skuCodes = new ArrayList<>();
            for (PrdcJobLineVO line : prdcJobLineVOList) {
                skuCodes.add(line.getSkuCode());
            }
            List<PcsSkuVO> skuList = mcPcsSkuService.findSkuByCodes(skuCodes, false);
            Map<String, PcsSkuVO> skuMap = new HashMap<>();
            if (EmptyUtil.isNotEmpty(skuList)) {
                for (PcsSkuVO sku : skuList) {
                    skuMap.put(sku.getCode(), sku);
                }
            }
            for (PrdcJobLineVO prdcJobLineVO : prdcJobLineVOList) {
                List<PrdcJobLineVO> tmpList = jobMap.get(prdcJobLineVO.getJobId());
                if (NullUtil.isNull(tmpList)) {
                    tmpList = new ArrayList<>();
                    jobMap.put(prdcJobLineVO.getJobId(), tmpList);
                }
                PcsSkuVO sku = skuMap.get(prdcJobLineVO.getSkuCode());
                if (NullUtil.isNotNull(sku)) {
                    prdcJobLineVO.setSkuName(sku.getNameCn());
                }
                tmpList.add(prdcJobLineVO);
            }
        }
        return jobMap;
    }

    @Override
    public List<PrdcPreJobVO> findPreJobListByCond(PrdcJobCond cond) {
        return prdcPreJobMapper.findPreJobListByCond(cond);
    }

    @Override
    public String findScmOperatorEmailByOperatorId(Long createOperatorId) {
        return prdcPreJobMapper.findScmOperatorEmailByOperatorId(createOperatorId);
    }

    @Override
    public List<PrdcJobVO> findNearestJobBySkuCodes(List<String> skuCodes) {
        return prdcJobMapper.findNearestJobBySkuCodes(skuCodes);
    }

    @Override
    public List<PrdcPreJobLineVO> findPreJobListListByPreJobId(Long preJobId) {
        return prdcPreJobLineMapper.findPreJobListListByPreJobId(preJobId);
    }

    @Override
    public List<PrdcPreJobDownloadVO> findPreJobDownListByCond(PrdcJobCond cond) {
        return prdcPreJobLineMapper.findPreJobDownListByCond(cond);
    }

    @Override
    @Transactional
    public Long processPrdcPreJob(PrdcPreJobVO vo) {
        Long prdcId = null;
        if (Calendar.getInstance().getTimeInMillis() < (DateUtil.dayStart(DateUtil.parse(vo.getEstStartDate(), DateUtil.DEFAULT_DATE_FORMAT)).getTime())) {
            return null;
        }
        if (Calendar.getInstance().getTimeInMillis() > (DateUtil.dayEnd(DateUtil.parse(vo.getEstDoneDate(), DateUtil.DEFAULT_DATE_FORMAT)).getTime())) {
            updatePrdcPreJobStatus(vo.getId(), PrdcPreJob.PRE_JOB_STATUS_FINISH);
        } else {
            int diff = vo.getEstQuantity() - vo.getFinishedQuantity();
            if (diff <= 0) {
                updatePrdcPreJobStatus(vo.getId(), PrdcPreJob.PRE_JOB_STATUS_FINISH);
            } else {
                int useAmount = 0;
                if (vo.getJobType() == 2) {
                    WhInvVO whInvVO = sWhInvService.findCanUseQttBySkuCodeAndWarehouseCode(vo.getSkuCode(), vo.getWarehouseCode());
                    if (whInvVO != null && whInvVO.getCanUseInv() > 0) {
                        useAmount = whInvVO.getCanUseInv();
                    }

                } else {
                    PrdcPreJobLineExample example = new PrdcPreJobLineExample();
                    example.createCriteria().andPreJobIdEqualTo(vo.getId());
                    List<PrdcPreJobLine> prdcPreJobLineList = prdcPreJobLineMapper.selectByExample(example);
                    int i = 0;
                    for (PrdcPreJobLine prdcPreJobLine : prdcPreJobLineList) {
                        WhInvVO whInvVO = sWhInvService.findCanUseQttBySkuCodeAndWarehouseCode(prdcPreJobLine.getSkuCode(), vo.getWarehouseCode());
                        if (whInvVO != null && whInvVO.getCanUseInv() > 0) {
                            int skuUseAmount = new BigDecimal(whInvVO.getCanUseInv()).divide(new BigDecimal(prdcPreJobLine.getRecipeAmount()), 0, BigDecimal.ROUND_DOWN).intValue();
                            if (i == 0) {
                                useAmount = skuUseAmount;
                            }
                            if (skuUseAmount < useAmount) {
                                useAmount = skuUseAmount;
                            }
                        } else {
                            break;
                        }
                        i += 1;
                    }
                }
                if (useAmount > 0) {
                    PrdcPreJobLineExample example = new PrdcPreJobLineExample();
                    example.createCriteria().andPreJobIdEqualTo(vo.getId());
                    List<PrdcPreJobLine> prdcPreJobLineList = prdcPreJobLineMapper.selectByExample(example);
                    int amount = 0;
                    if (diff >= vo.getMinAmount()) {
                        if (useAmount >= vo.getMinAmount()) {
                            if (useAmount > diff) {
                                amount = diff;
                            } else {
                                amount = useAmount;
                            }
                        }
                    } else {
                        if (diff <= useAmount) {
                            amount = diff;
                        }
                    }
                    if (amount > 0) {
                        prdcId = create(buildPrdcJob(vo, amount, prdcPreJobLineList));
                        int finishAmount = vo.getFinishedQuantity() + amount;
                        PrdcPreJob prdcPreJob = new PrdcPreJob();
                        prdcPreJob.setId(vo.getId());
                        prdcPreJob.setFinishedQuantity(finishAmount);
                        prdcPreJobMapper.updateByPrimaryKeySelective(prdcPreJob);
                        if (amount == diff) {
                            updatePrdcPreJobStatus(vo.getId(), PrdcPreJob.PRE_JOB_STATUS_FINISH);
                        } else {
                            updatePrdcPreJobStatus(vo.getId(), PrdcPreJob.PRE_JOB_STATUS_PROCESSING);
                        }
                    }

                }
            }
        }
        return prdcId;
    }

    private PrdcJobVO buildPrdcJob(PrdcPreJobVO vo, int amount, List<PrdcPreJobLine> prdcPreJobLineList) {
        PrdcJobVO prdcJobVO = new PrdcJobVO();
        prdcJobVO.setPlanStatus(PrdcJob.WMS_STATUS_RETURN_MODIFY);
        prdcJobVO.setCreateTime(Calendar.getInstance().getTime());
        prdcJobVO.setCreateOperatorId(vo.getCreateOperatorId());
        prdcJobVO.setReferenceCode(vo.getCode());
        prdcJobVO.setJobType(vo.getJobType());
        prdcJobVO.setRecipeId(vo.getRecipeId());
        prdcJobVO.setSkuCode(vo.getSkuCode());
        prdcJobVO.setWarehouseCode(vo.getWarehouseCode());
        prdcJobVO.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        prdcJobVO.setEstDoneDate(Calendar.getInstance().getTime());
        prdcJobVO.setEstQuantity(amount);
        prdcJobVO.setCreateOperatorName(vo.getCreateOperatorName());
        prdcJobVO.setRemark(vo.getRemark());
        prdcJobVO.setPriority(vo.getPriority());
        List<PrdcJobLineVO> prdcJobLineList = new ArrayList<>();
        prdcJobVO.setPrdcJobLineVOList(prdcJobLineList);
        for (PrdcPreJobLine prdcPreJobLine : prdcPreJobLineList) {
            PrdcJobLineVO prdcJobLine = new PrdcJobLineVO();
            prdcJobLine.setSkuCode(prdcPreJobLine.getSkuCode());
            prdcJobLine.setMaterialType(prdcPreJobLine.getMaterialType());
            prdcJobLine.setRecipeAmount(prdcPreJobLine.getRecipeAmount());
            prdcJobLine.setQuantity(new BigDecimal(prdcPreJobLine.getRecipeAmount()).multiply(new BigDecimal(amount)).setScale(0, BigDecimal.ROUND_UP).floatValue());
            prdcJobLine.setRealQuantity(0f);
            prdcJobLineList.add(prdcJobLine);
        }
        return prdcJobVO;
    }

    private void updatePrdcPreJobStatus(Long id, Integer status) {
        PrdcPreJob prdcPreJob = new PrdcPreJob();
        prdcPreJob.setId(id);
        prdcPreJob.setPlanStatus(status);
        prdcPreJobMapper.updateByPrimaryKeySelective(prdcPreJob);
    }

    @Override
    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond, Boolean cascade) {
        List<PrdcJob> prdcJobList = prdcJobMapper.findJobVOByCond(cond);
        if (CollectionUtils.isEmpty(prdcJobList)) {
            return new ArrayList<PrdcJobVO>();
        } else {
            List<PrdcJobVO> prdcJobVOList = BeanUtil.buildListFrom(prdcJobList, PrdcJobVO.class);
            List<String> skuCodes = new ArrayList<>();
            Set<String> physicalWarehouseCodeSet = new HashSet<>();
            Set<String> warehouseCodeSet = new HashSet<>();
            List<Long> recipeIds = new ArrayList<>();
            List<Long> jobIds = new ArrayList<>();
            for (PrdcJobVO prdcJobVO : prdcJobVOList) {
                skuCodes.add(prdcJobVO.getSkuCode());
                recipeIds.add(prdcJobVO.getRecipeId());
                jobIds.add(prdcJobVO.getId());
                physicalWarehouseCodeSet.add(prdcJobVO.getPhysicalWarehouseCode());
                warehouseCodeSet.add(prdcJobVO.getWarehouseCode());
            }
            // sku
            List<PcsSkuVO> skuList = mcPcsSkuService.findSkuByCodes(skuCodes, false);
            Map<String, PcsSkuVO> skuMap = new HashMap<>();
            if (EmptyUtil.isNotEmpty(skuList)) {
                for (PcsSkuVO sku : skuList) {
                    skuMap.put(sku.getCode(), sku);
                }
            }

            List<String> warehouseCodes = Arrays.asList(warehouseCodeSet.toArray(new String[warehouseCodeSet.size()]));
            // 逻辑仓分组类型
            Map<String,WhWarehouseGroupVO> whGroupMap = sWhWarehouseGroupService.findWhGroupMap(warehouseCodes);

            // 逻辑仓
            List<WhWarehouseVO> whWarehouses = sWhInfoService.findWarehouseByCodes(warehouseCodes);
            Map<String, WhWarehouseVO> warehouseCodeMap = new HashMap<>();
            if (EmptyUtil.isNotEmpty(whWarehouses)) {
                for (WhWarehouseVO warehouse : whWarehouses) {
                    warehouseCodeMap.put(warehouse.getCode(), warehouse);
                }
            }
            // 物理仓
            WhPhysicalWarehouseVO whPhysicalWarehouseVO = new WhPhysicalWarehouseVO();
            whPhysicalWarehouseVO.setWarehouseCodes(Arrays.asList(physicalWarehouseCodeSet.toArray(new String[physicalWarehouseCodeSet.size()])));
            List<WhPhysicalWarehouseVO> physicalWarehouses = sWhInfoService.findPhysicalWarehouseByCond(BeanUtil.buildFrom(whPhysicalWarehouseVO, WhPhysicalWarehouseVO.class));
            Map<String, WhPhysicalWarehouseVO> physicalWarehouseCodeMap = new HashMap<>();
            if (EmptyUtil.isNotEmpty(physicalWarehouses)) {
                for (WhPhysicalWarehouseVO physicalWarehouse : physicalWarehouses) {
                    physicalWarehouseCodeMap.put(physicalWarehouse.getCode(), physicalWarehouse);
                }
            }
            for (PrdcJobVO prdcJobVO : prdcJobVOList) {
                PcsSkuVO skuVO = skuMap.get(prdcJobVO.getSkuCode());
                if (NullUtil.isNotNull(skuVO)) {
                    prdcJobVO.setSkuName(skuVO.getNameCn());
                    prdcJobVO.setSkuBuyerId(skuVO.getBuyerId());
                    prdcJobVO.setSkuBuyerName(skuVO.getBuyerName());
                }
                if (NullUtil.isNotNull(warehouseCodeMap.get(prdcJobVO.getWarehouseCode()))) {
                    prdcJobVO.setWarehouseName(warehouseCodeMap.get(prdcJobVO.getWarehouseCode()).getName());
                }
                if (NullUtil.isNotNull(physicalWarehouseCodeMap.get(prdcJobVO.getPhysicalWarehouseCode()))) {
                    prdcJobVO.setPhysicalWarehouseName(physicalWarehouseCodeMap.get(prdcJobVO.getPhysicalWarehouseCode()).getName());
                    prdcJobVO.setWhPhysicalWarehouse(physicalWarehouseCodeMap.get(prdcJobVO.getPhysicalWarehouseCode()));
                }

                // 逻辑仓分组类型
                WhWarehouseGroupVO whGroup = whGroupMap.get(prdcJobVO.getWarehouseCode());
                if (EmptyUtil.isNotEmpty(whGroup) && WhWarehouseGroupVO.WAREHOUSE_YES.equals(whGroup.getType())){
                    prdcJobVO.setPhysicalWhIsWarehouse(true);
                }
            }
            if (cascade) {
                Map<Long, PrdcRecipeVO> recipeMap = new HashMap<>();
                PrdcRecipeCond recipeCond = new PrdcRecipeCond();
                recipeCond.setRecipeIds(recipeIds);
                List<PrdcRecipeVO> recipeList = prdcRecipeService.findRecipeVOByCond(recipeCond, true);
                if (EmptyUtil.isNotEmpty(recipeList)) {
                    for (PrdcRecipeVO recipeVO : recipeList) {
                        recipeMap.put(recipeVO.getId(), recipeVO);
                    }
                }
                Map<Long, List<PrdcJobLineVO>> prdcJobLineMap = findJobLineVOByJobIds(jobIds);
                for (PrdcJobVO prdcJobVO : prdcJobVOList) {
                    PrdcRecipeVO prdcRecipeVO = recipeMap.get(prdcJobVO.getRecipeId());
                    if (NullUtil.isNotNull(prdcRecipeVO)) {
                        prdcJobVO.setRecipeName(prdcRecipeVO.getRecipeName());
                        prdcJobVO.setRecipeCreateOperatorName(prdcRecipeVO.getCreateUserName());
                        prdcJobVO.setCustomization(prdcRecipeVO.getCustomization());
                    }
                    prdcJobVO.setPrdcJobLineVOList(prdcJobLineMap.get(prdcJobVO.getId()));
                }
                //填充定制信息
                fullCustoimzationInfo(prdcJobVOList);
            }
            return prdcJobVOList;
        }
    }

    private void fullCustoimzationInfo(List<PrdcJobVO> prdcJobVOList) {
        if (EmptyUtil.isEmpty(prdcJobVOList)) {
            return;
        }
        List<String> codes = new ArrayList<>();
        for (PrdcJobVO jobVO : prdcJobVOList) {
            codes.add(jobVO.getCode());
        }
        Map<String, List<WhJitPackageSkuReferenceVO>> codeMap = sWhJitPackageSkuReferenceService.findByReferenceCodeGroup(codes);
        if (!codeMap.isEmpty()) {
            for (PrdcJobVO jobVO : prdcJobVOList) {
                List<WhJitPackageSkuReferenceVO> tmpList = codeMap.get(jobVO.getCode());
                if (NullUtil.isNotNull(tmpList)) {
                    jobVO.setJitPackageSkuReferenceList(tmpList);
                }
            }
        }
    }

    @Override
    public Pagination<PrdcJobVO> findJobVOByCondPage(PrdcJobCond cond) {
        Pagination<PrdcJobVO> page = new Pagination<>(cond.getCurrpage(), cond.getPagenum());
        int total = prdcJobMapper.countJobVOByCond(cond);
        if (NumberUtil.isNullOrZero(total)) {
            page.setRecord(0);
            return page;
        }
        List<PrdcJobVO> list = findJobVOByCond(cond, cond.isCascade());
        list.forEach((PrdcJobVO vo) ->{
            setPrdcJobVOProperty(vo);
        });
        page.setRecord(total);
        page.setResultList(list);
        return page;
    }
    private void setPrdcJobVOProperty(PrdcJobVO vo){
        if(vo != null){
            if(vo.getWarehouseCode() != null){
                WhWarehouseVO whWarehouseVO = warehouseMap.get(vo.getWarehouseCode());
                if(whWarehouseVO == null){
                    whWarehouseVO = sWhInfoService.findWarehouseByCode(vo.getWarehouseCode());
                    if(whWarehouseVO != null){
                        warehouseMap.put(whWarehouseVO.getCode(),whWarehouseVO);
                    }
                }
                if(whWarehouseVO != null){
                    vo.setWarehouseName(whWarehouseVO.getName());
                }
                WhWarehouseGroupVO whGroup = whGroupMap.get(vo.getWarehouseCode());
                if(whGroup == null){
                    Map<String,WhWarehouseGroupVO> whGroupMap = sWhWarehouseGroupService.findWhGroupMap(Collections.singletonList(vo.getWarehouseCode()));
                    if(whGroupMap != null && whGroupMap.size() > 0){
                        whGroup = whGroupMap.get(vo.getWarehouseCode());
                        whGroupMap.put(vo.getWarehouseCode(),whGroup);
                    }
                }
                boolean isG = false;
                if (WhWarehouseGroupVO.WAREHOUSE_YES.equals(whGroup.getType())){
                    isG = true;
                }
                vo.setPhysicalWhIsWarehouse(isG);
            }
            if(vo.getPhysicalWarehouseCode() != null){
                WhPhysicalWarehouseVO whPhysicalWarehouseVO = whPhysicalWarehouseMap.get(vo.getPhysicalWarehouseCode());
                if(whPhysicalWarehouseVO == null){
                    whPhysicalWarehouseVO = sWhInfoService.findPhysicalWarehouseByCode(vo.getPhysicalWarehouseCode());
                    if(whPhysicalWarehouseVO != null){
                        whPhysicalWarehouseMap.put(whPhysicalWarehouseVO.getCode(),whPhysicalWarehouseVO);
                    }
                }
                if(whPhysicalWarehouseVO != null){
                    vo.setPhysicalWarehouseName(whPhysicalWarehouseVO.getName());
                }
            }
        }
    }
    @Override
    public PrdcJobCountInfo countPrdcJobByCond(PrdcJobCond cond) {
        return prdcJobMapper.countPrdcJobByCond(cond);
    }

    @Override
    @Transactional
    public Long create(PrdcJobVO vo) {
        List<WhInvOccupyVO> whOccupyList = new ArrayList<>();
        PrdcJob prdcJob = savePrdcJobAndGetOccupyList(vo, whOccupyList);
        vo.setCode(prdcJob.getCode());
        buildWhJitPackageSkuReference(vo);
        sWhInvService.occupy(whOccupyList, vo.getJitPackageSkuReferenceList());
        return prdcJob.getId();
    }

    private void buildWhJitPackageSkuReference(PrdcJobVO vo) {
        if (EmptyUtil.isNotEmpty(vo.getJitPackageSkuReferenceList())) {
            Date createTime = DateUtil.getNow();
            for (WhJitPackageSkuReferenceVO skuReferenceVO : vo.getJitPackageSkuReferenceList()) {
                skuReferenceVO.setReferenceCode(vo.getCode());
                skuReferenceVO.setCreateTime(createTime);
                if (NullUtil.isNull(vo.getCreateOperatorId())) {
                    skuReferenceVO.setCreateUserId(1L);
                } else {
                    skuReferenceVO.setCreateUserId(vo.getCreateOperatorId());
                }
            }
        }
    }

    @Override
    @Transactional
    public Integer updatePrdcPreJobByKey(PrdcPreJob prdcPreJob) {
        return prdcPreJobMapper.updateByPrimaryKeySelective(prdcPreJob);
    }

    @Override
    @Transactional
    public Long createPrdcPreJob(PrdcPreJob vo) {
        prdcPreJobMapper.insert(vo);
        int num = 0;
        int result = 0;
        while (result <= 0) {
            vo.setCode(generatePreJobCode(num));
            num += 1;
            try {
                result = prdcPreJobMapper.updateByPrimaryKeySelective(vo);
            } catch (Exception e) {

            }
        }
        PrdcRecipeMaterialExample example = new PrdcRecipeMaterialExample();
        example.createCriteria().andRecipeIdEqualTo(vo.getRecipeId());
        List<PrdcRecipeMaterial> list = prdcRecipeMaterialMapper.selectByExample(example);
        for (PrdcRecipeMaterial prdcRecipeMaterial : list) {
            PrdcPreJobLine prdcPreJobLine = new PrdcPreJobLine();
            prdcPreJobLine.setSkuCode(prdcRecipeMaterial.getSkuCode());
            prdcPreJobLine.setMaterialType(prdcRecipeMaterial.getMaterialType());
            prdcPreJobLine.setRecipeAmount(prdcRecipeMaterial.getQuantity());
            prdcPreJobLine.setPreJobId(vo.getId());
            prdcPreJobLineMapper.insert(prdcPreJobLine);
        }
        return vo.getId();
    }

    @Override
    @Transactional
    public String createFlowerPrdcPreJob(PcsPreAllotVO vo) {
        PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe = pcsFlowerDeliveryRecipeMapper.selectByPrimaryKey(vo.getRecipeId());
        PcsFlowerRecipeSkuExample pcsFlowerRecipeSkuExample = new PcsFlowerRecipeSkuExample();
        PcsFlowerRecipeSkuExample.Criteria criteria = pcsFlowerRecipeSkuExample.createCriteria();
        criteria.andRecipeIdEqualTo(vo.getRecipeId());
        criteria.andAvailableEqualTo(1);
        List<PcsFlowerRecipeSku> pcsFlowerRecipeSkuList = pcsFlowerRecipeSkuMapper.selectByExample(pcsFlowerRecipeSkuExample);
        if (pcsFlowerRecipeSkuList == null || pcsFlowerRecipeSkuList.size() == 0) {
            throw new PurchaseException("999", "还没有生成配方");
        }
        if (vo.getSelfShouldSendQuantity() <= 0) {
            throw new PurchaseException("999", "成品数量必须大于0");
        }
        PrdcRecipeCond prdcRecipeCond = new PrdcRecipeCond();
        prdcRecipeCond.setRecipeSkuCode(pcsFlowerDeliveryRecipe.getSkuCode());
        List<PrdcRecipeVO> prdcRecipeVOList = prdcRecipeService.findRecipeVOByCond(prdcRecipeCond, false);
        Long prdcRecipeId = null;
        if (prdcRecipeVOList == null || prdcRecipeVOList.size() == 0) {
            PrdcRecipeVO prdcRecipeVO = new PrdcRecipeVO();
            prdcRecipeVO.setCreateTime(Calendar.getInstance().getTime());
            prdcRecipeVO.setCreateUserId(vo.getOperatorId());
            PcsSkuVO pcsSkuVO = mcPcsSkuService.findByCode(pcsFlowerDeliveryRecipe.getSkuCode());
            prdcRecipeVO.setRecipeDesc(pcsSkuVO == null ? "" : pcsSkuVO.getNameCn());
            prdcRecipeVO.setRecipeName(pcsSkuVO == null ? "" : pcsSkuVO.getNameCn());
            prdcRecipeVO.setRecipeStatus(1);
            prdcRecipeVO.setSkuCode(pcsFlowerDeliveryRecipe.getSkuCode());
            List<PrdcRecipeMaterialVO> prdcRecipeMaterialVOList = new ArrayList<>();
            prdcRecipeVO.setRecipeMaterialVOList(prdcRecipeMaterialVOList);
            for (PcsFlowerRecipeSku pcsFlowerRecipeSku : pcsFlowerRecipeSkuList) {
                PrdcRecipeMaterialVO prdcRecipeMaterialVO = new PrdcRecipeMaterialVO();
                prdcRecipeMaterialVO.setSkuCode(pcsFlowerRecipeSku.getSkuCode());
                prdcRecipeMaterialVO.setQuantity(pcsFlowerRecipeSku.getExpendNumber());
                prdcRecipeMaterialVO.setMaterialType(pcsFlowerRecipeSku.getSkuType() == 0 ? 2 : pcsFlowerRecipeSku.getSkuType());
                prdcRecipeMaterialVOList.add(prdcRecipeMaterialVO);
            }
            prdcRecipeId = prdcRecipeService.create(prdcRecipeVO);
        } else {
            prdcRecipeId = prdcRecipeVOList.get(0).getId();
        }
        PrdcPreJob prdcPreJob = new PrdcPreJob();
        prdcPreJob.setSkuCode(pcsFlowerDeliveryRecipe.getSkuCode());
        prdcPreJob.setCreateTime(Calendar.getInstance().getTime());
        prdcPreJob.setPlanStatus(1);
        prdcPreJob.setCreateOperatorId(vo.getOperatorId());
        prdcPreJob.setFinishedQuantity(0);
        prdcPreJob.setEstDoneDate(pcsFlowerDeliveryRecipe.getSendDay());
        prdcPreJob.setEstQuantity(vo.getSelfShouldSendQuantity());
        prdcPreJob.setEstStartDate(Calendar.getInstance().getTime());
        prdcPreJob.setJobType(1);
        prdcPreJob.setMinQuantity(10);
        prdcPreJob.setRecipeId(prdcRecipeId);
        prdcPreJob.setRemark("周期配送商品");
        prdcPreJob.setWarehouseCode("WH020600010096");
        prdcPreJobMapper.insertSelective(prdcPreJob);
        int num = 0;
        int result = 0;
        while (result <= 0) {
            prdcPreJob.setCode(generatePreJobCode(num));
            num += 1;
            try {
                result = prdcPreJobMapper.updateByPrimaryKeySelective(prdcPreJob);
            } catch (Exception e) {

            }
        }
        for (PcsFlowerRecipeSku pcsFlowerRecipeSku : pcsFlowerRecipeSkuList) {
            PrdcPreJobLine prdcPreJobLine = new PrdcPreJobLine();
            prdcPreJobLine.setPreJobId(prdcPreJob.getId());
            prdcPreJobLine.setRecipeAmount(pcsFlowerRecipeSku.getExpendNumber());
            prdcPreJobLine.setMaterialType(pcsFlowerRecipeSku.getSkuType() == 0 ? 2 : pcsFlowerRecipeSku.getSkuType());
            prdcPreJobLine.setSkuCode(pcsFlowerRecipeSku.getSkuCode());
            prdcPreJobLineMapper.insertSelective(prdcPreJobLine);
        }
        return prdcPreJob.getCode();
    }

    private PrdcPreJobVO createPrdcPreJob(PrdcPreJobVO vo) {
        PrdcPreJob prdcPreJob = BeanUtil.buildFrom(vo, PrdcPreJob.class);
        Integer id = prdcPreJobMapper.insertSelective(prdcPreJob);
        int num = 0;
        int result = 0;
        while (result <= 0) {
            prdcPreJob.setCode(generatePreJobCode(num));
            num += 1;
            try {
                result = prdcPreJobMapper.updateByPrimaryKeySelective(prdcPreJob);
            } catch (Exception e) {

            }
        }
        List<PrdcPreJobLine> list = BeanUtil.buildListFrom(vo.getJobLineVOList(), PrdcPreJobLine.class);
        for (PrdcPreJobLine prdcPreJobLine : list) {
            prdcPreJobLine.setPreJobId(Long.parseLong(id.toString()));
            prdcPreJobLineMapper.insertSelective(prdcPreJobLine);
        }
        vo.setId(Long.parseLong(id.toString()));
        vo.setCode(prdcPreJob.getCode());
        return vo;
    }

    private String generatePreJobCode(int num) {
        String date = DateUtil.format(Calendar.getInstance().getTime(), DateUtil.DEFAULT_STR_FORMAT);
        long dateLong = Long.parseLong(date);
        dateLong += num;
        return "FPJ" + dateLong;
    }

    //获取占用库存列表，创建生产任务
    private PrdcJob savePrdcJobAndGetOccupyList(PrdcJobVO vo, List<WhInvOccupyVO> whOccupyList) {
        vo.setProcessingAmount(0);
        vo.setFinishedDamagedQuantity(0);
        vo.setFinishedQuantity(0);
        PrdcJob prdcJob = BeanUtil.buildFrom(vo, PrdcJob.class);
        List<PrdcJobLine> prdcJobLineList = BeanUtil.buildListFrom(vo.getPrdcJobLineVOList(), PrdcJobLine.class);

        WhWarehouseVO whWarehouse = sWhInfoService.findWarehouseByCode(vo.getWarehouseCode());
        Validation.paramNotNull(whWarehouse, "逻辑仓为空");
        Validation.paramNotNull(whWarehouse.getCommodityStatus(), "逻辑仓商品状态为空");
        PhyWhStockCond phyWhStockCond = new PhyWhStockCond();
        phyWhStockCond.setPhysicalWarehouseCode(vo.getPhysicalWarehouseCode());
        phyWhStockCond.setSkuStatus(whWarehouse.getCommodityStatus());
        if (vo.getJobType() == PrdcJobVO.JOB_TYPE_ASSEMBLE) {
            for (PrdcJobLine jobLine : prdcJobLineList) {
                WhInvVO whInvVO = sWhInvService.findCanUseQttBySkuCodeAndWarehouseCode(jobLine.getSkuCode(), vo.getWarehouseCode());
                if (jobLine.getQuantity() > whInvVO.getCanUseInv())
                    throw new PurchaseException("", "SKU[" + jobLine.getSkuCode() + "]" + "在[" + whWarehouse.getName() + "]中的可用库存不足");
                // 校验物理仓库存
                phyWhStockCond.setSkuCode(jobLine.getSkuCode());
                int physicalSkuStockCount = findPhysicalSkuStock(phyWhStockCond);
                if (jobLine.getQuantity() > physicalSkuStockCount) {
                    throw new PurchaseException("", "物理仓库存不足，SKU[" + jobLine.getSkuCode() + "],商品状态[" + phyWhStockCond.getSkuStatus() + "]" + "物理仓[" + phyWhStockCond.getPhysicalWarehouseCode() + "]，需扣减数[" + jobLine.getQuantity() + "]>当前库存数[" + physicalSkuStockCount + "]");
                }
            }
        } else if (vo.getJobType() == PrdcJobVO.JOB_TYPE_SPLIT) {
            WhInvVO whInvVO = sWhInvService.findCanUseQttBySkuCodeAndWarehouseCode(vo.getSkuCode(), vo.getWarehouseCode());
            if (vo.getEstQuantity() > whInvVO.getCanUseInv())
                throw new PurchaseException("", "SKU[" + vo.getSkuCode() + "]" + "在[" + whWarehouse.getName() + "]中的可用库存不足");
            // 校验物理仓库存
            phyWhStockCond.setSkuCode(vo.getSkuCode());
            int physicalSkuStockCount = findPhysicalSkuStock(phyWhStockCond);
            if (vo.getEstQuantity() > physicalSkuStockCount) {
                throw new PurchaseException("", "物理仓库存不足，SKU[" + vo.getSkuCode() + "],商品状态[" + phyWhStockCond.getSkuStatus() + "]" + "物理仓[" + phyWhStockCond.getPhysicalWarehouseCode() + "]，需扣减数[" + vo.getEstQuantity() + "]>当前库存数[" + physicalSkuStockCount + "]");
            }
        }
        createJob(prdcJob);
        vo.setCode(prdcJob.getCode());
        saveJobLine(prdcJob, prdcJobLineList);
        //占用库存
        whOccupyList.addAll(buildWhOccupy
                (prdcJob, prdcJobLineList, vo.getWarehouseCode(), WhInvOccupyVO.TYPE_PRODUCE_OUT));
        return prdcJob;
    }

    private int findPhysicalSkuStock(PhyWhStockCond cond) {
        List<PhyWhStockVO> phyWhStockVOs = sWhWmsSkuStockService.findPhyWhStockByCond(cond);
        if (CollectionUtils.isEmpty(phyWhStockVOs)) {
            return 0;
        }
        return phyWhStockVOs.get(0).getCanUseQuantity();
    }

    @Override
    @Transactional
    public List<Long> batchCreate(List<PrdcJobVO> list) {
        List<Long> ids = new ArrayList<>();
        if (EmptyUtil.isNotEmpty(list)) {
            List<WhInvOccupyVO> whOccupyList = new ArrayList<>();
            for (PrdcJobVO vo : list) {
                PrdcJob prdcJob = savePrdcJobAndGetOccupyList(vo, whOccupyList);
                ids.add(prdcJob.getId());
            }
            ServiceResp<List<SOccupyResultVO>> serviceResp = sStockService.occupy(convertWhInvOccupy2DTO(whOccupyList));
            if (serviceResp.isFailure()) {
                throw new PurchaseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
            }
        }
        return ids;
    }

    @Override
    @Transactional
    public List<Long> batchCreate(List<PrdcJobVO> list, String allotCode) {
        List<Long> ids = new ArrayList<>();
        if (EmptyUtil.isNotEmpty(list)) {
            List<WhInvOccupyVO> whOccupyList = new ArrayList<>();
            List<WhJitPackageSkuReferenceVO> referenceVOList = new ArrayList<>();
            for (PrdcJobVO vo : list) {
                PrdcJob prdcJob = savePrdcJobAndGetOccupyList(vo, whOccupyList);
                buildWhJitPackageSkuReference(vo);
                if (EmptyUtil.isNotEmpty(vo.getJitPackageSkuReferenceList())) {
                    referenceVOList.addAll(vo.getJitPackageSkuReferenceList());
                }
                ids.add(prdcJob.getId());
            }
            sWhInvService.occupy(whOccupyList, referenceVOList, allotCode);
        }
        return ids;
    }

    @Override
    public List<Long> batchCreateAndFinishForKafka(List<PrdcJobVO> list) throws Exception {

        List<Long> ids = new ArrayList<>();
        if (EmptyUtil.isNotEmpty(list)) {
            List<WhInvOccupyVO> whOccupyList = new ArrayList<>();
            for (PrdcJobVO vo : list) {
                PrdcJob prdcJob = savePrdcJobAndGetOccupyList(vo, whOccupyList);
                vo.setId(prdcJob.getId());
                ids.add(prdcJob.getId());
            }
            ServiceResp<List<SOccupyResultVO>> serviceResp = sStockService.occupy(convertWhInvOccupy2DTO(whOccupyList));
            if (serviceResp.isFailure()) {
                throw new PurchaseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
            }
        }
        if (EmptyUtil.isNotEmpty(list)) {
            for (PrdcJobVO vo : list) {
                PrdcJobVO updateVO = new PrdcJobVO();
                updateVO = BeanUtil.buildFrom(vo, PrdcJobVO.class);
                updateVO.setFinishTime(new Date());
                updateVO.setCreateTime(new Date());
                PrdcJobLineExample example = new PrdcJobLineExample();
                example.createCriteria().andJobIdEqualTo(updateVO.getId());
                List<PrdcJobLine> jobLines = prdcJobLineMapper.selectByExample(example);
                for (PrdcJobLine line : jobLines) {
                    line.setRealQuantity(line.getQuantity());
                }
                List<PrdcJobLineVO> jobLineVOS = BeanUtil.buildListFrom(jobLines, PrdcJobLineVO.class);
                updateVO.setPrdcJobLineVOList(jobLineVOS);
                finishJob(updateVO);
            }
        }
        return ids;
    }

    private void finishJob(PrdcJobVO vo) throws Exception {
        List<PrdcJobLine> prdcJobLineList = BeanUtil.buildListFrom(vo.getPrdcJobLineVOList(), PrdcJobLine.class);
        List<WhReleaseOccupationVO> whReleaseOccupationVOList =
                buildWhRelease(vo, prdcJobLineList, WhInvOccupyVO.TYPE_PRODUCE_OUT);
        if (CollectionUtils.isEmpty(whReleaseOccupationVOList)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "创建释放占用库存失败");
        }
        vo.setFinishedQuantity(vo.getEstQuantity());
        vo.setConfirmOperatorId(vo.getCreateOperatorId());
        vo.setConfirmOperatorName(vo.getCreateOperatorName());

        for (PrdcJobLineVO jobLine_0 : vo.getPrdcJobLineVOList()) {
            for (PrdcJobLineVO jobLine : vo.getPrdcJobLineVOList()) {
                if (jobLine_0.getSkuCode().equals(jobLine.getSkuCode())) {
                    //拆分订单辅耗材损耗
                    if (vo.getJobType() == 2 && jobLine_0.getMaterialType() == 2) {
                        jobLine_0.setRealQuantity(new Float(0));
                        jobLine_0.setDamageQuantity(0);
                    } else {
                        jobLine_0.setRealQuantity(jobLine.getRealQuantity());
                        jobLine_0.setDamageQuantity(jobLine.getDamageQuantity());
                        jobLine_0.setRemark(jobLine.getRemark());
                    }
                }
            }
        }
        List<WhCommandVO> whCommands = buildPrdcCommands(vo);//创建生产加工指令
        createCommandsAfterReleaseThenFinishAndUpdate(vo, whCommands, whReleaseOccupationVOList);
    }

    @Override
    @Transactional
    public Boolean returnModify(PrdcJobVO vo) {
        PrdcJob prdcJob = BeanUtil.buildFrom(vo, PrdcJob.class);
        List<PrdcJobLine> prdcJobLineList_0 = BeanUtil.buildListFrom(findJobLineVOByJobId(vo.getId()), PrdcJobLine.class);
        // 创建释放
        List<WhReleaseOccupationVO> whReleaseList = buildWhRelease(prdcJob, prdcJobLineList_0, WhInvOccupyVO.TYPE_PRODUCE_OUT);
        List<PrdcJobLine> prdcJobLineList = BeanUtil.buildListFrom(vo.getPrdcJobLineVOList(), PrdcJobLine.class);
        returnModifyJob(prdcJob);
        changeJobLine(prdcJob, prdcJobLineList);
        //创建新占用
        List<WhInvOccupyVO> whOccupyList = buildWhOccupy
                (prdcJob, prdcJobLineList, vo.getWarehouseCode(), WhInvOccupyVO.TYPE_PRODUCE_OUT);
        buildWhJitPackageSkuReference(vo);
        sWhInvService.occupyAfterRelease(whOccupyList, whReleaseList, vo.getCode(), vo.getJitPackageSkuReferenceList());
        return true;
    }

    @Override
    public Boolean deleteJobLine(Long jobId, Long jobLineId) {
        if (jobId == null || jobLineId == null) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        PrdcJobVO prdcJobVO = findJobVOById(jobId);
        if (prdcJobVO == null) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "匹配不到任务");
        }
        Boolean found = false;
        for (PrdcJobLineVO prdcJobLineVO : prdcJobVO.getPrdcJobLineVOList()) {
            if (!prdcJobLineVO.getId().equals(jobLineId)) {
                continue;
            }
            found = true;
        }
        if (found) {
            if (prdcJobLineMapper.deleteByPrimaryKey(jobLineId) == 0) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_DELETE_DB, "删除任务行失败");
            }
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "任务不包含该行数据");
        }
        return true;
    }

    @Override
    public Boolean cancelJobForStatusReturnModify(Long jobId) {
        if (jobId != null && jobId > 0) {
            PrdcJobVO prdcJobVO = findJobVOById(jobId);
            if (prdcJobVO != null) {
                if (prdcJobVO.getPlanStatus().equals(PrdcJob.PLAN_STATUS_RETURN_MODIFY)) {
                    PrdcJob update = new PrdcJob();
                    update.setId(jobId);
                    update.setPlanStatus(PrdcJob.PLAN_STATUS_CANCEL);
                    if (prdcJobMapper.updateByPrimaryKeySelective(update) == 0) {
                        throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "数据库更新失败");
                    }
                } else {
                    throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "the status is invalid ");
                }
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "job is not found ");
            }
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "the id is invalid");
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean startProduction(PrdcJobVO jobVO) {
        if (jobVO == null)
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        PrdcJob prdcJob = BeanUtil.buildFrom(jobVO, PrdcJob.class);
        int update = prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (update <= 0)
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "数据库更新失败");
//        facadeWi.getInstance().occupy(whInvOccupyList);
        return true;
    }

    @Override
    @Transactional
    public Boolean releaseJobLineOccupyAndUpdate(PrdcJobVO jobVO, List<WhReleaseOccupationVO> whReleaseOccupationVOList) {
        if (jobVO == null)
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        PrdcJob prdcJob = BeanUtil.buildFrom(jobVO, PrdcJob.class);
        int update = prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (update <= 0)
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "数据库更新失败");
        sWhInvService.releaseOccupation(whReleaseOccupationVOList, jobVO.getJitPackageSkuReferenceList());
        return true;
    }

    @Override
    @Transactional
    public Boolean createCommandsAfterReleaseThenFinishAndUpdate(PrdcJobVO jobVO, List<WhCommandVO> whCommands,
                                                                 List<WhReleaseOccupationVO> whReleaseOccupationVOList) throws Exception {
        if (jobVO == null)
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "param abnormal!");
        if (jobVO.getPlanStatus() == PrdcJob.PLAN_STATUS_FINISHED || jobVO.getPlanStatus() == PrdcJob.WMS_PLAN_STATUS_FINISHED || jobVO.getPlanStatus() == PrdcJob.PLAN_STATUS_CANCEL)
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "status abnormal!");
        PrdcJob prdcJob = BeanUtil.buildFrom(jobVO, PrdcJob.class);
        prdcJob.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_FINISHED);
        prdcJob.setFinishTime(new Date());
        int updateJob = prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (updateJob <= 0)
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "update data failed!");
        for (PrdcJobLine jobLine : jobVO.getPrdcJobLineVOList()) {
            int updateJobLine = prdcJobLineMapper.updateByPrimaryKey(jobLine);
            if (updateJobLine <= 0)
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "update data failed!");
        }
        //释放后创建指令并完成后更新job
        if (EmptyUtil.isNotEmpty(whCommands)) {
            for (WhCommandVO cmd : whCommands) {
                cmd.setPlanedDeliveryDate(prdcJob.getFinishTime());//冗余预计发货日期
            }
        }
        List<String> commands = wWhCommandService.createCommandsAfterReleaseThenFinishForPrdc(whCommands, whReleaseOccupationVOList);
        if (EmptyUtil.isEmpty(commands))
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "param abnormal!");
        return true;
    }

    @Override
    @Transactional
    public Boolean updateJobVO(PrdcJobVO jobVO) {
        if (jobVO == null)
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "param abnormal!");
        PrdcJob prdcJob = BeanUtil.buildFrom(jobVO, PrdcJob.class);
        int update = prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (update <= 0)
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "update data failed!");
        return true;
    }

    @Override
    @Transactional
    public Boolean updatePjJobVO(PrdcJobVO jobVO) {
        if (jobVO == null)
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "param abnormal!");
        PrdcJob prdcJob = BeanUtil.buildFrom(jobVO, PrdcJob.class);
        int update = prdcJobMapper.updateByPrimaryKeySelective(prdcJob);
        if (update <= 0)
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "update data failed!");
        return true;
    }

    @Override
    @Transactional
    public boolean updateProdJobById(long id, Integer sign) {
        int result = 0;
        try {
            result = prdcJobMapper.updateProdJobById(id, sign);
        } catch (Exception e) {
            log.error(e.getMessage());
        }
        if (result > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    @Transactional
    public boolean updateJobConfirmToWmsReturnModify(String jobCode) {
        PrdcJobExample example = new PrdcJobExample();
        example.createCriteria().andCodeEqualTo(jobCode);
        List<PrdcJob> jobs = prdcJobMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(jobs)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, String.format("[%s]加工单不存在", jobCode));
        }
        PrdcJob job = jobs.get(0);
        if (!PrdcJob.PLAN_STATUS_CONFIRM.equals(job.getPlanStatus())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, String.format("[%s]加工单状态[%s]", jobCode, job.getPlanStatus()));
        }
        changePrdcJobStatus(job.getId(), PrdcJob.PLAN_STATUS_CONFIRM, PrdcJob.WMS_STATUS_RETURN_MODIFY);
        return true;
    }

    private void changePrdcJobStatus(Long jobId, Integer oldStatus, Integer newStatus) {
        PrdcJobExample example = new PrdcJobExample();
        example.createCriteria().andPlanStatusEqualTo(oldStatus).andIdEqualTo(jobId);
        PrdcJob record = new PrdcJob();
        record.setPlanStatus(newStatus);
        int count = prdcJobMapper.updateByExampleSelective(record, example);
        if (count != 1) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "加工单状态更新失败");
        }
    }

    /**
     * 校验任务
     *
     * @param isCreat
     * @param rcd
     */
    private void validateJob(Boolean isCreat, PrdcJob rcd) {
        if (isCreat) {
            if (rcd.getId() != null) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "param abnormal");
            }
        } else {
            if (rcd.getId() == null) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "param abnormal");
            }
        }

        PrdcRecipeVO prdcRecipeVO = prdcRecipeService.findRecipeVOById(rcd.getRecipeId());
        if (prdcRecipeVO == null) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "recipeId匹配不到配方");
        }
        if (!prdcRecipeVO.getSkuCode().equals(rcd.getSkuCode())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "配方成品skuCode与任务成品skuCode不一致");
        }
        PcsSkuVO skuVO = mcPcsSkuService.findByCode(rcd.getSkuCode());
        if (skuVO == null) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "skuCode匹配不到sku");
        }
    }

    /**
     * 创建任务
     *
     * @param rcd
     */
    @Transactional
    private void createJob(PrdcJob rcd) {
        validateJob(true, rcd);
        rcd.setCode("");
        if (NullUtil.isNull(rcd.getPlanStatus())) {
            rcd.setPlanStatus(PrdcJob.WMS_STATUS_RETURN_MODIFY);
        }
        rcd.setCreateTime(DateUtil.getNow());
        if (prdcJobMapper.insert(rcd) == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "insert data failed!");
        }
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", rcd.getId());
        String code = CodeGenerator.getInstance().generate("PRDC_JOB_CODE", params);
        if (EmptyUtil.isEmpty(code)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_GENERATE_CODE, "任务编号生成失败");
        }
        rcd.setCode(code);
        if (prdcJobMapper.updateByPrimaryKey(rcd) == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "update data failed!");
        }
    }

    /**
     * 退回修改任务
     *
     * @param rcd
     */
    @Transactional
    private void returnModifyJob(PrdcJob rcd) {
        if (rcd.getPlanStatus() != PrdcJob.WMS_STATUS_RETURN_MODIFY)
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "status abnormal!");
        validateJob(false, rcd);
        PrdcJob update = new PrdcJob();
        update.setRecipeId(rcd.getRecipeId());
        update.setId(rcd.getId());
        update.setSkuCode(rcd.getSkuCode());
        update.setWarehouseCode(rcd.getWarehouseCode());
        update.setPriority(rcd.getPriority());
        update.setEstQuantity(rcd.getEstQuantity());
        update.setEstDoneDate(rcd.getEstDoneDate());
        update.setRemark(rcd.getRemark());
        update.setJobType(rcd.getJobType());
        if (prdcJobMapper.updateByPrimaryKeySelective(update) == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "update data failed!");
        }
    }

    /**
     * 保存任务行
     *
     * @param prdcJob
     * @param rcdList
     */
    private void saveJobLine(PrdcJob prdcJob, List<PrdcJobLine> rcdList) {
        List<Integer> nums = new ArrayList<Integer>();

        //算最大编号
        nums.add(0);
        for (PrdcJobLine line : rcdList) {
            if (line.getCode() != null && !line.getCode().equals("")) {
                String suffixCode = line.getCode().substring(line.getCode().indexOf(prdcJob.getCode()) + prdcJob.getCode().length());
                nums.add(Integer.valueOf(suffixCode));
            }
        }
        Collections.sort(nums);
        Integer maxNum = nums.get(0);

        for (int i = 0; i < rcdList.size(); i++) {
            PrdcJobLine rcd = rcdList.get(i);
            if (rcd.getId() == null) {
                rcd.setCode(PrdcJobLineUtil.getJobLineCode(prdcJob.getCode(), ++maxNum));
                createJobLine(prdcJob, rcd);
            }
//            else{
//                updateJobLine(prdcJob,rcd,maxNum);
//            }
        }

    }


    /**
     * 修改任务行
     *
     * @param prdcJob
     * @param rcdList
     */
    @Transactional
    private void changeJobLine(PrdcJob prdcJob, List<PrdcJobLine> rcdList) {
        List<Integer> nums = new ArrayList<Integer>();
        PrdcJobLineExample example = new PrdcJobLineExample();
        example.createCriteria().andJobIdEqualTo(prdcJob.getId());
        prdcJobLineMapper.deleteByExample(example);
        //算最大编号
        nums.add(0);
        for (PrdcJobLine line : rcdList) {
            if (line.getCode() != null && !line.getCode().equals("")) {
                String suffixCode = line.getCode().substring(line.getCode().indexOf(prdcJob.getCode()) + prdcJob.getCode().length());
                nums.add(Integer.valueOf(suffixCode));
            }
        }
        Collections.sort(nums);
        Integer maxNum = nums.get(0);
        for (int i = 0; i < rcdList.size(); i++) {
            PrdcJobLine rcd = rcdList.get(i);
            rcd.setCode(PrdcJobLineUtil.getJobLineCode(prdcJob.getCode(), ++maxNum));
            createJobLine(prdcJob, rcd);
        }

    }

    /**
     * 校验任务行
     *
     * @param rcd
     */
    private void validateJobLine(PrdcJob prdcJob, PrdcJobLine rcd) {
        PcsSkuVO skuVO = mcPcsSkuService.findByCode(rcd.getSkuCode());
        if (skuVO == null) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "耗材skuCode匹配不到sku");
        }
        if (rcd.getQuantity().compareTo(new Float(0)) <= 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "耗材sku数量不能小于等于0");
        }
        if (rcd.getSkuCode().equals(prdcJob.getSkuCode())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "耗材SKU包含成品SKU");
        }
    }

    /**
     * 创建任务行
     *
     * @param prdcJob
     * @param rcd
     */
    @Transactional
    private void createJobLine(PrdcJob prdcJob, PrdcJobLine rcd) {
        validateJobLine(prdcJob, rcd);
        rcd.setJobId(prdcJob.getId());
        if (prdcJobLineMapper.insert(rcd) == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "insert data failed!");
        }
    }

//    /**
//     * 更新任务行
//     * @param prdcJob
//     * @param rcd
//     */
//    @Transactional
//    private void updateJobLine(PrdcJob prdcJob,PrdcJobLine rcd,Integer maxNum){
//        validateJobLine(prdcJob,rcd);
//        rcd.setCode(PrdcJobLineUtil.getJobLineCode(prdcJob.getCode(),++maxNum));
//        createJobLine(prdcJob,rcd);
//    }

    @Override
    public List<WhCommandVO> buildPrdcCommands(PrdcJobVO jobVO) {
        if (CollectionUtils.isEmpty(jobVO.getPrdcJobLineVOList())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造释放库存失败,prdcJobLineVOList");
        }
        List<WhCommandVO> whCommandList = new ArrayList<>();
        WhCommandVO whCommandJob = new WhCommandVO();
        whCommandJob.setWarehouseCode(jobVO.getWarehouseCode());
        whCommandJob.setPhysicalWarehouseCode(jobVO.getPhysicalWarehouseCode());
        whCommandJob.setReferenceCode(jobVO.getCode());
        if (jobVO.getJobType() == PrdcJob.JOB_TYPE_ASSEMBLE) {
            whCommandJob.setInOutType(WhCommandVO.TYPE_PRODUCE_IN);
        } else if (jobVO.getJobType() == PrdcJob.JOB_TYPE_SPLIT) {
            whCommandJob.setInOutType(WhCommandVO.TYPE_PRODUCE_OUT);
        }
        List<WhCommandSkuVO> jobSkuList = new ArrayList<>();
        WhCommandSkuVO jobSku = new WhCommandSkuVO();
        jobSku.setSkuCode(jobVO.getSkuCode());
        jobSku.setPlanedQuantity(jobVO.getEstQuantity());
        jobSku.setQuantity(jobVO.getFinishedQuantity());
        jobSku.setDamagedQuantity(jobVO.getFinishedDamagedQuantity());
        jobSkuList.add(jobSku);
        whCommandJob.setWhCommandSkuList(jobSkuList);
        whCommandJob.setOperatorId(jobVO.getConfirmOperatorId());
        whCommandList.add(whCommandJob);
        for (PrdcJobLineVO jobLineVO : jobVO.getPrdcJobLineVOList()) {
            WhCommandVO whCommandJobLine = new WhCommandVO();
            List<WhCommandSkuVO> jobLineSkuList = new ArrayList<>();
            whCommandJobLine.setWarehouseCode(jobVO.getWarehouseCode());
            whCommandJobLine.setPhysicalWarehouseCode(jobVO.getPhysicalWarehouseCode());
            whCommandJobLine.setReferenceCode(jobLineVO.getCode());
            //组装
            if (jobVO.getJobType() == PrdcJob.JOB_TYPE_ASSEMBLE) {
                whCommandJobLine.setInOutType(WhCommandVO.TYPE_PRODUCE_OUT);
            }
            //拆分,辅耗材置损耗
            else if (jobVO.getJobType() == PrdcJob.JOB_TYPE_SPLIT) {
                if (jobLineVO.getMaterialType() == PrdcJobLineVO.MATERIAL_TYPE_AUXILIARY) continue;
                whCommandJobLine.setInOutType(WhCommandVO.TYPE_PRODUCE_IN);
            }
            //数量小于等于0,报错
            if (jobLineVO.getQuantity().compareTo(new Float(0)) <= 0) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造仓库指令失败,数量必须大于0");
            }
            WhCommandSkuVO jobLineSku = new WhCommandSkuVO();
            jobLineSku.setSkuCode(jobLineVO.getSkuCode());
            if (jobLineVO.getQuantity() != null) {
                jobLineSku.setPlanedQuantity(jobLineVO.getQuantity().intValue());
            } else {
                jobLineSku.setPlanedQuantity(0);
            }
            if (jobLineVO.getRealQuantity() != null) {
                jobLineSku.setQuantity(jobLineVO.getRealQuantity().intValue());
            } else {
                jobLineSku.setQuantity(0);
            }
            if (jobLineVO.getDamageQuantity() != null) {
                jobLineSku.setDamagedQuantity(jobLineVO.getDamageQuantity().intValue());
            } else {
                jobLineSku.setDamagedQuantity(0);
            }
            jobLineSkuList.add(jobLineSku);
            whCommandJobLine.setWhCommandSkuList(jobLineSkuList);
            whCommandList.add(whCommandJobLine);
        }

        return whCommandList;
    }

    @Override
    public List<WhReleaseOccupationVO> buildWhRelease(PrdcJob prdcJob, List<PrdcJobLine> prdcJobLineList, Integer occupyType) {
        List<WhReleaseOccupationVO> releaseList = new ArrayList();
        if (CollectionUtils.isEmpty(prdcJobLineList)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造释放库存的LIST失败,opSoPackageSkuList不能为空");
        }

        PrdcJob prdcJob_0 = findJobVOById(prdcJob.getId());
        if (prdcJob_0.getJobType() == PrdcJob.JOB_TYPE_ASSEMBLE) {
            for (PrdcJobLine rdcJobLine : prdcJobLineList) {
                //数量小于等于0,报错
                if (rdcJobLine.getQuantity().compareTo(new Float(0)) <= 0) {
                    throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造释放库存的LIST失败,数量必须大于0");
                }
                WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
                whReleaseOccupationVO.setOccupyType(occupyType);
                whReleaseOccupationVO.setReferenceCode(rdcJobLine.getCode());
                releaseList.add(whReleaseOccupationVO);
            }
        } else if (prdcJob_0.getJobType() == PrdcJob.JOB_TYPE_SPLIT) {
            WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
            whReleaseOccupationVO.setOccupyType(occupyType);
            whReleaseOccupationVO.setReferenceCode(prdcJob_0.getCode());
            releaseList.add(whReleaseOccupationVO);
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "error,type abnormal!");
        }

        return releaseList;
    }

    @Override
    public List<WhInvOccupyVO> buildWhOccupy(PrdcJob prdcJob, List<PrdcJobLine> prdcJobLineList, String warehouseCode, Integer occupyType) {
        List<WhInvOccupyVO> occupyList = new ArrayList<>();

        if (CollectionUtils.isEmpty(prdcJobLineList)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "param list cannot be null");
        }
        if (prdcJob.getJobType() == PrdcJob.JOB_TYPE_ASSEMBLE) {
            for (PrdcJobLine prdcJobLine : prdcJobLineList) {
                //数量小于等于0,报错
                if (NumberUtil.isNullOrZero(prdcJobLine.getQuantity())) {
                    throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "the quantity cannot be 0 or null");
                }
                WhInvOccupyVO whInvOccupy = new WhInvOccupyVO();
                whInvOccupy.setWarehouseCode(warehouseCode);
                whInvOccupy.setOccupyType(occupyType);
                whInvOccupy.setReferenceCode(prdcJobLine.getCode());
                whInvOccupy.setSkuCode(prdcJobLine.getSkuCode());
                whInvOccupy.setQuantity(prdcJobLine.getQuantity().intValue());
                occupyList.add(whInvOccupy);
            }
        } else if (prdcJob.getJobType() == PrdcJob.JOB_TYPE_SPLIT) {
            //数量小于等于0,报错
            if (NumberUtil.isNullOrZero(prdcJob.getEstQuantity())) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "the quantity cannot be 0 or null!");
            }
            WhInvOccupyVO whInvOccupy = new WhInvOccupyVO();
            whInvOccupy.setWarehouseCode(warehouseCode);
            whInvOccupy.setOccupyType(occupyType);
            whInvOccupy.setReferenceCode(prdcJob.getCode());
            whInvOccupy.setSkuCode(prdcJob.getSkuCode());
            whInvOccupy.setQuantity(prdcJob.getEstQuantity());
            occupyList.add(whInvOccupy);
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "error,status abnormal!");
        }

        return occupyList;
    }


//    @Override
//    public List<WhInvOccupyVO> buildWhOccupy(List<PrdcJob> prdcJobList, String warehouseCode, Integer occupyType) {
//        List<WhInvOccupyVO> occupyList = new ArrayList<>();
//        if (CollectionUtils.isEmpty(prdcJobLineList)) {
//            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造占用库存的LIST失败,opSoPackageSkuList不能为空");
//        }
//        for (PrdcJobLine prdcJobLine : prdcJobLineList) {
//            //数量小于等于0,报错
//            if (prdcJobLine.getQuantity().compareTo(new Float(0)) <= 0) {
//                throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造占用库存的LIST失败,数量必须大于0");
//            }
//            WhInvOccupyVO whInvOccupy = new WhInvOccupyVO();
//            whInvOccupy.setWarehouseCode(warehouseCode);
//            whInvOccupy.setOccupyType(occupyType);
//            whInvOccupy.setReferenceCode(prdcJobLine.getCode());
//            whInvOccupy.setSkuCode(prdcJobLine.getSkuCode());
//            whInvOccupy.setQuantity(prdcJobLine.getQuantity().intValue());
//            occupyList.add(whInvOccupy);
//        }
//        return occupyList;
//    }

    @Override
    public List<Map<String, String>> getWarehouseList(List<String> warehouseCodeList) {
        List<Map<String, String>> warehouseNameList = new ArrayList<>();
        for (String warehouseCode : warehouseCodeList) {
            Map<String, String> option;
            option = new HashMap();
            option.put("code", warehouseCode);
            option.put("name", getWarehouseName(warehouseCode));
            warehouseNameList.add(option);
        }
        return warehouseNameList;
    }

    @Override
    public String getWarehouseName(String warehouseCode) {
        String name = "";
        if (NullUtil.isNotNull(warehouseCode)) {
            WhWarehouseVO wh = sWhInfoService.findWarehouseByCode(warehouseCode);
            if (NullUtil.isNotNull(wh) && EmptyUtil.isNotEmpty(wh.getName())) {
                name = wh.getName();
            }
        }
        return name;
    }

    @Override
    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo) {
        return sWhWmsPrdcJobTaskService.getPrdcJobMaxTask(vo);
    }

    @Override
    public boolean updatePrdcJobWhenTaskFinish(WhWmsPrdcJobTaskVO vo) {
        List<String> prdcJobCodes = new ArrayList<String>();
        if (vo != null) {
            prdcJobCodes.add(vo.getPrdcJobCode());
        }
        List<PrdcJob> prdcJobs = prdcJobMapper.getPrdcJobProcessingOrPartFinished(prdcJobCodes);
        if (prdcJobs != null && !prdcJobs.isEmpty()) {
            prdcJobCodes.clear();
            for (PrdcJob job : prdcJobs) {
                prdcJobCodes.add(job.getCode());
            }
            List<Map<String, Object>> wmsPrdcJobTaskInfos = sWhWmsPrdcJobTaskService.getWmsPrdcJobTaskFinishedInfo(prdcJobCodes);
            List<Map<String, Object>> wmsPrdcJobTaskProcesInfos = sWhWmsPrdcJobTaskService.getWmsPrdcJobTaskProcessingInfo(prdcJobCodes);
            List<Map<String, Object>> wmsPrdcJobTaskFinishedRealAmount = sWhWmsPrdcJobTaskService.getWmsPrdcJobTaskFinishedRealAmount(prdcJobCodes);
            if (wmsPrdcJobTaskInfos != null && !wmsPrdcJobTaskInfos.isEmpty()) {
                for (PrdcJob job : prdcJobs) {
                    Map<String, Object> info = getTaskInfoByPrdcJobCode(wmsPrdcJobTaskInfos, job.getCode());
                    Map<String, Object> processingInfo = getTaskInfoByPrdcJobCode(wmsPrdcJobTaskProcesInfos, job.getCode());
                    List<Map<String, Object>> jobLineRealAmounts = getJobInfoByPrdcJobCode(wmsPrdcJobTaskFinishedRealAmount, job.getCode());
                    {

                        if (info != null && processingInfo == null) {//所有子任务都已完成
                            PrdcJob update = new PrdcJob();
                            update.setId(job.getId());
                            if (PrdcJob.JOB_TYPE_ASSEMBLE.equals(job.getJobType())) {//组装
                                Integer finishedGoodsAmount = object2Int(info.get("finishedGoodsAmount"));
                                Integer finishedDefectiveAmount = object2Int(info.get("finishedDefectiveAmount"));
                                Integer amount = object2Int(info.get("amount"));
                                if (job.getEstQuantity().compareTo(amount) == 0) {//所有产品都已组装
                                    update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_FINISHED);
                                    update.setFinishTime(DateUtil.getNow());
                                } else if (job.getEstQuantity().compareTo(amount) > 0 && amount > 0) {//部分产品组装
                                    update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_PARTFINISHED);
                                } else {
                                    update.setPlanStatus(PrdcJob.WMS_STATUS_RETURN_MODIFY);
                                }
                                update.setFinishedQuantity(finishedGoodsAmount);
                                update.setFinishedDamagedQuantity(finishedDefectiveAmount);
                                update.setProcessingAmount(0);

                            } else {//拆分
                                //Integer finishedGoodsAmount = object2Int(info.get("finishedGoodsAmount"));
                                Integer amount = object2Int(info.get("amount"));
                                if (job.getEstQuantity().compareTo(amount) == 0) {//所有产品都已拆分
                                    update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_FINISHED);
                                    update.setFinishTime(DateUtil.getNow());
                                } else if (job.getEstQuantity().compareTo(amount) > 0 && amount > 0) {//部分产品拆分
                                    update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_PARTFINISHED);
                                } else {
                                    update.setPlanStatus(PrdcJob.WMS_STATUS_RETURN_MODIFY);
                                }
                                update.setFinishedQuantity(amount);
                                update.setProcessingAmount(0);
                            }
                            updatePrdcJobCheckCancle(update);
                            // 更新prdcJobLine realQuantity
                            for (Map<String, Object> realInfo : jobLineRealAmounts) {
                                PrdcJobLine prdcJobLine = makePrdcJobLine(realInfo, update);
                                if (prdcJobLine != null) {
                                    prdcJobLineMapper.updateByExampleSelective(prdcJobLine, makePrdcJobLineExample(prdcJobLine));
                                }
                            }
                        } else if (info != null && processingInfo != null) {//存在未完成的任务
                            PrdcJob update = new PrdcJob();
                            update.setId(job.getId());
                            update.setPlanStatus(PrdcJob.WMS_PLAN_STATUS_PROCESSING);
                            if (PrdcJob.JOB_TYPE_ASSEMBLE.equals(job.getJobType())) {//组装
                                Integer finishedGoodsAmount = object2Int(info.get("finishedGoodsAmount"));
                                Integer finishedDefectiveAmount = object2Int(info.get("finishedDefectiveAmount"));
                                update.setFinishedQuantity(finishedGoodsAmount);
                                update.setFinishedDamagedQuantity(finishedDefectiveAmount);
                            } else {//拆分
                                Integer finishedGoodsAmount = object2Int(info.get("finishedGoodsAmount"));
                                update.setFinishedQuantity(finishedGoodsAmount);
                            }
                            Integer processingAmount = object2Int(processingInfo.get("amount"));
                            update.setProcessingAmount(processingAmount);
                            updatePrdcJobCheckCancle(update);
                        } else {
                            //throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "error,status abnormal!");
                        }


                    }

                }
            }
        }


        return true;
    }

    /**
     * 更新未取消加工单信息,若已取消则不更新状态,其它字段更新
     */
    private void updatePrdcJobCheckCancle(PrdcJob update) {
        PrdcJobExample example = new PrdcJobExample();
        example.createCriteria().andIdEqualTo(update.getId()).andPlanStatusNotEqualTo(PrdcJob.PLAN_STATUS_CANCEL);
        int size = prdcJobMapper.updateByExampleSelective(update, example);
        if (size == 0) {
            update.setPlanStatus(null);
            prdcJobMapper.updateByPrimaryKeySelective(update);
        }
    }

    private PrdcJobLineExample makePrdcJobLineExample(PrdcJobLine prdcJobLine) {
        if (prdcJobLine == null) {
            return null;
        }
        PrdcJobLineExample exam = new PrdcJobLineExample();
        Criteria crit = exam.createCriteria();
        crit.andSkuCodeEqualTo(prdcJobLine.getSkuCode());
        crit.andJobIdEqualTo(prdcJobLine.getJobId());
        return exam;
    }


    private PrdcJobLine makePrdcJobLine(Map<String, Object> jobLineRealAmount, PrdcJob update) {
        if (jobLineRealAmount == null) {
            return null;
        }
        PrdcJobLine prdcJobLine = new PrdcJobLine();
        prdcJobLine.setJobId(update.getId());
        prdcJobLine.setSkuCode(String.valueOf(jobLineRealAmount.get("skuCode")));
        prdcJobLine.setRealQuantity(Float.valueOf(String.valueOf(jobLineRealAmount.get("realAmount"))));
        prdcJobLine.setDamageQuantity(Integer.valueOf(String.valueOf(jobLineRealAmount.get("realDefectiveAmount"))));
        return prdcJobLine;
    }


    private Integer object2Int(Object obj) {
        if (obj instanceof Integer) {
            return (Integer) obj;
        }
        return Integer.parseInt(obj.toString());
    }

    private Map<String, Object> getTaskInfoByPrdcJobCode(List<Map<String, Object>> infos, String prdcJobCode) {
        if (infos != null && !infos.isEmpty()) {
            for (Map<String, Object> info : infos) {
                Object code = info.get("prdcJobCode");
                if (prdcJobCode.equals(code)) {
                    return info;
                }
            }
        }
        return null;
    }

    private List<Map<String, Object>> getJobInfoByPrdcJobCode(List<Map<String, Object>> jobFinishedRealAmount, String prdcJobCode) {
        List<Map<String, Object>> map = new ArrayList<Map<String, Object>>();
        if (jobFinishedRealAmount != null && !jobFinishedRealAmount.isEmpty()) {
            for (Map<String, Object> info : jobFinishedRealAmount) {
                Object code = info.get("prdcJobCode");
                if (prdcJobCode.equals(code)) {
                    map.add(info);
                }
            }
            return map;
        }
        return null;
    }


    @Override
    public List<Map<String, Object>> getWmsPrdcJobTaskFinishedInfo(
            List<String> prdcJobCodes) {
        return sWhWmsPrdcJobTaskService.getWmsPrdcJobTaskFinishedInfo(prdcJobCodes);
    }


    @Override
    public List<PrdcJob> getPrdcJobProcessingOrPartFinished(List<String> codes) {
        return prdcJobMapper.getPrdcJobProcessingOrPartFinished(codes);
    }

    @Override
    public List<WhReleaseOccupationVO> buildWhRelease(List<PrdcJobLineVO> prdcJobLineVOList, Integer occupyType) {
        List<WhReleaseOccupationVO> releaseList = new ArrayList();
        if (CollectionUtils.isEmpty(prdcJobLineVOList)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造释放库存的LIST失败,opSoPackageSkuList不能为空");
        }
        for (PrdcJobLineVO rdcJobLineVO : prdcJobLineVOList) {
            //数量小于等于0,报错
            if (rdcJobLineVO.getQuantity().compareTo((float) 0) <= 0) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造释放库存的LIST失败,数量必须大于0");
            }
            WhReleaseOccupationVO whReleaseOccupationVO = new WhReleaseOccupationVO();
            whReleaseOccupationVO.setOccupyType(occupyType);
            whReleaseOccupationVO.setReferenceCode(rdcJobLineVO.getCode());
            releaseList.add(whReleaseOccupationVO);
        }
        return releaseList;
    }

    @Override
    public List<WhInvOccupyVO> buildWhOccupy(List<PrdcJobLineVO> prdcJobLineVOList, String warehouseCode, Integer occupyType) {
        List<WhInvOccupyVO> occupyList = new ArrayList<>();
        if (CollectionUtils.isEmpty(prdcJobLineVOList)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造占用库存的LIST失败,opSoPackageSkuList不能为空");
        }
        for (PrdcJobLineVO prdcJobLineVO : prdcJobLineVOList) {
            //数量小于等于0,报错
            if (prdcJobLineVO.getQuantity().compareTo((float) 0) <= 0) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造占用库存的LIST失败,数量必须大于0");
            }
            WhInvOccupyVO whInvOccupy = new WhInvOccupyVO();
            whInvOccupy.setWarehouseCode(warehouseCode);
            whInvOccupy.setOccupyType(occupyType);
            whInvOccupy.setReferenceCode(prdcJobLineVO.getCode());
            whInvOccupy.setSkuCode(prdcJobLineVO.getSkuCode());
            whInvOccupy.setQuantity(((Double) Math.ceil(prdcJobLineVO.getQuantity())).intValue());
            occupyList.add(whInvOccupy);
        }
        return occupyList;
    }

    @Override
    @Transactional
    public Boolean checkOccupyAndUpdate(PrdcJobVO jobVO, List<WhInvOccupyVO> whInvOccupyList) {
        if (jobVO == null)
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        PrdcJob prdcJob = BeanUtil.buildFrom(jobVO, PrdcJob.class);
        int update = prdcJobMapper.updateByPrimaryKey(prdcJob);
        if (update <= 0)
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "数据库更新失败");
        ServiceResp<List<SOccupyResultVO>> serviceResp = sStockService.occupy(convertWhInvOccupy2DTO(whInvOccupyList));
        if (serviceResp.isFailure()) {
            throw new PurchaseException(serviceResp.getRespCode(), serviceResp.getRespMsg());
        }
        return true;
    }


    @Override
    public List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond) {
        return this.prdcJobMapper.findExportJobVOByCond(cond);
    }


    @Override
    public List<PrdcJob> findSkuReportJobVO() {
        return prdcJobMapper.findSkuReportJobVO();
    }

    private List<SStockOccupyDTO> convertWhInvOccupy2DTO(List<WhInvOccupyVO> whInvOccupyList) {
        List<SStockOccupyDTO> dtoList = new ArrayList<SStockOccupyDTO>();
        if (EmptyUtil.isNotEmpty(whInvOccupyList)) {
            for (WhInvOccupyVO whInvOccupy : whInvOccupyList) {
                dtoList.add(convertWhInvOccupy2DTO(whInvOccupy));
            }
        }
        return dtoList;
    }

    private SStockOccupyDTO convertWhInvOccupy2DTO(WhInvOccupyVO whInvOccupy) {
        SStockOccupyDTO sStockOccupyDTO = new SStockOccupyDTO();
        BeanUtils.copyProperties(whInvOccupy, sStockOccupyDTO);
        sStockOccupyDTO.setOccupyTime(new Date());
        sStockOccupyDTO.setOccupyType(SStockOccupyTypeEnum.getEnumByCode(whInvOccupy.getOccupyType()));
        return sStockOccupyDTO;
    }


    @Override
    public boolean isSplitBySkuCode(String skuCode) {
        return prdcJobMapper.isSplitBySkuCode(skuCode) > 0;
    }
}
