package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCustomsInfoVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuCustomBckCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuCustomBckMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCustomBck;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCustomBckService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCustomBckVO;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.thebeastshop.common.Pagination;

/**
 * @version V1.0
 * @Description:${todo}(用一句话描述该文件做什么)
 * @author: ljj
 * @date: 2018/10/22 17:11
 */
@Service("pcsSkuCustomBckService")
public class PcsSkuCustomBckServiceImpl implements PcsSkuCustomBckService {

    @Autowired
    private PcsSkuCustomBckMapper pcsSkuCustomBckMapper;

    @Autowired
    private McPcsSkuService mcPcsSkuService;

    @Override
    public Pagination<PcsSkuCustomBckVO> findByCond(PcsSkuCustomBckCond cond) {
        Pagination<PcsSkuCustomBckVO> page = new Pagination<>(cond.getCurrpage(), cond.getPagenum());
        Integer count = pcsSkuCustomBckMapper.countByCond(cond);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero(count)) return null;
        page.setResultList(pcsSkuCustomBckMapper.findByCond(cond));
        return page;
    }

    @Override
    public Integer countByCond(PcsSkuCustomBckCond cond) {
        return pcsSkuCustomBckMapper.countByCond(cond);
    }

    @Override
    public Integer approveOrRefuseSkuCustomBck(Integer id, Integer status, String customBckCode,String remark) {
        Integer res = 0;
        PcsSkuCustomBck pcsSkuCustomBck = new PcsSkuCustomBck();
        pcsSkuCustomBck.setId(id);
        pcsSkuCustomBck.setStatus(status);
        boolean flag = false;   //是否更新郭师傅表中字段
        if (status == 1) {
            //通过
            pcsSkuCustomBck.setCustomsNumber(customBckCode);
            pcsSkuCustomBck.setRemark(remark);
            flag =true;
        } else {
            pcsSkuCustomBck.setRemark(remark);
        }
        res = pcsSkuCustomBckMapper.updateByPrimaryKeySelective(pcsSkuCustomBck);
        if (flag) {
            PcsSkuCustomBck customBck = pcsSkuCustomBckMapper.selectByPrimaryKey(id);
            PcsSkuCustomsInfoVO pcsSkuCustomsInfo = new PcsSkuCustomsInfoVO();
            pcsSkuCustomsInfo.setSkuCode(customBck.getSkuCode());
            pcsSkuCustomsInfo.setCustomsRecordNumber(customBckCode);
            mcPcsSkuService.updateSkuCustomInfo(pcsSkuCustomsInfo);
        }
        return res;
    }

    @Override
    public Integer insertWhenNotExist(PcsSkuCustomBck pcsSkuCustomBck) {
        PcsSkuCustomBckCond cond = new PcsSkuCustomBckCond();
        cond.setSkuCode(pcsSkuCustomBck.getSkuCode());
        if (CollectionUtils.isEmpty(pcsSkuCustomBckMapper.findByCond(cond))) {
            return pcsSkuCustomBckMapper.insert(pcsSkuCustomBck);
        }
        return 0;
    }
}
