package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.pegasus.integration.PegasusIntegrationFacade;
import com.thebeastshop.pegasus.service.purchase.cond.SkuCerCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuCertificateFieldMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuCertificateMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuCertificateMpCodeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuCertificateSpecialMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.*;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTplService;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuCertificateService;
import com.thebeastshop.pegasus.service.purchase.vo.*;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;

/**
 * Created by Administrator on 2016/11/22.
 */
@Service("pcsSkuCertificateService")
public class PcsSkuCertificateServiceImpl implements PcsSkuCertificateService{

    @Autowired
    private PcsSkuCertificateMapper pcsSkuCertificateMapper;

    @Autowired
    private PcsSkuCertificateFieldMapper pcsSkuCertificateFieldMapper;

    @Autowired
    private PcsSkuCertificateSpecialMapper pcsSkuCertificateSpecialMapper;

    @Autowired
    private PcsCertificateTplService pcsCertificateTplService;

    @Autowired
    private PcsSkuCertificateMpCodeMapper pcsSkuCertificateMpCodeMapper;

    @Override
    public List<PcsSkuCertificateVO> findSkuCerByCond(SkuCerCond cond) {
        return pcsSkuCertificateMapper.findSkuCerByCond(cond);
    }

    @Override
    public List<PcsSkuCertificateVO> findRecipeCerVOByCond(SkuCerCond cond) {
        return pcsSkuCertificateMapper.findRecipeCerVOByCond(cond);
    }

    @Override
    public List<PcsSkuCerInfoExcelVO> findSkuCerExportInfoByCond(SkuCerCond cond) {
        return pcsSkuCertificateMapper.findSkuCerExportInfoByCond(cond);
    }

    @Override
    public PcsSkuCertificateVO findBySkuCode(String skuCode) {
        return findBySkuCode(skuCode,true);
    }

    @Override
    public PcsSkuCertificateVO findBySkuCode(String skuCode, boolean cascade) {
        PcsSkuCertificateVO cerVO = pcsSkuCertificateMapper.findBySkuCode(skuCode);
        if(NullUtil.isNull(cerVO) || !cascade){
            return cerVO;
        }
        List<PcsSkuCertificateFieldVO> fieldlist = pcsSkuCertificateFieldMapper.findByCerId(cerVO.getId());
        cerVO.setFieldList(fieldlist);
        if(EmptyUtil.isNotEmpty(fieldlist)){
            PcsCertificateTplVO tplVO = pcsCertificateTplService.findById(cerVO.getCerTplId(),true);
            pcsCertificateTplService.fullCerTplDefaultValue(tplVO,skuCode);
            for(PcsSkuCertificateFieldVO field : fieldlist){
                for(PcsCertificateTplFieldVO tplField : tplVO.getTplFieldVOList()){
                    if(field.getCerTplFieldId().equals(tplField.getId())){
                        field.setTplFieldVO(tplField);
                        if(PcsCertificateTplFieldVO.WRITE_TYPE_SKUINFO.equals(tplField.getWriteType())&&EmptyUtil.isEmpty(field.getValue())){
                            field.setValue(tplField.getDefaultValue());
                        }
                        break;
                    }
                    if (EmptyUtil.isNotEmpty(cerVO.getCertificateSize())
                            && CollectionUtils.isNotEmpty(tplField.getFieldTypesetList())){
                        for (PcsCertificateTplFieldTypesetVO tplFieldTypesetVO : tplField.getFieldTypesetList()){
                            if (cerVO.getCertificateSize().equals(tplFieldTypesetVO.getCerSize())){
                                tplField.setCurrFieldTypeset(tplFieldTypesetVO);
                                break;
                            }
                        }
                    }
                    if (EmptyUtil.isEmpty(tplField.getCurrFieldTypeset())){
                        if (CollectionUtils.isNotEmpty(tplField.getFieldTypesetList())){
                            tplField.setCurrFieldTypeset(tplField.getFieldTypesetList().get(0));
                        }
                    }
                }
            }
        }
        cerVO.setSpecialList(findSpecialByCerId(cerVO.getId()));
        return cerVO;
    }

    @Override
    public List<PcsSkuCertificateVO> findBySkuCodes(List<String> skuCodeList,boolean cascade) {
        if (CollectionUtils.isEmpty(skuCodeList)){
            return Collections.emptyList();
        }
        List<PcsSkuCertificateVO> cerList = pcsSkuCertificateMapper.findBySkuCodes(skuCodeList);
        if(EmptyUtil.isEmpty(cerList) || !cascade){
            return cerList;
        }
        List<Long> cerIds = new ArrayList<>();
        List<Long> cerTplIds = new ArrayList<>();
        for(PcsSkuCertificateVO cerVO : cerList){
            cerIds.add(cerVO.getId());
            cerTplIds.add(cerVO.getCerTplId());
        }
        List<PcsSkuCertificateFieldVO> cerFieldList = pcsSkuCertificateFieldMapper.findByCerIds(cerIds);
        List<PcsCertificateTplVO> tplList = pcsCertificateTplService.findByIds(cerTplIds,true);
        Map<Long,PcsCertificateTplFieldVO> tplFieldMap = new HashMap<>();
        if(EmptyUtil.isNotEmpty(tplList)){
            for(PcsCertificateTplVO tplVO : tplList){
                if(EmptyUtil.isNotEmpty(tplVO.getTplFieldVOList())){
                    for(PcsCertificateTplFieldVO tplFieldVO :  tplVO.getTplFieldVOList()){
                        tplFieldMap.put(tplFieldVO.getId(),tplFieldVO);
                    }
                }
            }
        }
        List<PcsSkuCertificateSpecial> specialList = findSpecialByCerIds(cerIds);
        Map<Long,List<PcsSkuCertificateSpecial>> cerSpecialListMap = new HashMap<>();
        if(EmptyUtil.isNotEmpty(specialList)){
            for(PcsSkuCertificateSpecial special : specialList){
                List<PcsSkuCertificateSpecial> tmpList = cerSpecialListMap.get(special.getCerId());
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    cerSpecialListMap.put(special.getCerId(),tmpList);
                }
                tmpList.add(special);
            }
        }
        if(EmptyUtil.isNotEmpty(cerFieldList)){
            Map<Long,List<PcsSkuCertificateFieldVO>> cerFieldMap = new HashMap<>();
            for(PcsSkuCertificateFieldVO cerField : cerFieldList){
                Long key = cerField.getCerId();
                List<PcsSkuCertificateFieldVO> tmpList = cerFieldMap.get(key);
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    cerFieldMap.put(key,tmpList);
                }
                cerField.setTplFieldVO(tplFieldMap.get(cerField.getCerTplFieldId()));
                tmpList.add(cerField);
            }
            for(PcsSkuCertificateVO cerVO : cerList){
                cerVO.setFieldList(cerFieldMap.get(cerVO.getId()));
                cerVO.setSpecialList(cerSpecialListMap.get(cerVO.getId()));
            }
        }
        return cerList;
    }

    @Override
    public List<PrintSkuCerVO> getPrintCerBySkuCodeBarCode(PrintCerVO cond) {
        if(EmptyUtil.isEmpty(cond) || EmptyUtil.isEmpty(cond.getSkuInfos())){
            return new ArrayList<>();
        }
        List<PrintSkuCerVO> skuCerList = cond.getSkuInfos();
        List<String> skuCodes = new ArrayList<>();
        for(PrintSkuCerVO sb : skuCerList){
            skuCodes.add(sb.getSkuCode());
        }
        Map<String,String> cerMpCodeMap = findSkuCerMpCodeMap(skuCodes);
        List<PcsSkuCertificateVO> cerList = findBySkuCodes(skuCodes,true);
        if(EmptyUtil.isEmpty(cerList)){
            return new ArrayList<>();
        }
        List<PrintSkuCerVO> printList = new ArrayList<>();
        for(PrintSkuCerVO printSkuCer : skuCerList){
            for(PcsSkuCertificateVO cerVO : cerList){
                if(cerVO.getSkuCode().equals(printSkuCer.getSkuCode())){
                    cerVO.setBarCode(printSkuCer.getBarCode());
                    printSkuCer.setSubmited(isCerSubmited(cerVO));
                    printSkuCer.setSimple(isSimpleCer(cerVO));
                    printSkuCer.setCerSize(cerVO.getCertificateSize());
                    printSkuCer.setImgUrl(cerVO.getImgUrl());
                    printSkuCer.setFieldList(buildPrintSkuCerFields(cerVO,printSkuCer));
                    printSkuCer.setSpecialList(buildPrintCerSpecials(cerVO));
                    printSkuCer.setPrintMpCode(PcsSkuCertificateVO.PRINT_MP_CODE_YES.equals(cerVO.getPrintMpCode()));
                    printSkuCer.setMpCodeUrl(cerMpCodeMap.get(cerVO.getSkuCode()));
                    printList.add(printSkuCer);
                    break;
                }
            }
        }
        return printList;
    }

    private boolean isCerSubmited(PcsSkuCertificateVO cerVO){
        return PcsSkuCertificateVO.SUBMIT_STATUS_SUBMITTED.equals(cerVO.getIsSubmit());
    }

    private boolean isSimpleCer(PcsSkuCertificateVO cerVO){
        return PcsSkuCertificateVO.CER_TYPE_SIMPLE.equals(cerVO.getCerType());
    }

    @Override
    public List<String> findSkuCodeNeedAutoSubmit() {
        return pcsSkuCertificateMapper.findSkuCodeNeedAutoSubmit();
    }

    private List<PrintCerSpecialVO> buildPrintCerSpecials(PcsSkuCertificateVO cerVO){
        if(EmptyUtil.isEmpty(cerVO.getSpecialList())){
            return new ArrayList<>();
        }
        List<PrintCerSpecialVO> printSpecialList = new ArrayList<>();
        for(PcsSkuCertificateSpecial special: cerVO.getSpecialList()){
            PrintCerSpecialVO printSpecial = new PrintCerSpecialVO();
            printSpecial.setSpecialCode(special.getSpecialCode());
            printSpecial.setSpecialType(special.getSpecialType());
            printSpecial.setSpecialValue(special.getSpecialValue());
            printSpecialList.add(printSpecial);
        }
        return printSpecialList;
    }

    private List<PrintSkuCerFieldVO> buildPrintSkuCerFields(PcsSkuCertificateVO cerVO,PrintSkuCerVO printSkuCer){
        if(EmptyUtil.isEmpty(cerVO.getFieldList())){
            return new ArrayList<>();
        }
        List<PrintSkuCerFieldVO> fieldList = new ArrayList<>();
        PrintSkuCerFieldVO printField = null;
        PcsCertificateTplFieldVO tplField = null;
        for(PcsSkuCertificateFieldVO fieldVO : cerVO.getFieldList()){
            printField = new PrintSkuCerFieldVO();
            tplField = fieldVO.getTplFieldVO();
            if (EmptyUtil.isEmpty(tplField)){
                continue;
            }
            printField.setName(tplField.getName());
            printField.setFontSize(tplField.getFontSize());
            printField.setNeedPrintName(PcsCertificateTplFieldVO.PRINT_YES.equals(tplField.getIsPrint()));
            printField.setSortOrder(fieldVO.getSortOrder());
            printField.setPosition(tplField.getPosition());
            if(PcsCertificateTplFieldVO.WRITE_TYPE_INPUT.equals(tplField.getWriteType())){
                printField.setValue(fieldVO.getValue());
            }else{
                if(EmptyUtil.isEmpty(cerVO.getBarCode()) && PcsCertificateTplFieldVO.WRITE_TYPE_SYSTEM.equals(tplField.getWriteType())){
                    printField.setValue("系统获取");
                }else{
                    if (PcsCertificateTplFieldVO.WRITE_TYPE_SYSTEM.equals(tplField.getWriteType())
                            && PcsCertificateTplFieldVO.FILED_TYPE_PROD_DATE.equals(tplField.getName())){
                        if (EmptyUtil.isNotEmpty(printSkuCer.getProdDate())){
                            printField.setValue(printSkuCer.getProdDate());
                        }else{
                            // 是生产日期字段 并且 填写方式是“系统获取” 且合格证标志不需要"生产日期" 则在打印时不显示生产日期
                            if (!PcsSkuCertificateVO.NEED_PROD_DATE_YES.equals(cerVO.getNeedProdDate()) || EmptyUtil.isEmpty(printSkuCer.getProdDate())){
                                continue;
                            }
                        }
                    }else{
                        if(PcsCertificateTplFieldVO.WRITE_TYPE_SKUINFO.equals(tplField.getWriteType()) && EmptyUtil.isNotEmpty(fieldVO.getValue())){
                            printField.setValue(fieldVO.getValue());
                        }else{
                            String value = pcsCertificateTplService.getFieldDicValue(tplField.getFieldDicId(),cerVO.getSkuCode(),cerVO.getBarCode());
                            printField.setValue(value);
                        }
                    }
                }
            }
            List<PcsCertificateTplFieldTypesetVO> typesetList = tplField.getFieldTypesetList();
            if (CollectionUtils.isNotEmpty(typesetList)){
                for(PcsCertificateTplFieldTypesetVO typeset : typesetList){
                    if(typeset.getCerSize().equals(cerVO.getCertificateSize())){
                        printField.setTypeset(typeset.getShowType().toString());
                        fieldList.add(printField);
                        break;
                    }
                }
            }
        }
        return fieldList;
    }

    @Override
    @Transactional
    public void save(PcsSkuCertificateVO cerVO) {
        if(NullUtil.isNull(cerVO.getPrintMpCode())){
            cerVO.setPrintMpCode(PcsSkuCertificateVO.PRINT_MP_CODE_NO);
        }
        pcsSkuCertificateMapper.insert(cerVO);
        if(EmptyUtil.isNotEmpty(cerVO.getFieldList())){
            for(PcsSkuCertificateFieldVO fieldVO : cerVO.getFieldList()){
                fieldVO.setCerId(cerVO.getId());
                pcsSkuCertificateFieldMapper.insert(fieldVO);
            }
        }
        if(EmptyUtil.isNotEmpty(cerVO.getSpecialList())){
            for(PcsSkuCertificateSpecial special : cerVO.getSpecialList()){
                special.setCerId(cerVO.getId());
                pcsSkuCertificateSpecialMapper.insert(special);
            }
        }
    }

    @Override
    @Transactional
    public void update(PcsSkuCertificateVO cerVO) {
        deleteCerFieldByCerId(cerVO.getId());
        deleteCerSpecialByCerId(cerVO.getId());
        pcsSkuCertificateMapper.updateByPrimaryKey(cerVO);
        if(EmptyUtil.isNotEmpty(cerVO.getFieldList())){
            for(PcsSkuCertificateFieldVO fieldVO : cerVO.getFieldList()){
                fieldVO.setCerId(cerVO.getId());
                pcsSkuCertificateFieldMapper.insert(fieldVO);
            }
        }
        if(EmptyUtil.isNotEmpty(cerVO.getSpecialList())){
            for(PcsSkuCertificateSpecial special : cerVO.getSpecialList()){
                special.setCerId(cerVO.getId());
                pcsSkuCertificateSpecialMapper.insert(special);
            }
        }
    }

    @Override
    @Transactional
    public void saveOrUpdate(PcsSkuCertificateVO cerVO) {
        if(NullUtil.isNull(cerVO.getId())){
            save(cerVO);
        }else{
            update(cerVO);
        }
    }

    @Override
    @Transactional
    public boolean saveOrUpdateSkuCer(PcsSkuCertificateVO cerVO) {
        int reslut = 0;
        if(NullUtil.isNull(cerVO.getId())){
            if(NullUtil.isNotNull(cerVO.getPrintMpCode())){
                cerVO.setPrintMpCode(PcsSkuCertificateVO.PRINT_MP_CODE_NO);
            }
            reslut = pcsSkuCertificateMapper.insert(cerVO);
        }else{
            reslut = pcsSkuCertificateMapper.updateByPrimaryKeySelective(cerVO);
        }
        return reslut > 0;
    }

    @Override
    @Transactional
    public void saveOrUpdate(List<PcsSkuCertificateVO> cerList) {
        if(EmptyUtil.isNotEmpty(cerList)){
           for(PcsSkuCertificateVO cerVO : cerList){
               saveOrUpdate(cerVO);
           }
        }
    }

    @Override
    @Transactional
    public void saveOrUpdateStatus(PcsSkuCertificateVO cerVO) {
        if(NullUtil.isNull(cerVO.getId())){
            if(NullUtil.isNotNull(cerVO.getPrintMpCode())){
                cerVO.setPrintMpCode(PcsSkuCertificateVO.PRINT_MP_CODE_NO);
            }
            pcsSkuCertificateMapper.insert(cerVO);
        }else{
            pcsSkuCertificateMapper.updateByPrimaryKey(cerVO);
        }
    }

    //批量删除标签字段
    private int deleteCerFieldByCerId(Long cerId){
        PcsSkuCertificateFieldExample example = new PcsSkuCertificateFieldExample();
        example.createCriteria().andCerIdEqualTo(cerId);
        return pcsSkuCertificateFieldMapper.deleteByExample(example);
    }

    //批量标签特殊值
    private int deleteCerSpecialByCerId(Long cerId){
        PcsSkuCertificateSpecialExample example = new PcsSkuCertificateSpecialExample();
        example.createCriteria().andCerIdEqualTo(cerId);
        return pcsSkuCertificateSpecialMapper.deleteByExample(example);
    }

    //查询合格证特殊值
    private List<PcsSkuCertificateSpecial> findSpecialByCerId(Long cerId){
        PcsSkuCertificateSpecialExample example = new PcsSkuCertificateSpecialExample();
        example.createCriteria().andCerIdEqualTo(cerId);
        return pcsSkuCertificateSpecialMapper.selectByExample(example);
    }

    //查询合格证特殊值
    private List<PcsSkuCertificateSpecial> findSpecialByCerIds(List<Long> cerIds){
        PcsSkuCertificateSpecialExample example = new PcsSkuCertificateSpecialExample();
        example.createCriteria().andCerIdIn(cerIds);
        return pcsSkuCertificateSpecialMapper.selectByExample(example);
    }


    @Override
    @Transactional
    public boolean saveSkuCerMpCode(String skuCode, String mpCodeUrl) {
        PcsSkuCertificateMpCode record = new PcsSkuCertificateMpCode();
        record.setSkuCode(skuCode);
        record.setMpCodeUrl(mpCodeUrl);
        record.setCreateTime(DateUtil.getNow());
        pcsSkuCertificateMpCodeMapper.insert(record);
        return true;
    }

    @Override
    @Transactional
    public boolean batchSaveSkuCerMpCode(Map<String,String> skuCode_mpCodeUrl) {
    	if(EmptyUtil.isNotEmpty(skuCode_mpCodeUrl)){
    		List<PcsSkuCertificateMpCode> recordList = new ArrayList<>();
        	for (Map.Entry<String, String> entry : skuCode_mpCodeUrl.entrySet()) {
        		PcsSkuCertificateMpCode record = new PcsSkuCertificateMpCode();
                record.setSkuCode(entry.getKey());
                record.setMpCodeUrl(entry.getValue());
                record.setCreateTime(DateUtil.getNow());
                recordList.add(record);
        	}

            pcsSkuCertificateMpCodeMapper.batchInsert(recordList);
    	}

        return true;
    }

    @Override
    public String findSkuCerMpCode(String skuCode) {
        PcsSkuCertificateMpCodeExample example = new PcsSkuCertificateMpCodeExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        List<PcsSkuCertificateMpCode> list = pcsSkuCertificateMpCodeMapper.selectByExample(example);
        if(EmptyUtil.isEmpty(list)){
            return null;
        }
        //取最后一条记录
        return list.get(list.size()-1).getMpCodeUrl();
    }

    @Override
    public List<String> findSkuCerWithSalesPriceField(List<String> skuCodes) {
        if(EmptyUtil.isEmpty(skuCodes)){
            return new ArrayList<>();
        }
        return pcsSkuCertificateMapper.findSkuCerWithSalesPriceField(skuCodes);
    }

    @Override
    public List<String> findSkuSalesPriceChangePreDay() {
        return pcsSkuCertificateMapper.findSkuSalesPriceChangePreDay();
    }

    @Override
    public Map<String, String> findSkuCerMpCodeMap(List<String> skuCodes) {
        Map<String,String> map = new HashMap<>();
        PcsSkuCertificateMpCodeExample example = new PcsSkuCertificateMpCodeExample();
        example.createCriteria().andSkuCodeIn(skuCodes);
        List<PcsSkuCertificateMpCode> list = pcsSkuCertificateMpCodeMapper.selectByExample(example);
        if(EmptyUtil.isNotEmpty(list)){
            for(PcsSkuCertificateMpCode mpCode : list){
                map.put(mpCode.getSkuCode(),mpCode.getMpCodeUrl());
            }
        }
        return map;
    }

    @Override
    public String getOrCreateSkuCerMpCode(String skuCode){
        String mpCodeUrl = findSkuCerMpCode(skuCode);
        if(EmptyUtil.isEmpty(mpCodeUrl)){
            mpCodeUrl = createwxaqrcode(skuCode);
            if(EmptyUtil.isNotEmpty(mpCodeUrl)){
                saveSkuCerMpCode(skuCode,mpCodeUrl);
            }
        }
        return mpCodeUrl;
    }

    //请求微信二维码接口，并上传二维码文件到oss
    private String createwxaqrcode(String skuCode){
        String accessToken = getAppletToken();
        if(EmptyUtil.isEmpty(accessToken)){
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM
                    ,"获取Token失败,请稍后重试！");
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient HttpClient = httpClientBuilder.build();
        HttpPost httpPost = new HttpPost(
                "https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token="
                        +accessToken);
        try{
            String path = PropConstants.getProperties("SCM_CER_MP_CODE_PATH");
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("path",String.format(path,skuCode));
            jsonObj.put("width",3400);
            httpPost.setEntity(new StringEntity(jsonObj.toString(),"UTF-8"));
            HttpResponse httpResponse = HttpClient.execute(httpPost);
            //获取响应消息实体
            HttpEntity entity = httpResponse.getEntity();
            if(NullUtil.isNotNull(entity)){
                String contentType = entity.getContentType().getValue();
                if(contentType.contains("application/json")){//非图片
                    throw new PurchaseException(EntityUtils.toString(entity,"UTF-8"));
                }
                byte[] bytes = EntityUtils.toByteArray(entity);
                InputStream inputStream = new ByteArrayInputStream(bytes);
                //直接上传到Oss
                String key = PegasusIntegrationFacade.getInstance().getOssUtilBean().uploadFile(null,"mp_code_"+skuCode, contentType.split("/")[1], inputStream);
                String pathPrefix = PegasusIntegrationFacade.getInstance().getOssUtilBean().getBaseUrl();
                return pathPrefix+key;
            }
        }catch (IOException e){
            e.printStackTrace();
        }finally {
            try{
                HttpClient.close();
            }catch (Exception e){}
        }
        return null;
    }

    private String getAppletToken(){
        String tokenUrl = PropConstants.getProperties("SCM_APPLET_TOKEN_URL");
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient HttpClient = httpClientBuilder.build();
        HttpGet httpGet = new HttpGet(tokenUrl);
        try{
            HttpResponse httpResponse = HttpClient.execute(httpGet);
            if(httpResponse.getStatusLine().getStatusCode() == HttpStatus.OK.value()){
                //获取响应消息实体
                HttpEntity entity = httpResponse.getEntity();
                if(NullUtil.isNotNull(entity)){
                    return EntityUtils.toString(entity,"UTF-8");
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            try{
                HttpClient.close();
            }catch (Exception e){}
        }
        return null;
    }


    @Override
    public Integer insertOrUpdateByExampleSelective(PcsSkuCertificate record, PcsSkuCertificateExample example) {
        Integer res;
        //1：查询在标签表里是否有记录
        List<PcsSkuCertificate> list = pcsSkuCertificateMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            res = pcsSkuCertificateMapper.updateByExampleSelective(record,example);
        } else {
            res = pcsSkuCertificateMapper.insert(record);
        }
        return res;
    }
}
