package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuAutoApproveBgmCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsSkuFinanceAutoApproveRuleCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsSkuAutoApproveBgmMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuAutoApproveBgm;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuAutoApproveBgmExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsSkuAutoApproveRuleService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuAutoApproveBgmVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuFinanceAutoApproveRule;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuFinanceAutoApproveRuleVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.model.CommTypeValue;
import com.thebeastshop.pegasus.util.vo.CommTypeValueVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("pcsSkuAutoApproveRuleService")
public class PcsSkuAutoApproveRuleServiceImpl implements PcsSkuAutoApproveRuleService {

    PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();

    @Autowired
    private PcsSkuAutoApproveBgmMapper pcsSkuAutoApproveBgmMapper;

    @Override
    public boolean addOrEdit(PcsSkuFinanceAutoApproveRuleVO vo) {
        List<CommTypeValue> commTypeValues = new ArrayList<>();
        makePcsSkuAutoApproveRule(vo, commTypeValues);
        if (CollectionUtils.isNotEmpty(commTypeValues)){
            //return pegasusUtilFacade.batchAddCommTypeValueAfterEmptyByType(commTypeValues, CommTypeValueVO.TYPE_AUTO_MAKE_ORDER);
            return pegasusUtilFacade.addOrUpdateCommTypeValue(commTypeValues);
        }
        return false;
    }

    private void makePcsSkuAutoApproveRule(PcsSkuFinanceAutoApproveRuleVO vo,
                                           List<CommTypeValue> commTypeValues){
        // 保存品类配置
        PcsSkuFinanceAutoApproveRule voTmp = new PcsSkuFinanceAutoApproveRule();
        voTmp.setCategoryIds(vo.getCategoryIds());
        CommTypeValue commTypeValue = new CommTypeValue();
        commTypeValue.setType(CommTypeValueVO.TYPE_AUTO_FINANCE_APPROVE);
        commTypeValue.setName(CommTypeValueVO.TYPE_AUTO_FINANCE_APPROVE_CATEGORY);
        if (CollectionUtils.isNotEmpty(vo.getCategoryIds())) {
            commTypeValue.setValue(JSONObject.toJSONString(voTmp));
        }else{
            commTypeValue.setValue("");
        }
        commTypeValue.setDescription("SKU财务自动审批——>品类列表");
        commTypeValues.add(commTypeValue);

        /*if (EmptyUtil.isNotEmpty(vo.getAutoApproveTypes())
                || EmptyUtil.isNotEmpty(vo.getZeroCostAutoApproves())
                || EmptyUtil.isNotEmpty(vo.getCostRiseUnder())){

        }*/
        // 保存其它参数
        PcsSkuFinanceAutoApproveRule approveRule = BeanUtil.buildFrom(vo, PcsSkuFinanceAutoApproveRule.class);
        // 品类和其它参数分开存放,此处不再存储品类
        approveRule.setCategoryIds(null);
        CommTypeValue commTypeValueOther = new CommTypeValue();
        commTypeValueOther.setType(CommTypeValueVO.TYPE_AUTO_FINANCE_APPROVE);
        commTypeValueOther.setName(CommTypeValueVO.TYPE_AUTO_FINANCE_APPROVE_OTHER);
        commTypeValueOther.setValue(JSONObject.toJSONString(approveRule));
        commTypeValueOther.setDescription("SKU财务自动审批——>其它参数");
        commTypeValues.add(commTypeValueOther);
    }

    @Override
    public Map<Integer, BigDecimal> getPcsSkuFinanceAutoApproveRuleForCostRiseUnder() {
        Map<Integer, BigDecimal> ruleMap = new HashMap<>();
        PcsSkuFinanceAutoApproveRuleVO autoApproveRuleVO = findPcsSkuFinanceAutoApproveRuleVO(null);
        if (EmptyUtil.isEmpty(autoApproveRuleVO)){
            ruleMap.put(PcsSkuFinanceAutoApproveRuleVO.SKU_COST_RISE_UNDER, BigDecimal.ZERO);
            ruleMap.put(PcsSkuFinanceAutoApproveRuleVO.MATERIAL_COST_RISE_UNDER, BigDecimal.ZERO);
            return ruleMap;
        }
        BigDecimal costRiseUnder = EmptyUtil.isEmpty(autoApproveRuleVO.getCostRiseUnder())?BigDecimal.ZERO:new BigDecimal(autoApproveRuleVO.getCostRiseUnder());
        BigDecimal materialCostRiseUnder = EmptyUtil.isEmpty(autoApproveRuleVO.getMaterialCostRiseUnder())?BigDecimal.ZERO:new BigDecimal(autoApproveRuleVO.getMaterialCostRiseUnder());
        ruleMap.put(PcsSkuFinanceAutoApproveRuleVO.SKU_COST_RISE_UNDER, costRiseUnder);
        ruleMap.put(PcsSkuFinanceAutoApproveRuleVO.MATERIAL_COST_RISE_UNDER, materialCostRiseUnder);
        return ruleMap;
    }

    @Override
    public PcsSkuFinanceAutoApproveRuleVO findPcsSkuFinanceAutoApproveRuleVO(PcsSkuFinanceAutoApproveRuleCond cond) {
        PcsSkuFinanceAutoApproveRuleVO pcsSkuFinanceAutoApproveRuleVO = new PcsSkuFinanceAutoApproveRuleVO();
        List<CommTypeValue> commTypeValues = pegasusUtilFacade.getCommTypeValuesByType(CommTypeValueVO.TYPE_AUTO_FINANCE_APPROVE);
        if (CollectionUtils.isNotEmpty(commTypeValues)){
            Map<String, CommTypeValue> commTypeValueMap = new HashMap<>();
            for (CommTypeValue commTypeValue : commTypeValues){
                commTypeValueMap.put(commTypeValue.getName(),commTypeValue);
            }
            // 获取 财务自动审批 其它参数
            CommTypeValue commTypeValueTmp = commTypeValueMap.get(CommTypeValueVO.TYPE_AUTO_FINANCE_APPROVE_OTHER);
            if (EmptyUtil.isNotEmpty(commTypeValueTmp)
                    && EmptyUtil.isNotEmpty(commTypeValueTmp.getValue())){
                JSONObject otherJson = JSON.parseObject(commTypeValueTmp.getValue());
                PcsSkuFinanceAutoApproveRuleVO autoMakeOrderParamTmp = JSONObject.toJavaObject(otherJson,PcsSkuFinanceAutoApproveRuleVO.class);
                if (EmptyUtil.isNotEmpty(autoMakeOrderParamTmp)){
                    pcsSkuFinanceAutoApproveRuleVO = BeanUtil.buildFrom(autoMakeOrderParamTmp, PcsSkuFinanceAutoApproveRuleVO.class);
                }
            }

            // 获取 财务自动审批 品类参数
            commTypeValueTmp = commTypeValueMap.get(CommTypeValueVO.TYPE_AUTO_FINANCE_APPROVE_CATEGORY);
            if (EmptyUtil.isNotEmpty(commTypeValueTmp)
                    && EmptyUtil.isNotEmpty(commTypeValueTmp.getValue())){
                JSONObject categoryJson = JSON.parseObject(commTypeValueTmp.getValue());
                PcsSkuFinanceAutoApproveRuleVO autoApproveRuleVO = JSONObject.toJavaObject(categoryJson, PcsSkuFinanceAutoApproveRuleVO.class);
                if (EmptyUtil.isNotEmpty(autoApproveRuleVO)
                        && CollectionUtils.isNotEmpty(autoApproveRuleVO.getCategoryIds())){
                    List<Long> categoryIds = new ArrayList<>();
                    autoApproveRuleVO.getCategoryIds().forEach(categoryId -> {
                        categoryIds.add(categoryId);
                    });
                    if (EmptyUtil.isEmpty(autoApproveRuleVO.getId())){
                        pcsSkuFinanceAutoApproveRuleVO.setId(commTypeValueTmp.getId());
                    }
                    pcsSkuFinanceAutoApproveRuleVO.setCategoryIds(categoryIds);
                }
            }

            if (pcsSkuFinanceAutoApproveRuleVO != null
                    && EmptyUtil.isNotEmpty(cond)
                    && cond.isFetchBgms()){
                // 基准毛利率
                pcsSkuFinanceAutoApproveRuleVO.setSkuAutoApproveBgmVOs(pcsSkuAutoApproveBgmMapper.listAllPcsSkuAutoApproveBgmVO());
            }
        }
        return pcsSkuFinanceAutoApproveRuleVO;
    }

    @Override
    @Transactional
    public boolean addPcsSkuAutoApproveBgm(PcsSkuAutoApproveBgm skuAutoApproveBgm) {
        return pcsSkuAutoApproveBgmMapper.insertSelective(skuAutoApproveBgm) > 0;
    }

    @Override
    @Transactional
    public boolean batchAddPcsSkuAutoApproveBgm(List<PcsSkuAutoApproveBgm> skuAutoApproveBgms, Boolean needEmpty) {
        if (needEmpty){
            emptyPcsSkuAutoApproveBgm();
        }
        return pcsSkuAutoApproveBgmMapper.batchInsert(skuAutoApproveBgms);
    }

    @Override
    public boolean emptyPcsSkuAutoApproveBgm() {
        return pcsSkuAutoApproveBgmMapper.deleteByExample(null) > 0;
    }

    @Override
    public List<PcsSkuAutoApproveBgm> listAllPcsSkuAutoApproveBgm() {
        return pcsSkuAutoApproveBgmMapper.selectByExample(null);
    }

    @Override
    public List<PcsSkuAutoApproveBgm> listPcsSkuAutoApproveBgmByCond(PcsSkuAutoApproveBgmCond cond) {
        PcsSkuAutoApproveBgmExample example = buildPcsSkuAutoApproveBgmExampleByCond(cond);
        return pcsSkuAutoApproveBgmMapper.selectByExample(example);
    }

    private PcsSkuAutoApproveBgmExample buildPcsSkuAutoApproveBgmExampleByCond(PcsSkuAutoApproveBgmCond cond) {
        PcsSkuAutoApproveBgmExample example = new PcsSkuAutoApproveBgmExample();
        PcsSkuAutoApproveBgmExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(cond.getCategoryId())){
            criteria.andCategoryIdEqualTo(cond.getCategoryId());
        }else if (CollectionUtils.isNotEmpty(cond.getCategoryIds())){
            criteria.andCategoryIdIn(cond.getCategoryIds());
        }
        if (EmptyUtil.isNotEmpty(cond.getSkuPurchasePattern())){
            criteria.andSkuPurchasePatternEqualTo(cond.getSkuPurchasePattern());
        }
        if (EmptyUtil.isNotEmpty(cond.getCategoryLevel())){
            criteria.andCategoryLevelEqualTo(cond.getCategoryLevel());
        }
        return example;
    }

    @Override
    public List<PcsSkuAutoApproveBgmVO> listAllPcsSkuAutoApproveBgmVO() {
        return pcsSkuAutoApproveBgmMapper.listAllPcsSkuAutoApproveBgmVO();
    }

    @Override
    public List<PcsSkuAutoApproveBgmVO> listAllPcsSkuAutoApproveBgmVOByCond(PcsSkuAutoApproveBgmCond cond) {
        return pcsSkuAutoApproveBgmMapper.listAllPcsSkuAutoApproveBgmVOByCond(cond);
    }

    @Override
    public List<PcsSkuAutoApproveBgmVO> listAllFirstCategoryBgmVO() {
        return pcsSkuAutoApproveBgmMapper.listAllFirstCategoryBgmVO();
    }

    @Override
    public List<PcsSkuAutoApproveBgmVO> listCategoryBgmVOByCond(PcsSkuAutoApproveBgmCond cond) {
        return pcsSkuAutoApproveBgmMapper.listCategoryBgmVOByCond(cond);
    }
}
