/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.message.enums.MsgTypeEnum;
import com.thebeastshop.message.enums.PublishTypeEnum;
import com.thebeastshop.message.service.MsgSendService;
import com.thebeastshop.message.vo.MsgSingleVo;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.enums.PcsSkuSalesPriceChangeStatusEnum;
import com.thebeastshop.pegasus.merchandise.enums.PcsSkuStatusEnum;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuSalesPriceChangeService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuAuditRecordsVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoCreditNoteCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseReturnCond;
import com.thebeastshop.pegasus.service.purchase.dao.*;
import com.thebeastshop.pegasus.service.purchase.enums.PoStatusEnum;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.*;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.vo.*;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import com.thebeastshop.pegasus.util.model.CommAudit;
import com.thebeastshop.pegasus.util.model.CommFileRef;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import com.thebeastshop.stock.enums.SStockInOutTypeEnum;
import com.thebeastshop.wms.cond.PhyWhStockCond;
import com.thebeastshop.wms.sservice.SWhInfoService;
import com.thebeastshop.wms.sservice.SWhInvService;
import com.thebeastshop.wms.sservice.SWhWmsSkuStockService;
import com.thebeastshop.wms.sservice.WWhCommandService;
import com.thebeastshop.wms.vo.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

import static java.math.BigDecimal.ROUND_HALF_DOWN;
import static java.util.stream.Collectors.toMap;

/**
 * @author Eric.Lou
 * @version $Id: PcsPurchaseOrderServiceImpl.java, v 0.1 2015-08-10 10:28
 */
@Service("pcsPurchaseOrderService")
public class PcsPurchaseOrderServiceImpl implements PcsPurchaseOrderService, CheckAble, CodeAble {

    private final Logger log = LoggerFactory.getLogger(PcsPurchaseOrderServiceImpl.class);

    @Autowired
    private PcsPurchaseOrderMapper pcsPurchaseOrderMapper;

    @Autowired
    private PcsPoLineService pcsPoLineService;
    @Autowired
    private PcsPoPlanMapper pcsPoPlanMapper;
    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;
    @Autowired
    private McPcsSkuSalesPriceChangeService mcPcsSkuSalesPriceChangeService;
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    @Autowired
    private PcsPurchaseReturnMapper pcsPurchaseReturnMapper;
    @Autowired
    private PcsPurchaseReturnSkuMapper pcsPurchaseReturnSkuMapper;
    @Autowired
    private PcsPurchaseOrderCostMapper pcsPurchaseOrderCostMapper;
    @Autowired
    private PcsPoPlanCostMapper pcsPoPlanCostMapper;
    @Autowired
    private PcsCostAdjustMapper pcsCostAdjustMapper;

    @Autowired
    private PurchaseSellStockReportMapper purchaseSellStockReportMapper;

    @Autowired
    private MsgSendService msgSendService;
    @Autowired
    private PcsPoApprovalRecordsMapper pcsPoApprovalRecordsMapper;
    @Autowired
    private PcsPoLineApprovalRecordMapper pcsPoLineApprovalRecordMapper;

    @Autowired
    private PcsPoCreditNoteMapper pcsPoCreditNoteMapper;

    @Autowired
    private PcsPoPlanService pcsPoPlanService;
    @Autowired
    private PcsPoCostApprovalRecordsMapper pcsPoCostApprovalRecordsMapper;

    @Autowired
    private WWhCommandService wWhCommandService;

    @Autowired
    private SWhInfoService sWhInfoService;

    @Autowired
    private SWhInvService sWhInvService;

    @Autowired
    private SWhWmsSkuStockService sWhWmsSkuStockService;

    private PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();

    @Override
    public Boolean check(Object obj) {
        PcsPurchaseOrder record = (PcsPurchaseOrder) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        Boolean currencyFlag = false;
        /*List<CommCurrency> allCurrency = PegasusUtilFacade.getInstance().findAllCurrency();
        for (CommCurrency c : allCurrency) {
            if (c.getCode().equals(record.getPurchaseCurrencyCode())) {
                record.setPurchaseCurrencyDesc(c.getDescInfo());
                currencyFlag = true;
                break;
            }
        }
        if (!currencyFlag) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }*/
        record.setPurchaseCurrencyDesc(record.getPurchaseCurrencyCode());
        return true;
    }


    private Boolean check(PcsPurchaseOrder record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }

    private Boolean check(String code) {
        return NullUtil.isNull(findPoByCode(code)) ? true : false;
    }

    @Override
    public String generateCode(Object id) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("PCS_PURCHASE_ORDER", params);
        return code;
    }

    @Override
    public PcsPurchaseOrder buildFromVO(PcsPurchaseOrderVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsPurchaseOrder record = new PcsPurchaseOrder();
        BeanUtils.copyProperties(vo, record);
        record.setPurchaseCurrencyRate(vo.getRate());
        return record;
    }

    @Override
    public PcsPurchaseOrderVO buildFromModel(PcsPurchaseOrder record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsPurchaseOrderVO vo = new PcsPurchaseOrderVO();
        BeanUtils.copyProperties(record, vo);
        vo.setRate(record.getPurchaseCurrencyRate());
        return vo;
    }

    @Override
    public Long addPcsPoCreditNoteVO(PcsPoCreditNoteVO vo) {
        return createPcsPoCreditNote(vo);
    }

    @Override
    public void deletePcsPoCreditNoteVO(PcsPoCreditNoteVO vo) {
        PcsPoCreditNote pcsPoCreditNote = pcsPoCreditNoteMapper.selectByPrimaryKey(vo.getId());
        if (pcsPoCreditNote.getStatus() != 0) {
            throw new RuntimeException("只有未使用状态才可以删除");
        }
        pcsPoCreditNoteMapper.deleteByPrimaryKey(vo.getId());
        List<String> fileRefCodes = new ArrayList<>();
        fileRefCodes.add(vo.getId().toString());
        // 2、del old attachements
        pegasusUtilFacade.deleteCommFileRefByRefCodes(fileRefCodes, CommFileRef.CONTRACT_TYPE_CREDIT_NOTE);
    }

    private Long createPcsPoCreditNote(PcsPoCreditNoteVO creditNoteVO) {

        Map<Long, List<CommFileRef>> mapCommFileRefs = new HashMap<>();
        pcsPoCreditNoteMapper.insertSelective(creditNoteVO);
        if (CollectionUtils.isNotEmpty(creditNoteVO.getAttachmentList())) {
            mapCommFileRefs.put(creditNoteVO.getId(), creditNoteVO.getAttachmentList());
        }
        // 保存Credit Note关联的附件
        if (mapCommFileRefs.size() > 0) {
            mapCommFileRefs.forEach((k, v) -> {
                v.forEach(commRef -> {
                    commRef.setReferenceCode(k.toString());
                    pegasusUtilFacade.createCommFileRef(commRef);
                });
            });
        }
        return creditNoteVO.getId();
    }

    @Override
    @Transactional
    public PcsPurchaseOrder create(PcsPurchaseOrder record, boolean saveDraft) {
        if (check(record)) {
            if (check(record, true)) {
                record.setCreateTime(new Date());
                record.setIsReceivedAll(PegasusConstants.YES);
                pcsPurchaseOrderMapper.insertSelective(record);
                try {
                    final String code = generateCode(record.getId());
                    if (check(code)) {
                        record.setCode(code);
                        if (!saveDraft) {
	                      /*  myScheduler.execute(new Runnable() {
	            				@Override
	            				public void run() {
	            					sendNotice(code);
	            				}
	            			});*/
                        }
                        pcsPurchaseOrderMapper.updateByPrimaryKeySelective(record);
                        return record;
                    } else {
                        throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "code字段数据库已有相同的值不能重复");
                    }
                } catch (Exception e) {
                    log.error("", e);
                    throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_GENERATE_CODE, "生成CODE失败");
                }
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsPurchaseOrder record) {
        if (check(record)) {
            if (check(record, false)) {
                record.setCode(null);
                return pcsPurchaseOrderMapper.updateByPrimaryKeySelective(record) != 0;
            }
        }
        return false;
    }

    @Override
    public PcsPurchaseOrder findPoById(Long id) {
        return pcsPurchaseOrderMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsPoCreditNote> listPcsPoCreditNoteByCond(PcsPoCreditNoteCond cond) {
        PcsPoCreditNoteExample example = buildPcsPoCreditNoteExampleByCond(cond);
        return pcsPoCreditNoteMapper.selectByExample(example);
    }

    @Override
    public List<PcsPoCreditNoteVO> listPcsPoCreditNoteVOByCond(PcsPoCreditNoteCond cond) {
        return pcsPoCreditNoteMapper.listPcsPoCreditNoteVOByCond(cond);
    }

    @Override
    public List<PcsPoCreditNoteVO> listSumPoCreditNoteVOByCond(PcsPoCreditNoteCond cond) {
        return pcsPoCreditNoteMapper.listSumPoCreditNoteVOByCond(cond);
    }

    private boolean checkBigDecimalGtZero(BigDecimal amount) {
        if (EmptyUtil.isNotEmpty(amount) && amount.compareTo(BigDecimal.ZERO) > 0) {
            return true;
        }
        return false;
    }

    private PcsPoCreditNoteExample buildPcsPoCreditNoteExampleByCond(String poCode, Integer status) {
        PcsPoCreditNoteCond cond = new PcsPoCreditNoteCond();
        cond.setPoCode(poCode);
        cond.setStatus(status);
        return buildPcsPoCreditNoteExampleByCond(cond);
    }

    private PcsPoCreditNoteExample buildPcsPoCreditNoteExampleByCond(PcsPoCreditNoteCond cond) {
        PcsPoCreditNoteExample example = new PcsPoCreditNoteExample();
        PcsPoCreditNoteExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(cond.getPoCode())) {
            criteria.andPoCodeEqualTo(cond.getPoCode());
        }
        if (EmptyUtil.isNotEmpty(cond.getStatus())) {
            criteria.andStatusEqualTo(cond.getStatus());
        }
        if (EmptyUtil.isNotEmpty(cond.getNotStatus())) {
            criteria.andStatusNotEqualTo(cond.getNotStatus());
        }
        if (EmptyUtil.isNotEmpty(cond.getValid())) {
            criteria.andValidEqualTo(cond.getValid());
        } else {
            criteria.andValidEqualTo(PegasusConstants.STATUS_AVAILABLE);
        }
        return example;
    }

    @Override
    public PcsPurchaseOrderVO findPoVOById(Long id) {
    	PcsPurchaseOrderVO pcsPurchaseOrderVO = pcsPurchaseOrderMapper.findPoVOById(id);
    	if(EmptyUtil.isNotEmpty(pcsPurchaseOrderVO)) {
        PcsPoApprovalRecords pcsPoApprovalRecords = findNewestApprovalRecordsByPoId(id);
        if (pcsPoApprovalRecords != null) {
            pcsPurchaseOrderVO.setSubmitUserId(pcsPoApprovalRecords.getSubmitUserId());
        }
    		List<PcsPurchaseOrderCost> orderCostList = pcsPurchaseOrderCostMapper.selectByPoId(id);
    	    pcsPurchaseOrderVO.setOrderCostList(orderCostList);
    	    if(EmptyUtil.isNotEmpty(orderCostList)) {
    	    	for(PcsPurchaseOrderCost pcsPurchaseOrderCost : orderCostList) {
    	    		short costType = pcsPurchaseOrderCost.getCostType();
        	    	if(costType == 1) {
        	    		pcsPurchaseOrderVO.setMoldCost(pcsPurchaseOrderCost.getAfterTaxesAmount());
        	    		pcsPurchaseOrderVO.setMoldRate(pcsPurchaseOrderCost.getRate());
        	    	}
        	    	if(costType == 2) {
        	    		pcsPurchaseOrderVO.setPlateCost(pcsPurchaseOrderCost.getAfterTaxesAmount());
        	    		pcsPurchaseOrderVO.setPlateRate(pcsPurchaseOrderCost.getRate());
        	    	}
        	    	if(costType == 3) {
        	    		pcsPurchaseOrderVO.setFreightCost(pcsPurchaseOrderCost.getAfterTaxesAmount());
        	    		pcsPurchaseOrderVO.setFreightRate(pcsPurchaseOrderCost.getRate());
        	    	}
        	    }
    	    }
    	}
    	
        return pcsPurchaseOrderVO;
    }

    @Override
    public PcsPurchaseOrderVO findPoVOByCode(String code) {
        return pcsPurchaseOrderMapper.findPoVOByCode(code);
    }

    @Override
    public PcsPurchaseOrder findPoByPoCode(String poCode) {
        return findPoByCode(poCode);
    }

    @Override
    public PcsPurchaseOrderVO findPurchaseOrderByCommandCode(String commandCode) {
        return pcsPurchaseOrderMapper.findPurchaseOrderByCommandCode(commandCode);
    }

    @Override
    public PcsPurchaseOrder findPoByCode(String code) {
        PcsPurchaseOrderExample example = new PcsPurchaseOrderExample();
        example.createCriteria().andCodeEqualTo(code);
        final List<PcsPurchaseOrder> poList = pcsPurchaseOrderMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return null;
        } else {
            if (poList.size() > 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, " 根据code[" + code + "]能查出2条以上(含两条)记录");
            } else {
                return poList.get(0);
            }
        }
    }

    @Override
    public List<PcsPurchaseOrderVO> findPOVOByCond(PcsPurchaseOrderCond cond) {
        return pcsPurchaseOrderMapper.findPOVOByCond(cond);
    }

    @Override
    public PageInfo<PcsPurchaseOrderVO> pageQueryPOByCond(PcsPurchaseOrderCond cond) {
        PageRowBounds rowBounds = new PageRowBounds(cond.getPageStart(), cond.getPagenum());
        PageInfo pageInfo = new PageInfo(pcsPurchaseOrderMapper.pageQueryPOByCond(cond, rowBounds));
        pageInfo.setTotal(rowBounds.getTotal());
        return pageInfo;
    }

    @Override
    public Map<String, Integer> countPoGroupByStatus(PcsPurchaseOrderCond cond) {
        List<Map<String, Integer>> countMapList = pcsPurchaseOrderMapper.countPoGroupByStatus(cond);
        Map<String, Integer> countMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(countMapList)) {
            countMapList.forEach(map -> {
                countMap.put(String.valueOf(map.get("poStatus")), map.get("poCount"));
            });
        }
        return countMap;
    }

    @Override
    @Transactional
    public Long createPurchaseOrderAndLine(PcsPurchaseOrderVO pcsPurchaseOrderVO) {
        PcsPurchaseOrder pcsPurchaseOrder = buildFromVO(pcsPurchaseOrderVO);
        List<PcsPoLine> pcsPoLineList = new ArrayList<PcsPoLine>();
        if (CollectionUtils.isEmpty(pcsPurchaseOrderVO.getPcsPoLineVOList())) {
            pcsPoLineList = Collections.emptyList();
        } else {
            for (PcsPoLineVO pcsPoLineVO : pcsPurchaseOrderVO.getPcsPoLineVOList()) {
                PcsPoLine pcsPoLine = pcsPoLineService.buildFromVO(pcsPoLineVO);
                pcsPoLineList.add(pcsPoLine);
            }
        }
        Long poId = createPurchaseOrderAndLine(pcsPurchaseOrder, pcsPoLineList, pcsPurchaseOrderVO.isSaveDraft(),
                pcsPurchaseOrderVO.getOrderCostList());

        // 保存po单 Credit Note
        createPcsPoCreditNoteVO(pcsPurchaseOrderVO.getPcsPoCreditNoteVOs(), pcsPurchaseOrder.getCode());

        // 保存po单 其它附件
        createPoOtherAttachments(pcsPurchaseOrderVO.getOtherAttachmentList(), pcsPurchaseOrder.getId());

        return poId;
    }

    private void updateCreatePcsPoCreditNoteVO(List<PcsPoCreditNoteVO> creditNoteVOs, String poCode) {
        PcsPoCreditNoteExample example = buildPcsPoCreditNoteExampleByCond(poCode, null);
        List<PcsPoCreditNote> creditNotes = pcsPoCreditNoteMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(creditNotes)) {
            // 1、del old credit note
            pcsPoCreditNoteMapper.deleteByExample(example);
            List<String> fileRefCodes = new ArrayList<>();
            creditNotes.forEach(cn -> {
                fileRefCodes.add(cn.getId().toString());
            });

            // 2、del old attachements
            pegasusUtilFacade.deleteCommFileRefByRefCodes(fileRefCodes, CommFileRef.CONTRACT_TYPE_CREDIT_NOTE);
        }
        // 3
        createPcsPoCreditNoteVO(creditNoteVOs, poCode);
    }

    private void updatePoOtherAttachments(List<CommFileRef> otherAttachmentList, Long poId) {
        pegasusUtilFacade.deleteCommFileRefByRefCodes(Arrays.asList(poId.toString()), CommFileRef.CONTRACT_TYPE_PO_OTHER);
        createPoOtherAttachments(otherAttachmentList, poId);
    }

    private void createPcsPoCreditNoteVO(List<PcsPoCreditNoteVO> creditNoteVOs, String poCode) {
        if (CollectionUtils.isNotEmpty(creditNoteVOs)) {
            Map<Long, List<CommFileRef>> mapCommFileRefs = new HashMap<>();
            for (PcsPoCreditNoteVO creditNoteVO : creditNoteVOs) {
                creditNoteVO.setPoCode(poCode);
                pcsPoCreditNoteMapper.insertSelective(creditNoteVO);
                if (CollectionUtils.isNotEmpty(creditNoteVO.getAttachmentList())) {
                    mapCommFileRefs.put(creditNoteVO.getId(), creditNoteVO.getAttachmentList());
                }
            }

            // 保存Credit Note关联的附件
            if (mapCommFileRefs.size() > 0) {
                mapCommFileRefs.forEach((k, v) -> {
                    v.forEach(commRef -> {
                        commRef.setReferenceCode(k.toString());
                        pegasusUtilFacade.createCommFileRef(commRef);
                    });
                });
            }
        }
    }

    private void createPoOtherAttachments(List<CommFileRef> otherAttachmentList, Long poId) {
        if (CollectionUtils.isNotEmpty(otherAttachmentList)) {
            otherAttachmentList.forEach(attach -> {
                attach.setReferenceCode(poId.toString());
                pegasusUtilFacade.createCommFileRef(attach);
            });
        }
    }

    @Override
    @Transactional
    public Long createPurchaseOrderAndLine(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, boolean saveDraft,
                                           List<PcsPurchaseOrderCost> orderCostList) {

        computeTotalPrice(pcsPurchaseOrder, pcsPoLineList, orderCostList);
        if (pcsPoLineList.size() == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "至少需要一个行信息");
        }
        if (saveDraft) {
            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT);
        } else {
            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT);
            pcsPurchaseOrder.setLastSubmitTime(new Date());
            checkSkuStatus(pcsPoLineList);
        }
        pcsPurchaseOrder.setIncludeShipment(checkIsContainFreight(orderCostList) ? (short) 0 : 1);

        pcsPurchaseOrder = create(pcsPurchaseOrder, saveDraft);
        if (EmptyUtil.isEmpty(pcsPurchaseOrder.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "头信息保存失败," + pcsPurchaseOrder.toString());
        }
        for (PcsPoLine pcsPoLine : pcsPoLineList) {
        	  /*PcsSkuVO pcsSkuVO = mcPcsSkuService.findByCode(pcsPoLine.getSkuCode());
              if(EmptyUtil.isNotEmpty(pcsSkuVO)) {
            	  BigDecimal rate = pcsPurchaseOrder.getPurchaseCurrencyRate() == null ? new BigDecimal(1.0) : pcsPurchaseOrder.getPurchaseCurrencyRate();
            	  if(pcsPoLine.getUnitPrice().multiply(rate).compareTo(pcsSkuVO.getCostPrice().multiply(new BigDecimal(1.02))) > 0) {
               		throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM,"[" + pcsSkuVO.getCode() + "]" + pcsSkuVO.getNameCn() +  "采购价不得高于成本价2%");
               	}
              }*/
        	/*//SKU没有完成售价审核
        	if(!saveDraft && EmptyUtil.isEmpty(mcPcsSkuService.findAuditRecordsByCodeAndStatus(pcsPoLine.getSkuCode(), PcsSkuSalesPriceChange.STATUS_SUCCESS))) {
        		 throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "采购单中存在售价审批未通过的SKU，提交失败");
        	}*/
            pcsPoLine.setPoId(pcsPurchaseOrder.getId());
            if (pcsPoLineService.create(pcsPoLine).compareTo(0L) < 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "行信息保存失败," + pcsPoLine.toString());
            }
        }
        createPurchaseOrderCosts(orderCostList, pcsPurchaseOrder.getId());
        //生成审核记录
        if (!saveDraft) {
            pcsPurchaseOrder.setPurchaseOrderStatus(PoStatusEnum.PURCHASE_ORDER_STATUS_DRAFT.getKey());
            savePoAndLineApprovalRecord(pcsPurchaseOrder, pcsPoLineList, orderCostList);
        }
        return pcsPurchaseOrder.getId();
    }


    @Override
    public void checkPurchaseOrderBeforeEdit(PcsPurchaseOrderVO editVO) {
        if (NullUtil.isNull(editVO.getId())) {
            return;
        }
        PcsPurchaseOrderVO info = findPurchaseOrderById(editVO.getId());
        if (NullUtil.isNull(info)) {
            throw new PurchaseException(String.format("[%s]采购单不存在！", editVO.getId()));
        }
        checkPurchaseOrderFieldsBeforeEdit(editVO, info);
    }


    @Override
    public PcsPoFieldEditableInfoVO buildPoFieldEditableInfo(PcsPurchaseOrderVO info) {
        int passTimes = getPoPassApprovalTimes(info.getId());
        info.setAuditPassOnce(passTimes > 0);
        //草稿
        Predicate<Integer> isDraft = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT::equals;
        //已驳回
        Predicate<Integer> isReject = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT::equals;
        //待审核
        Predicate<Integer> isWaitingAudit = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT::equals;
        Predicate<Integer> isWaitFinanceApprovel = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_FINANCE_APPROVEL::equals;
        Predicate<Integer> isAudit = isWaitingAudit.or(isWaitFinanceApprovel);
        //待收货
        Predicate<Integer> isWaitReceive = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE::equals;
        //收货中
        Predicate<Integer> isWaitingReceive = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE::equals;
        //已完成
        Predicate<Integer> isAlreadyFinish = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH::equals;
        //草稿或驳回
        Predicate<Integer> isDraftOrReject = isDraft.or(isReject);
        //已驳回或待收货或收货中
        Predicate<Integer> isRejectOrWaitOrWaitingReceive = isReject.or(isWaitReceive).or(isWaitingReceive);
        //是否审批通过过至少一次前置条件
        Predicate<Integer> isAuditPassOnce = (status) -> info.isAuditPassOnce();
        //编辑页(从未审批通过过)
        Predicate<Integer> neverPassOnce = isAuditPassOnce.negate().and(isDraftOrReject);
        //未创建pop
        List<PcsPoPlan> planList = pcsPoPlanService.findPcsPoPlanByPoId(info.getId());
        Predicate<Integer> neverCreatePoPlan = (status) -> EmptyUtil.isEmpty(planList);
        //通用
        BooleanSupplier commCanEdit = () -> isAuditPassOnce.and(isDraftOrReject).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        PcsPoFieldEditableInfoVO editableInfo = new PcsPoFieldEditableInfoVO();
        //供应商
        BooleanSupplier supplierCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setSupplier(supplierCanEdit.getAsBoolean());
        //币种
        BooleanSupplier purchaseCurrencyCodeCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setPurchaseCurrencyCode(purchaseCurrencyCodeCanEdit.getAsBoolean());
        //成本中心
        BooleanSupplier purchaseOrderCostCenterCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setPurchaseOrderCostCenter(purchaseOrderCostCenterCanEdit.getAsBoolean());
        //要求交货日期
        BooleanSupplier askDeliveryDateCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        editableInfo.setAskDeliveryDate(askDeliveryDateCanEdit.getAsBoolean());
        //关务安排
        BooleanSupplier needCustomsArrangeCanEdit = askDeliveryDateCanEdit;
        editableInfo.setNeedCustomsArrange(needCustomsArrangeCanEdit.getAsBoolean());
        //dt
        BooleanSupplier setDeliveryTermsCanEdit = askDeliveryDateCanEdit;
        editableInfo.setDeliveryTerms(setDeliveryTermsCanEdit.getAsBoolean());
        //收货物理仓
        BooleanSupplier physicalWarehouseCodeCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setPhysicalWarehouseCode(physicalWarehouseCodeCanEdit.getAsBoolean());
        //收货逻辑仓
        BooleanSupplier warehouseCodeCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setWarehouseCode(warehouseCodeCanEdit.getAsBoolean());
        //自动创建POP
        BooleanSupplier autoBuildPopCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        editableInfo.setAutoBuildPop(autoBuildPopCanEdit.getAsBoolean());
        //过量交货限度
        BooleanSupplier overDeliveryLimitRateCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        editableInfo.setOverDeliveryLimitRate(overDeliveryLimitRateCanEdit.getAsBoolean());
        //备注
        BooleanSupplier remarkCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive.or(isAlreadyFinish)).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        editableInfo.setRemark(remarkCanEdit.getAsBoolean());
        //合同
        BooleanSupplier contractAttachmentCanEdit = () -> neverPassOnce.or(isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive.or(isAlreadyFinish))).test(info.getPurchaseOrderStatus());
        editableInfo.setContractAttachment(contractAttachmentCanEdit.getAsBoolean());
        //采购单费用
        BooleanSupplier poCostCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setPoCost(poCostCanEdit.getAsBoolean());
        //SKU
        BooleanSupplier skuCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        BooleanSupplier skuQuantityCanEdit = () -> neverPassOnce.or(isWaitReceive.or(isReject).and(neverCreatePoPlan)).test(info.getPurchaseOrderStatus());
        BooleanSupplier skuUnitPriceCanEdit = () -> isAuditPassOnce.and(isReject).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        BooleanSupplier skuTaxRateCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        editableInfo.setSku(skuCanEdit.getAsBoolean());
        editableInfo.setSkuQuantity(skuQuantityCanEdit.getAsBoolean());
        editableInfo.setSkuUnitPrice(skuUnitPriceCanEdit.getAsBoolean());
        editableInfo.setSkuTaxRate(skuTaxRateCanEdit.getAsBoolean());

        //其他附件-待定
        BooleanSupplier creditNoteCanEdit = () -> isWaitingReceive.or(isWaitReceive).or(isAlreadyFinish).test(info.getPurchaseOrderStatus());
        editableInfo.setCreditNote(creditNoteCanEdit.getAsBoolean());
        //其他附件-待定
        BooleanSupplier otherAttachmentsCanEdit = () -> true;
        editableInfo.setOtherAttachments(otherAttachmentsCanEdit.getAsBoolean());
        editableInfo.setAuditPassOnce(info.isAuditPassOnce());

        return editableInfo;
    }


    private void checkPurchaseOrderFieldsBeforeEdit(PcsPurchaseOrderVO editVO, PcsPurchaseOrderVO info) {
        int passTimes = getPoPassApprovalTimes(info.getId());
        info.setAuditPassOnce(passTimes > 0);
        //草稿
        Predicate<Integer> isDraft = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT::equals;
        //已驳回
        Predicate<Integer> isReject = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT::equals;
        //待审核
        Predicate<Integer> isWaitingAudit = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT::equals;
        Predicate<Integer> isWaitFinanceApprovel = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_FINANCE_APPROVEL::equals;
        Predicate<Integer> isAudit = isWaitingAudit.or(isWaitFinanceApprovel);
        //待收货
        Predicate<Integer> isWaitReceive = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE::equals;
        //收货中
        Predicate<Integer> isWaitingReceive = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE::equals;
        //已完成
        Predicate<Integer> isAlreadyFinish = PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH::equals;
        //草稿或驳回
        Predicate<Integer> isDraftOrReject = isDraft.or(isReject);
        //已驳回或待收货或收货中
        Predicate<Integer> isRejectOrWaitOrWaitingReceive = isReject.or(isWaitReceive).or(isWaitingReceive);
        //是否审批通过过至少一次前置条件
        Predicate<Integer> isAuditPassOnce = (status) -> info.isAuditPassOnce();
        //编辑页(从未审批通过过)
        Predicate<Integer> neverPassOnce = isAuditPassOnce.negate().and(isDraftOrReject);
        //未创建pop
        List<PcsPoPlan> planList = pcsPoPlanService.findPcsPoPlanByPoId(info.getId());
        Predicate<Integer> neverCreatePoPlan = (status) -> EmptyUtil.isEmpty(planList);
        //通用
        BooleanSupplier commCanEdit = () -> isAuditPassOnce.and(isDraftOrReject).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        //供应商
        BooleanSupplier supplierCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        checkPurchaseOrderField(supplierCanEdit, editVO::getSupplierId, info::getSupplierId
                , String.format("[%s][%s]供应商不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        //币种
        BooleanSupplier purchaseCurrencyCodeCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        checkPurchaseOrderField(purchaseCurrencyCodeCanEdit, editVO::getPurchaseCurrencyCode, info::getPurchaseCurrencyCode
                , String.format("[%s][%s]币种不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        //成本中心
        BooleanSupplier purchaseOrderCostCenterCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        checkPurchaseOrderField(purchaseOrderCostCenterCanEdit, editVO::getPurchaseOrderCostCenter, info::getPurchaseOrderCostCenter
                , String.format("[%s][%s]成本中心不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        //要求交货日期
        BooleanSupplier askDeliveryDateCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        checkPurchaseOrderField(askDeliveryDateCanEdit, editVO::getAskDeliveryDate, info::getAskDeliveryDate
                , String.format("[%s][%s]交货日期不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        //关务安排
        BooleanSupplier needCustomsArrangeCanEdit = askDeliveryDateCanEdit;
        checkPurchaseOrderField(needCustomsArrangeCanEdit, editVO::getNeedCustomsArrange, info::getNeedCustomsArrange
                , String.format("[%s][%s]关务安排不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        //dt
        BooleanSupplier deliveryTermsCanEdit = askDeliveryDateCanEdit;
        checkPurchaseOrderField(deliveryTermsCanEdit, editVO::getDeliveryTerms, info::getDeliveryTerms
                , String.format("[%s][%s]DeliveryTerms不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        //收货物理仓
        BooleanSupplier physicalWarehouseCodeCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        checkPurchaseOrderField(physicalWarehouseCodeCanEdit, editVO::getPhysicalWarehouseCode, info::getPhysicalWarehouseCode
                , String.format("[%s][%s]物理仓不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        //收货逻辑仓
        BooleanSupplier warehouseCodeCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        checkPurchaseOrderField(warehouseCodeCanEdit, editVO::getWarehouseCode, info::getWarehouseCode
                , String.format("[%s][%s]收货逻辑仓不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        //自动创建POP
        BooleanSupplier autoBuildPopCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        checkPurchaseOrderField(autoBuildPopCanEdit, editVO::getAutoBuildPop, info::getAutoBuildPop
                , String.format("[%s][%s]自动创建POP不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        //过量交货限度
        BooleanSupplier overDeliveryLimitRateCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        checkPurchaseOrderField(overDeliveryLimitRateCanEdit, editVO::getOverDeliveryLimitRate, info::getOverDeliveryLimitRate
                , String.format("[%s][%s]过量交货限度不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        //备注
        BooleanSupplier remarkCanEdit = () -> isAuditPassOnce.and(isRejectOrWaitOrWaitingReceive.or(isAlreadyFinish)).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        checkPurchaseOrderField(remarkCanEdit, editVO::getRemark, info::getRemark
                , String.format("[%s][%s]备注不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        //其他附件-待定
        BooleanSupplier creditNoteCanEdit = () -> isWaitingReceive.or(isWaitReceive).or(isAlreadyFinish).test(info.getPurchaseOrderStatus());
        //其他附件-待定
        BooleanSupplier otherAttachmentsCanEdit = () -> true;
        //
        //采购单费用
        BooleanSupplier poCostCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        Map<Short, PcsPurchaseOrderCost> infoPoCostMap = info.getOrderCostList().stream()
                .collect(toMap(PcsPurchaseOrderCost::getCostType, item -> item));
        //采购单费用行数校验
        Integer infoPoCostLength = EmptyUtil.isEmpty(info.getOrderCostList()) ? 0 : info.getOrderCostList().size();
        Integer editPoCostLength = EmptyUtil.isEmpty(editVO.getOrderCostList()) ? 0 : editVO.getOrderCostList().size();
        checkPurchaseOrderField(poCostCanEdit, () -> editPoCostLength, () -> infoPoCostLength
                , String.format("[%s][%s]采购单费用不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        editVO.getOrderCostList().forEach((poCost) -> {
            PcsPurchaseOrderCost editOrderCost = infoPoCostMap.get(poCost.getCostType());
            //费用是否存在
            checkPurchaseOrderField(poCostCanEdit, () -> true, () -> NullUtil.isNotNull(editOrderCost)
                    , String.format("[%s][%s]采购单费用不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
            //行税率
            checkPurchaseOrderField(poCostCanEdit, editOrderCost::getRate, poCost::getRate
                    , String.format("[%s][%s]采购单费用不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
            //行费用金额
            checkPurchaseOrderField(poCostCanEdit, editOrderCost::getAfterTaxesAmount, poCost::getAfterTaxesAmount
                    , String.format("[%s][%s]采购单费用不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        });
        //SKU
        BooleanSupplier skuCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        BooleanSupplier skuQuantityCanEdit = () -> neverPassOnce.or(isWaitReceive.or(isReject).and(neverCreatePoPlan)).test(info.getPurchaseOrderStatus());
        BooleanSupplier skuUnitPriceCanEdit = () -> isAuditPassOnce.and(isReject).or(neverPassOnce).test(info.getPurchaseOrderStatus());
        BooleanSupplier skuTaxRateCanEdit = () -> neverPassOnce.test(info.getPurchaseOrderStatus());
        Integer infoPoLineLength = EmptyUtil.isEmpty(info.getPcsPoLineVOList()) ? 0 : info.getPcsPoLineVOList().size();
        Integer editPoLineLength = EmptyUtil.isEmpty(editVO.getPcsPoLineVOList()) ? 0 : editVO.getPcsPoLineVOList().size();
        checkPurchaseOrderField(skuCanEdit, () -> infoPoLineLength, () -> editPoLineLength
                , String.format("[%s][%s]SKU不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
        Map<String, PcsPoLineVO> infoPoLineMap = info.getPcsPoLineVOList().stream()
                .collect(toMap(PcsPoLineVO::getSkuCode, Function.identity(), (v1, v2) -> v1));

        List<Long> delLineIds = new ArrayList<Long>();
        List<PcsPoLineVO> editPoLineList = editVO.getPcsPoLineVOList();
        infoPoLineMap.forEach((skuCode, value) -> {
            boolean isDelete = true;
            for (PcsPoLineVO editPoLine : editPoLineList) {
                String editPoLineSkuCode = editPoLine.getSkuCode();
                if (skuCode.equals(editPoLineSkuCode)) {
                    isDelete = false;
                }
            }
            if (isDelete) {
                delLineIds.add(value.getId());
            }

        });

        editVO.getPcsPoLineVOList().forEach((editPoLine) -> {
            PcsPoLineVO infoPoLine = infoPoLineMap.get(editPoLine.getSkuCode());
            if (infoPoLine != null) {
                //行sku是否存在
                checkPurchaseOrderField(skuCanEdit, () -> true, () -> NullUtil.isNotNull(infoPoLine)
                        , String.format("[%s][%s]SKU行不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
                //行数量
                checkPurchaseOrderField(skuQuantityCanEdit, infoPoLine::getQuantity, editPoLine::getQuantity
                        , String.format("[%s][%s]SKU行数量不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
                //行采购单价
                checkPurchaseOrderField(skuUnitPriceCanEdit, infoPoLine::getUnitPrice, editPoLine::getUnitPrice
                        , String.format("[%s][%s]SKU行采购单价不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
                //行税率
                checkPurchaseOrderField(skuTaxRateCanEdit, infoPoLine::getTaxRate, editPoLine::getTaxRate
                        , String.format("[%s][%s]SKU行税率不可编辑！", info.getCode(), info.getPurchaseOrderStatusName()));
            }
        });
        editVO.setDelLineIds(delLineIds);
    }

    //字段检查-是否可编辑
    private void checkPurchaseOrderField(
            BooleanSupplier canEditSupplier,
            Supplier<?> s1,
            Supplier<?> s2,
            String message) {
        if (!canEditSupplier.getAsBoolean()) {
            boolean change = isFieldChange(s1, s2);
            if (change) {
                throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, message);
            }
        }
    }

    private boolean isFieldChange(Supplier<?> s1, Supplier<?> s2) {
        boolean isEqual = false;
        if (NullUtil.isNull(s1.get()) && NullUtil.isNull(s2.get())) {
            isEqual = true;
        } else if (NullUtil.isNotNull(s1.get()) && NullUtil.isNotNull(s2.get())) {
            Class clazz = s1.get().getClass();
            if (BigDecimal.class.equals(clazz)) {
                BigDecimal b1 = (BigDecimal) s1.get();
                BigDecimal b2 = (BigDecimal) s2.get();
                isEqual = b1.compareTo(b2) == 0;
            } else {
                isEqual = Predicate.isEqual(s1.get()).test(s2.get());
            }
        }
        return !isEqual;
    }


    /**
     * check 采购单需审批字段
     *
     * @param editVO
     * @param info
     * @param passTimes
     */
    private boolean checkPurchaseOrderApprovalFields(PcsPurchaseOrderVO editVO, PcsPurchaseOrderVO info, int passTimes) {
        try {
            info.setAuditPassOnce(passTimes > 0);

            if (passTimes == 0 && (info.getPurchaseOrderStatus().equals(PoStatusEnum.PURCHASE_ORDER_STATUS_DRAFT.getKey())
                    || info.getPurchaseOrderStatus().equals(PoStatusEnum.PURCHASE_ORDER_STATUS_REJECT.getKey()))) {
                return editVO.isSaveDraft();
            }

            if (isFieldChange(editVO::getPurchaseCurrencyCode, info::getPurchaseCurrencyCode)) {
                return false;
            }
            Map<Short, PcsPurchaseOrderCost> infoPoCostMap = info.getOrderCostList().stream()
                    .collect(toMap(PcsPurchaseOrderCost::getCostType, item -> item));
            //采购单费用行数校验
            Integer infoPoCostLength = EmptyUtil.isEmpty(info.getOrderCostList()) ? 0 : info.getOrderCostList().size();
            Integer editPoCostLength = EmptyUtil.isEmpty(editVO.getOrderCostList()) ? 0 : editVO.getOrderCostList().size();

            if (isFieldChange(() -> editPoCostLength, () -> infoPoCostLength)) {
                return false;
            }

            editVO.getOrderCostList().forEach((poCost) -> {
                PcsPurchaseOrderCost editOrderCost = infoPoCostMap.get(poCost.getCostType());
                //费用没有变更
                if (isFieldChange(() -> true, () -> NullUtil.isNotNull(editOrderCost))
                        || isFieldChange(editOrderCost::getRate, poCost::getRate)
                        || isFieldChange(editOrderCost::getAfterTaxesAmount, poCost::getAfterTaxesAmount)) {
                    throw new PurchaseException("采购单费用有变更！");
                }
            });
            //SKU
            Integer infoPoLineLength = EmptyUtil.isEmpty(info.getPcsPoLineVOList()) ? 0 : info.getPcsPoLineVOList().size();
            Integer editPoLineLength = EmptyUtil.isEmpty(editVO.getPcsPoLineVOList()) ? 0 : editVO.getPcsPoLineVOList().size();
            if (isFieldChange(() -> infoPoLineLength, () -> editPoLineLength)) {
                return false;
            }

            Map<String, PcsPoLineVO> infoPoLineMap = info.getPcsPoLineVOList().stream()
                    .collect(toMap(PcsPoLineVO::getSkuCode, Function.identity(), (v1, v2) -> v1));


            editVO.getPcsPoLineVOList().forEach((editPoLine) -> {
                PcsPoLineVO infoPoLine = infoPoLineMap.get(editPoLine.getSkuCode());
                if (infoPoLine != null) {
                    if (isFieldChange(() -> true, () -> NullUtil.isNotNull(infoPoLine))
                            || isFieldChange(infoPoLine::getQuantity, editPoLine::getQuantity)
                            || isFieldChange(infoPoLine::getUnitPrice, editPoLine::getUnitPrice)
                            || isFieldChange(infoPoLine::getTaxRate, editPoLine::getTaxRate)) {
                        throw new PurchaseException("采购单行数据有变更！");
                    }
                }
            });
        } catch (PurchaseException purchaseException) {
            return false;
        }
        return true;
    }

    private List<PcsPurchaseOrderCost> findPurchaseOrderCost(Long purchaseOrderId) {
        return pcsPurchaseOrderCostMapper.selectByPoId(purchaseOrderId);
    }

    private List<PcsPoPlanVO> findPcsPoPlanVOList(Long poId) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        PcsPoPlanExample.Criteria criteria = example.createCriteria();
        criteria.andPoIdEqualTo(poId);
        return BeanUtil.buildListFrom(pcsPoPlanMapper.selectByExample(example), PcsPoPlanVO.class);
    }

    private PcsPurchaseOrderVO findPurchaseOrderById(Long id) {
        PcsPurchaseOrder po = findPoById(id);
        PcsPurchaseOrderVO vo = null;
        if (NullUtil.isNotNull(po)) {
            List<PcsPoLine> poLineList = pcsPoLineService.findPoLineByPoId(id);
            List<PcsPoLineVO> poLineVOList = BeanUtil.buildListFrom(poLineList, PcsPoLineVO.class);
            List<PcsPurchaseOrderCost> poOrderCostList = findPurchaseOrderCost(id);
            vo = BeanUtil.buildFrom(po, PcsPurchaseOrderVO.class);
            vo.setPcsPoLineVOList(poLineVOList);
            vo.setOrderCostList(poOrderCostList);
        }
        return vo;
    }


    private boolean checkIsContainFreight(List<PcsPurchaseOrderCost> orderCostList) {
        if (orderCostList == null || orderCostList.size() == 0) {
            return false;
        }
        for (PcsPurchaseOrderCost pcsPurchaseOrderCost : orderCostList) {
            if (pcsPurchaseOrderCost.getCostType() == 3 && pcsPurchaseOrderCost.getAfterTaxesAmount() != null
                    && new BigDecimal(0).compareTo(pcsPurchaseOrderCost.getAfterTaxesAmount()) < 0) {
                return true;
            }
        }
        return false;
    }


    /**
     * @param pcsPurchaseOrder
     * @param pcsPoLineList
     */
    @Override
    public void computeTotalPrice(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, List<PcsPurchaseOrderCost> orderCostList) {
        BigDecimal totalAmount = new BigDecimal(0.00);
        BigDecimal totalTax = new BigDecimal(0.00);
        BigDecimal totalAmountAfterTax = new BigDecimal(0.00);
        BigDecimal otherFeeAfterTax = new BigDecimal(0.00);

        if (EmptyUtil.isNotEmpty(pcsPoLineList)) {
            for (PcsPoLine pcsPoLine : pcsPoLineList) {
                BigDecimal unitPrice = pcsPoLine.getUnitPrice();
                int quantity = pcsPoLine.getQuantity();
                BigDecimal taxRate = pcsPoLine.getTaxRate();

                taxRate = taxRate.add(new BigDecimal(1));
                BigDecimal unitPriceAfterTax = pcsPoLine.getUnitPrice().divide(taxRate, 4, BigDecimal.ROUND_HALF_EVEN);
                pcsPoLine.setTotalPrice(unitPrice.multiply(new BigDecimal(quantity)));
                totalAmount = totalAmount.add(pcsPoLine.getTotalPrice());
                pcsPoLine.setUnitPriceAfterTax(unitPriceAfterTax);
                pcsPoLine.setTotalPriceAfterTax(unitPriceAfterTax.multiply(new BigDecimal(quantity)));
                pcsPoLine.setTaxRate(pcsPoLine.getTaxRate());
                totalAmountAfterTax = totalAmountAfterTax.add(pcsPoLine.getTotalPriceAfterTax());

            }
            if (EmptyUtil.isNotEmpty(orderCostList)) {
                for (PcsPurchaseOrderCost pcsPurchaseOrderCost : orderCostList) {
                    totalAmount = totalAmount.add(pcsPurchaseOrderCost.getAfterTaxesAmount() == null ? BigDecimal.ZERO : pcsPurchaseOrderCost.getAfterTaxesAmount());
                    totalAmountAfterTax = totalAmountAfterTax.add(pcsPurchaseOrderCost.getPreTaxesAmount() == null ? BigDecimal.ZERO : pcsPurchaseOrderCost.getPreTaxesAmount());
                }
            }
            //totalAmount = totalAmount.add(pcsPurchaseOrder.getOtherFee());
            //otherFeeAfterTax = pcsPurchaseOrder.getOtherFee().divide(pcsPurchaseOrder.getOtherFeeTaxRate().add(new BigDecimal(1)), 2,  BigDecimal.ROUND_HALF_EVEN);
            totalAmountAfterTax = totalAmountAfterTax.add(otherFeeAfterTax);
            totalTax = totalAmount.subtract(totalAmountAfterTax);
        }
        //pcsPurchaseOrder.setPcsPoLineVOList(pcsPoLineList);

        //totalAmountAfterTax = totalAmountAfterTax.add(pcsPurchaseOrder.getOtherFee());
        //物流费用

        if ((EmptyUtil.isNotEmpty(pcsPurchaseOrder.getCrossBorderFlag()) && pcsPurchaseOrder.getCrossBorderFlag() == 0) &&
                (EmptyUtil.isNotEmpty(pcsPurchaseOrder.getIncludeShipment()) && pcsPurchaseOrder.getIncludeShipment() == 0)) {
            BigDecimal logisticsCost = pcsPurchaseOrder.getLogisticsCost() == null ? new BigDecimal(0.0) : pcsPurchaseOrder.getLogisticsCost();
            totalAmount = totalAmount.add(logisticsCost);
            pcsPurchaseOrder.setTotalAmount(totalAmount);
            pcsPurchaseOrder.setTotalAmountAfterTax(totalAmountAfterTax.add(logisticsCost));
            //totalAmountAfterTax = totalAmountAfterTax.add(pcsPurchaseOrder.getTaxes());
        }
        pcsPurchaseOrder.setOtherFeeTaxRate(pcsPurchaseOrder.getOtherFeeTaxRate());
        Long poId = pcsPurchaseOrder.getId();
        BigDecimal purchaseCurrencyRate = pcsPurchaseOrder.getPurchaseCurrencyRate();
        //sum POP费用
        if (poId != null) {
            PcsPoPlanCost sumPoPlanCost = pcsPoPlanCostMapper.sumPopFeeByPoId(poId);
            if (sumPoPlanCost != null) {
                totalAmount.add(sumPoPlanCost.getAfterTaxAmount().divide(purchaseCurrencyRate, ROUND_HALF_DOWN));
                totalAmountAfterTax.add(sumPoPlanCost.getPreTaxAmount().divide(purchaseCurrencyRate, ROUND_HALF_DOWN));
            }
        }
        pcsPurchaseOrder.setTotalAmount(totalAmount);
        pcsPurchaseOrder.setTotalAmountAfterTax(totalAmountAfterTax);
    }

  /*@Override
  public void computeTotalPrice(PcsPurchaseOrderVO pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, List<PcsPurchaseOrderCost> orderCostList) {
    BigDecimal totalAmount =  new BigDecimal(0.00);
    BigDecimal totalTax = new BigDecimal(0.00);
    BigDecimal totalAmountAfterTax = new BigDecimal(0.00);
    BigDecimal otherFeeAfterTax = new BigDecimal(0.00);

    if(EmptyUtil.isNotEmpty(pcsPoLineList)) {
      for(PcsPoLine pcsPoLine : pcsPoLineList) {
        BigDecimal unitPrice = pcsPoLine.getUnitPrice();
        int quantity = pcsPoLine.getQuantity();
        BigDecimal taxRate = pcsPoLine.getTaxRate();

        taxRate = taxRate.add(new BigDecimal(1));
        BigDecimal unitPriceAfterTax = pcsPoLine.getUnitPrice().divide(taxRate, 4,  BigDecimal.ROUND_HALF_EVEN);
        pcsPoLine.setTotalPrice(unitPrice.multiply(new BigDecimal(quantity) ));
        totalAmount = totalAmount.add(pcsPoLine.getTotalPrice());
        pcsPoLine.setUnitPriceAfterTax(unitPriceAfterTax);
        pcsPoLine.setTotalPriceAfterTax(unitPriceAfterTax.multiply(new BigDecimal(quantity)));
        pcsPoLine.setTaxRate(pcsPoLine.getTaxRate());
        totalAmountAfterTax = totalAmountAfterTax.add(pcsPoLine.getTotalPriceAfterTax());

      }
      if(EmptyUtil.isNotEmpty(orderCostList)) {
        for(PcsPurchaseOrderCost pcsPurchaseOrderCost : orderCostList) {
          totalAmount = totalAmount.add(pcsPurchaseOrderCost.getAfterTaxesAmount() == null ? BigDecimal.ZERO : pcsPurchaseOrderCost.getAfterTaxesAmount());
          totalAmountAfterTax = totalAmountAfterTax.add(pcsPurchaseOrderCost.getPreTaxesAmount() == null ? BigDecimal.ZERO : pcsPurchaseOrderCost.getPreTaxesAmount());
        }
      }
      //totalAmount = totalAmount.add(pcsPurchaseOrder.getOtherFee());
      //otherFeeAfterTax = pcsPurchaseOrder.getOtherFee().divide(pcsPurchaseOrder.getOtherFeeTaxRate().add(new BigDecimal(1)), 2,  BigDecimal.ROUND_HALF_EVEN);
      totalAmountAfterTax = totalAmountAfterTax.add(otherFeeAfterTax);
      totalTax = totalAmount.subtract(totalAmountAfterTax);
    }
    //pcsPurchaseOrder.setPcsPoLineVOList(pcsPoLineList);
    pcsPurchaseOrder.setTotalAmount(totalAmount);
    pcsPurchaseOrder.setTotalAmountAfterTax(totalAmountAfterTax);
    //totalAmountAfterTax = totalAmountAfterTax.add(pcsPurchaseOrder.getOtherFee());
    //物流费用

    if((EmptyUtil.isNotEmpty(pcsPurchaseOrder.getCrossBorderFlag()) && pcsPurchaseOrder.getCrossBorderFlag() == 0) &&
            (EmptyUtil.isNotEmpty(pcsPurchaseOrder.getIncludeShipment()) && pcsPurchaseOrder.getIncludeShipment() == 0)) {
      BigDecimal  logisticsCost = pcsPurchaseOrder.getLogisticsCost() == null ? new BigDecimal(0.0) : pcsPurchaseOrder.getLogisticsCost();
      totalAmount = totalAmount.add(logisticsCost);
      pcsPurchaseOrder.setTotalAmount(totalAmount);
      pcsPurchaseOrder.setTotalAmountAfterTax(totalAmountAfterTax.add(logisticsCost));
      //totalAmountAfterTax = totalAmountAfterTax.add(pcsPurchaseOrder.getTaxes());
    }
    pcsPurchaseOrder.setOtherFeeTaxRate(pcsPurchaseOrder.getOtherFeeTaxRate());
  }*/

    @Override
    @Transactional
    public Boolean updatePurchaseOrderAndLine(List<PcsPoLine> pcsPoLineList,
                                              PcsPurchaseOrderVO pcsPurchaseOrderVO) {


        PcsPurchaseOrder pcsPurchaseOrder = BeanUtil.buildFrom(pcsPurchaseOrderVO, PcsPurchaseOrder.class);
        pcsPurchaseOrder.setPurchaseCurrencyRate(pcsPurchaseOrderVO.getRate());
        Long poId = pcsPurchaseOrder.getId();

        //删除行
        List<Long> delLineIds = pcsPurchaseOrderVO.getDelLineIds();
        if (delLineIds != null && delLineIds.size() > 0) {
            deletePcsPoLine(poId, delLineIds);
        }
        PcsPurchaseOrderVO oldPcsPurchaseOrder = findPurchaseOrderById(poId);
        int passTimes = getPoPassApprovalTimes(poId);
        boolean saveDraft = checkPurchaseOrderApprovalFields(pcsPurchaseOrderVO, oldPcsPurchaseOrder, passTimes);
        List<PcsPurchaseOrderCost> orderCostList = pcsPurchaseOrderVO.getOrderCostList();
        List<PcsPurchaseOrderCost> oldOrderCostList = passTimes == 0 ? orderCostList : oldPcsPurchaseOrder.getOrderCostList();
        computeTotalPrice(pcsPurchaseOrder, pcsPoLineList, oldOrderCostList);
        if (pcsPoLineList.size() == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "至少需要一个行信息");
        }
        PcsPurchaseOrder newPcsPurchaseOrder = null;
        try {
            newPcsPurchaseOrder = (PcsPurchaseOrder) pcsPurchaseOrder.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }

        //提交
        if (!saveDraft) {
            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT);
            pcsPurchaseOrder.setLastSubmitTime(new Date());

            checkSkuStatus(pcsPoLineList);
            List<PcsPoLine> oldPcsPoLineList = passTimes == 0 ? pcsPoLineList : pcsPoLineService.findPoLineByPoId(poId);
            computeTotalPrice(pcsPurchaseOrder, oldPcsPoLineList, oldOrderCostList);

            updatePurchaseOrderCosts(oldOrderCostList, pcsPurchaseOrder.getId());

            if (passTimes > 0) {
                pcsPurchaseOrder.setPurchaseCurrencyCode(null);
                pcsPurchaseOrder.setPurchaseCurrencyDesc(null);
                pcsPurchaseOrder.setPurchaseCurrencyRate(null);
            }
        } else {
            updatePurchaseOrderCosts(orderCostList, pcsPurchaseOrder.getId());
        }
        pcsPurchaseOrder.setIncludeShipment(checkIsContainFreight(oldOrderCostList) ? (short) 0 : 1);
        Boolean update = update(pcsPurchaseOrder);

        if (update) {
            //保存行信息才直接生效
            if (saveDraft || passTimes == 0) {
                for (PcsPoLine pcsPoLine : pcsPoLineList) {
            	
            	/* PcsSkuVO pcsSkuVO = mcPcsSkuService.findByCode(pcsPoLine.getSkuCode());
                 if(EmptyUtil.isNotEmpty(pcsSkuVO)) {
                	BigDecimal rate = pcsPurchaseOrder.getPurchaseCurrencyRate() == null ? new BigDecimal(1.0) : pcsPurchaseOrder.getPurchaseCurrencyRate();
                 	if(pcsPoLine.getUnitPrice().multiply(rate).compareTo(pcsSkuVO.getCostPrice().multiply(new BigDecimal(1.02))) > 0) {
                 		throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM,"[" + pcsSkuVO.getCode() + "]" + pcsSkuVO.getNameCn() +  "采购价不得高于成本价2%");
                 	}
                 }*/
            	/*//SKU没有完成售价审核
            	if(!saveDraft && EmptyUtil.isEmpty(mcPcsSkuService.findAuditRecordsByCodeAndStatus(pcsPoLine.getSkuCode(), PcsSkuSalesPriceChange.STATUS_SUCCESS))) {
            		 throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "采购单中存在售价审批未通过的SKU，提交失败");
            	}*/
                    if (EmptyUtil.isEmpty(pcsPoLine.getId())) {
                        pcsPoLine.setPoId(pcsPurchaseOrder.getId());
                        if (pcsPoLineService.create(pcsPoLine).compareTo(0L) < 1) {
                            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "行信息保存失败," + pcsPoLine.toString());
                        }
                    } else {
                        if (!pcsPoLineService.update(pcsPoLine)) {
                            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "行信息更新失败," + pcsPoLine.toString());
                        }
                    }
                }
            }


            // 更新 po Credit Note
//            updateCreatePcsPoCreditNoteVO(pcsPurchaseOrderVO.getPcsPoCreditNoteVOs(), oldPcsPurchaseOrder.getCode());

            // 保存po 其它附件
            updatePoOtherAttachments(pcsPurchaseOrderVO.getOtherAttachmentList(), pcsPurchaseOrder.getId());

            //生成审核记录
            if (!saveDraft) {
                //记录提交前采购单的状态
                newPcsPurchaseOrder.setPurchaseOrderStatus(oldPcsPurchaseOrder.getPurchaseOrderStatus());
                savePoAndLineApprovalRecord(newPcsPurchaseOrder, pcsPoLineList, orderCostList);
            }
            return true;
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "头信息更新失败," + pcsPurchaseOrder.toString());
        }
    }

    private void checkSkuStatus(List<PcsPoLine> pcsPoLineList) {
        List<String> skuCodeList = new ArrayList<String>();
        for (PcsPoLine pcsPoLine : pcsPoLineList) {
            skuCodeList.add(pcsPoLine.getSkuCode());
        }
        Map<String, PcsSkuAuditRecordsVO> map = mcPcsSkuService.mapAuditRecordsByCodeAndStatus(skuCodeList, PcsSkuSalesPriceChangeStatusEnum.COMPLETED_REVIEW.getStatus());
        Map<String, PcsSkuVO> skuDTOMap = mcPcsSkuService.mapSkuByCodes(skuCodeList);

        StringBuilder sb = new StringBuilder();
        for (String skuCode : skuCodeList) {
            if (!map.containsKey(skuCode)) {
                sb.append("[").append(skuCode).append("]")
                        .append(skuDTOMap.get(skuCode).getNameCn()).append(",")
                        .append(PcsSkuStatusEnum.getDesc(skuDTOMap.get(skuCode).getSkuStatus())).append("</br>");
            }
            PcsSkuVO skuDTO = skuDTOMap.get(skuCode);
            //不能采购
            if (PegasusConstants.NO == skuDTO.getCanPurchase()) {
                sb.append("[").append(skuCode).append("]")
                        .append(skuDTO.getNameCn()).append(",")
                        .append("已经停止采购，如有问题请联系采购员").append(skuDTO.getRealName()).append("</br>");
            }
        }
        if (EmptyUtil.isNotEmpty(sb)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "以下SKU未审批通过，提交失败</br>" + sb.toString());
        }

    }

    /**
     * 审批通知
     */
    private void sendNotice(String code) {
//    	 final SmsUtil smsUtil = SmsUtil.getInstance();
//         final SmsVO smsVO = new SmsVO();
//         smsVO.setSendTime(new Date());
        CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance()
                .findConfigByKey("planner.Approval.Mobile");
        // 收件人
        String[] toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        if (toNotifyUsers != null && toNotifyUsers.length > 0) {
            List<MsgSingleVo> msgSingleVoList = new ArrayList<>();
            for (String mobile : toNotifyUsers) {
                MsgSingleVo msgSingleVo = new MsgSingleVo();
                msgSingleVo.setMsgTo(mobile);
                msgSingleVo.setContent("您好，您有新的采购单需要审批，采购单code：" + code + "，请尽快审批，谢谢！");
                msgSingleVo.setMsgType(MsgTypeEnum.SmsMsg);
                msgSingleVo.setPublishType(PublishTypeEnum.IDENTIFYING_CODE);
                msgSingleVoList.add(msgSingleVo);
            }
            msgSendService.sendInterfaceVO(msgSingleVoList);
        }
// 		smsVO.setMobileList(Arrays.asList(toNotifyUsers));
//
// 		smsVO.setContent("您好，您有新的采购单需要审批，采购单code："+ code +"，请尽快审批，谢谢！");
// 		smsUtil.send(smsVO);

        // 邮件VO
        commGlobalConfig = PegasusUtilFacade.getInstance()
                .findConfigByKey("planner.Approval.Email");
        toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
        emailVO.setSubject("采购单审批");
        emailVO.setContent("您好，您有新的采购单需要审批，采购单 code：" + code + "，请尽快审批，谢谢！");
        // 发邮件
        if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
            // 正式环境发邮件
            EmailUtil.getInstance().send(emailVO);
        }
    }

    @Override
    public List<String> findWarehouseCodeGroup() {
        List<String> warehouseCodeList = pcsPurchaseOrderMapper.findWarehouseCodeGroup();
        if (CollectionUtils.isEmpty(warehouseCodeList)) {
            return Collections.emptyList();
        } else {
            return warehouseCodeList;
        }
    }

    @Override
    public List<PcsPurchaseOrderVO> findPoInfoByWarehouseCodeGroup() {
        List<PcsPurchaseOrderVO> purchaseOrderVOs = pcsPurchaseOrderMapper.findPoInfoByWarehouseCodeGroup();
        if (CollectionUtils.isEmpty(purchaseOrderVOs)) {
            return Collections.emptyList();
        } else {
            return purchaseOrderVOs;
        }
    }

    @Override
    @Transactional
    public Boolean auditPurchaseOrder(long id, Boolean isPass, Integer type) {
        PcsPurchaseOrderVO record = findPoVOForApprovalById(id, true);
        Integer poStatusBeforeAudit = record.getPurchaseOrderStatus();
        if (EmptyUtil.isNotEmpty(record) && (record.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT) ||
                record.getPurchaseOrderStatus() == 4 || record.getPurchaseOrderStatus() == 6)) {
            record.setAuditTime(new Date());
            if (isPass) {
                if (type == 1) {
                    record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                } else if (type == 2) {//品类经理审批->plannint审批
                    if (poStatusBeforeAudit != PoStatusEnum.PURCHASE_ORDER_STATUS_WAITING_AUDIT.getKey()) {
                        throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "状态已更新，请检查单据的最新状态");
                    }
                    record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_FINANCE_APPROVEL);
                } else if (type == 6) {//planner审批->待收货
                    if (poStatusBeforeAudit != PoStatusEnum.PURCHASE_ORDER_STATUS_WAIT_FINANCE_APPROVEL.getKey()) {
                        throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "状态已更新，请检查单据的最新状态");
                    }
                    record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                    List<PcsPoPlan> pcsPoPlanList = pcsPoPlanService.findPcsPoPlanByPoId(record.getId());
                    if (pcsPoPlanList != null && pcsPoPlanList.size() > 0) {
                        for (PcsPoPlan pcsPoPlan : pcsPoPlanList) {
                            if (!pcsPoPlan.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_FINISHED) && !pcsPoPlan.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_CLOSED)) {
                                record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE);
                                break;
                            }
                        }
                    }
                } else if (type == 0) {
                    record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                }
            } else {
                //重新打开驳回状态是已完成
                if (EmptyUtil.isNotEmpty(record.getNewAskDeliveryDate())) {
                    record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH);
                } else {
                    record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT);
                }
            }
            auditPoHandle(id, record);
            boolean update = update(BeanUtil.buildFrom(record, PcsPurchaseOrder.class));
            if (update) {
                return true;
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "审核更新数据库失败");
            }
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "必须是待审核状态");
        }
    }

    /**
     * 审核通过PO_LINE
     *
     * @param newestApprovalRecord
     */
    private void auditPoLineHandle(PcsPoApprovalRecords newestApprovalRecord) {
        if (newestApprovalRecord != null) {
            List<PcsPoLineApprovalRecord> poLineApprovalRecords = pcsPoLineApprovalRecordMapper.selectByApprovalRecordId(newestApprovalRecord.getId());

            List<PcsPoLineVO> pcsPoLineList = BeanUtil.buildListFrom(poLineApprovalRecords, PcsPoLineVO.class);
            if (pcsPoLineList == null || pcsPoLineList.size() == 0) {
                return;
            }
            for (PcsPoLineApprovalRecord poLineApprovalRecord : poLineApprovalRecords) {
                PcsPoLineVO pcsPoLineVO = BeanUtil.buildFrom(poLineApprovalRecord, PcsPoLineVO.class);
                if (poLineApprovalRecord.getPoLineId() == null) {
                    pcsPoLineService.create(BeanUtil.buildFrom(poLineApprovalRecord, PcsPoLine.class));
                } else {
                    pcsPoLineVO.setId(poLineApprovalRecord.getPoLineId());
                    pcsPoLineService.update(pcsPoLineVO);
                }
            }
        }

    }

    /**
     * 审核通过PO_COST
     *
     * @param
     */
    private void auditPoCostHandle(Long approvalRecordId) {
        List<PcsPurchaseOrderCost> pcsPurchaseOrderCosts = findPoCostApprovalRecords(approvalRecordId);
        for (PcsPurchaseOrderCost purchaseOrderCost : pcsPurchaseOrderCosts) {
            pcsPurchaseOrderCostMapper.updateByPoIdAndCostType(purchaseOrderCost);
        }
    }

    private void auditPoHandle(Long poId, PcsPurchaseOrderVO record) {
        Integer poApprovalStatus = record.getPurchaseOrderStatus();
        PcsPoApprovalRecords newestApprovalRecord = findNewestApprovalRecordsByPoId(poId);
        newestApprovalRecord.setPoApprovalStatus(poApprovalStatus);
        //审核通过
        if (PoStatusEnum.PURCHASE_ORDER_STATUS_WAIT_RECEIVE.getKey().equals(poApprovalStatus)) {
            auditPoLineHandle(newestApprovalRecord);
            auditPoCostHandle(newestApprovalRecord.getId());
            newestApprovalRecord.setEffectiveTime(new Date());
            //采购单币种生效
            record.setPurchaseCurrencyRate(newestApprovalRecord.getPurchaseCurrencyRate());
            record.setPurchaseCurrencyCode(newestApprovalRecord.getPurchaseCurrencyCode());
            record.setPurchaseCurrencyDesc(newestApprovalRecord.getPurchaseCurrencyDesc());
        }
        pcsPoApprovalRecordsMapper.updateByPrimaryKeySelective(newestApprovalRecord);
    }

    @Override
    @Transactional
    public Boolean closePurchaseOrder(long id) {
        PcsPurchaseOrder record = findPoById(id);
        if (EmptyUtil.isNotEmpty(record) && (record.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE))) {
            record.setFinishedTime(new Date());
            record.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH);
            boolean update = update(record);
            if (update) {
                if (record.getPurchaseOrderCostCenter() != null) {
                    // 如果采购单关闭时间跟采购单要求交货日期不是一个月，则关闭采购单时释放采购单预算到当前月给财务
                    String po_Time = DateFormatUtils.format(record.getAskDeliveryDate(), "yyyy-MM");
                    String now = DateFormatUtils.format(new Date(), "yyyy-MM");
                    if (!po_Time.equals(now)) {
                        List<PcsPoLine> poLineList = pcsPoLineService.findPoLineByPoId(id);
                        List<PcsPoPlanLine> poPlanLineList = pcsPoPlanLineService.findPoPlanLineByPoId(id);
                        BigDecimal poLineSum = BigDecimal.ZERO;
                        BigDecimal poPlanLineSum = BigDecimal.ZERO;
                        // PcsPoLine 里面税前税后是倒过来的，PcsPoPlanLine里面税前税后是正确的
                        for (PcsPoLine poLine : poLineList) {
                            poLineSum = poLineSum.add(poLine.getUnitPriceAfterTax().multiply(new BigDecimal(poLine.getQuantity())));
                        }
                        for (PcsPoPlanLine poPlanLine : poPlanLineList) {
                            BigDecimal q = poPlanLine.getQuantity() == null ? BigDecimal.ZERO : new BigDecimal(poPlanLine.getQuantity());
                            BigDecimal wq = poPlanLine.getWasteQuantity() == null ? BigDecimal.ZERO : new BigDecimal(poPlanLine.getWasteQuantity());
                            poPlanLineSum = poPlanLineSum.add(poPlanLine.getUnitPrice().multiply(q.add(wq)));
                        }

                        if (poPlanLineSum.intValue() != 0 && EmptyUtil.isNotEmpty(record.getPurchaseCurrencyRate())) {
                            BigDecimal extra_cost = poLineSum.subtract(poPlanLineSum).multiply(record.getPurchaseCurrencyRate());
                            extra_cost = extra_cost.setScale(2, BigDecimal.ROUND_HALF_UP);

                            Integer budgetYear = Integer.parseInt(now.substring(0, 4));
                            Integer budgetMonth = Integer.parseInt(now.substring(now.length() - 2, now.length()));

                            Map<String, Object> params = new HashMap<>();
                            params.put("budgetYear", budgetYear);
                            params.put("budgetMonth", budgetMonth);
                            params.put("categoryId", record.getPurchaseOrderCostCenter());
                            List<OpFinanceBudget> budgets = pcsPurchaseOrderMapper.findOpFinanceBudgetByParams(params);
                            if (CollectionUtils.isEmpty(budgets)) {
                                OpFinanceBudget budget = new OpFinanceBudget();
                                budget.setBudgetMonth(budgetMonth);
                                budget.setBudgetYear(budgetYear);
                                budget.setCategoryId(record.getPurchaseOrderCostCenter());
                                budget.setCreateTime(new Date());
                                budget.setExtraBudget(extra_cost);
                                budget.setTotalBudget(extra_cost);
                                pcsPurchaseOrderMapper.insertOpFinanceBudget(budget);
                            } else {
                                OpFinanceBudget budget = budgets.get(0);
                                BigDecimal extraBudget = budget.getExtraBudget() == null ? BigDecimal.ZERO :
                                        budget.getExtraBudget();
                                budget.setExtraBudget(extraBudget.add(extra_cost));
                                budget.setTotalBudget(budget.getTotalBudget().add(extra_cost));
                                pcsPurchaseOrderMapper.updateOpFinanceBudget(budget);
                            }
                        }
                    }
                }
                return true;
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "关闭采购单更新数据库失败");
            }
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "待收货的采购单才能整单关闭！");
        }
    }

    @Override
    @Transactional
    public Boolean deletePcsPoLine(long poId, long pcsPoLineId) {
        final PcsPurchaseOrder pcsPurchaseOrder = findPoById(poId);
        if (EmptyUtil.isNotEmpty(pcsPurchaseOrder)
                && EmptyUtil.isNotEmpty(pcsPurchaseOrder.getPurchaseOrderStatus())
                && (pcsPurchaseOrder.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_DRAFT)
                || pcsPurchaseOrder.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_REJECT)
        )
        ) {
            final PcsPoLine pcsPoLine = pcsPoLineService.findPoLineById(pcsPoLineId);
            if (EmptyUtil.isNotEmpty(pcsPoLine) && EmptyUtil.isNotEmpty(pcsPoLine.getPoId()) && pcsPoLine.getPoId().equals(poId)) {
                return pcsPoLineService.deleteById(pcsPoLineId);
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "行Id异常");
            }
        } else {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "只有待修改状态的采购单可以删减行信息");
        }
    }

    @Override
    public int deletePcsPoLine(long poId, List<Long> delLineIds) {
        delLineIds.stream().forEach(pcsPoLineId -> {
            deletePcsPoLine(poId, pcsPoLineId);
        });
        return 0;
    }

    @Override
    @Transactional
    public Boolean batchUpdatePcsPoLine(PcsPurchaseOrderVO pcsPoVO, Long operatorId) {
        final PcsPurchaseOrder pcsPurchaseOrder = findPoById(pcsPoVO.getId());
        if (EmptyUtil.isEmpty(pcsPurchaseOrder)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "匹配不到采购单");
        }
        List<PcsPoLineVO> pcsPoLineVOs = pcsPoVO.getPcsPoLineVOList();
        if (EmptyUtil.isEmpty(pcsPoLineVOs)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "匹配不到采购单行信息");
        }
        for (PcsPoLineVO pcsPoLineVO : pcsPoLineVOs) {
//            PcsSkuVO pcsSkuVO = mcPcsSkuService.findByCode(pcsPoLineVO.getSkuCode());
           /* if (EmptyUtil.isNotEmpty(pcsSkuVO)) {
            	BigDecimal rate = pcsPurchaseOrder.getPurchaseCurrencyRate() == null ? new BigDecimal(1.0) : pcsPurchaseOrder.getPurchaseCurrencyRate();
                // 调整价除汇率
                if (pcsPoLineVO.getAdjustUnitPrice().divide(rate,2,BigDecimal.ROUND_HALF_EVEN).compareTo(pcsSkuVO.getCostPrice().multiply(new BigDecimal(1.02))) > 0) {
                    throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "[" + pcsSkuVO.getCode() + "]" + pcsSkuVO.getNameCn() + "采购价不得高于成本价2%");
                }
                *//*if (pcsPoLineVO.getAdjustUnitPrice().multiply(rate).compareTo(pcsSkuVO.getCostPrice().multiply(new BigDecimal(1.02))) > 0) {
                    throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "[" + pcsSkuVO.getCode() + "]" + pcsSkuVO.getNameCn() + "采购价不得高于成本价2%");
                }*//*
            }*/
            if (EmptyUtil.isNotEmpty(pcsPoLineVO.getId())) {
                // 无需更新skucode
                PcsCostAdjustExample example = new PcsCostAdjustExample();
                PcsCostAdjustExample.Criteria criteria = example.createCriteria();
                criteria.andCostTypeEqualTo(PcsCostAdjust.COST_TYPE_SKU);
                criteria.andCostIdEqualTo(pcsPoLineVO.getId());
                example.setOrderByClause("ADJUST_TIME desc");
                List<PcsCostAdjust> pcsCostAdjustList = pcsCostAdjustMapper.selectByExample(example);

                BigDecimal lastAjustAfterTaxAmount = BigDecimal.ZERO;//最近一次调整价格
                PcsCostAdjust pcsCostAdjust = new PcsCostAdjust();
                if (pcsCostAdjustList != null && pcsCostAdjustList.size() > 0) {
                    PcsCostAdjust lastPcsCostAdjust = pcsCostAdjustList.get(0);
                    lastAjustAfterTaxAmount = lastPcsCostAdjust.getAdjustAfterTaxAmount();
                    //修改前税前单价
                    pcsCostAdjust.setOldUnitPricePreTax(lastPcsCostAdjust.getAdjustUnitPricePreTax());
                } else {
                    PcsPoLine pcsPoLine = pcsPoLineService.findPoLineById(pcsPoLineVO.getId());
                    if (pcsPoLine != null) {
                        lastAjustAfterTaxAmount = pcsPoLine.getUnitPrice().multiply(pcsPurchaseOrder.getPurchaseCurrencyRate()).setScale(4, BigDecimal.ROUND_HALF_EVEN);
                        BigDecimal unitPricePreTax = pcsPoLine.getUnitPrice().divide(pcsPoLine.getTaxRate().add(new BigDecimal(1)), 4, BigDecimal.ROUND_HALF_EVEN);
                        BigDecimal unitPricePreTaxRmb = unitPricePreTax.multiply(pcsPurchaseOrder.getPurchaseCurrencyRate()).setScale(4, BigDecimal.ROUND_HALF_EVEN);
                        //修改前税前单价
                        pcsCostAdjust.setOldUnitPricePreTax(unitPricePreTaxRmb);
                    }
                }
                pcsCostAdjust.setCostId(pcsPoLineVO.getId());
                pcsCostAdjust.setCostType(PcsCostAdjust.COST_TYPE_SKU);
                pcsCostAdjust.setAdjustActualTaxrate(pcsPoLineVO.getAdjustTaxRate());//实际税率(调整后的税率)
                pcsCostAdjust.setAdjustAfterTaxAmount(pcsPoLineVO.getAdjustUnitPrice());//rmb//实付金额(调整后的金额,税后)
                //实付金额(调整后的金额,税前)
                BigDecimal preTaxAmount = pcsPoLineVO.getAdjustUnitPrice().divide(pcsPoLineVO.getAdjustTaxRate().add(new BigDecimal(1)), 4, BigDecimal.ROUND_HALF_EVEN);
                pcsCostAdjust.setAdjustPreTaxAmount(preTaxAmount);//
                pcsCostAdjust.setAdjustPersonId(operatorId);
                pcsCostAdjust.setAdjustTime(Calendar.getInstance().getTime());
                //调整幅度(与上次调整的金额差)
                BigDecimal range = pcsPoLineVO.getAdjustUnitPrice().subtract(lastAjustAfterTaxAmount).setScale(4, BigDecimal.ROUND_HALF_EVEN);
                pcsCostAdjust.setAdjustAmountRange(range);
                pcsCostAdjust.setSkuCode(pcsPoLineVO.getSkuCode());
                pcsCostAdjust.setPoCode(pcsPurchaseOrder.getCode());
                //税前差额
                //税后差额
                //修改后税前单价
                pcsCostAdjust.setAdjustUnitPricePreTax(pcsPoLineVO.getAdjustUnitPrice().divide(pcsPoLineVO.getAdjustTaxRate().add(new BigDecimal(1)), 4, BigDecimal.ROUND_HALF_EVEN));

                pcsCostAdjustMapper.insertSelective(pcsCostAdjust);
                pcsPoLineVO.setSkuCode(null);
                if (!pcsPoLineService.update(pcsPoLineVO)) {
                    throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "行信息更新失败," + pcsPoLineVO.toString());
                }
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "匹配不到采购单行信息," + pcsPoLineVO.toString());
            }
        }
        return true;
    }

    @Override
    @Transactional
    public void processReceicePlan(String poPlanCode, Map<String, Integer> liangpinMap, Map<String, Integer> canciMap) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andCodeEqualTo(poPlanCode);
        List<PcsPoPlan> pcsPoPlanList = pcsPoPlanMapper.selectByExample(example);
        if (pcsPoPlanList != null && pcsPoPlanList.size() > 0) {
            PcsPoPlan pcsPoPlan = pcsPoPlanList.get(0);
            pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_FINISHED);
            pcsPoPlan.setReceiveDate(new Date());
            pcsPoPlanMapper.updateByPrimaryKey(pcsPoPlan);
            List<PcsPoPlanLine> pcsPoPlanLineList = pcsPoPlanLineService.findPoPlanLineByPoPlanId(pcsPoPlan.getId());
            for (PcsPoPlanLine pcsPoPlanLine : pcsPoPlanLineList) {
                pcsPoPlanLine.setQuantity(liangpinMap.get(pcsPoPlanLine.getSkuCode()));
                pcsPoPlanLine.setWasteQuantity(canciMap.get(pcsPoPlanLine.getSkuCode()));
                pcsPoPlanLineService.update(pcsPoPlanLine);
            }
            int result = pcsPoPlanMapper.isAllReceivePo(pcsPoPlan.getPoId());
            //po完成收货
            if (result <= 0) {
                PcsPurchaseOrder purchaseOrder = pcsPurchaseOrderMapper.selectByPrimaryKey(pcsPoPlan.getPoId());
                if (purchaseOrder != null) {
                    purchaseOrder.setFinishedTime(Calendar.getInstance().getTime());
                    purchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_ALREADY_FINISH);
                    pcsPurchaseOrderMapper.updateByPrimaryKey(purchaseOrder);
                }
            } else { //po未完成收货
                int allPoPlanFinished = pcsPoPlanMapper.isAllPoPlanFinished(pcsPoPlan.getPoId());
                //收货计划都完成
                if (allPoPlanFinished == 0) {
                    PcsPurchaseOrder purchaseOrder = pcsPurchaseOrderMapper.selectByPrimaryKey(pcsPoPlan.getPoId());
                    if (purchaseOrder != null) {
                        purchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                        pcsPurchaseOrderMapper.updateByPrimaryKey(purchaseOrder);
                    }
                }
            }
        }
    }

    @Override
    public boolean updatePurchaseOrder(PcsPurchaseOrder record) {
        return pcsPurchaseOrderMapper.updateByPrimaryKeySelective(record) != 0;
    }


    @Override
    public long countByCond(PcsPurchaseOrderCond cond) {
        return pcsPurchaseOrderMapper.countByCond(cond);
    }

    @Override
    public PcsPurchaseReturn bulidFromVO(PcsPurchaseReturnVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsPurchaseReturn record = new PcsPurchaseReturn();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    public PcsPurchaseReturnSku bulidFromVO(PcsPurchaseReturnSkuVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsPurchaseReturnSku record = new PcsPurchaseReturnSku();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    @Transactional
    public Long createPurchaseReturnAndLine(PcsPurchaseReturn pcsPurchaseReturn, List<PcsPurchaseReturnSku> returnSkuVOList, boolean saveDraft) throws Exception {
        pcsPurchaseReturn.setCreateTime(new Date());
        pcsPurchaseReturn.setAvailable(true);
        if (saveDraft) {
            pcsPurchaseReturn.setReturnStatus(PcsPurchaseReturn.PURCHASE_RETURN_STATUS_DRAFT);
        } else {
            pcsPurchaseReturn.setReturnStatus(PcsPurchaseReturn.PURCHASE_RETURN_STATUS_WAITING_AUDIT);
        }
        // 新增采退单
        Long purchaseReturnId = savePurchaseReturnAndLine(pcsPurchaseReturn, returnSkuVOList);
        if (!saveDraft) {
            PcsPurchaseReturnVO pcsPurchaseReturnVO = this.findPRVOById(pcsPurchaseReturn.getId(), true);

            // boolean good = true;
            // 指令SKU列表
            List<WhCommandSkuVO> whCommandSkuList = new ArrayList<>();
            for (PcsPurchaseReturnSkuVO pcsPurchaseReturnSkuVO : pcsPurchaseReturnVO.getReturnSkuVOList()) {
                WhCommandSkuVO whCommandSku = new WhCommandSkuVO();
                whCommandSku.setSkuCode(pcsPurchaseReturnSkuVO.getSkuCode());
                whCommandSku.setPlanedQuantity(pcsPurchaseReturnSkuVO.getExpectedQuantity());
                whCommandSkuList.add(whCommandSku);
            }
            // 记录采退出库指令
            WhCommandVO whCommandOut = new WhCommandVO();
            whCommandOut.setReferenceCode(pcsPurchaseReturnVO.getCode());
            whCommandOut.setInOutType(SStockInOutTypeEnum.OUT_TYPE_PURCHASE_RETURN.getCode());
            whCommandOut.setExpressType(Integer.parseInt(pcsPurchaseReturn.getExpressType() + ""));
            whCommandOut.setPlanedDeliveryDate(DateUtil.getNow());////冗余预计发货日期

            //OMS二期 [物理仓默认为原始采购单的收货仓,逻辑仓为物理仓对应的默认出库仓(按良品、残次)]
            whCommandOut.setWarehouseCode(pcsPurchaseReturnVO.getWarehouseCode());
            whCommandOut.setPhysicalWarehouseCode(pcsPurchaseReturnVO.getTargetWarehouse());
            whCommandOut.setWhCommandSkuList(whCommandSkuList);
            checkSkuStock(whCommandOut);
            wWhCommandService.createCommand(whCommandOut);
        }
        return purchaseReturnId;
    }

    private Long savePurchaseReturnAndLine(PcsPurchaseReturn pcsPurchaseReturn, List<PcsPurchaseReturnSku> returnSkuVOList) {
        if (EmptyUtil.isNotEmpty(returnSkuVOList)) {
            pcsPurchaseReturnMapper.insertSelective(pcsPurchaseReturn);
            Long purchaseReturnId = pcsPurchaseReturn.getId();
            pcsPurchaseReturn.setCode(generateReturnCode(purchaseReturnId));
            updatePurchaseReturn(pcsPurchaseReturn);
            if (EmptyUtil.isNotEmpty(returnSkuVOList)) {
                for (PcsPurchaseReturnSku pcsPurchaseReturnSku : returnSkuVOList) {
                    pcsPurchaseReturnSku.setPurchaseReturnId(purchaseReturnId);
                    pcsPurchaseReturnSkuMapper.insertSelective(pcsPurchaseReturnSku);
                    pcsPurchaseReturnSku.setCode(generateReturnLineCode(pcsPurchaseReturnSku.getId(), pcsPurchaseReturn.getCode()));
                    pcsPurchaseReturnSkuMapper.updateByPrimaryKeySelective(pcsPurchaseReturnSku);
                }
            }
            return purchaseReturnId;
        }
        return 0L;
    }

    /**
     * 良品和残次分开新建采退单
     *
     * @param returnSkuVOList
     * @param flag
     * @return
     */
    private List<PcsPurchaseReturnSku> getSkuVOList(List<PcsPurchaseReturnSku> returnSkuVOList, boolean flag) {
        List<PcsPurchaseReturnSku> lineList = new ArrayList<>();
        for (PcsPurchaseReturnSku pcsPurchaseReturnSku : returnSkuVOList) {
            //良品
            if (flag && pcsPurchaseReturnSku.getSkuType() == 1) {
                lineList.add(pcsPurchaseReturnSku);
            }
            //残次
            if (!flag && pcsPurchaseReturnSku.getSkuType() == 0) {
                lineList.add(pcsPurchaseReturnSku);
            }
        }
        return lineList;
    }

    @Override
    @Transactional
    public Boolean updatePurchaseReturnAndLine(PcsPurchaseReturn pcsPurchaseReturn, List<PcsPurchaseReturnSku> returnSkuVOList, boolean saveDraft) throws Exception {

        PcsPurchaseReturnVO pcsPurchaseReturnVO = this.findPRVOById(pcsPurchaseReturn.getId(), true);
        if (!saveDraft) {
            pcsPurchaseReturn.setReturnStatus(PcsPurchaseReturn.PURCHASE_RETURN_STATUS_WAITING_AUDIT);
        }
        updatePurchaseReturn(pcsPurchaseReturn);
        if (EmptyUtil.isNotEmpty(returnSkuVOList)) {
            List<PcsPurchaseReturnSkuVO> hisLine = pcsPurchaseReturnVO.getReturnSkuVOList();
            for (PcsPurchaseReturnSkuVO pcsPurchaseReturnSkuVO : hisLine) {
                Long lineId = pcsPurchaseReturnSkuVO.getId();
                boolean isDel = true;
                for (PcsPurchaseReturnSku pcsPurchaseReturnSku : returnSkuVOList) {
                    if (lineId.equals(pcsPurchaseReturnSku.getId())) {
                        isDel = false;
                    }
                }

                //删除行
                if (isDel) {
                    pcsPurchaseReturnSkuMapper.deleteByPrimaryKey(lineId);
                }
            }
            for (PcsPurchaseReturnSku pcsPurchaseReturnSku : returnSkuVOList) {
                //Long purchaseReturnLineId = pcsPurchaseReturnSkuMapper.insertSelective(pcsPurchaseReturnSku);
                //pcsPurchaseReturnSku.setCode(generateReturnLineCode(purchaseReturnLineId, pcsPurchaseReturnSku.getCode()));
                if (pcsPurchaseReturnSku.getId() != null) {
                    pcsPurchaseReturnSkuMapper.updateByPrimaryKeySelective(pcsPurchaseReturnSku);
                } else {
                    pcsPurchaseReturnSku.setPurchaseReturnId(pcsPurchaseReturn.getId());
                }
            }
        }

        if (!saveDraft) {
            pcsPurchaseReturnVO = this.findPRVOById(pcsPurchaseReturn.getId(), true);
            // boolean good = true;
            // 指令SKU列表
            List<WhCommandSkuVO> whCommandSkuList = new ArrayList<>();
            for (PcsPurchaseReturnSkuVO pcsPurchaseReturnSkuVO : pcsPurchaseReturnVO.getReturnSkuVOList()) {
                WhCommandSkuVO whCommandSku = new WhCommandSkuVO();
                whCommandSku.setSkuCode(pcsPurchaseReturnSkuVO.getSkuCode());
                whCommandSku.setPlanedQuantity(pcsPurchaseReturnSkuVO.getExpectedQuantity());
                whCommandSkuList.add(whCommandSku);
               /*if(pcsPurchaseReturnSkuVO.getSkuType() == 0) {
            	   good = false;
               }*/
            }
            // 记录采退出库指令
            WhCommandVO whCommandOut = new WhCommandVO();
            whCommandOut.setReferenceCode(pcsPurchaseReturnVO.getCode());
            whCommandOut.setInOutType(WhCommandVO.TYPE_PURCHASE_RETURN_OUT);
            whCommandOut.setExpressType(Integer.parseInt(pcsPurchaseReturn.getExpressType() + ""));
            whCommandOut.setPlanedDeliveryDate(DateUtil.getNow());//冗余预计发货日期
           /*if(good) {
        	   whCommandOut.setWarehouseCode("WH020600010096");
           } else {
        	   whCommandOut.setWarehouseCode("WH020600010097");
           }*/
            //OMS二期 [物理仓默认为原始采购单的收货仓,逻辑仓为物理仓对应的默认出库仓(按良品、残次)]
            whCommandOut.setWarehouseCode(pcsPurchaseReturnVO.getWarehouseCode());
            whCommandOut.setPhysicalWarehouseCode(pcsPurchaseReturnVO.getTargetWarehouse());
            whCommandOut.setWhCommandSkuList(whCommandSkuList);

            checkSkuStock(whCommandOut);
            String outCmdCode = wWhCommandService.createCommand(whCommandOut);
        }
        return null;
    }

    /**
     * 校验库存 逻辑仓/物理仓库存
     *
     * @param whCommand
     */
    private void checkSkuStock(WhCommandVO whCommand) {
        // 设置物理仓库存查询条件
        PhyWhStockCond phyWhStockCond = new PhyWhStockCond();
        phyWhStockCond.setPhysicalWarehouseCode(whCommand.getPhysicalWarehouseCode());
        WhWarehouseVO whWarehouse = sWhInfoService.findWarehouseByCode(whCommand.getWarehouseCode());
        phyWhStockCond.setSkuStatus(whWarehouse.getCommodityStatus());
        for (WhCommandSkuVO commandSku : whCommand.getWhCommandSkuList()) {
            WhInvVO whInvVO = sWhInvService.findCanUseQttBySkuCodeAndWarehouseCode(commandSku.getSkuCode(), whCommand.getWarehouseCode());
            if (commandSku.getPlanedQuantity() > whInvVO.getCanUseInv())
                throw new PurchaseException("", "SKU[" + commandSku.getSkuCode() + "]," + WhWarehouseVO.getSkuStatusName(whWarehouse.getCommodityStatus()) + ",在[" + whWarehouse.getName() + "]中的可用库存不足");
            // 校验物理仓库存
            phyWhStockCond.setSkuCode(commandSku.getSkuCode());
            int physicalSkuStockCount = findPhysicalSkuStock(phyWhStockCond);
            if (commandSku.getPlanedQuantity() > physicalSkuStockCount) {
                throw new PurchaseException("", "物理仓库存不足，SKU[" + commandSku.getSkuCode() + "],商品状态[" + WhWarehouseVO.getSkuStatusName(phyWhStockCond.getSkuStatus()) + "]" + "物理仓[" + phyWhStockCond.getPhysicalWarehouseCode() + "]，需扣减数[" + commandSku.getPlanedQuantity() + "]>当前库存数[" + physicalSkuStockCount + "]");
            }
        }
    }

    private int findPhysicalSkuStock(PhyWhStockCond cond) {
        List<PhyWhStockVO> phyWhStockVOs = sWhWmsSkuStockService.findPhyWhStockByCond(cond);
        if (CollectionUtils.isEmpty(phyWhStockVOs)) {
            return 0;
        }
        return phyWhStockVOs.get(0).getCanUseQuantity();
    }

    /**
     * 生成采退单号
     *
     * @param id
     * @return
     */
    public String generateReturnCode(Object id) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("PCS_PURCHASE_RETURN", params);
        return code;
    }

    /**
     * 生成采退单行code
     *
     * @param id
     * @return
     */
    public String generateReturnLineCode(Object id, String pcsPurchaseReturnCode) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("pcsPurchaseReturnCode", pcsPurchaseReturnCode);
        String code = CodeGenerator.getInstance().generate("PCS_PURCHASE_RETURN_LINE", params);
        return code;
    }


    @Override
    public Boolean updatePurchaseReturn(PcsPurchaseReturn pcsPurchaseReturn) {
        return pcsPurchaseReturnMapper.updateByPrimaryKeySelective(pcsPurchaseReturn) == 1 ? true : false;
    }


    @Override
    public List<PcsPurchaseReturnVO> findPRVOByCond(PcsPurchaseReturnCond cond) {
        return pcsPurchaseReturnMapper.findPRVOByCond(cond);
    }

    @Override
    public Integer countPRVOByCond(PcsPurchaseReturnCond cond) {
        return pcsPurchaseReturnMapper.countRVOByCond(cond);
    }


    @Override
    public PcsPurchaseReturnVO findPRVOById(Long id, boolean withLine) {
        PcsPurchaseReturnVO pcsPurchaseReturnVO = pcsPurchaseReturnMapper.findPRVOById(id);
        if (EmptyUtil.isNotEmpty(pcsPurchaseReturnVO) && withLine) {
            PcsPurchaseReturnSku cond = new PcsPurchaseReturnSku();
            cond.setPurchaseReturnId(id);
            cond.setPoId(pcsPurchaseReturnVO.getPoId());
            List<PcsPurchaseReturnSkuVO> lineList = pcsPurchaseReturnSkuMapper.findPrLineByCond(cond);
            /*if (EmptyUtil.isNotEmpty(lineList)) {
                for (PcsPurchaseReturnSkuVO pcsPurchaseReturnSkuVO : lineList) {
                    pcsPurchaseReturnSkuVO.setRefundedGoodQuantity(pcsPurchaseReturnSkuVO.getRefundedGoodQuantity() + pcsPurchaseReturnSkuVO.getGoodRealityQuantity());
                    pcsPurchaseReturnSkuVO.setRefundedWasteQuantity(pcsPurchaseReturnSkuVO.getRefundedWasteQuantity() + pcsPurchaseReturnSkuVO.getWasteRealityQuantity());
                    pcsPurchaseReturnSkuVO.setRefundedHoldPendingQuantity(pcsPurchaseReturnSkuVO.getRefundedHoldPendingQuantity() + pcsPurchaseReturnSkuVO.getHoldPendingRealityQuantity());
                }
            }*/
            pcsPurchaseReturnVO.setReturnSkuVOList(lineList);
        }
        return pcsPurchaseReturnVO;
    }


    @Override
    public List<PcsPurchaseReturnSkuVO> findPrLineByCond(PcsPurchaseReturnSku cond) {
        return pcsPurchaseReturnSkuMapper.findPrLineByCond(cond);
    }


    @Override
    public Boolean auditPurchaseReturn(CommAudit commAudit) throws Exception {
        PcsPurchaseReturn pcsPurchaseReturn = new PcsPurchaseReturn();
        pcsPurchaseReturn.setId(Long.valueOf(commAudit.getId()));
        if (commAudit.getIsPass()) {
            pcsPurchaseReturn.setAuditTime(new Date());
            pcsPurchaseReturn.setReturnStatus(PcsPurchaseReturn.PURCHASE_RETURN_STATUS_WAITING_SEND);
            //pegasusWarehouseServiceFacade.finishCommandByCode(outCmdCode);
        } else {
            PcsPurchaseReturnVO pcsPurchaseReturnVO = this.findPRVOById(pcsPurchaseReturn.getId(), false);
            wWhCommandService.cancelCommandByTypeAndReferenceCode(28, pcsPurchaseReturnVO.getCode());
            pcsPurchaseReturn.setReturnStatus(PcsPurchaseReturn.PURCHASE_RETURN_STATUS_REJECT);
        }
        return this.updatePurchaseReturn(pcsPurchaseReturn);
    }

    @Override
    public Boolean closePurchaseReturn(Long id) {
        PcsPurchaseReturn pcsPurchaseReturn = new PcsPurchaseReturn();
        pcsPurchaseReturn.setId(Long.valueOf(id));
        pcsPurchaseReturn.setReturnStatus(PcsPurchaseReturn.PURCHASE_RETURN_STATUS_CANCLE);
        PcsPurchaseReturnVO pcsPurchaseReturnVO = this.findPRVOById(pcsPurchaseReturn.getId(), true);
        WhCommandVO whCommand = wWhCommandService.findCommandByTypeAndReferenceCode(28, pcsPurchaseReturnVO.getCode(), false);
        if (whCommand != null) {
            if (whCommand.getCommandStatus() != 0 && whCommand.getCommandStatus() != 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "已经波次启动不能取消！");
            } else {
                wWhCommandService.cancelCommandByTypeAndReferenceCode(28, pcsPurchaseReturnVO.getCode());
            }
        }
        return this.updatePurchaseReturn(pcsPurchaseReturn);

    }

    @Override
    public List<PcsPurchaseOrderVO> findPOVOBySupplierId(Long supplierId) {
        return pcsPurchaseOrderMapper.findPOVOBySupplierId(supplierId);
    }

    @Override
    public List<PcsPoLineVO> findFinancePoLineVOByParams(Map<String, Object> params) {
        return pcsPurchaseOrderMapper.findFinancePoLineVOByParams(params);
    }

    @Override
    public List<PcsPurchaseOrderVO> findPoCostById(Long id) {
        return pcsPurchaseOrderMapper.findPoCostById(id);
    }

    @Override
    public List<Long> createPurchaseOrderCosts(List<PcsPurchaseOrderCost> orderCostList, Long poId) {
        if (EmptyUtil.isNotEmpty(orderCostList)) {
            for (PcsPurchaseOrderCost pcsPurchaseOrderCost : orderCostList) {
                pcsPurchaseOrderCost.setPoId(poId);
                pcsPurchaseOrderCost.setCreateTime(new Date());
                pcsPurchaseOrderCostMapper.insertSelective(pcsPurchaseOrderCost);
            }
        }
        return null;
    }


    @Override
    public List<Long> updatePurchaseOrderCosts(List<PcsPurchaseOrderCost> orderCostList, Long poId) {
        if (EmptyUtil.isNotEmpty(orderCostList)) {
            for (PcsPurchaseOrderCost pcsPurchaseOrderCost : orderCostList) {
                pcsPurchaseOrderCost.setPoId(poId);
                pcsPurchaseOrderCostMapper.updateByPrimaryKeySelective(pcsPurchaseOrderCost);
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean batchUpdatePcsPoCost(PcsPoPlanCostVO pcsPoCostVO, Long operatorId) {
        final PcsPurchaseOrder pcsPurchaseOrder = findPoById(pcsPoCostVO.getId());
        if (EmptyUtil.isEmpty(pcsPurchaseOrder)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "匹配不到采购单");
        }
        // 更新采购单费用/更新采购单pop费用
        List<PcsCostAdjust> pcsPoCosts = pcsPoCostVO.getPcsCostAdjustList();
        if (EmptyUtil.isEmpty(pcsPoCosts)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "匹配不到采购单费用");
        }
        // 本次调整时间
        Date adjustTime = Calendar.getInstance().getTime();
        for (PcsCostAdjust pcsPoCost : pcsPoCosts) {
            if (EmptyUtil.isNotEmpty(pcsPoCost.getCostId())) {
                PcsCostAdjustExample example = new PcsCostAdjustExample();
                PcsCostAdjustExample.Criteria criteria = example.createCriteria();
                criteria.andCostTypeEqualTo(pcsPoCost.getCostType());
                criteria.andCostIdEqualTo(pcsPoCost.getCostId());
                example.setOrderByClause(" ADJUST_TIME desc");
                List<PcsCostAdjust> pcsCostAdjustList = pcsCostAdjustMapper.selectByExample(example);
                BigDecimal diffAmountTaxPre = pcsPoCost.getAdjustPreTaxAmount();
                BigDecimal diffAmountTaxAfter = pcsPoCost.getAdjustAfterTaxAmount();
                if (pcsCostAdjustList != null && pcsCostAdjustList.size() > 0) {
                    PcsCostAdjust realPcsCostAdjust = pcsCostAdjustList.get(0);
                    diffAmountTaxPre = pcsPoCost.getAdjustPreTaxAmount().subtract(realPcsCostAdjust.getAdjustPreTaxAmount());
                    diffAmountTaxAfter = pcsPoCost.getAdjustAfterTaxAmount().subtract(realPcsCostAdjust.getAdjustAfterTaxAmount());
                    if (pcsPoCost.getCostType().equals(PcsCostAdjust.COST_TYPE_POP)) {
                        if (realPcsCostAdjust.getPopCode() != null) {
                            pcsPoCost.setPopCode(realPcsCostAdjust.getPopCode());
                        } else {
                            PcsPoPlanCost pcsPoPlanCost = pcsPoPlanCostMapper.selectByPrimaryKey(pcsPoCost.getCostId());
                            if (pcsPoPlanCost != null && pcsPoPlanCost.getPoPlanId() != null) {
                                PcsPoPlan pcsPoPlan = pcsPoPlanMapper.selectByPrimaryKey(Long.parseLong(pcsPoPlanCost.getPoPlanId().toString()));
                                if (pcsPoPlan != null) {
                                    pcsPoCost.setPopCode(pcsPoPlan.getCode());
                                }
                            }
                        }
                    }
                } else {
                    if (pcsPoCost.getCostType().equals(PcsCostAdjust.COST_TYPE_PO)) {
                        PcsPurchaseOrderCost pcsPurchaseOrderCost = pcsPurchaseOrderCostMapper.selectByPrimaryKey(pcsPoCost.getCostId());
                        if (pcsPurchaseOrderCost != null) {
                            BigDecimal rmbRate = pcsPurchaseOrder.getPurchaseCurrencyRate().add(new BigDecimal(0));
                            BigDecimal preTaxesAmountRmb = BigDecimal.ZERO;
                            if (NullUtil.isNotNull(preTaxesAmountRmb)) {
                                preTaxesAmountRmb = pcsPurchaseOrderCost.getPreTaxesAmount().multiply(rmbRate).setScale(4, RoundingMode.HALF_UP);
                            }
                            diffAmountTaxPre = pcsPoCost.getAdjustPreTaxAmount().subtract(preTaxesAmountRmb);

                            BigDecimal diffAmountTaxAfterRmb = BigDecimal.ZERO;
                            if (NullUtil.isNotNull(pcsPurchaseOrderCost.getAfterTaxesAmount())) {
                                diffAmountTaxAfterRmb = pcsPurchaseOrderCost.getAfterTaxesAmount().multiply(rmbRate).setScale(4, RoundingMode.HALF_UP);
                            }
                            diffAmountTaxAfter = pcsPoCost.getAdjustAfterTaxAmount().subtract(diffAmountTaxAfterRmb);
                        }
                    } else if (pcsPoCost.getCostType().equals(PcsCostAdjust.COST_TYPE_POP)) {
                        PcsPoPlanCost pcsPoPlanCost = pcsPoPlanCostMapper.selectByPrimaryKey(pcsPoCost.getCostId());
                        if (pcsPoPlanCost != null && pcsPoPlanCost.getPoPlanId() != null) {
                            PcsPoPlan pcsPoPlan = pcsPoPlanMapper.selectByPrimaryKey(Long.parseLong(pcsPoPlanCost.getPoPlanId().toString()));
                            if (pcsPoPlan != null) {
                                pcsPoCost.setPopCode(pcsPoPlan.getCode());
                            }
                            diffAmountTaxPre = pcsPoCost.getAdjustPreTaxAmount().subtract(pcsPoPlanCost.getPreTaxAmount() == null ? new BigDecimal(0) : pcsPoPlanCost.getPreTaxAmount());
                            diffAmountTaxAfter = pcsPoCost.getAdjustAfterTaxAmount().subtract(pcsPoPlanCost.getAfterTaxAmount() == null ? new BigDecimal(0) : pcsPoPlanCost.getAfterTaxAmount());
                        }
                    }
                }
                pcsPoCost.setDiffAmountTaxPre(diffAmountTaxPre);
                pcsPoCost.setDiffAmountTaxAfter(diffAmountTaxAfter);
                pcsPoCost.setPoCode(pcsPurchaseOrder.getCode());
                pcsPoCost.setAdjustTime(adjustTime);
                pcsPoCost.setAdjustPersonId(operatorId);
                if (pcsCostAdjustMapper.insertSelective(pcsPoCost) < 0) {
                    throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "采购单费用更新失败," + pcsPoCost.toString());
                }
            } else {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "匹配不到采购单费用信息," + pcsPoCost.toString());
            }
        }
        return true;
    }

    @Override
    public List<PcsCostAdjust> findCostAjustByCostIds(List<Long> costIds, Integer costType) {
        if (EmptyUtil.isEmpty(costIds) || NullUtil.isNull(costType)) {
            return new ArrayList<>();
        }
        PcsCostAdjustExample example = new PcsCostAdjustExample();
        example.createCriteria().andCostIdIn(costIds).andCostTypeEqualTo(costType);
        return pcsCostAdjustMapper.selectByExample(example);
    }

    @Override
    public List<PurchaseSellStockReportVO> findPssReportByCond(PcsPurchaseOrderCond cond) {
        return purchaseSellStockReportMapper.findPssReportByCond(cond);
    }

    @Override
    public List<PurchaseSellStockReportVO> findPssReportByIds(List<Long> reportIds) {
        return purchaseSellStockReportMapper.findPssReportByIds(reportIds);
    }

    @Override
    @Transactional
    public int reopenPurchaseOrder(Long poId, Date askDeliveryDate) {
        PcsPurchaseOrder purchaseOrder = pcsPurchaseOrderMapper.selectByPrimaryKey(poId);
        if (EmptyUtil.isNotEmpty(askDeliveryDate)) {
            //新的要求收货日期字段备用，暂时无效
            purchaseOrder.setNewAskDeliveryDate(askDeliveryDate);
            purchaseOrder.setAskDeliveryDate(askDeliveryDate);
        } else {
            purchaseOrder.setNewAskDeliveryDate(purchaseOrder.getAskDeliveryDate());
        }
        savePoAndLineApprovalRecord(purchaseOrder, pcsPoLineService.findPoLineByPoId(poId), pcsPurchaseOrderCostMapper.selectByPoId(poId));
        purchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT);
        return pcsPurchaseOrderMapper.updateByPrimaryKeySelective(purchaseOrder);
    }

    @Override
    public List<PcsPurchaseOrder> findNeedToClosedPO() {
        return pcsPurchaseOrderMapper.findNeedToClosedPO();
    }

    @Override
    public List<PcsPurchaseOrderVO> findNearestPurchaseOrderBySkuCodes(List<String> skuCodes) {
        return pcsPurchaseOrderMapper.findNearestPurchaseOrderBySkuCodes(skuCodes);
    }

    @Override
    public PageInfo<PcsPoProgressTrackingVO> pageQueryTrackingProgressByCond(PcsPurchaseOrderCond cond) {
        PageRowBounds rowBounds = new PageRowBounds(cond.getPageStart(), cond.getPagenum());
        PageInfo pageInfo = new PageInfo(pcsPurchaseOrderMapper.pageQueryTrackingProgressByCond(cond, rowBounds));
        pageInfo.setTotal(rowBounds.getTotal());
        return pageInfo;
    }

    @Override
    public List<PcsPoProgressTrackingDetailVO> queryTrackingProgressDetailByCond(PcsPurchaseOrderCond cond) {

        List<PcsPoProgressTrackingDetailVO> allList = new ArrayList<PcsPoProgressTrackingDetailVO>();
        int currpage = 0;

        boolean hasNextPage = true;
        while (hasNextPage) {
            currpage++;
            PageRowBounds pageRowBounds = new PageRowBounds((currpage - 1) * 2000, 2000);
            List<PcsPoProgressTrackingDetailVO> list = pcsPurchaseOrderMapper.queryTrackingProgressDetailByCond(cond, pageRowBounds);
            allList.addAll(list);
            if (list == null || list.size() == 0) {
                hasNextPage = false;
            }
        }
        Map<String, Long> skuFirstPOMap = mapSkuFirstPO(cond);
        int listSize = allList.size();
        for (int i = 0; i < listSize; i++) {
            PcsPoProgressTrackingDetailVO trackingDetailVO = allList.get(i);
            String skuCode = trackingDetailVO.getSkuCode();
            //SKU首单
            if (trackingDetailVO.getPoId().equals(skuFirstPOMap.get(skuCode))) {
                trackingDetailVO.setFirstOrder(true);
            }
        }
        return allList;
    }

    @Override
    public Map<String, Long> mapSkuFirstPO(PcsPurchaseOrderCond cond) {
        List<PcsPoProgressTrackingDetailVO> list = pcsPurchaseOrderMapper.querySkuFirstOrder(cond);
        Map<String, Long> map = new HashMap<String, Long>();
        if (list == null || list.size() == 0) {
            return map;
        }

        int listSize = list.size();
        for (int i = 0; i < listSize; i++) {
            PcsPoProgressTrackingDetailVO trackingDetailVO = list.get(i);
            map.put(trackingDetailVO.getSkuCode(), trackingDetailVO.getPoId());
        }
        return map;
    }

    @Override
    public List<Long> findCanAutoCreatePopPoIds() {
        List<PcsPoLineVO> poLines = pcsPoLineService.selectCanAutoCreatePopLines();
        Set<Long> poIds = new HashSet<Long>();
        if (poLines == null || poLines.size() == 0) {
            return new ArrayList<Long>(poIds);
        }
        for (PcsPoLineVO pcsPoLine : poLines) {
            if (pcsPoLine.getPoId() != null) {
                poIds.add(pcsPoLine.getPoId());
            }
        }
        return new ArrayList<Long>(poIds);
    }

    @Override
    public List<PcsPoApprovalRecords> findApprovalRecordsByPoId(Long poId) {
        PcsPoApprovalRecordsExample example = new PcsPoApprovalRecordsExample();
        example.createCriteria().andPoIdEqualTo(poId);
        example.setOrderByClause("id desc");
        return pcsPoApprovalRecordsMapper.selectByExample(example);
    }

    @Override
    public PcsPoApprovalRecords findNewestApprovalRecordsByPoId(Long poId) {
        List<PcsPoApprovalRecords> approvalRecords = findApprovalRecordsByPoId(poId);
        if (approvalRecords == null || approvalRecords.size() == 0) {
            return null;
        }
        return approvalRecords.get(0);
    }

  @Override
  public Long savePoApprovalRecord(PcsPurchaseOrder pcsPurchaseOrder) {
    Long poId = pcsPurchaseOrder.getId();
    PcsPoApprovalRecords newestApprovalRecord = findNewestApprovalRecordsByPoId(poId);
    PcsPoApprovalRecords approvalRecord = new PcsPoApprovalRecords();
    Integer approvalTimes = 1;
    //没有审核过
    if (newestApprovalRecord != null) {
      approvalTimes = newestApprovalRecord.getApprovalTimes() + 1;
    }
    approvalRecord.setPoId(poId);
    approvalRecord.setPoStatusBeforeSubmit(pcsPurchaseOrder.getPurchaseOrderStatus());
    Date now = new Date();
    approvalRecord.setSubmitTime(now);
    approvalRecord.setApprovalTimes(approvalTimes);
    approvalRecord.setUpdateTime(now);
    approvalRecord.setPurchaseCurrencyCode(pcsPurchaseOrder.getPurchaseCurrencyCode());
    approvalRecord.setPurchaseCurrencyRate(pcsPurchaseOrder.getPurchaseCurrencyRate());
    approvalRecord.setPurchaseCurrencyDesc(pcsPurchaseOrder.getPurchaseCurrencyDesc());
    approvalRecord.setPoApprovalStatus(PoStatusEnum.PURCHASE_ORDER_STATUS_WAITING_AUDIT.getKey());
    approvalRecord.setSubmitUserId(pcsPurchaseOrder.getSubmitUserId());
    pcsPoApprovalRecordsMapper.insertSelective(approvalRecord);
    return approvalRecord.getId();
  }

    @Override
    @Transactional
    public Long savePoAndLineApprovalRecord(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, List<PcsPurchaseOrderCost> orderCostList) {
        Long poApprovalRecordId = savePoApprovalRecord(pcsPurchaseOrder);
        if (pcsPoLineList == null || pcsPoLineList.size() == 0) {
            return null;
        }
        List<PcsPoLineApprovalRecord> lineApprovalRecords = new ArrayList<PcsPoLineApprovalRecord>();
        for (PcsPoLine pcsPoLine : pcsPoLineList) {
            PcsPoLineApprovalRecord poLineApprovalRecord = BeanUtil.buildFrom(pcsPoLine, PcsPoLineApprovalRecord.class);
            poLineApprovalRecord.setPoApprovalRecordId(poApprovalRecordId);
            poLineApprovalRecord.setPoLineId(pcsPoLine.getId());
            lineApprovalRecords.add(poLineApprovalRecord);
        }
        savePoApprovalRecordLine(lineApprovalRecords);
        savePoCostApprovalRecords(orderCostList, poApprovalRecordId);
        return poApprovalRecordId;
    }

    private void savePoCostApprovalRecords(List<PcsPurchaseOrderCost> poCostList, Long poApprovalRecordId) {
        if (poCostList != null && poCostList.size() > 0) {
            for (PcsPurchaseOrderCost poCost : poCostList) {
                PcsPoCostApprovalRecords record = new PcsPoCostApprovalRecords();
                BeanUtils.copyProperties(poCost, record);
                record.setPoApprovalRecordId(poApprovalRecordId);
                pcsPoCostApprovalRecordsMapper.insertSelective(record);
            }
        }
    }

    @Override
    public int savePoApprovalRecordLine(List<PcsPoLineApprovalRecord> lineApprovalRecords) {
        return pcsPoLineApprovalRecordMapper.batchInsert(lineApprovalRecords);
    }

    @Override
    @Transactional
    public int withdrawApproval(Long poId) {
        Integer poStatusBeforeSubmit = PoStatusEnum.PURCHASE_ORDER_STATUS_DRAFT.getKey();
        PcsPoApprovalRecords newestApprovalRecord = findNewestApprovalRecordsByPoId(poId);
        if (newestApprovalRecord != null) {
            poStatusBeforeSubmit = newestApprovalRecord.getPoStatusBeforeSubmit();
        }
        PcsPurchaseOrderVO purchaseOrderVO = new PcsPurchaseOrderVO();
        purchaseOrderVO.setId(poId);
        purchaseOrderVO.setPoStatusBeforeSubmit(poStatusBeforeSubmit);
        int rct = pcsPurchaseOrderMapper.withdrawApproval(purchaseOrderVO);
        if (rct == 0) {
            throw new PurchaseException("警告", "采购单状态已更新，无法撤回，请刷新页面后重新操作");
        }
   /* List<PcsPoLineApprovalRecord>  poLineApprovalRecords = pcsPoLineApprovalRecordMapper.selectByApprovalRecordId(newestApprovalRecord.getId());
    List<PcsPurchaseOrderCost> orderCostList = pcsPurchaseOrderCostMapper.selectByPoId(poId);*/

        /**
         * 撤回采购单总金额
         */

        /* List<PcsPoLine> poLines = BeanUtil.buildListFrom(poLineApprovalRecords, PcsPoLine.class);*/
   /* if (poLines != null && poLines.size() > 0) {
      PcsPurchaseOrder pcsPurchaseOrder = new PcsPurchaseOrder();
      pcsPurchaseOrder.setId(poId);
      computeTotalPrice(pcsPurchaseOrder, BeanUtil.buildListFrom(poLineApprovalRecords, PcsPoLine.class), orderCostList);
      pcsPurchaseOrderMapper.updateByPrimaryKeySelective(pcsPurchaseOrder);
    }*/

        return rct;
    }

    @Override
    public List<PcsPoLineVO> findPoApprovalRecordLine(Long poId) {
        PcsPoApprovalRecords newestApprovalRecord = findNewestApprovalRecordsByPoId(poId);
        if (EmptyUtil.isNotEmpty(newestApprovalRecord)) {
            List<PcsPoLineVO> poLineApprovalRecords = pcsPoLineApprovalRecordMapper.findPoLineVOByPoId(newestApprovalRecord.getPoId(), newestApprovalRecord.getId());
            if (poLineApprovalRecords == null || poLineApprovalRecords.size() == 0) {
                return null;
            }
            return poLineApprovalRecords;
        }
        return null;
    }

    @Override
    public List<PcsPurchaseOrderCost> findPoCostApprovalRecords(Long poApprovalRecordId) {
        PcsPoCostApprovalRecordsExample example = new PcsPoCostApprovalRecordsExample();
        example.createCriteria().andPoApprovalRecordIdEqualTo(poApprovalRecordId);
        return BeanUtil.buildListFrom(pcsPoCostApprovalRecordsMapper.selectByExample(example), PcsPurchaseOrderCost.class);
    }

    @Override
    public PcsPurchaseOrderVO findPoVOByCond(PcsPurchaseOrderCond cond) {
        PcsPurchaseOrderVO pcsPurchaseOrderVO = null;
        if (EmptyUtil.isNotEmpty(cond.getId())) {
            pcsPurchaseOrderVO = pcsPurchaseOrderMapper.findPoVOById(cond.getId());
        } else if (EmptyUtil.isNotEmpty(cond.getPoCode())) {
            pcsPurchaseOrderVO = pcsPurchaseOrderMapper.findPoVOByCode(cond.getPoCode());
        }
        if (pcsPurchaseOrderVO != null) {
            if (cond.isFetchPoLine()) {
                pcsPurchaseOrderVO.setPcsPoLineVOList(pcsPoLineService.findPoLineVOByPoId(pcsPurchaseOrderVO.getId()));
            }
            if (cond.isFetchPoCost()) {
                pcsPurchaseOrderVO.setPcsPoCostList(findPurchaseOrderCost(pcsPurchaseOrderVO.getId()));
            }
            if (cond.isFetchPop()) {
                List<PcsPoPlanVO> pcsPoPlanVOs = findPcsPoPlanVOList(pcsPurchaseOrderVO.getId());
                if (CollectionUtils.isNotEmpty(pcsPoPlanVOs)) {
                    pcsPurchaseOrderVO.setPcsPoPlanVOList(pcsPoPlanVOs);

                    Set<Long> popIds = new HashSet<>();
                    Set<Integer> popIdList = new HashSet<>();
                    pcsPoPlanVOs.forEach(pop -> {
                        popIds.add(pop.getId());
                        popIdList.add(pop.getId().intValue());
                    });
                    if (cond.isFetchPopLine()) {
                        Map<Long, List<PcsPoPlanLineVO>> popLineMap = pcsPoPlanService.findPoPlanLineMap(Arrays.asList(popIds.toArray(new Long[popIds.size()])));
                        if (!popLineMap.isEmpty()) {
                            pcsPoPlanVOs.forEach(pop -> {
                                List<PcsPoPlanLineVO> lineList = popLineMap.get(pop.getId());
                                if (NullUtil.isNotNull(lineList)) {
                                    pop.setPcsPoPlanLineVOList(lineList);
                                }
                            });
                        }
                    }
                    if (cond.isFetchPopCost()) {
                        Map<Integer, List<PcsPoPlanCost>> popCostMap = mapPcsPoPlanCost(Arrays.asList(popIdList.toArray(new Integer[popIdList.size()])));
                        if (popCostMap.size() > 0) {
                            pcsPoPlanVOs.forEach(pop -> {
                                List<PcsPoPlanCost> popCostList = popCostMap.get(pop.getId().intValue());
                                if (NullUtil.isNotNull(popCostList)) {
                                    pop.setPcsPoPlanCosts(popCostList);
                                }
                            });
                        }
                    }
                }
            }
        }
        return pcsPurchaseOrderVO;
    }

    public Map<Integer, List<PcsPoPlanCost>> mapPcsPoPlanCost(List<Integer> popIds) {
        Map<Integer, List<PcsPoPlanCost>> map = new HashMap<>();
        List<PcsPoPlanCost> poPlanCosts = pcsPoPlanService.listPcsPoPlanCostByPopIds(popIds);
        if (EmptyUtil.isNotEmpty(poPlanCosts)) {
            poPlanCosts.forEach(poPlanCost -> {
                List<PcsPoPlanCost> tmpList = map.get(poPlanCost.getPoPlanId());
                if (NullUtil.isNull(tmpList)) {
                    tmpList = new ArrayList<>();
                    map.put(poPlanCost.getPoPlanId(), tmpList);
                }
                tmpList.add(poPlanCost);
            });
        }
        return map;
    }

    @Override
    public PcsPurchaseOrderVO findPoVOById(long id, boolean cascadeLine) {
        PcsPurchaseOrderVO pcsPurchaseOrderVO = findPoVOById(id);
        if (pcsPurchaseOrderVO == null) {
            return null;
        }
        pcsPurchaseOrderVO.setPcsPoLineVOList(pcsPoLineService.findPoLineVOByPoId(id));
        return pcsPurchaseOrderVO;
    }

    @Override
    public PcsPurchaseOrderVO findPoVOForApprovalById(long id, boolean cascadeLine) {
        PcsPurchaseOrderVO pcsPurchaseOrderVO = findPoVOById(id);
        if (pcsPurchaseOrderVO == null) {
            return null;
        }
        PcsPoApprovalRecords newestApprovalRecord = findNewestApprovalRecordsByPoId(id);
        List<PcsPoLineVO> poLineVOList = new ArrayList<PcsPoLineVO>();
        if (newestApprovalRecord != null) {
            poLineVOList = findPoApprovalRecordLine(id);
            PcsPurchaseOrder pcsPurchaseOrder = BeanUtil.buildFrom(pcsPurchaseOrderVO, PcsPurchaseOrder.class);
            computeTotalPrice(pcsPurchaseOrder, BeanUtil.buildListFrom(poLineVOList, PcsPoLine.class), pcsPurchaseOrderVO.getOrderCostList());
            pcsPurchaseOrderVO.setPcsPoLineVOList(poLineVOList);
            pcsPurchaseOrderVO.setTotalAmount(pcsPurchaseOrder.getTotalAmount());
            pcsPurchaseOrderVO.setTotalAmountAfterTax(pcsPurchaseOrder.getTotalAmountAfterTax());

            List<PcsPurchaseOrderCost> pcsPurchaseOrderCosts = findPoCostApprovalRecords(newestApprovalRecord.getId());
            if (pcsPurchaseOrderCosts == null || pcsPurchaseOrderCosts.size() > 0) {
                pcsPurchaseOrderVO.setOrderCostList(pcsPurchaseOrderCosts);
            }
        }
        return pcsPurchaseOrderVO;
    }

    @Override
    public Map<String, Integer> mapRefundedGoodQuantityByPoIdAndSkuCode(Long poId) {
        List<PcsPurchaseReturnSkuVO> returnSkuList = pcsPurchaseReturnSkuMapper.selectRealityGoodQuantityByPoId(poId);
        if (returnSkuList == null || returnSkuList.size() == 0) {
            return null;
        }
        Map<String, Integer> map = new HashMap<String, Integer>();
        for (PcsPurchaseReturnSkuVO returnSkuVO : returnSkuList) {
            String key = new StringBuilder().append(returnSkuVO.getPoId()).append("_").append(returnSkuVO.getSkuCode()).toString();
            map.put(key, returnSkuVO.getGoodRealityQuantity());
        }
        return map;
    }

    @Override
    public Map<String, Integer> computeRealityGoodQuantityByPoId(Long poId) {
        //良品存良品字段，其他存残次字段
        List<PcsPurchaseReturnSkuVO> list = pcsPurchaseReturnSkuMapper.computeRealityGoodQuantityByPoId(poId);
        if (EmptyUtil.isNotEmpty(list)) {
            return list.stream()
                    .collect(toMap(PcsPurchaseReturnSkuVO::getSkuCode, PcsPurchaseReturnSkuVO::getGoodRealityQuantity, (v1, v2) -> v1 + v2));
        }
        return new HashMap<>();
    }

    @Override
    public List<PcsPoApprovalRecords> listPoApprovalRecords(Long poId, Integer approvalStatus) {
        PcsPoApprovalRecordsExample example = new PcsPoApprovalRecordsExample();
        PcsPoApprovalRecordsExample.Criteria criteria = example.createCriteria();
        criteria.andPoApprovalStatusEqualTo(approvalStatus);
        criteria.andPoIdEqualTo(poId);
        return pcsPoApprovalRecordsMapper.selectByExample(example);
    }

    @Override
    public int getPoPassApprovalTimes(Long poId) {
        List<PcsPoApprovalRecords> records = listPoApprovalRecords(poId, PoStatusEnum.PURCHASE_ORDER_STATUS_WAIT_RECEIVE.getKey());
        return records == null ? 0 : records.size();
    }

    @Override
    public List<PcsPurchaseOrderVO> listPoVOByIds(List<Long> ids, boolean cascadeLine) {
        PcsPurchaseOrderCond cond = new PcsPurchaseOrderCond();
        cond.setPoIds(ids);
        List<PcsPurchaseOrderVO> poVOs = pcsPurchaseOrderMapper.findPOVOByCond(cond);
        if (cascadeLine && CollectionUtils.isNotEmpty(poVOs)){
            poVOs.forEach(po -> {
                po.setPcsPoLineVOList(pcsPoLineService.findPoLineVOByPoId(po.getId()));
            });
        }
        return poVOs;
    }
}

