package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseFlowerSupplierCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseFlowerSupplierMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlowerSupplier;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlowerSupplierExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseFlowerSupplierService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseFlowerSupplierVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.pegasus.util.comm.SQLUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.thebeastshop.common.Pagination;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: ljj
 * @Description:${todo}(用一句话描述该文件做什么)
 * @Date: 2018/12/12 18:00
 * @Version 1.0
 */
@Service("pcsPurchaseFlowerSupplierService")
public class PcsPurchaseFlowerSupplierServiceImpl implements PcsPurchaseFlowerSupplierService {

    public final Logger log = LoggerFactory.getLogger(PcsPurchaseFlowerSupplierServiceImpl.class);

    @Autowired
    private PcsPurchaseFlowerSupplierMapper pcsPurchaseFlowerSupplierMapper;

    @Override
    public Integer addOrEditPurchaseFlowerSupplier(PcsPurchaseFlowerSupplierVO pcsPurchaseFlowerSupplierVO) {
        if ( 0 == pcsPurchaseFlowerSupplierVO.getId()) {
            pcsPurchaseFlowerSupplierMapper.insert(pcsPurchaseFlowerSupplierVO);
            final Map<String, Object> params = new HashMap<String, Object>();
            params.put("id", pcsPurchaseFlowerSupplierVO.getId());
            String flowerCode = CodeGenerator.getInstance().generate("PCS_SUP_CODE", params);
            PcsPurchaseFlowerSupplier updateVO = new PcsPurchaseFlowerSupplier();
            updateVO.setId(pcsPurchaseFlowerSupplierVO.getId());
            updateVO.setCode(flowerCode);
            updateVO.setStatus(1);
            return pcsPurchaseFlowerSupplierMapper.updateByPrimaryKeySelective(updateVO);
        } else {
            return pcsPurchaseFlowerSupplierMapper.updateByPrimaryKeySelective(pcsPurchaseFlowerSupplierVO);
        }
    }

    @Override
    public Pagination<PcsPurchaseFlowerSupplierVO> findByCond(PcsPurchaseFlowerSupplierCond cond) {

        Pagination<PcsPurchaseFlowerSupplierVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int count = pcsPurchaseFlowerSupplierMapper.countByCond(cond);
        page.setRecord(count);
        if(!NumberUtil.isNullOrZero(count)){
            List<PcsPurchaseFlowerSupplierVO> flowerVOList = pcsPurchaseFlowerSupplierMapper.findByCond(cond);
            page.setResultList(flowerVOList);
        }
        return page;
    }

    @Override
    public PcsPurchaseFlowerSupplierVO findById(Integer id) {
        PcsPurchaseFlowerSupplier pcsPurchaseFlowerSupplier = pcsPurchaseFlowerSupplierMapper.selectByPrimaryKey(id);
        return BeanUtil.buildFrom(pcsPurchaseFlowerSupplier, PcsPurchaseFlowerSupplierVO.class);
    }

    @Override
    public List<PcsPurchaseFlowerSupplierVO> findByCondForExport(PcsPurchaseFlowerSupplierCond cond) {
        return pcsPurchaseFlowerSupplierMapper.findByCond(cond);
    }

    @Override
    public Integer updateByExample(PcsPurchaseFlowerSupplierVO pcsPurchaseFlowerVO) {
        PcsPurchaseFlowerSupplier updateVO = BeanUtil.buildFrom(pcsPurchaseFlowerVO,PcsPurchaseFlowerSupplierVO.class);
        return pcsPurchaseFlowerSupplierMapper.updateByPrimaryKeySelective(updateVO);
    }

    @Override
    public Integer batchUpdateByCode(List<PcsPurchaseFlowerSupplierVO> pcsPurchaseFlowers) {
        return pcsPurchaseFlowerSupplierMapper.batchUpdateByCodeSelective(BeanUtil.buildListFrom(pcsPurchaseFlowers,PcsPurchaseFlowerSupplier.class));
    }

    @Override
    public Integer batchInsert(List<PcsPurchaseFlowerSupplierVO> pcsPurchaseFlowerSupplierVOS) {
        if (CollectionUtils.isNotEmpty(pcsPurchaseFlowerSupplierVOS)) {
            List<PcsPurchaseFlowerSupplier> updateVOs = Lists.newArrayList();
            for (PcsPurchaseFlowerSupplier pcsPurchaseFlowerSupplier : pcsPurchaseFlowerSupplierVOS) {
                pcsPurchaseFlowerSupplierMapper.insert(pcsPurchaseFlowerSupplier);
                final Map<String, Object> params = new HashMap<String, Object>();
                params.put("id", pcsPurchaseFlowerSupplier.getId());
                String flowerCode = CodeGenerator.getInstance().generate("PCS_SUP_CODE", params);
                PcsPurchaseFlowerSupplier updateVO = new PcsPurchaseFlowerSupplier();
                updateVO.setId(pcsPurchaseFlowerSupplier.getId());
                updateVO.setCode(flowerCode);
                updateVO.setStatus(1);
                updateVOs.add(updateVO);
            }
            return pcsPurchaseFlowerSupplierMapper.batchUpdateByPramaryKeySelective(updateVOs);
        } else {
            return null;
        }
    }

    @Override
    public List<PcsPurchaseFlowerSupplierVO> findByNameOrCodeLike(String term) {
        return pcsPurchaseFlowerSupplierMapper.findByNameOrCodeLike(SQLUtils.allLike(term));
    }

    @Override
    public List<PcsPurchaseFlowerSupplierVO> findAllSupplier() {
        PcsPurchaseFlowerSupplierExample example = new PcsPurchaseFlowerSupplierExample();
        example.createCriteria().andStatusEqualTo(PcsPurchaseFlowerSupplier.STATUS_ENABLE);
        List<PcsPurchaseFlowerSupplier> list = pcsPurchaseFlowerSupplierMapper.selectByExample(example);
        return BeanUtil.buildListFrom(list,PcsPurchaseFlowerSupplierVO.class);
    }
}
