package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseFlowerCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseFlowerMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlower;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseFlowerService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPurchaseFlowerVO;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.thebeastshop.common.Pagination;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: ljj
 * @Description:${todo}(用一句话描述该文件做什么)
 * @Date: 2018/12/7 15:46
 * @Version 1.0
 */
@Service("pcsPurchaseFlowerService")
public class PcsPurchaseFlowerServiceImpl implements PcsPurchaseFlowerService {

    public final Logger log = LoggerFactory.getLogger(PcsPurchaseFlowerServiceImpl.class);

    @Autowired
    private PcsPurchaseFlowerMapper pcsPurchaseFlowerMapper;


    @Override
    @Transactional
    public Integer addOrEditPurchaseFlower(PcsPurchaseFlowerVO pcsPurchaseFlower) {
        if ( 0 == pcsPurchaseFlower.getId()) {
            pcsPurchaseFlowerMapper.insert(pcsPurchaseFlower);
            final Map<String, Object> params = new HashMap<String, Object>();
            params.put("id", pcsPurchaseFlower.getId());
            String flowerCode = CodeGenerator.getInstance().generate("PCS_FLOWER_CODE", params);
            PcsPurchaseFlower updateVO = new PcsPurchaseFlower();
            updateVO.setId(pcsPurchaseFlower.getId());
            updateVO.setCode(flowerCode);
            updateVO.setStatus(1);
            return pcsPurchaseFlowerMapper.updateByPrimaryKeySelective(updateVO);
        } else {
            return pcsPurchaseFlowerMapper.updateByPrimaryKeySelective(pcsPurchaseFlower);
        }
    }

    @Override
    public Pagination<PcsPurchaseFlowerVO> findByCond(PcsPurchaseFlowerCond cond) {
        Pagination<PcsPurchaseFlowerVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int count = pcsPurchaseFlowerMapper.countByCond(cond);
        page.setRecord(count);
        if(!NumberUtil.isNullOrZero(count)){
            List<PcsPurchaseFlowerVO> flowerVOList = pcsPurchaseFlowerMapper.findByCond(cond);
            page.setResultList(flowerVOList);
        }
        return page;
    }

    @Override
    public PcsPurchaseFlowerVO findById(Integer id) {
        PcsPurchaseFlower pcsPurchaseFlower = pcsPurchaseFlowerMapper.selectByPrimaryKey(id);
        PcsPurchaseFlowerVO pcsPurchaseFlowerVO = BeanUtil.buildFrom(pcsPurchaseFlower,PcsPurchaseFlowerVO.class);
        return pcsPurchaseFlowerVO;
    }

    @Override
    public List<PcsPurchaseFlowerVO> findByCondForExport(PcsPurchaseFlowerCond cond) {
        return pcsPurchaseFlowerMapper.findByCond(cond);
    }

    @Override
    public Integer updateByExample(PcsPurchaseFlowerVO pcsPurchaseFlowerVO) {
        PcsPurchaseFlower updateVO = BeanUtil.buildFrom(pcsPurchaseFlowerVO,PcsPurchaseFlower.class);
        return pcsPurchaseFlowerMapper.updateByPrimaryKeySelective(updateVO);
    }

    @Override
    @Transactional
    public Integer batchUpdateByCode(List<PcsPurchaseFlower> pcsPurchaseFlowers) {
        return pcsPurchaseFlowerMapper.batchUpdateByCodeSelective(pcsPurchaseFlowers);
    }

    @Override
    @Transactional
    public Integer batchInsert(List<PcsPurchaseFlower> pcsPurchaseFlowers) {
        List<PcsPurchaseFlower> updateVOs = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(pcsPurchaseFlowers)) {
            for (PcsPurchaseFlower pcsPurchaseFlower : pcsPurchaseFlowers) {
                pcsPurchaseFlowerMapper.insert(pcsPurchaseFlower);
                final Map<String, Object> params = new HashMap<String, Object>();
                params.put("id", pcsPurchaseFlower.getId());
                String flowerCode = CodeGenerator.getInstance().generate("PCS_FLOWER_CODE", params);
                PcsPurchaseFlower updateVO = new PcsPurchaseFlower();
                updateVO.setId(pcsPurchaseFlower.getId());
                updateVO.setCode(flowerCode);
                updateVOs.add(updateVO);
            }
            return pcsPurchaseFlowerMapper.batchUpdateByPramaryKeySelective(updateVOs);
        } else {
            return null;
        }

    }

    @Override
    public List<PcsPurchaseFlowerVO> findPurchaseFlowerByChannelCodeAndCodeOrName(String channelCode, String nameOrCode,Integer unitConfigId) {
        return pcsPurchaseFlowerMapper.findPurchaseFlowerByChannelCodeAndCodeOrName(channelCode,nameOrCode,unitConfigId);
    }

}
