package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.cond.PurchaseFlowerAchievementReportCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseFlowerAchievementMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseFlowerAchievement;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseFlowerAchievementService;
import com.thebeastshop.pegasus.service.purchase.vo.PurchaseFlowerReportVO;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.thebeastshop.common.Pagination;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: ljj
 * @Description:${todo}(用一句话描述该文件做什么)
 * @Date: 2019/2/19 15:03
 * @Version 1.0
 */
@Service("pcsPurchaseFlowerAchievementService")
public class PcsPurchaseFlowerAchievementServiceImpl implements PcsPurchaseFlowerAchievementService {

    @Autowired
    private PcsPurchaseFlowerAchievementMapper pcsPurchaseFlowerAchievementMapper;

    @Override
    public Integer checkInAchievement(PcsPurchaseFlowerAchievement pcsPurchaseFlowerAchievement) {
        return pcsPurchaseFlowerAchievementMapper.insertSelective(pcsPurchaseFlowerAchievement);
    }

    @Override
    public Pagination<PurchaseFlowerReportVO> findPurchaseFlowerAchievementReportByCond(PurchaseFlowerAchievementReportCond cond) {
        Pagination<PurchaseFlowerReportVO> page = new Pagination<>(cond.getCurrpage(),cond.getPagenum());
        int count = pcsPurchaseFlowerAchievementMapper.countPurchaseFlowerAchievementReportByCond(cond);
        page.setRecord(count);
        if(NumberUtil.isNullOrZero(count)) return null;
        List<PurchaseFlowerReportVO> list = pcsPurchaseFlowerAchievementMapper.findPurchaseFlowerAchievementReportByCond(cond);
        for (PurchaseFlowerReportVO purchaseFlowerReportVO : list) {
            //本店业绩 要减去 CRM业绩
            purchaseFlowerReportVO.setAllAmount(purchaseFlowerReportVO.getAllAmount().subtract(purchaseFlowerReportVO.getCrmAmount()));
            BigDecimal currentDateAllAmount = purchaseFlowerReportVO.getAllAmount().add(purchaseFlowerReportVO.getOnlineAmount()).add(purchaseFlowerReportVO.getCrmAmount())
                    .add(purchaseFlowerReportVO.getGroupAmount()).add(purchaseFlowerReportVO.getOtherAmount());
            purchaseFlowerReportVO.setCurrdateAmount(currentDateAllAmount);
        }
        if (CollectionUtils.isEmpty(list)){
            return null;
        }else{
            page.setResultList(list);
            return page;
        }
    }
}
