/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.commdata.service.CommGlobalConfigService;
import com.thebeastshop.commdata.vo.CommEntityOpRcdVO;
import com.thebeastshop.commdata.vo.CommGlobalConfigVO;
import com.thebeastshop.common.utils.*;
import com.thebeastshop.kit.codetemplate.utils.CodeGenerator;
import com.thebeastshop.commdata.service.CommEntityOperationRcdService;
import com.thebeastshop.message.service.EmailSendService;
import com.thebeastshop.message.vo.EmailVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoPlanCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoPlanCostCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanCostMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanLineMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanMapper;
import com.thebeastshop.pegasus.service.purchase.enums.PoLogisticsEnum;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.*;
import com.thebeastshop.pegasus.service.purchase.service.*;
import com.thebeastshop.pegasus.service.purchase.vo.*;
import com.thebeastshop.pegasus.util.comm.ExcelUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.pegasus.util.inter.CodeAble;
import com.thebeastshop.wms.sservice.WWhCommandService;
import com.thebeastshop.wms.vo.WhCommandSkuVO;
import com.thebeastshop.wms.vo.WhCommandVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.thebeastshop.common.Pagination;
import com.thebeastshop.pegasus.util.comm.DateUtil;

import java.math.BigDecimal;
import java.util.*;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoPlanServiceImpl.java, v 0.1 2015-08-12 15:03
 */
@Service("pcsPoPlanService")
public class PcsPoPlanServiceImpl implements PcsPoPlanService, CheckAble, CodeAble {

    private final Logger log = LoggerFactory.getLogger(PcsPoPlanServiceImpl.class);

    @Autowired
    private WWhCommandService wWhCommandService;

    @Autowired
    private CommGlobalConfigService commGlobalConfigService;

    @Autowired
    private CommEntityOperationRcdService commEntityOperationRcdService;

    @Autowired
    private PcsPoPlanMapper pcsPoPlanMapper;

    @Autowired
    private PcsPoPlanLineMapper pcsPoPlanLineMapper;

    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;

    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;

    @Autowired
    private PcsPoLineService pcsPoLineService;
    
    @Autowired
    private PcsPoPlanCostMapper pcsPoPlanCostMapper;

    @Autowired
    private PcsPoLogisticsBillService pcsPoLogisticsBillService;

    @Autowired
    private EmailSendService emailSendService;

    @Override
    public PcsPoPlan buildFromVO(PcsPoPlanVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsPoPlan record = new PcsPoPlan();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    public PcsPoPlanVO buildFromModel(PcsPoPlan record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsPoPlanVO vo = new PcsPoPlanVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    private WhCommandVO bulidWhCommand(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList) {
        PcsPurchaseOrder po = pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId());
        if (EmptyUtil.isEmpty(po)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "采购单号不能为空");
        }
        if (!po.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE) && !po.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED, "采购单状态必须是收货中");
        }
        if (CollectionUtils.isEmpty(pcsPoPlanLineList)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "pcsPoPlanLineList不能为空");
        }
        WhCommandVO whCommand = new WhCommandVO();
        whCommand.setWarehouseCode(po.getWarehouseCode());
        whCommand.setPhysicalWarehouseCode(po.getPhysicalWarehouseCode());
        whCommand.setReferenceCode(pcsPoPlan.getCode());
        whCommand.setInOutType(WhCommandVO.TYPE_PURCHASE_IN);
        List<WhCommandSkuVO> whCommandSkuList = new ArrayList<WhCommandSkuVO>();
        for (PcsPoPlanLine line : pcsPoPlanLineList) {
            if (line.getPlanedQuantity().compareTo(0) <= 0) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造仓库指令的LIST失败,数量必须大于0");
            }
            WhCommandSkuVO whCommandSku = new WhCommandSkuVO();
            whCommandSku.setSkuCode(line.getSkuCode());
            whCommandSku.setPlanedQuantity(line.getPlanedQuantity());
            whCommandSku.setQpb(line.getQpb());
            if(!NumberUtil.isNullOrZero(line.getQuantity())){
                whCommandSku.setQuantity(line.getQuantity());
            }
            if(!NumberUtil.isNullOrZero(line.getWasteQuantity())){
                whCommandSku.setDamagedQuantity(line.getWasteQuantity());
            }
            whCommandSkuList.add(whCommandSku);
        }
        if (CollectionUtils.isEmpty(whCommandSkuList)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "构造仓库指令的LIST失败,whCommandSkuList不能为空");
        }
        whCommand.setWhCommandSkuList(whCommandSkuList);
        return whCommand;
    }

    @Override
    @Transactional
    public PcsPoPlan create(PcsPoPlan record) {
        if (check(record)) {
            if (check(record, true)) {
                record.setWhCommandCode("");
                record.setPlanStatus(PcsPoPlan.PLAN_STATUS_WAITING_RECEIVE);
                record.setCreateTime(DateUtil.getNow());
                pcsPoPlanMapper.insertSelective(record);
                try {
                    String code = generateCode(record.getId());
                    if (check(code)) {
                        record.setCode(code);
                    } else {
                        throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, "code字段数据库已有相同的值不能重复");
                    }
                } catch (PurchaseException we) {
                    log.error("", we);
                    throw new PurchaseException(we.getErrorCode(), "facadeWhInner error:" + we.getMessage());
                } catch (Exception e) {
                    log.error("", e);
                    throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_GENERATE_CODE, e.getMessage());
                }
                pcsPoPlanMapper.updateByPrimaryKeySelective(record);
                return record;
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsPoPlan record) {
        if (check(record)) {
            if (check(record, false)) {
                return pcsPoPlanMapper.updateByPrimaryKeySelective(record) != 0;
            }
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updatePcsPoPlanWarnFlagByIds(List<Long> ids) {
        return pcsPoPlanMapper.updatePcsPoPlanWarnFlagByIds(ids) != 0;
    }

    @Override
    public List<PcsPopFeeVO> calculatePopFee(List<Long> popIds) {
        return pcsPoPlanCostMapper.calculatePopFee(popIds);
    }

    @Override
    public Map<Long, PcsPopFeeVO> mapPopFee(List<Long> popIds) {
      List<PcsPopFeeVO> list = calculatePopFee(popIds);
      Map<Long, PcsPopFeeVO> map = new HashMap<Long, PcsPopFeeVO>();
      if (list == null || list.size() == 0) {
        return map;
      }
      for (PcsPopFeeVO popFeeVO : list) {
        map.put(popFeeVO.getPopId(), popFeeVO);
      }
      return map;
    }

    @Override
    @Transactional
    public int delPoPlanFee(Long poPlanFeeId) {
        // 新增一条负记录后修改原来记录为不可用
        PcsPoPlanCost cost = selectCostByCostId(poPlanFeeId);
        cost.setAvailable((byte) 0);
        updatePoPlanFee(cost, 1);
        if(cost != null){
            cost.setId(null);
            cost.setPreTaxAmount(BigDecimal.ZERO.subtract(cost.getPreTaxAmount()));
            cost.setAfterTaxAmount(BigDecimal.ZERO.subtract(cost.getAfterTaxAmount()));
            cost.setFeeTime(new Date());
            cost.setCreateTime(new Date());
            createPoPlanFee(cost);
        }
        return 0;
    }

  @Override
  public int delPoPlanFeeByIds(List<Long> feeIds) {
    Integer ret = 0;
    feeIds.stream().forEach(feeId -> {
        delPoPlanFee(feeId);
    });
    return ret;
  }

  @Override
    public PcsPoPlan findPoPlanById(long id) {
        return pcsPoPlanMapper.selectByPrimaryKey(id);
    }
    
    @Override
    public boolean updatePcsPoPlanById(long id, String date) {
    	int result = 0 ;
    	try {
    		result = pcsPoPlanMapper.updatePcsPoPlanById(id, date);
		} catch (Exception e) {
			log.error(e.getMessage());
		}
    	if(result > 0){
    		return true;
    	}else{
    		return false;
    	}
    }

    @Override
    @Transactional
    public boolean updatePcsPoPlanByPrimaryKey(PcsPoPlan pcsPoPlan) {
        if (EmptyUtil.isEmpty(pcsPoPlan.getId())
                || EmptyUtil.isEmpty(pcsPoPlanMapper.selectByPrimaryKey(pcsPoPlan.getId()))){
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM+" popId不存在，更新失败!");
        }
        return pcsPoPlanMapper.updateByPrimaryKeySelective(pcsPoPlan) > 0;
    }

    @Override
    public boolean updatePcsPoPlanLineById(long id,Integer sign) {
    	int result = 0 ;
    	try {
    		result = pcsPoPlanMapper.updatePcsPoPlanLineById(id, sign);
		} catch (Exception e) {
			log.error(e.getMessage());
		}
    	if(result > 0){
    		return true;
    	}else{
    		return false;
    	}
    }
    
    @Override
    public boolean updatePrdcJobById(long id,Integer sign) {
    	int result = 0 ;
    	try {
    		result = pcsPoPlanMapper.updatePrdcJobById(id, sign);
		} catch (Exception e) {
			log.error(e.getMessage());
		}
    	if(result > 0){
    		return true;
    	}else{
    		return false;
    	}
    }

    @Override
    public PcsPoPlan findPoPlanByCode(String code) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andCodeEqualTo(code);
        final List<PcsPoPlan> poList = pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return null;
        } else {
            if (poList.size() > 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.DUPLICATE_FIELD, " 根据code[" + code + "]能查出2条以上(含两条)记录");
            } else {
                return poList.get(0);
            }
        }
    }

    @Override
    public List<PcsPoPlan> findPoPlanByStatus(Integer status) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andPlanStatusEqualTo(status);
        final List<PcsPoPlan> poList = pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        } else {
            return poList;
        }
    }

    @Override
    public List<PcsPoPlanVO> findWasteAfterPopFinished(PcsPoPlanVO vo) {
        final List<PcsPoPlanVO> poList = pcsPoPlanMapper.findWasteAfterPopFinished(vo);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        } else {
            return poList;
        }
    }

    @Override
    public void sendPopEmailByCond(PcsPoPlanVO vo) {
        // 获取发送的链接地址
        List<PcsPoPlanVO> poPlanList = null;
        List<String> toAddressList = null;
        if (PcsPoPlanVO.SEND_POP_EMAIL_ORIGIN_HOLD_PENDING == vo.getSendPopEmailOrigin()){
            // 采购入库待定商品通知 邮件
            poPlanList = vo.getPoPlanVOs();
            /*toAddressList = Arrays.asList(PegasusUtilFacade.getInstance().
                    findConfigByKey("cronSendEmailByHoldpendingAterPopFinished.toAddress").getConfigValue().split(","));*/
            toAddressList = vo.getPopInStorageEmailReceivers();
        }else{
            // 以前的 POP收货残次 邮件
            poPlanList = findWasteAfterPopFinished(vo);
            // 特别收件人邮箱
            toAddressList = Arrays.asList(commGlobalConfigService.
                    findConfigByKey("cronSendEmailByWasteAterPopFinished.toAddress").getConfigValue().split(","));
        }
        if (CollectionUtils.isNotEmpty(poPlanList)){
            // 获取发送的链接地址
            CommGlobalConfigVO commGlobalConfig = commGlobalConfigService.
                    findConfigByKey("cronSendEmailByWasteAterPopFinished.webUrl");
            String link = "http://scm.thebeastshop.com/scm/wms/receiveShelves/listDetailWaste.htm";
            if (EmptyUtil.isNotEmpty(commGlobalConfig)
                    && EmptyUtil.isNotEmpty(commGlobalConfig.getConfigValue())){
                link = commGlobalConfig.getConfigValue();
            }
            String emailTitle = "POP收货残次";
            if (PcsPoPlanVO.SEND_POP_EMAIL_ORIGIN_HOLD_PENDING == vo.getSendPopEmailOrigin()){
                emailTitle = "POP入库通知";
            }
            log.debug("[POP完成时,"+emailTitle+"提醒]pcsPoPlanServiceImpl.sendPopEmailByCond begin at " +  DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));

            if (CollectionUtils.isEmpty(toAddressList)){
                toAddressList = Collections.emptyList();
            }
            sendEmailByWasteAterPopFinished(poPlanList,toAddressList,link,emailTitle,vo);

            log.debug("[POP完成时,"+emailTitle+"提醒]pcsPoPlanServiceImpl.sendPopEmailByCond end at " +  DateUtil.format(new Date(), DateUtil.DEFAULT_DATETIME_FORMAT));
        }
    }

    private void sendEmailWasteAterPopFinished(StringBuffer emailContent,List<PcsPoPlanVO> pcsPoPlanVOs,List<String> toAddressList,
                                               String link,String emailTitle,PcsPoPlanVO vo){
        emailContent.append("<table id='table-5'><thead><th>PO</th><th>POP</th><th>SKU</th><th>SKU名称</th>" +
                    "<th>计划数</th><th>实收良品</th><th>待定数量</th><th>差异数(计划-良品)</th><th>残次链接</th></thead><tbody>");
        List<Long> popIds = new ArrayList<>();
        // SKU采购员邮箱对应的数据
        Map<String,List<PcsPoPlanVO>> poPlanVOMap = new HashMap<>();
        StringBuffer allEmailContent = new StringBuffer();
        // 构建全部行数据，发给特殊收件人
        buildPopWasteContent(allEmailContent,pcsPoPlanVOs,popIds,link,poPlanVOMap);
        allEmailContent.append("</tbody></table></html>");

        // 构建每个买手创建的数据，发给对应的买手 (买手邮箱为：买手登录人邮箱)
        // 买手登录人邮箱
        Map<String,StringBuffer> buyerLoginUserEmailContentMap = new HashMap<>();
        if (poPlanVOMap.size() > 0){
            for (Map.Entry<String, List<PcsPoPlanVO>> entry : poPlanVOMap.entrySet()) {
                StringBuffer buyerEmailContent = buyerLoginUserEmailContentMap.get(entry.getKey());
                if (EmptyUtil.isEmpty(buyerEmailContent)){
                    buyerEmailContent = new StringBuffer();
                    buyerLoginUserEmailContentMap.put(entry.getKey(),buyerEmailContent);
                }
                buildPopWasteContent(buyerEmailContent,entry.getValue(),null,link,null);
            }
            for (Map.Entry<String,StringBuffer> buyerContentEntry : buyerLoginUserEmailContentMap.entrySet()){
                buyerContentEntry.getValue().append("</tbody></table></html>");
            }
        }

        // pop收货残次 定时任务
        if (!vo.isOnlySendBuyerEmail()){
            // 发送邮件 特殊人发全部行信息，并更新
            sendPopWasteEmail(toAddressList,emailContent.toString()+allEmailContent.toString(),popIds,emailTitle);

            //  针对 采购员发对应的sku行信息,不再更新
            if (buyerLoginUserEmailContentMap.size() > 0){
                for (Map.Entry<String,StringBuffer> entry : buyerLoginUserEmailContentMap.entrySet()){
                    sendPopWasteEmail(Arrays.asList(entry.getKey().split(",")),
                            emailContent.toString()+entry.getValue().toString(),null,emailTitle);
                }
            }
        }
    }

    private void sendEmailHoldPendingAterPopFinished(StringBuffer emailContent,List<PcsPoPlanVO> pcsPoPlanVOs,List<String> toAddressList,
                                                    String link,String emailTitle,PcsPoPlanVO vo){
        emailContent.append("<table id='table-5'><thead><th>PO</th><th>POP</th><th>SKU</th><th>SKU名称</th>" +
                "<th>计划数</th><th>实收良品</th><th>待定数量</th><th>差异</th><th>质检入库时间</th><th>待定原因</th><th>强制处理日期</th><th>残次链接</th></thead><tbody>");
        List<Long> popIds = new ArrayList<>();
        // SKU采购员邮箱对应的数据
        Map<String,List<PcsPoPlanVO>> buyerPoPlanVOMap = new HashMap<>();

        StringBuffer allEmailContent = emailContent;
        // 构建全部行数据，发给特殊收件人
        buildPopHoldPendingContent(allEmailContent,pcsPoPlanVOs,popIds,link,buyerPoPlanVOMap);
        allEmailContent.append("</tbody></table></html>");

        // 构建每个买手创建的数据，发给对应的买手 (买手邮箱为：买手上面配置的邮箱)
        // 买手上面配置的邮箱
        Map<String,StringBuffer> buyerEmailContentMap = new HashMap<>();
        if (buyerPoPlanVOMap.size() > 0){
            for (Map.Entry<String, List<PcsPoPlanVO>> entry : buyerPoPlanVOMap.entrySet()) {
                StringBuffer buyerEmailContent = buyerEmailContentMap.get(entry.getKey());
                if (EmptyUtil.isEmpty(buyerEmailContent)){
                    buyerEmailContent = new StringBuffer();
                    buyerEmailContentMap.put(entry.getKey(),buyerEmailContent);
                }
                buildPopHoldPendingContent(buyerEmailContent,entry.getValue(),null,link,null);
            }
            for (Map.Entry<String,StringBuffer> buyerContentEntry : buyerEmailContentMap.entrySet()){
                buyerContentEntry.getValue().append("</tbody></table></html>");
            }
        }

        // 不再单独发给 固定收件人，而是改为(固定收件人+每个买手的邮箱)
        // pop收货残次 定时任务
        /*if (!vo.isOnlySendBuyerEmail()){
            // 发送邮件 特殊人发全部行信息，并更新
            sendPopWasteEmail(toAddressList,emailContent.toString()+allEmailContent.toString(),popIds,true,emailTitle);
        }*/
        // 采购残次待定未处理 (定时任务 及 pop收货完成时发送)
        if (buyerEmailContentMap.size() > 0){
            for (Map.Entry<String,StringBuffer> entry : buyerEmailContentMap.entrySet()){
                String entryKey = entry.getKey();
                boolean hasUndeterminedQuantity = checkHasUndeterminedQuantity(buyerPoPlanVOMap.get(entryKey));
                if (hasUndeterminedQuantity) {
                    if(!emailTitle.contains("有待定商品需处理")) {
                        emailTitle += "（有待定商品需处理）";
                    }
                    /*toAddressList = Arrays.asList(PegasusUtilFacade.getInstance().
                            findConfigByKey("cronSendEmailByHoldpendingAterPopFinished.quality.toAddress").getConfigValue().split(","));*/
                }
                // 发送给 (固定收件人+当前sku的买手)
                // 固定收件人邮箱
                //waitSendAddressSet.addAll(toAddressList);
                //emailContent.append(entry.getValue());

                // 买手邮箱
                //waitSendAddressSet.addAll(Arrays.asList(entryKey.split(",")));

            }
            sendPopWasteEmail(toAddressList, allEmailContent.toString(),popIds,emailTitle);
        }
    }

    /**
     * 检查是否有 待定数量
     * @param pcsPoPlanVOs
     * @return
     */
    private boolean checkHasUndeterminedQuantity(List<PcsPoPlanVO> pcsPoPlanVOs) {
      if (pcsPoPlanVOs == null || pcsPoPlanVOs.size() == 0) {
        return false;
      }
      for(PcsPoPlanVO poPlanVO : pcsPoPlanVOs) {
        if (poPlanVO.isHasUndeterminedQuantity()) {
            return true;
        }
      }
      return false;
    }



    private void sendEmailByWasteAterPopFinished(List<PcsPoPlanVO> pcsPoPlanVOs,List<String> toAddressList,
                                                 String link,String emailTitle,PcsPoPlanVO vo) {
        final int sendMailOrigin = vo.getSendPopEmailOrigin();
        StringBuffer emailContent = new StringBuffer();
        emailContent.append("<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
        emailContent.append("#table-5 td {color: #000;}");
        emailContent.append("#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
        emailContent.append("#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
        if (PcsPoPlanVO.SEND_POP_EMAIL_ORIGIN_HOLD_PENDING == sendMailOrigin){
            log.info("采购入库邮件--sendEmailByWasteAterPopFinished:{}", vo.getCode());
            sendEmailHoldPendingAterPopFinished(emailContent,pcsPoPlanVOs,toAddressList,
                    link,emailTitle,vo);
        }else{
            sendEmailWasteAterPopFinished(emailContent,pcsPoPlanVOs,toAddressList,
                    link,emailTitle,vo);
        }
    }

    private void sendPopWasteEmail(List<String> toAddressList,String emailContent,
                                   List<Long> popIds,String emailTitle){
        EmailVO emailVO = new EmailVO();
        emailVO.setToAddressList(toAddressList);
        emailVO.setSubject(emailTitle);
        emailVO.setContent(emailContent);
        // 发邮件
        if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
            // 正式环境发邮件
            try {
                log.info("开始发送"+emailTitle+"邮件：" + emailVO.getToAddressList());
                boolean result = emailSendService.send(emailVO);
                if (result && CollectionUtils.isNotEmpty(popIds)){
                    // 更新发送邮件提醒标志
                    updatePcsPoPlanWarnFlagByIds(popIds);
                }
                log.info("成功发送"+emailTitle+"邮件：" + emailVO.getToAddressList());
            }catch (Exception e){
                log.error("入库邮件发送失败----POP{}", JSON.toJSONString(popIds));
                e.printStackTrace();
            }
        }
    }

    /**
     * 组装 pop 残次邮件内容
     * @param emailContent
     * @param pcsPoPlanVOs
     * @param popIds
     * @param link
     * @param poPlanVOMap
     */
    private void buildPopWasteContent(StringBuffer emailContent, List<PcsPoPlanVO> pcsPoPlanVOs,List<Long> popIds,
                                      String link,Map<String,List<PcsPoPlanVO>> poPlanVOMap){
        for (PcsPoPlanVO pcsPoPlanVO : pcsPoPlanVOs) {
            emailContent.append("<tr>");
            emailContent.append("<td>" + pcsPoPlanVO.getPoCode() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getCode() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getSkuCode() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getSkuName() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getPlanedQuantity() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getQuantity() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getWasteQuantity() + "</td>");
            emailContent.append("<td>" + (pcsPoPlanVO.getPlanedQuantity()-pcsPoPlanVO.getQuantity()) + "</td>");
            emailContent.append("<td><a href='"+link+"?popCode="+pcsPoPlanVO.getCode()+"&skuCode="+pcsPoPlanVO.getSkuCode()+"'>残次链接</a></td>");
            emailContent.append("</tr>");
            if (popIds != null){
                popIds.add(pcsPoPlanVO.getId());
            }
            if (poPlanVOMap != null){
                if (EmptyUtil.isNotEmpty(pcsPoPlanVO.getCreateOperatorEmail())){
                    List<PcsPoPlanVO> pcsPoPlanVOsTmp = poPlanVOMap.get(pcsPoPlanVO.getCreateOperatorEmail());
                    if (CollectionUtils.isEmpty(pcsPoPlanVOsTmp)){
                        pcsPoPlanVOsTmp = new ArrayList<>();
                        poPlanVOMap.put(pcsPoPlanVO.getCreateOperatorEmail(),pcsPoPlanVOsTmp);
                    }
                    pcsPoPlanVOsTmp.add(pcsPoPlanVO);
                }
            }
        }
    }

    /**
     * 组装 采购入库待定商品 邮件内容
     * @param emailContent
     * @param pcsPoPlanVOs
     * @param popIds
     * @param link
     * @param buyerPoPlanVOMap
     */
    private void buildPopHoldPendingContent(StringBuffer emailContent, List<PcsPoPlanVO> pcsPoPlanVOs,List<Long> popIds,
                                      String link,Map<String,List<PcsPoPlanVO>> buyerPoPlanVOMap){
        for (PcsPoPlanVO pcsPoPlanVO : pcsPoPlanVOs) {
            //计划数
            int planedQuantity = pcsPoPlanVO.getPlanedQuantity() == null ? 0 : pcsPoPlanVO.getPlanedQuantity();
            //实收良品
            int qcQuantity = pcsPoPlanVO.getQuantity() == null ? 0 : pcsPoPlanVO.getQuantity();
            //待定数
            int qcWasteQuantity =  pcsPoPlanVO.getWasteQuantity() == null ? 0 : pcsPoPlanVO.getWasteQuantity();
            if (qcWasteQuantity > 0 ||  planedQuantity - qcQuantity > 0) {
                emailContent.append("<tr bgcolor=\"#FF9F9F\">");
            } else {
                emailContent.append("<tr>");
            }
            emailContent.append("<td>" + pcsPoPlanVO.getPoCode() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getCode() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getSkuCode() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getSkuName() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getPlanedQuantity() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getQuantity() + "</td>");
            emailContent.append("<td>" + pcsPoPlanVO.getWasteQuantity() + "</td>");
            emailContent.append("<td>" + (pcsPoPlanVO.getPlanedQuantity() - pcsPoPlanVO.getQuantity()) + "</td>");
            emailContent.append("<td>" + formatDate(pcsPoPlanVO.getQcCreateTime(),DateUtil.DEFAULT_DATETIME_FORMAT) + "</td>");
            if (qcWasteQuantity > 0) {
              emailContent.append("<td>" + pcsPoPlanVO.getQcRemark() + "</td>");
              emailContent.append("<td>" + formatDate(pcsPoPlanVO.getSystemProcessTime(), DateUtil.DEFAULT_DATE_FORMAT) + "</td>");
              emailContent.append("<td><a href='" + link + "?qcId=" + pcsPoPlanVO.getQcId() + "&popCode=" + pcsPoPlanVO.getCode() + "&skuCode=" + pcsPoPlanVO.getSkuCode() + "&originType=1" + "'>残次链接</a></td>");
            } else {
              emailContent.append("<td></td>");
              emailContent.append("<td></td>");
              emailContent.append("<td></td>");
            }
            emailContent.append("</tr>");
            if (popIds != null){
                popIds.add(pcsPoPlanVO.getId());
            }
            if (buyerPoPlanVOMap != null){
                if (EmptyUtil.isNotEmpty(pcsPoPlanVO.getBuyerEmailAddress())){
                    List<PcsPoPlanVO> pcsPoPlanVOsTmp = buyerPoPlanVOMap.get(pcsPoPlanVO.getBuyerEmailAddress());
                    if (CollectionUtils.isEmpty(pcsPoPlanVOsTmp)){
                        pcsPoPlanVOsTmp = new ArrayList<>();
                        buyerPoPlanVOMap.put(pcsPoPlanVO.getBuyerEmailAddress(),pcsPoPlanVOsTmp);
                    }
                    pcsPoPlanVOsTmp.add(pcsPoPlanVO);
                }
            }
        }
    }

    private String formatDate(Date date,String format){
        if (EmptyUtil.isEmpty(date)){
            return "";
        }
        return DateUtil.format(date,format);
    }

    private List<PoInfomationVO> findPoInfomation(){
        final List<PoInfomationVO> poList = pcsPoPlanMapper.findPoInfomation();
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        } else {
            return poList;
        }
    }
    @Override
    @Transactional
    public Boolean createPoPlanAndLine(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList) throws Exception {
        if (pcsPoPlanLineList.size() == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "至少需要一个计划行信息");
        }
        pcsPoPlan = create(pcsPoPlan);
        if (EmptyUtil.isEmpty(pcsPoPlan.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "计划头信息保存失败," + pcsPoPlan.toString());
        }
        for (PcsPoPlanLine line : pcsPoPlanLineList) {
            line.setPoPlanId(pcsPoPlan.getId());
            if (pcsPoPlanLineService.create(line).compareTo(0L) < 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "计划行信息保存失败," + line.toString());
            }
        }
        WhCommandVO whCommand = bulidWhCommand(pcsPoPlan, pcsPoPlanLineList);
        pcsPoPlan.setWhCommandCode(wWhCommandService.createCommand(whCommand));
        if (!update(pcsPoPlan)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "计划头信息更新失败," + pcsPoPlan.toString());
        }
        PcsPurchaseOrder pcsPurchaseOrder = pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId());
        String poCode = pcsPurchaseOrder.getCode();
        pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_RECEIVE);
        pcsPurchaseOrderService.update(pcsPurchaseOrder);

        //关务跟踪需要创建物流单
        if (pcsPurchaseOrder.getNeedCustomsArrange()) {
            PcsPoPlanLogisticsBillVO logisticsBill = new PcsPoPlanLogisticsBillVO();
            logisticsBill.setPoCode(poCode);
            logisticsBill.setPopCode(pcsPoPlan.getCode());
            logisticsBill.setCreator(pcsPoPlan.getCreateOperatorId());
            logisticsBill.setCreateTime(pcsPoPlan.getCreateTime());
            logisticsBill.setBillStatus(PoLogisticsEnum.WAITING_SUBMIT.getKey());
            logisticsBill.setPoId(pcsPurchaseOrder.getId());
            logisticsBill.setPopId(pcsPoPlan.getId());
            pcsPoLogisticsBillService.savePopLogisticsBill(logisticsBill);
        }

        return true;
    }

    @Override
    @Transactional
    public Boolean createPoPlanAndLineThenFinish(PcsPoPlan pcsPoPlan, List<PcsPoPlanLine> pcsPoPlanLineList) throws Exception {
        if (pcsPoPlanLineList.size() == 0) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "至少需要一个计划行信息");
        }
        pcsPoPlan.setPlanedSendDate(DateUtil.getNow());
        pcsPoPlan.setPlanedReceiveDate(DateUtil.getNow());
        pcsPoPlan = create(pcsPoPlan);
        if (EmptyUtil.isEmpty(pcsPoPlan.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "计划头信息保存失败," + pcsPoPlan.toString());
        }
        for (PcsPoPlanLine line : pcsPoPlanLineList) {
            line.setPoPlanId(pcsPoPlan.getId());
            Integer quantity = line.getQuantity();
            Integer wasteQuantity = line.getWasteQuantity();
            if (pcsPoPlanLineService.create(line).compareTo(0L) < 1) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "计划行信息保存失败," + line.toString());
            }
            line.setQuantity(quantity);
            line.setWasteQuantity(wasteQuantity);
            if (!pcsPoPlanLineService.update(line)) {
                throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_INSERT_DB, "计划行信息更新失败," + line.toString());
            }
        }
        WhCommandVO whCommandForCreate = bulidWhCommand(pcsPoPlan, pcsPoPlanLineList);
        pcsPoPlan.setWhCommandCode(wWhCommandService.createCommandThenFinish(whCommandForCreate));
        if(EmptyUtil.isEmpty(pcsPoPlan.getWhCommandCode())){
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "仓库指令生成失败," + pcsPoPlan.toString());
        }
        pcsPoPlan.setReceiveDate(DateUtil.getNow());
        pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_ALREADY_IN);
        if (!update(pcsPoPlan)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ERROR_UPDATE_DB, "计划头信息更新失败," + pcsPoPlan.toString());
        }
        return true;
    }

    @Override
    public List<PcsPoPlan> findPcsPoPlanByPoId(long poId) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andPoIdEqualTo(poId);
        final List<PcsPoPlan> poList = pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        } else {
            return poList;
        }
    }

    @Override
    public List<PcsPoPlanVO> findPopVOsByCond(PcsPoPlanCond cond) {
        List<PcsPoPlanVO> poPlanVOs = pcsPoPlanMapper.findPopVOsByCond(cond);
        if (cond.isFetchPopLine() && CollectionUtils.isNotEmpty(poPlanVOs)){
            List<Long> popIds = new ArrayList<>();
            poPlanVOs.forEach(pop -> {
                popIds.add(pop.getId());
            });
            buildPopLineToPopVO(poPlanVOs, popIds);
        }
        return poPlanVOs;
    }

    @Override
    public List<PcsPoPlanVO> findPcsPoPlanByPoIds(List<Long> poIds,boolean cascade) {
        PcsPoPlanExample example = new PcsPoPlanExample();
        example.createCriteria().andPoIdIn(poIds);
        example.setOrderByClause("PO_ID desc");
        final List<PcsPoPlan> poList = pcsPoPlanMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        } else {
            List<Long> poPlanIds = new ArrayList<>();
            List<PcsPoPlanVO> vos = new ArrayList<>(poList.size());
            for (PcsPoPlan record : poList) {
                poPlanIds.add(record.getId());
                PcsPoPlanVO vo = buildFromModel(record);
                vos.add(vo);
            }
            if(cascade){
                buildPopLineToPopVO(vos, poPlanIds);
            }
            return vos;
        }
    }

    private void buildPopLineToPopVO(List<PcsPoPlanVO> vos, List<Long> poPlanIds){
        Map<Long,List<PcsPoPlanLineVO>> popLineMap = findPoPlanLineMap(poPlanIds);
        if(!popLineMap.isEmpty()){
            for(PcsPoPlanVO vo : vos) {
                List<PcsPoPlanLineVO> lineList = popLineMap.get(vo.getId());
                if(NullUtil.isNotNull(lineList)){
                    vo.setPcsPoPlanLineVOList(lineList);
                }
            }
        }
    }

    @Override
    public List<PcsPoPlan> findPcsPoPlanByCond(PcsPoPlanCond cond) {
        PcsPoPlanExample example = buildPcsPoPlanExample(cond);
        return pcsPoPlanMapper.selectByExample(example);
    }

    private PcsPoPlanExample buildPcsPoPlanExample(PcsPoPlanCond cond){
        PcsPoPlanExample example = new PcsPoPlanExample();
        PcsPoPlanExample.Criteria criteria = example.createCriteria();
        if (EmptyUtil.isNotEmpty(cond.getId())){
            criteria.andIdEqualTo(cond.getId());
        }else if(CollectionUtils.isNotEmpty(cond.getIds())){
            criteria.andIdIn(cond.getIds());
        }
        if (EmptyUtil.isNotEmpty(cond.getCode())){
            criteria.andCodeEqualTo(cond.getCode());
        }else if(CollectionUtils.isNotEmpty(cond.getCodes())){
            criteria.andCodeIn(cond.getCodes());
        }
        if (EmptyUtil.isNotEmpty(cond.getPlanStatus())){
            criteria.andPlanStatusEqualTo(cond.getPlanStatus());
        }
        if (EmptyUtil.isNotEmpty(cond.getPoId())){
            criteria.andPoIdEqualTo(cond.getPoId());
        }
        if (EmptyUtil.isNotEmpty(cond.getWhCommandCode())){
            criteria.andWhCommandCodeEqualTo(cond.getWhCommandCode());
        }
        if (EmptyUtil.isNotEmpty(cond.getWarnFlag())){
            criteria.andWarnFlagEqualTo(cond.getWarnFlag());
        }
        if(EmptyUtil.isNotEmpty(cond.getGoldjetInboundNum())){
        	criteria.andGoldjetInboundNumEqualTo(cond.getGoldjetInboundNum());
        }
        if (EmptyUtil.isNotEmpty(cond.getBillOfLading())){
            criteria.andBillOfLadingEqualTo(cond.getBillOfLading());
        }else if(EmptyUtil.isNotEmpty(cond.getBillOfLadingLike())){
            criteria.andBillOfLadingLike(SQLUtils.allLike(cond.getBillOfLading()));
        }
        return example;
    }

    @Override
    public Map<Long,List<PcsPoPlanLineVO>> findPoPlanLineMap(List<Long> poPlanIds){
        Map<Long,List<PcsPoPlanLineVO>> map = new HashMap<>();
        List<PcsPoPlanLineVO> lineList = pcsPoPlanLineService.findPoPlanLineVOByPoPlanIds(poPlanIds);
        if(EmptyUtil.isNotEmpty(lineList)){
            for(PcsPoPlanLineVO poPlanLineVO : lineList){
                List<PcsPoPlanLineVO> tmpList = map.get(poPlanLineVO.getPoPlanId());
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    map.put(poPlanLineVO.getPoPlanId(),tmpList);
                }
                tmpList.add(poPlanLineVO);
            }
        }
        return map;
    }

    @Override
    @Transactional
    public Boolean synPoPlanAndLine(PcsPoPlan poPlan) {
        WhCommandVO whCommand = wWhCommandService.findCommandByCode(poPlan.getWhCommandCode(), true);
        if (EmptyUtil.isNotEmpty(whCommand) && whCommand.getCommandStatus().equals(WhCommandVO.STATUS_FINISHED)) {
            List<PcsPoPlanLine> pcsPoPlanLineList = pcsPoPlanLineService.findPoPlanLineByPoPlanId(poPlan.getId());
            for (PcsPoPlanLine poPlanLine : pcsPoPlanLineList) {
                for (WhCommandSkuVO whCommandSku : whCommand.getWhCommandSkuList()) {
                    if (!poPlanLine.getSkuCode().equals(whCommandSku.getSkuCode())) {
                        continue;
                    }
                    poPlanLine.setQuantity(whCommandSku.getQuantity());
                    poPlanLine.setWasteQuantity(whCommandSku.getDamagedQuantity());
                    pcsPoPlanLineService.update(poPlanLine);
                }
            }
            poPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_ALREADY_IN);
            poPlan.setReceiveDate(whCommand.getProcessTime());
            update(poPlan);
        }
        return true;
    }
    @Override
    public byte[] exportPoInfomation() {
        List<PoInfomationVO> poList = findPoInfomation();
        if(CollectionUtils.isEmpty(poList)){
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM,"没有相关数据");
        }
        Map<String, List<List<String>>> sheets = new HashMap<String, List<List<String>>>();
        List<List<String>> allLines = new ArrayList<>();
        List<String> head = new ArrayList<>();
        // head
        head.add("采购单编号");
        head.add("采购单状态");
        head.add("供应商");
        head.add("目标仓库");
        head.add("创建时间");
        head.add("创建人");
        head.add("审核时间");
        head.add("SKU");
        head.add("SKU名");
        head.add("要求交货日期");
        head.add("数量");
        head.add("单价");
        head.add("总价");
        head.add("实收良品");
        head.add("实收残次");
        head.add("待收数量");
        allLines.add(head);
        for(PoInfomationVO vo:poList){
            List<String> list = new ArrayList<>();
            list.add(vo.getPoCode());
            list.add(vo.getPurchaseOrderStatus());
            list.add(vo.getSuppName());
            list.add(vo.getHouseName());
            list.add(vo.getCreateTime());
            list.add(vo.getNickName());
            list.add(vo.getAuditTime());
            list.add(vo.getSkuCode());
            list.add(vo.getSkuName());
            list.add(vo.getAskDeliveryDate());
            list.add(vo.getQuantity());
            list.add(vo.getUnitPriceAfterTax());
            list.add(vo.getTotalPriceAfterTax());
            list.add(vo.getReceiveQuantity());
            list.add(vo.getWasteQuantity());
            list.add(vo.getWaitStockAmout());
            allLines.add(list);
        }


        //return bytes
        sheets.put("采购单明细", allLines);
        byte[] res = new ExcelUtil().write(sheets, true);
        return res;
    }

    @Override
    public byte[] exportPoPlanStatusWaitingIn() {
        List<PcsPoPlan> poPlans = findPoPlanByStatus(PcsPoPlan.PLAN_STATUS_WAITING_IN);
        if(CollectionUtils.isEmpty(poPlans)){
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM,"没有相关数据");
        }
        Map<String, List<List<String>>> sheets = new HashMap<String, List<List<String>>>();
        List<List<String>> allLines = new ArrayList<>();
        List<String> head = new ArrayList<>();
        // head
        head.add("采购单编号");
        head.add("创建人");
        head.add("SKU");
        head.add("SKU名");
        head.add("采购单数量");
        head.add("收货计划编号");
        head.add("收货状态");
        head.add("计划发货日期");
//        head.add("供应商");
       
//        head.add("创建时间");
//        head.add("审核人");
//        head.add("审核时间");
       
//        head.add("计划发货日期");
        head.add("计划收货日期");
        head.add("实际收货日期");
        head.add("计划入数量");
      /*  head.add("实际入库数量");
        head.add("实际入库良品数量");
        head.add("实际入库次品数量");*/
//        head.add("采购单价");
//        head.add("行总金额");
        allLines.add(head);

        //缓存
        Map<Long,PcsPurchaseOrderVO> poVOMap = new HashMap<>();
        Map<Long,List<PcsPoLine>> poLinesMap = new HashMap<>();
        Map<Long,String> poAuditUserNameMap = new HashMap<>();

        for (PcsPoPlan poPlan : poPlans) {
            if(!poVOMap.containsKey(poPlan.getPoId())){
                PcsPurchaseOrderVO poVO = pcsPurchaseOrderService.findPoVOById(poPlan.getPoId());
                poVOMap.put(poPlan.getPoId(),poVO);
            }
            if(!poLinesMap.containsKey(poPlan.getPoId())){
               List<PcsPoLine> poLines = pcsPoLineService.findPoLineByPoId(poPlan.getPoId());
               poLinesMap.put(poPlan.getPoId(),poLines);
            }
            if(!poAuditUserNameMap.containsKey(poPlan.getPoId())){
                List<CommEntityOpRcdVO> commEntityOpRcds = commEntityOperationRcdService.
                        findEntityOpRcdByClazzAndId("PcsPurchaseOrder", poPlan.getPoId().toString());
                poAuditUserNameMap.put(poPlan.getPoId(),"");
                for (CommEntityOpRcdVO commEntityOpRcd : commEntityOpRcds) {
                    if(!commEntityOpRcd.getOperationDesc().equals("审核通过采购单")){
                        continue;
                    }
                    poAuditUserNameMap.put(poPlan.getPoId(),commEntityOpRcd.getOperatorName());
                }
            }
        }

         Map<String, Integer> skuPoPlan = new HashMap<>();;
         //遍历poPlan 生成excel line
        for (PcsPoPlan poPlan : poPlans) {
            List<PcsPoPlanLineVO> poPlanLineVOs = pcsPoPlanLineService.findPoPlanLineVOByPoPlanId(poPlan.getId());
            PcsPurchaseOrderVO poVO = poVOMap.get(poPlan.getPoId());//采购单
            List<PcsPoLine> poLines = poLinesMap.get(poPlan.getPoId());//采购单行
            String poAuditUserName = poAuditUserNameMap.get(poPlan.getPoId());
            for (PcsPoPlanLineVO poPlanLineVO : poPlanLineVOs) {
            	
            	String skuCode = poPlanLineVO.getSkuCode();
            	skuPoPlan.put(skuCode, (skuPoPlan.get(skuCode) == null ? 0 : skuPoPlan.get(skuCode)) + 1);
            	
                List<String> line = new ArrayList<>();
                line.add(poVO.getCode());
                line.add(poVO.getCreateOperatorName());
                line.add(poPlanLineVO.getSkuCode());
                line.add(poPlanLineVO.getSkuNameCn());
                line.add(poPlanLineVO.getQuantity() + "");
                line.add(poPlan.getCode());
                line.add("待入库");
//                line.add(poVO.getSupplierNameCn());
               
//                line.add(DateUtil.format(poVO.getCreateTime(),DateUtil.DEFAULT_DATE_FORMAT));
//                line.add(poAuditUserName);
//                line.add(DateUtil.format(poVO.getAuditTime(),DateUtil.DEFAULT_DATE_FORMAT));
               
//                line.add(DateUtil.format(poPlan.getPlanedSendDate(),DateUtil.DEFAULT_DATE_FORMAT));
                line.add(DateUtil.format(poPlan.getPlanedSendDate(), DateUtil.DEFAULT_DATE_FORMAT));
                line.add(DateUtil.format(poPlan.getPlanedReceiveDate(), DateUtil.DEFAULT_DATE_FORMAT));
                line.add(DateUtil.format(poPlan.getReceiveDate(), DateUtil.DEFAULT_DATE_FORMAT));
                line.add(poPlanLineVO.getPlanedQuantity().toString());
              /*  line.add(poPlanLineVO.getQuantity() + poPlanLineVO.getWasteQuantity() + "");
                line.add(poPlanLineVO.getQuantity() + "");
                line.add(poPlanLineVO.getWasteQuantity() + "");*/
                
//                line.add("");
//                line.add("");

//                for (PcsPoLine poLine : poLines) {
//                    if(!poPlanLineVO.getSkuCode().equals(poLine.getSkuCode())){
//                        continue;
//                    }
//                    line.set(12,poLine.getUnitPrice().toString());
//                    line.set(13,poLine.getUnitPrice().multiply(new BigDecimal(poPlanLineVO.getPlanedQuantity())).toString());
//                }

                allLines.add(line);
            }
        }

      /*  //采购单数量补充
       for (int i = 0; i < allLines.size(); i++) {
    		List<String> line = allLines.get(i);
    		if(i != 0) {
	        	String skuCode = line.get(2);
	        	line.set(4, (skuPoPlan.get(skuCode) == null ? "0" : skuPoPlan.get(skuCode))  + "");
    		}
        }*/
        
        //return bytes
        sheets.put("收货计划-待入库", allLines);
        byte[] res = new ExcelUtil().write(sheets, true);
        return res;
    }

    @Override
    public Boolean check(Object obj) {
        PcsPoPlan record = (PcsPoPlan) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }

    private Boolean check(PcsPoPlan record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (isCreate && (EmptyUtil.isEmpty(record.getPoId()))) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "采购单ID为空");
        }
        if (isCreate && EmptyUtil.isEmpty(pcsPurchaseOrderService.findPoById(record.getPoId()))) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "采购单ID数据库不存在");
        }
        return true;
    }

    private Boolean check(String code) {
        return NullUtil.isNull(findPoPlanByCode(code)) ? true : false;
    }

    @Override
    public String generateCode(Object id) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        return CodeGenerator.getInstance().generate("PCS_PO_PLAN", params);
    }

    /**
     * 更新采购单收货计划
     *
     * @return 是否成功
     */
    @Override
    public boolean updatePoPlan(PcsPoPlan po) {
        int rs=0;
        rs=pcsPoPlanMapper.updateByPrimaryKeySelective(po);
        return rs>0;
    }

    /**
     * 更新采购单收货计划行；
     *
     * @return 是否成功
     */
    @Override
    public boolean updatePoPlanLine(PcsPoPlanLine line) {
//        if(line.getQuantity()!=null&&line.getQuantity()!=0) {
//            PcsPoPlanLine lineVo = pcsPoPlanLineMapper.selectByPrimaryKey(line.getId());
//            line.setQuantity(lineVo.getQuantity() + line.getQuantity());
//        }
        return pcsPoPlanLineMapper.updateByPrimaryKeySelective(line) !=0;
    }

    @Override
    public boolean isAllPoPlanFinished(Long poId) {
        int result = pcsPoPlanMapper.isAllPoPlanFinished(poId);
        if(result == 0){
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllReceivePo(Long poId) {
        int result = pcsPoPlanMapper.isAllReceivePo(poId);
        if(result == 0){
            return  true;
        }
        return false;
    }

    @Override
    @Transactional
    public Boolean closePoPlanByPlanId(Long poPlandId) {
        PcsPoPlan pcsPoPlan = pcsPoPlanMapper.selectByPrimaryKey(poPlandId);
        if(pcsPoPlan != null && pcsPoPlan.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING_RECEIVE)){
            //处理对应物流单
            pcsPoLogisticsBillService.closePoPlan(poPlandId);
            return closePoPlanByPlanId(pcsPoPlan);
        }else{
            throw new RuntimeException("收货计划不存在或收货计划不是待收货状态");
        }
    }

    @Override
    public Boolean closePoPlanByPlanIdCheckCommand(Long poPlandId,Integer whCommandId) {
        PcsPoPlan pcsPoPlan = pcsPoPlanMapper.selectByPrimaryKey(poPlandId);
        WhCommandVO whCommand = wWhCommandService.findCommandById(whCommandId,false);
        if(pcsPoPlan == null || whCommand == null ||
                (!WhCommandVO.STATUS_WAITING_QUALITY_CONTROL.equals(whCommand.getCommandStatus())
                    && !WhCommandVO.STATUS_QUALITY_PROCESSING.equals(whCommand.getCommandStatus()))){
            throw new RuntimeException("收货计划不存在或指令不存在或指令不是(待质检、质检中)状态");
        }else{
            return closePoPlanByPlanId(pcsPoPlan);
        }
    }

    private Boolean closePoPlanByPlanId(PcsPoPlan pcsPoPlan) {
        // 关闭pop时，如果有收货信息，则指令设置为收货完成，没有收货信息则关闭
        Integer hasReceive = pcsPoPlanMapper.checkPopHasReceive(pcsPoPlan.getId());
        WhCommandVO whCommand = wWhCommandService.findCommandByTypeAndReferenceCode(WhCommandVO.TYPE_PURCHASE_IN,pcsPoPlan.getCode(),false);
        if (EmptyUtil.isNotEmpty(hasReceive) && hasReceive > 0){
            pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_FINISHED);
            pcsPoPlan.setReceiveDate(DateUtil.getNow());
            pcsPoPlanMapper.updateByPrimaryKeySelective(pcsPoPlan);
            if (whCommand != null){
                // 指令设置为收货完成
                wWhCommandService.updateCommandStatusById(Integer.parseInt(whCommand.getId()+""),WhCommandVO.STATUS_QUALITY_FINISHED);
            }
        }else{
            // pop关闭
            pcsPoPlan.setPlanStatus(PcsPoPlan.PLAN_STATUS_CLOSED);
            pcsPoPlanMapper.updateByPrimaryKey(pcsPoPlan);
            // facadeWhInner.colseCommandByReferenceCode(WhCommandVO.TYPE_PURCHASE_IN,pcsPoPlan.getCode());
            // 指令设置为完成
            if (whCommand != null){
                wWhCommandService.updateCommandStatusById(Integer.parseInt(whCommand.getId()+""),WhCommandVO.STATUS_FINISHED);
            }
        }
        List<PcsPoPlan> pcsPoPlanList = findPcsPoPlanByPoId(pcsPoPlan.getPoId());
        boolean isUpdate = true;
        for(PcsPoPlan pcsPoPlan1:pcsPoPlanList){
            if(pcsPoPlan1.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING_IN) || pcsPoPlan1.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING_RECEIVE) || pcsPoPlan1.getPlanStatus().equals(PcsPoPlan.PLAN_STATUS_WAITING)){
                isUpdate = false;
                break;
            }
        }
        if(isUpdate){
            PcsPurchaseOrder pcsPurchaseOrder = pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId());
            if(!pcsPurchaseOrder.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE)){
                pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                pcsPurchaseOrderService.update(pcsPurchaseOrder);
            }
        }
        return true;
    }

	@Override
	@Transactional
	public int createPoPlanFee(PcsPoPlanCost pcsPoPlanCost) {
		//pcsPoPlanCost.setTotalPrice(pcsPoPlanCost.getUnitPrice().multiply(new BigDecimal(pcsPoPlanCost.getQuantity())));
		if(pcsPoPlanCost.getAvailable() == null){
			pcsPoPlanCost.setAvailable((byte) 1);
		}
		//有效数据才去更新采购单总金额
		if (pcsPoPlanCost.getAvailable() == 1) {
     updatePoTotalAmount(pcsPoPlanCost, 0);
    }
		pcsPoPlanCost.setCreateTime(new Date());
		return pcsPoPlanCostMapper.insertSelective(pcsPoPlanCost);
	}

    @Override
    public int batchCreatePoPlanFee(List<PcsPoPlanCost> pcsPoPlanCosts) {
        batchUpdatePoTotalAmount(pcsPoPlanCosts,0);
        return pcsPoPlanCostMapper.batchInsertPoPlanCost(pcsPoPlanCosts);
    }

    @Override
	public List<PcsPoPlanCost> selectCostByPoPlanId(Integer poPlanId) {
		return pcsPoPlanCostMapper.selectCostByPoPlanId(poPlanId);
	}

    @Override
    public List<PcsPoPlanCost> listPcsPoPlanCostByPopIds(List<Integer> popIds) {
        PcsPoPlanCostExample example = new PcsPoPlanCostExample();
        PcsPoPlanCostExample.Criteria criteria = example.createCriteria();
        criteria.andPoPlanIdIn(popIds);
        criteria.andAvailableEqualTo((byte)1);
        return pcsPoPlanCostMapper.selectByExample(example);
    }

    @Override
    public Map<Integer, List<PcsPoPlanCost>> mapPcsPoPlanCost(List<Integer> popIds) {
        Map<Integer,List<PcsPoPlanCost>> map = new HashMap<>();
        List<PcsPoPlanCost> poPlanCosts = listPcsPoPlanCostByPopIds(popIds);
        if(EmptyUtil.isNotEmpty(poPlanCosts)){
            poPlanCosts.forEach(poPlanCost -> {
                List<PcsPoPlanCost> tmpList = map.get(poPlanCost.getPoPlanId());
                if(NullUtil.isNull(tmpList)){
                    tmpList = new ArrayList<>();
                    map.put(poPlanCost.getPoPlanId(),tmpList);
                }
                tmpList.add(poPlanCost);
            });
        }
        return map;
    }

    @Override
    public List<PcsPoPlanCostVO> listPoPlanCostVOsByGroup(PcsPoPlanCostCond cond) {
        return pcsPoPlanCostMapper.listPoPlanCostVOsByGroup(cond);
    }

    @Override
    public List<PcsPoPlanCostVO> listPoPlanCostVOs(PcsPoPlanCostCond cond) {
        return pcsPoPlanCostMapper.listPoPlanCostVOs(cond);
    }

    @Override
    public Pagination<PcsPoPlanCostVO> pagePoPlanCostVOs(PcsPoPlanCostCond cond) {
        Pagination<PcsPoPlanCostVO> page = new Pagination<>(cond.getCurrpage(), cond.getPagenum());
        int count = countPoPlanCostVOsByGroup(cond);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero(count)){
            return page;
        }
        List<PcsPoPlanCostVO> poPlanCostVOs = pcsPoPlanCostMapper.listPoPlanCostVOsByGroup(cond);
        page.setResultList(poPlanCostVOs);
        return page;
    }

    private Integer countPoPlanCostVOsByGroup(PcsPoPlanCostCond cond){
        return pcsPoPlanCostMapper.countPoPlanCostVOsByGroup(cond);
    }

    @Override
    public List<PcsPoPlanCost> findPoCostDetails(Integer poId) {
        return pcsPoPlanCostMapper.findPoPCostDetailByPoId(poId);
    }

	@Override
	public int updatePoTotalAmount(PcsPoPlanCost pcsPoPlanCost, int optType) {
		return batchUpdatePoTotalAmount(Collections.singletonList(pcsPoPlanCost),optType);
	}

public int batchUpdatePoTotalAmount(List<PcsPoPlanCost> pcsPoPlanCosts, int optType) {
    if (CollectionUtils.isEmpty(pcsPoPlanCosts)){
        return 1;
    }
    Integer popId = pcsPoPlanCosts.get(0).getPoPlanId();
		PcsPurchaseOrder pcsPurchaseOrder = pcsPurchaseOrderService.findPoById(pcsPoPlanMapper.selectByPrimaryKey(Long.parseLong(popId.toString())).getPoId());
		BigDecimal purchaseCurrencyRate = pcsPurchaseOrder.getPurchaseCurrencyRate();
    if(optType == 0) {
        for (PcsPoPlanCost poPlanCost : pcsPoPlanCosts) {
            pcsPurchaseOrder.setTotalAmount(pcsPurchaseOrder.getTotalAmount().add(poPlanCost.getAfterTaxAmount().divide(purchaseCurrencyRate, 2, ROUND_HALF_DOWN)));
            pcsPurchaseOrder.setTotalAmountAfterTax(pcsPurchaseOrder.getTotalAmountAfterTax().add(poPlanCost.getPreTaxAmount().divide(purchaseCurrencyRate, 2, ROUND_HALF_DOWN)));
        }
		} else {
      for (PcsPoPlanCost poPlanCost : pcsPoPlanCosts){
        pcsPurchaseOrder.setTotalAmount(pcsPurchaseOrder.getTotalAmount().subtract(poPlanCost.getAfterTaxAmount().divide(purchaseCurrencyRate, 2, ROUND_HALF_DOWN)));
        pcsPurchaseOrder.setTotalAmountAfterTax(pcsPurchaseOrder.getTotalAmountAfterTax().subtract(poPlanCost.getPreTaxAmount().divide(purchaseCurrencyRate, 2, ROUND_HALF_DOWN)));
      }
		}
		if(EmptyUtil.isNotEmpty(pcsPurchaseOrder.getCrossBorderFlag()) && pcsPurchaseOrder.getCrossBorderFlag() == 1) {
			return pcsPurchaseOrderService.update(pcsPurchaseOrder) ? 1 : 0;
		}
		return 1;
	}

	@Override
	public int updatePoPlanFee(PcsPoPlanCost pcsPoPlanCost, int optType) {
		//删除
		if(optType == 1) {
			PcsPoPlanCost oldPcsPoPlanCost = pcsPoPlanCostMapper.selectByPrimaryKey(pcsPoPlanCost.getId());
			updatePoTotalAmount(oldPcsPoPlanCost, 1);
		}
		return pcsPoPlanCostMapper.updateByPrimaryKeySelective(pcsPoPlanCost);
	}

	@Override
	public PcsPoPlanCost selectCostByCostId(Long costId) {
		return pcsPoPlanCostMapper.selectByPrimaryKey(costId);
	}

    @Override
    public Integer closePopPlanEndMonth() {
        return pcsPoPlanCostMapper.closePopPlanEndMonth();
    }
}
