/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import java.util.*;

import com.thebeastshop.pegasus.service.purchase.cond.PcsPoPlanLineCond;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanLineMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLineExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLineVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import com.thebeastshop.common.Pagination;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoPlanLineServiceImpl.java, v 0.1 2015-08-12 15:03
 */
@Service("pcsPoPlanLineService")
public class PcsPoPlanLineServiceImpl implements PcsPoPlanLineService, CheckAble {

    private final Logger log = LoggerFactory.getLogger(PcsPoPlanLineServiceImpl.class);

    @Autowired
    private PcsPoPlanLineMapper pcsPoPlanLineMapper;

    @Autowired
    private McPcsSkuService mcPcsSkuService;

    @Override
    public PcsPoPlanLine buildFromVO(PcsPoPlanLineVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsPoPlanLine record = new PcsPoPlanLine();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    public PcsPoPlanLineVO buildFromModel(PcsPoPlanLine record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsPoPlanLineVO vo = new PcsPoPlanLineVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    @Override
    @Transactional
    public Long create(PcsPoPlanLine record) {
        if (check(record)) {
            if (check(record, true)) {
                record.setQuantity(0);
                record.setWasteQuantity(0);
                pcsPoPlanLineMapper.insertSelective(record);
                return record.getId();
            }
        }
        return null;
    }

    @Override
    @Transactional
    public boolean update(PcsPoPlanLine record) {
        if (check(record)) {
            if (check(record, false)) {
                return pcsPoPlanLineMapper.updateByPrimaryKeySelective(record) != 0;
            }
        }
        return false;
    }

    @Override
    @Transactional
    public int update(List<PcsPoPlanLineVO> records) {
        int rct = 0;
        if (records == null || records.size() == 0) {
         return rct;
        }
        for (PcsPoPlanLineVO pcsPoPlanLineVO : records) {
          rct = pcsPoPlanLineMapper.updateByPrimaryKeySelective(BeanUtil.buildFrom(pcsPoPlanLineVO, PcsPoPlanLine.class));
        }
        return rct;
    }

    @Override
    public List<PcsPoPlanLine> findPoPlanLineByPoPlanId(long poPlanId) {
        PcsPoPlanLineExample example = new PcsPoPlanLineExample();
        example.createCriteria().andPoPlanIdEqualTo(poPlanId);
        final List<PcsPoPlanLine> list = pcsPoPlanLineMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        } else {
            return list;
        }
    }

    @Override
    public List<PcsPoPlanLineVO> findPoPlanLineVOByPoPlanId(long poPlanId) {
        List<PcsPoPlanLineVO> list = pcsPoPlanLineMapper.findPoPlanLineVOByPoPlanId(poPlanId);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        } else {
            return list;
        }
    }
    
    @Override
    public List<PcsPoPlanLineVO> findPoPlanLineVO(boolean cascade) {
        List<PcsPoPlanLineVO> list = pcsPoPlanLineMapper.findPoPlanLineVO();
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        } else {
            return list;
        }
    }

    @Override
    public List<PcsPoPlanLineVO> findPoPlanLineVOByPoPlanIds(List<Long> poPlanIds) {
        List<PcsPoPlanLineVO> list = pcsPoPlanLineMapper.findPoPlanLineVOByPoPlanIds(poPlanIds);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        } else {
            return list;
        }
    }

    @Override
    public Boolean check(Object obj) {
        PcsPoPlanLine record = (PcsPoPlanLine) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }

    private Boolean check(PcsPoPlanLine record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (isCreate && EmptyUtil.isEmpty(record.getPlanedQuantity())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "计划数量为空");
        }
        if (isCreate && EmptyUtil.isEmpty(record.getSkuCode())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "skuCode为空");
        }
        if (isCreate && EmptyUtil.isEmpty(mcPcsSkuService.findByCode(record.getSkuCode()))) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "skuCode数据库不存在");
        }
        return true;
    }

	@Override
	public List<PcsPoPlanLine> findPoPlanLineByPoId(long poId) {
		PcsPoPlanLineExample example = new PcsPoPlanLineExample();
	    example.createCriteria().andPoIdEqualTo(poId);
		List<PcsPoPlanLine> list = pcsPoPlanLineMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        } else {
            return list;
        }
	}

    @Override
    public List<PcsPoPlanLineVO> listPcsPoPlanLineVOByCond(PcsPoPlanLineCond cond) {
        return pcsPoPlanLineMapper.listPoPlanLineVOByCond(cond);
    }

    @Override
    public Pagination<PcsPoPlanLineVO> pagePcsPoPlanLineVOByCond(PcsPoPlanLineCond cond) {
        Pagination<PcsPoPlanLineVO> page = new Pagination<>(cond.getCurrpage(), cond.getPagenum());
        int count = countPcsPoLineByCond(cond);
        page.setRecord(count);
        if (NumberUtil.isNullOrZero(count))
            return page;
        List<PcsPoPlanLineVO> pcsPoPlanLineVOs = pcsPoPlanLineMapper.listPoPlanLineVOByCond(cond);
        page.setResultList(pcsPoPlanLineVOs);
        return page;
    }

    private int countPcsPoLineByCond(PcsPoPlanLineCond cond){
        return pcsPoPlanLineMapper.countPoPlanLineVOByCond(cond);
    }

    @Override
	public List<PcsPoPlanLineVO> findPcsPoPlanLineListByParams(Map<String,Object> params) {
		if(params == null || params.size() == 0){
			return null;
		}

		return pcsPoPlanLineMapper.findPcsPoPlanLineListByParams(params);
	}

    @Override
    @Transactional
    public int addPopLineHsCode(List<PcsPoPlanLineVO> popLines) {
      int rct = 0;
      if (popLines == null || popLines.size() == 0) {
         return 0;
      }
      for (PcsPoPlanLineVO planLineVO : popLines) {
          PcsPoPlanLine pcsPoPlanLine = new PcsPoPlanLine();
          pcsPoPlanLine.setId(planLineVO.getId());
          pcsPoPlanLine.setHsCode(planLineVO.getHsCode());
          rct += pcsPoPlanLineMapper.updateByPrimaryKeySelective(pcsPoPlanLine);
      }

     return rct;
    }

    @Override
    public List<PcsPoPlanLineVO> sumPopSkuTotalQuantity(List<Long> popIds) {
        return pcsPoPlanLineMapper.sumPopSkuTotalQuantity(popIds);
    }

    @Override
    public List<PcsPoPlanLineVO> listIncludeWaste(List<Long> poIds) {
        return pcsPoPlanLineMapper.selectIncludeWaste(poIds);
    }
}