package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.pegasus.integration.email.EmailUtil;
import com.thebeastshop.pegasus.integration.email.vo.EmailVO;
import com.thebeastshop.pegasus.merchandise.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.cond.PoLogisticsBillCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanLineMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanLogisticsBillMapper;
import com.thebeastshop.pegasus.service.purchase.enums.PoLogisticsEnum;
import com.thebeastshop.pegasus.service.purchase.enums.PoPCostTypeEnum;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanCost;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLogisticsBill;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlanLogisticsBillExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLogisticsBillService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanLineService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanLogisticsBillVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPopFeeVO;
import com.thebeastshop.pegasus.service.purchase.vo.PoLogisticsBillStatusTab;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("pcsPoLogisticsBillService")
public class PcsPoLogisticsBillServiceImpl implements PcsPoLogisticsBillService {

    private final static Logger LOGGER = LoggerFactory.getLogger(PcsPoLogisticsBillServiceImpl.class);

    @Autowired
    private PcsPoPlanLogisticsBillMapper pcsPoPlanLogisticsBillMapper;
    @Autowired
    private PcsPoPlanLineMapper pcsPoPlanLineMapper;
    @Autowired
    private PcsPoPlanLineService pcsPoPlanLineService;
    @Autowired
    private PcsPoPlanService pcsPoPlanService;

    @Override
    @Transactional
    public int savePopLogisticsBill(PcsPoPlanLogisticsBillVO logisticsBill) {

        PcsPoPlanLogisticsBill logisticsBillDO = buildVO2DO(logisticsBill);
        pcsPoPlanLineService.addPopLineHsCode(logisticsBill.getPopLines());
        boolean isSave = logisticsBill.isSave();
        //设置申请时间
        if (!isSave) {
            logisticsBillDO.setSubmitApplicationTime(new Date());
            logisticsBillDO.setBillStatus(PoLogisticsEnum.PENDING.getKey());
        }
        if (logisticsBill.getId() == null) {
         return  pcsPoPlanLogisticsBillMapper.insertSelective(logisticsBillDO);
        } else {
          return  pcsPoPlanLogisticsBillMapper.updateByPrimaryKeySelective(logisticsBillDO);
        }
    }

    @Override
    @Transactional
    public int savePopLogisticsBills(List<PcsPoPlanLogisticsBillVO> logisticsBills) {
      if (logisticsBills == null || logisticsBills.size() == 0) {
         return 0;
      }

      buildPopLogisticsBillsStatus(logisticsBills);
      savePOPFee(logisticsBills);
      List<PcsPoPlanLogisticsBill> updateList = BeanUtil.buildListFrom(logisticsBills, PcsPoPlanLogisticsBill.class);
      return pcsPoPlanLogisticsBillMapper.batchUpdateByPrimaryKeySelective(updateList);
    }


    private void savePOPFee(List<PcsPoPlanLogisticsBillVO> logisticsBills) {

      List<Long> popIds = logisticsBills.stream()
              .map(po -> po.getPopId()).collect(Collectors.toList());
      Map<Long, PcsPopFeeVO> popFeeMap = pcsPoPlanService.mapPopFee(popIds);
      Map<Integer, List<PcsPoPlanCost>> listMap = pcsPoPlanService.mapPcsPoPlanCost(popIds.stream()
              .map(popId -> popId.intValue()).collect(Collectors.toList()));
      List<PcsPoPlanCost> pcsPoPlanCosts = new ArrayList<PcsPoPlanCost>();
      Date currentDateTime = new Date();
      List<Long> delIds = new ArrayList<Long>();
      logisticsBills.stream().forEach(logisticsBill -> {
        Long popId = logisticsBill.getPopId();
        PcsPopFeeVO popFeeVO = popFeeMap.get(popId);
        //关税
        BigDecimal tariff = logisticsBill.getTariff();
        //增值税
        BigDecimal vat = logisticsBill.getVat();
        //消费税
        BigDecimal consumptionTaxAmount = logisticsBill.getConsumptionTaxAmount();
        //国内段费用
        BigDecimal internalFee = logisticsBill.getInternalFee();
        //国际段费用
        BigDecimal internationalFee = logisticsBill.getInternationalFee();
        PcsPoPlanCost pcsPoPlanCost = new PcsPoPlanCost();
        pcsPoPlanCost.setCreateTime(currentDateTime);
        pcsPoPlanCost.setPoPlanId(popId.intValue());
        pcsPoPlanCost.setOtherFeeType(-1);
        pcsPoPlanCost.setShipmentType(-1);
        pcsPoPlanCost.setTaxType(-1);
        pcsPoPlanCost.setAvailable((byte)1);
        pcsPoPlanCost.setTaxRate(BigDecimal.ZERO);
        List<PcsPoPlanCost> hisPopCosts = listMap.get(popId.intValue());
        //修改了关税
        if (tariff != null && tariff.compareTo(popFeeVO.getTariffAmount()) != 0) {
          pcsPoPlanCost.setRelationMan(popFeeVO.getTariffAgent());
          pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.TAXES, 1, tariff));
          //pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.TAXES, 1, popFeeVO.getTariffAmount().negate()));
          delIds.addAll(buildDeletePOPCost(PoPCostTypeEnum.TAXES, 1, hisPopCosts));
        }
        //修改了增值税
        if (vat != null && vat.compareTo(popFeeVO.getVatAmount()) != 0) {
          pcsPoPlanCost.setRelationMan(popFeeVO.getVatAgent());
          pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.TAXES, 2, vat));
          //pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.TAXES, 2, popFeeVO.getVatAmount().negate()));
          delIds.addAll(buildDeletePOPCost(PoPCostTypeEnum.TAXES, 2, hisPopCosts));
        }
        //修改了消费税
        if (consumptionTaxAmount != null && consumptionTaxAmount.compareTo(popFeeVO.getConsumptionTaxAmount()) != 0) {
          pcsPoPlanCost.setRelationMan(popFeeVO.getConsumptionTaxAgent());
          pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.TAXES, 3, consumptionTaxAmount));
          //pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.TAXES, 3, popFeeVO.getConsumptionTaxAmount().negate()));
          delIds.addAll(buildDeletePOPCost(PoPCostTypeEnum.TAXES, 3, hisPopCosts));
        }
        //修改了国内段费用
        if (internalFee != null && internalFee.compareTo(popFeeVO.getInternalFee()) != 0) {
          pcsPoPlanCost.setRelationMan(logisticsBill.getInternalAgent());
          pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.LOGISTICS, 13, internalFee));
          //pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.LOGISTICS, 13, popFeeVO.getInternalFee().negate()));
          delIds.addAll(buildDeletePOPCost(PoPCostTypeEnum.LOGISTICS, 13, hisPopCosts));
        } else {
          String internalAgent = logisticsBill.getInternalAgent();
          //修改了国内代理
          if (internalAgent != null && !internalAgent.equals(popFeeVO.getInternalProxy())) {
              pcsPoPlanCost.setRelationMan(logisticsBill.getInternalAgent());
              pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.LOGISTICS, 13, internalFee));
              //pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.LOGISTICS, 13, popFeeVO.getInternalFee().negate()));
              delIds.addAll(buildDeletePOPCost(PoPCostTypeEnum.LOGISTICS, 13, hisPopCosts));
          }
        }


        //修改了国际段费用
        if (internationalFee != null && internationalFee.compareTo(popFeeVO.getInternationalFee()) != 0) {
          pcsPoPlanCost.setRelationMan(logisticsBill.getInternationalAgent());
          pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.LOGISTICS, 14, internationalFee));
          //pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.LOGISTICS, 14, popFeeVO.getInternationalFee().negate()));
          delIds.addAll(buildDeletePOPCost(PoPCostTypeEnum.LOGISTICS, 14, hisPopCosts));
        } else {
          String internationalAgent = logisticsBill.getInternationalAgent();
          if (internationalAgent != null && !internationalAgent.equals(popFeeVO.getInternationalProxy())) {
            pcsPoPlanCost.setRelationMan(logisticsBill.getInternationalAgent());
            pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.LOGISTICS, 14, internationalFee));
            //pcsPoPlanCosts.add(buildPOPCost(pcsPoPlanCost, PoPCostTypeEnum.LOGISTICS, 14, popFeeVO.getInternationalFee().negate()));
            delIds.addAll(buildDeletePOPCost(PoPCostTypeEnum.LOGISTICS, 14, hisPopCosts));
          }
        }


      });

      if (pcsPoPlanCosts != null && pcsPoPlanCosts.size() > 0) {
        pcsPoPlanService.batchCreatePoPlanFee(pcsPoPlanCosts);
      }
      if (delIds != null && delIds.size() > 0) {
        pcsPoPlanService.delPoPlanFeeByIds(delIds);
      }
    }

    private PcsPoPlanCost buildPOPCost(PcsPoPlanCost pcsPoPlanCost, PoPCostTypeEnum poPCostTypeEnum,
                                       Integer feeType, BigDecimal feeAmount) {
      PcsPoPlanCost newPopCost = new PcsPoPlanCost();
      BeanUtils.copyProperties(pcsPoPlanCost, newPopCost);
      newPopCost.setPreTaxAmount(feeAmount);
      newPopCost.setAfterTaxAmount(feeAmount);
      if (feeAmount.compareTo(BigDecimal.ZERO) <= 0) {
          newPopCost.setAvailable((byte)0);
      }
      switch (poPCostTypeEnum) {
        case OTHER:
          newPopCost.setOtherFeeType(feeType);
          break;
        case TAXES:
          newPopCost.setTaxType(feeType);
          break;
        case LOGISTICS:
          newPopCost.setShipmentType(feeType);
          break;
          default:
            break;
      }
      return newPopCost;
    }

  private List<Long> buildDeletePOPCost(PoPCostTypeEnum poPCostTypeEnum,
                                           Integer feeType, List<PcsPoPlanCost> hisPoPlanCosts) {
    List<Long> delIds = new ArrayList<Long>();
    if (hisPoPlanCosts != null && hisPoPlanCosts.size() > 0) {
        hisPoPlanCosts.stream().forEach(hisPoPlanCost -> {
            Long hisCostId = hisPoPlanCost.getId();
            switch (poPCostTypeEnum) {
                case OTHER:
                    break;
                case TAXES:
                    if (hisPoPlanCost.getTaxType() == feeType) {
                        delIds.add(hisCostId);
                    }
                    break;
                case LOGISTICS:
                    if (hisPoPlanCost.getShipmentType() == feeType) {
                        delIds.add(hisCostId);
                    }
                    break;
                default:
                    break;
            }
        });
    }
    return delIds;
  }


    @Override
    public PcsPoPlanLogisticsBill buildVO2DO(PcsPoPlanLogisticsBillVO logisticsBill) {
        return BeanUtil.buildFrom(logisticsBill, PcsPoPlanLogisticsBill.class);
    }

    @Override
    public PcsPoPlanLogisticsBillVO buildDO2VO(PcsPoPlanLogisticsBill logisticsBill) {
        return BeanUtil.buildFrom(logisticsBill, PcsPoPlanLogisticsBillVO.class);
    }

    @Override
    public PcsPoPlanLogisticsBillVO getPcsPoPlanLogisticsBillById(Integer billId) {
        return buildDO2VO(pcsPoPlanLogisticsBillMapper.selectByPrimaryKey(billId));
    }

    @Override
    public PcsPoPlanLogisticsBillVO getPcsPoPlanLogisticsBillByPopCode(String popCode) {
        PcsPoPlanLogisticsBillExample example = new PcsPoPlanLogisticsBillExample();
        example.createCriteria().andPopCodeEqualTo(popCode);
        List<PcsPoPlanLogisticsBill> list = pcsPoPlanLogisticsBillMapper.selectByExample(example);
        if (list == null || list.size() == 0) {
            return  null;
        }
        return buildDO2VO(list.get(0));
    }

    @Override
    public PcsPoPlanLogisticsBillVO getPcsPoPlanLogisticsBillByPopId(Long popId) {
        PcsPoPlanLogisticsBillExample example = new PcsPoPlanLogisticsBillExample();
        example.createCriteria().andPopIdEqualTo(popId);
        List<PcsPoPlanLogisticsBill> list = pcsPoPlanLogisticsBillMapper.selectByExample(example);
        if (list == null || list.size() == 0) {
            return  null;
        }
        return buildDO2VO(list.get(0));
    }

    @Override
    public PageInfo<PcsPoPlanLogisticsBillVO> listBillByCond(PoLogisticsBillCond cond) {
        PageRowBounds pageRowBounds = new PageRowBounds(cond.getOffset(), cond.getPagenum());
        List<PcsPoPlanLogisticsBillVO>  billVOS = pcsPoPlanLogisticsBillMapper.selectByCond(cond, pageRowBounds);
        buildPopDetailInfo(billVOS);
        PageInfo<PcsPoPlanLogisticsBillVO> pageInfo = new PageInfo<PcsPoPlanLogisticsBillVO>(billVOS);
        pageInfo.setTotal(pageRowBounds.getTotal());
        return pageInfo;
    }

    @Override
    public List<PoLogisticsBillStatusTab> countGroupByBillstatus(PoLogisticsBillCond cond) {
        return pcsPoPlanLogisticsBillMapper.countGroupByBillstatus(cond);
    }

    @Override
    public int cancelPopLogisticsBill(Integer id) {
        PcsPoPlanLogisticsBill bill = pcsPoPlanLogisticsBillMapper.selectByPrimaryKey(id);
        if (bill.getBillStatus() != PoLogisticsEnum.WAITING_SUBMIT.getKey()) {
          throw new PurchaseException("", "只有待提交状态物流单才可以取消！");
        }
        int rct = pcsPoPlanLogisticsBillMapper.cancelPopLogisticsBill(id);
        if (rct == 0) {
            throw new PurchaseException("", "取消失败！");
        }

        return 1;
    }

    @Override
    public List<PcsPoPlanLogisticsBillVO> listLogisticsBillByPoId(Long poId) {
        PcsPoPlanLogisticsBillExample example = new PcsPoPlanLogisticsBillExample();
        example.createCriteria().andPoIdEqualTo(poId);
        List<PcsPoPlanLogisticsBill> list = pcsPoPlanLogisticsBillMapper.selectByExample(example);
        if (list == null || list.size() == 0) {
           return null;
        }
        return BeanUtil.buildListFrom(list, PcsPoPlanLogisticsBillVO.class);
    }

    @Override
    public Boolean closePoPlan(Long poPlandId) {
        PcsPoPlanLogisticsBillVO pcsPoPlanLogisticsBillVO = getPcsPoPlanLogisticsBillByPopId(poPlandId);
        if (pcsPoPlanLogisticsBillVO == null) {
           return true;
        }
        int billStatus = pcsPoPlanLogisticsBillVO.getBillStatus();
        //物流单状态是取消或者已完成则不处理
        if (PoLogisticsEnum.CANCLE.getKey() == billStatus || PoLogisticsEnum.COMPLETED.getKey() == billStatus) {
           return true;
        }
        int newBillStatus = PoLogisticsEnum.WAITING_SUBMIT.getKey() == billStatus ? PoLogisticsEnum.CANCLE.getKey() : PoLogisticsEnum.COMPLETED.getKey();
        if (pcsPoPlanLogisticsBillMapper.updateLogisticsBillStatus(pcsPoPlanLogisticsBillVO.getId(), newBillStatus, billStatus) == 1) {
           return true;
        } else {
            LOGGER.info("关闭POP 物流单状态异常，POP物流单INFO:{}", JSON.toJSONString(pcsPoPlanLogisticsBillVO));
            throw new PurchaseException("", "物流单状态异常");
        }
    }

    private void buildPopLogisticsBillsStatus(List<PcsPoPlanLogisticsBillVO> updateList) {
       if (updateList != null && updateList.size() > 0) {
          int listSize = updateList.size();
          for (int i = 0 ; i < listSize; i ++) {
              PcsPoPlanLogisticsBillVO logisticsBill = updateList.get(i);
              Integer billStatus = logisticsBill.getBillStatus();
              if (billStatus != null) {
               if(billStatus == PoLogisticsEnum.PENDING.getKey()) {
                    Date actualDeliveryTime = logisticsBill.getActualDeliveryTime();
                    //实际到货不为空，则状态为已完成
                    if (actualDeliveryTime != null) {
                        logisticsBill.setBillStatus(PoLogisticsEnum.COMPLETED.getKey());
                        //如果到货日期>=今天，则自动发送邮件给仓库
                        if (!actualDeliveryTime.before(DateUtil.parse(DateUtil.getNowFormat(DateUtil.DEFAULT_DATE_FORMAT), DateUtil.DEFAULT_DATE_FORMAT))) {
                          sendSinceImportPOArrivalNotice(logisticsBill);
                        }
                    } else {
                        logisticsBill.setBillStatus(PoLogisticsEnum.PROCESSING.getKey());
                    }
                } else if(billStatus == PoLogisticsEnum.PROCESSING.getKey()) {
                    if (logisticsBill.getActualDeliveryTime() != null) {
                        logisticsBill.setBillStatus(PoLogisticsEnum.COMPLETED.getKey());
                        //如果到货日期>=今天，则自动发送邮件给仓库
                        if (!logisticsBill.getActualDeliveryTime().before(DateUtil.parse(DateUtil.getNowFormat(DateUtil.DEFAULT_DATE_FORMAT), DateUtil.DEFAULT_DATE_FORMAT))) {
                            sendSinceImportPOArrivalNotice(logisticsBill);
                        }
                    }
                }
              }
          }
       }
    }

    //自进口采购单预计到货通知
    private void sendSinceImportPOArrivalNotice(PcsPoPlanLogisticsBillVO poPlanLogisticsBill) {

      Long poCreator = poPlanLogisticsBill.getPoCreator();

      StringBuilder emailContentSb = new StringBuilder();
      emailContentSb.append("<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
      emailContentSb.append("#table-5 td {color: #000;}");
      emailContentSb.append("#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
      emailContentSb.append("#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
      emailContentSb.append("<table id='table-5'>" +
              "<thead>" +
                "<th>PO单号</th>" +
                "<th>POP单号</th>" +
                "<th>创建人</th>" +
                "<th>预计到仓日期</th>" +
              "</thead>" +
            "<tbody>");

      emailContentSb.append("<tr>");
      emailContentSb.append("<td>").append(poPlanLogisticsBill.getPoCode()).append("</td>");
      emailContentSb.append("<td>").append(poPlanLogisticsBill.getPopCode()).append("</td>");
      emailContentSb.append("<td>").append(poPlanLogisticsBill.getCreatorName()).append("</td>");
      emailContentSb.append("<td>").append(DateUtil.format(poPlanLogisticsBill.getActualDeliveryTime(),DateUtil.DEFAULT_DATE_FORMAT)).append("</td>");
      emailContentSb.append("</tr>");
      emailContentSb.append("</tbody></table></html>");

      String emailTitle = "自进口采购单预计到货通知";
      EmailVO emailVO = new EmailVO();
      emailVO.setToAddressList(poPlanLogisticsBill.getNoticeAddressList());
      emailVO.setSubject(emailTitle);
      emailVO.setContent(emailContentSb.toString());
      // 发邮件
      if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
        // 正式环境发邮件
        try {
          LOGGER.info("开始发送"+emailTitle+"邮件：" + emailVO.getToAddressList());
          boolean result = EmailUtil.getInstance().send(emailVO);
          LOGGER.info("成功发送"+emailTitle+"邮件：" + emailVO.getToAddressList());
        }catch (Exception e){
          LOGGER.error("自进口采购单预计到货通知----POP{}", JSON.toJSONString(poPlanLogisticsBill.getPopCode()));
          e.printStackTrace();
        }
      }

    }

    private void buildPopDetailInfo(List<PcsPoPlanLogisticsBillVO>  bills) {
       if (bills != null) {
          List<Long> popIds = new ArrayList<Long>();
          int billQuantity = bills.size();
          for (PcsPoPlanLogisticsBillVO billVO : bills) {
              popIds.add(billVO.getPopId());
          }

           List<Map<String, String>> sumPopSkuTotalAmountMap = pcsPoPlanLineMapper.sumPopSkuTotalAmount(popIds);
           Map<Long, PcsPopFeeVO> pcsPopFeeMap = pcsPoPlanService.mapPopFee(popIds);
           for (int i = 0; i < billQuantity; i ++) {
               PcsPoPlanLogisticsBillVO billVO = bills.get(i);
               Long popId = billVO.getPopId();
               if (sumPopSkuTotalAmountMap == null || sumPopSkuTotalAmountMap.size() == 0) {
                   billVO.setGoodsValue(BigDecimal.ZERO);
               } else {
                   for (Map<String, String> map : sumPopSkuTotalAmountMap) {
                     if (popId.equals(Long.valueOf(String.valueOf(map.get("key"))))) {
                         billVO.setGoodsValue(new BigDecimal(String.valueOf(map.get("value"))));
                         break;
                     }
                   }
               }
               PcsPopFeeVO popFeeVO = pcsPopFeeMap.get(popId);
               if (popFeeVO != null) {
                 billVO.setTariff(popFeeVO.getTariffAmount() == null ? BigDecimal.ZERO : popFeeVO.getTariffAmount());
                 billVO.setVat(popFeeVO.getVatAmount() == null ? BigDecimal.ZERO : popFeeVO.getVatAmount());
                 billVO.setInternationalFee(popFeeVO.getInternationalFee() == null ? BigDecimal.ZERO : popFeeVO.getInternationalFee());
                 billVO.setInternalFee(popFeeVO.getInternalFee() == null ? BigDecimal.ZERO : popFeeVO.getInternalFee());
                 billVO.setInternationalAgent(popFeeVO.getInternationalProxy());
                 billVO.setInternalAgent(popFeeVO.getInternalProxy());
                 billVO.setConsumptionTaxAmount(popFeeVO.getConsumptionTaxAmount());
               }
           }
       }
    }
}
