/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.dao.PcsPoLineMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLine;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoLineExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoLineService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoLineVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.pegasus.util.inter.CheckAble;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsPoLineServiceImpl.java, v 0.1 2015-08-10 11:00
 */
@Service("pcsPoLineService")
public class PcsPoLineServiceImpl implements PcsPoLineService, CheckAble {

    private final Logger log = LoggerFactory.getLogger(PcsPoLineServiceImpl.class);

    @Autowired
    private PcsPoLineMapper pcsPoLineMapper;


    @Override
    public Boolean check(Object obj) {
        PcsPoLine record = (PcsPoLine) obj;
        if (EmptyUtil.isEmpty(record)) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }


    private Boolean check(PcsPoLine record, Boolean isCreate) {
        if (isCreate && EmptyUtil.isNotEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        if (!isCreate && EmptyUtil.isEmpty(record.getId())) {
            throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "参数异常");
        }
        return true;
    }


    @Override
    public PcsPoLine buildFromVO(PcsPoLineVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsPoLine record = new PcsPoLine();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

    @Override
    public PcsPoLineVO buildFromModel(PcsPoLine record) {
        if (NullUtil.isNull(record)) {
            return null;
        }
        PcsPoLineVO vo = new PcsPoLineVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
    }

    @Override
    public List<PcsPoLineVO> buildFromModel(List<PcsPoLine> records) {
        if (records == null || records.size() == 0) {
          return null;
        }
        List<PcsPoLineVO> voList = new ArrayList<PcsPoLineVO>();
        for (PcsPoLine pcsPoLine : records) {
          PcsPoLineVO pcsPoLineVO = buildFromModel(pcsPoLine);
          if (pcsPoLineVO != null) {
            voList.add(pcsPoLineVO);
          }
        }
        return voList;
    }

    @Override
    @Transactional
    public Long create(PcsPoLine record) {
        if (check(record)) {
            if (check(record, true)) {
                pcsPoLineMapper.insertSelective(record);
                return record.getId();
            }
        }
        return null;
    }

    @Override
    public boolean update(PcsPoLineVO pcsPoLineVO) {
        return update(buildFromVO(pcsPoLineVO));
    }

    @Override
    @Transactional
    public boolean update(PcsPoLine record) {
        if (check(record)) {
            if (check(record, false)) {
                return pcsPoLineMapper.updateByPrimaryKeySelective(record) != 0;
            }
        }
        return false;
    }

    @Override
    public PcsPoLine findPoLineById(long id) {
        return pcsPoLineMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<PcsPoLineVO> findPoLineByPoIds(List<Long> poIds) {
       PcsPoLineExample example = new PcsPoLineExample();
       example.createCriteria().andPoIdIn(poIds);
       return buildFromModel(pcsPoLineMapper.selectByExample(example));
    }

    @Override
    public List<PcsPoLine> findPoLineByPoId(long poId) {
        PcsPoLineExample example = new PcsPoLineExample();
        example.createCriteria().andPoIdEqualTo(poId);
        final List<PcsPoLine> poLineList = pcsPoLineMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poLineList)) {
            return Collections.emptyList();
        } else {
            return poLineList;
        }
    }

    @Override
    public List<PcsPoLineVO> findPoLineVOByPoId(long poId) {
        List<PcsPoLineVO> vos = pcsPoLineMapper.findPoLineVOByPoId(poId);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        } else {
            return vos;
        }
    }

    @Override
    public List<PcsPoLineVO> findPoLineVOByPoIdForExcel(long poId) {
        List<PcsPoLineVO> vos = pcsPoLineMapper.findPoLineVOByPoIdForExcel(poId);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        } else {
            return vos;
        }
    }

    @Override
    public List<PcsPoLineVO> findPoLineVOById(long id) {
        List<PcsPoLineVO> vos = pcsPoLineMapper.findPoLineVOById(id);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        } else {
            return vos;
        }
    }

    @Override
    public List<PcsPoLineVO> findPackageNumBySku(PcsPoLineVO pcsPpLinevo) {
        List<PcsPoLineVO> vos = pcsPoLineMapper.findPackageNumBySku(pcsPpLinevo);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        } else {
            return vos;
        }
    }

    @Override
    public List<PcsPoLineVO> findAutomaticTransferAllot(PcsPoPlan pcsPoPlan) {
        List<PcsPoLineVO> vos = pcsPoLineMapper.findAutomaticTransferAllot(pcsPoPlan);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        } else {
            return vos;
        }
    }

    @Override
    @Transactional
    public Boolean deleteById(long id) {
        PcsPoLine record = findPoLineById(id);
        if (EmptyUtil.isNotEmpty(record)) {
            return pcsPoLineMapper.deleteByPrimaryKey(id) != 0;
        }
        return false;
    }


	@Override
	public List<PcsPoLineVO> findPoSkuByPoId(long poId) {
		List<PcsPoLineVO> vos = pcsPoLineMapper.findPoSkuByPoId(poId);
	    if (CollectionUtils.isEmpty(vos)) {
	        return Collections.emptyList();
	    } else {
	        return vos;
	    }
	}

    @Override
    public List<PcsPoLineVO> findSkuByPoCode(String poCode) {
        List<PcsPoLineVO> vos = pcsPoLineMapper.findSkuByPoCode(poCode);
        if (CollectionUtils.isEmpty(vos)) {
            return Collections.emptyList();
        } else {
            return vos;
        }
    }

    @Override
    public List<PcsPoLineVO> selectCanAutoCreatePopLines() {
        return pcsPoLineMapper.selectCanAutoCreatePopLines();
    }

}
