package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.kit.redis.util.RedisClient;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerDeliveryCapacityCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerDeliveryCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerRecipePlanCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsFlowerRecipeSkuCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerDeliveryMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerDeliveryRecipeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerMonthlyCapacityLogMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerMonthlyCapacitySettingMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerRecipeSkuMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.model.*;
import com.thebeastshop.pegasus.service.purchase.service.PcsFlowerDeliveryRecipePhyWhCapacityService;
import com.thebeastshop.pegasus.service.purchase.service.PcsFlowerDeliveryService;
import com.thebeastshop.pegasus.service.purchase.vo.*;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.*;
import com.thebeastshop.stock.constant.SStockFlowerMonConstants;
import com.thebeastshop.stock.dto.SFlowerMonthlyCityDTO;
import com.thebeastshop.stock.dto.SFlowerMonthlyQueryDTO;
import com.thebeastshop.stock.enums.SFlowerProductionTypeEnum;
import com.thebeastshop.stock.service.SFlowerMonthlyService;
import com.thebeastshop.wms.sservice.WWhCommandService;
import com.thebeastshop.wms.vo.WhWarehouseGroupVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import com.thebeastshop.common.Pagination;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;

/**
 * Created by jim.huang on 2017/2/8.
 */
@Service("pcsFlowerDeliveryService")
public class PcsFlowerDeliveryServiceImpl implements PcsFlowerDeliveryService {

    private final Logger log = LoggerFactory.getLogger(PcsFlowerDeliveryServiceImpl.class);

    @Autowired
    PcsFlowerDeliveryMapper pcsFlowerDeliveryMapper;

    @Autowired
    PcsFlowerDeliveryRecipeMapper pcsFlowerDeliveryRecipeMapper;

    @Autowired
    PcsFlowerRecipeSkuMapper pcsFlowerRecipeSkuMapper;

    @Autowired
    private PcsFlowerMonthlyCapacitySettingMapper pcsFlowerMonthlyCapacitySettingMapper;

    @Autowired
    private PcsFlowerDeliveryRecipePhyWhCapacityService pcsFlowerDeliveryRecipePhyWhCapacityService;

    @Autowired
    private PcsFlowerMonthlyCapacityLogMapper pcsFlowerMonthlyCapacityLogMapper;

    @Autowired
    private SFlowerMonthlyService flowerMonthlyService;

    @Autowired
    private RedisClient redisClient;

    @Autowired
    private WWhCommandService wWhCommandService;

    private PegasusUtilFacade pegasusUtilFacade = PegasusUtilFacade.getInstance();

    @Override
    public Pagination<PcsFlowerDeliveryVO> getFlowerDeliveryByCond(PcsFlowerDeliveryCond cond) {
        int count = pcsFlowerDeliveryMapper.getFlowerDeliveryCountByCond(cond);
        Pagination<PcsFlowerDeliveryVO> page = new Pagination<>(cond.getCurrpage(), cond.getPagenum());
        page.setRecord(count);
        if (NumberUtil.isNullOrZero(count)) return null;
        List<PcsFlowerDeliveryVO> pcsFlowerDeliveries = pcsFlowerDeliveryMapper.getFlowerDeliveryByCond(cond);
        if (CollectionUtils.isNotEmpty(pcsFlowerDeliveries)) {
            for (PcsFlowerDeliveryVO pcsFlowerDelivery : pcsFlowerDeliveries) {
                pcsFlowerDelivery.setSendDate(pcsFlowerDelivery.getSendDate());
//                pcsFlowerDelivery.setPlanQuantity(pcsFlowerDelivery.getPlanQuantity() + pcsFlowerDelivery.getTmallPlanQuantity());
//                pcsFlowerDelivery.setSoldQuantity(pcsFlowerDelivery.getSoldQuantity() + pcsFlowerDelivery.getTmallSoldQuantity());
//                pcsFlowerDelivery.setHistorySoldQuantity(pcsFlowerDelivery.getHistorySoldQuantity() + pcsFlowerDelivery.getTmallHistorySoldQuantity());
//                pcsFlowerDelivery.setShouldSendQuantity(pcsFlowerDelivery.getSoldQuantity()+pcsFlowerDelivery.getHistorySoldQuantity());

                Long currentRecipeId = pcsFlowerDelivery.getRecipeId();
                StringBuffer recipeName = new StringBuffer("");
                List<PcsFlowerRecipeSkuVO> pcsFlowerRecipeSkuVOs = new ArrayList<>();
                if (currentRecipeId != null) {
                    pcsFlowerRecipeSkuVOs = pcsFlowerRecipeSkuMapper.getFlowerRecipeSkuByCond(currentRecipeId);
                }
                if (CollectionUtils.isNotEmpty(pcsFlowerRecipeSkuVOs)) {
                    for (PcsFlowerRecipeSkuVO pcsFlowerRecipeSkuVO : pcsFlowerRecipeSkuVOs) {
                        if (pcsFlowerRecipeSkuVO != null) {
                            recipeName = recipeName.append("[").append(pcsFlowerRecipeSkuVO.getSkuCode()).append("]").append(pcsFlowerRecipeSkuVO.getSkuName() == null ? "" : pcsFlowerRecipeSkuVO.getSkuName())
                                    .append("*").append(pcsFlowerRecipeSkuVO.getQuantity()).append("</br>");
                        }
                    }
                    pcsFlowerDelivery.setRecipe(recipeName.toString());
                } else {
                    pcsFlowerDelivery.setRecipe("");
                }
            }
            page.setResultList(pcsFlowerDeliveries);
        } else {
            return null;
        }
        return page;
    }

    @Override
    public PcsFlowerDeliveryVO getFlowerDeliveryBySku(PcsFlowerDeliveryCond cond) {
        /*PcsFlowerDeliveryDate pcsFlowerDeliveryDate = getFlowerStockAndDate("101170408", DateUtil.parse("2017-03-02","yyyy-MM-dd"), "CHN1032");
        List<PcsFlowerMerchantibleVO> pcsFlowerMerchantibleVOs = getFlowerSellNumber();*/
        return pcsFlowerDeliveryMapper.getFlowerDeliveryBySku(cond);
    }

    @Override
    public PcsFlowerDeliveryRecipe getFlowerDeliveryRecipeById(Long recipeId) {
        return pcsFlowerDeliveryRecipeMapper.selectByPrimaryKey(recipeId);
    }

    @Override
    public List<PcsFlowerDeliveryRecipeVO> getFlowerDeliveryRecipeByCond(PcsFlowerDeliveryCond cond) {
        List<PcsFlowerDeliveryRecipeVO> pcsFlowerDeliveries = pcsFlowerDeliveryRecipeMapper.getFlowerDeliveryDetailByCond(cond);
        return pcsFlowerDeliveries;
    }


    @Override
    public Pagination<PcsFlowerDeliveryRecipeVO> getFlowerDeliveryDetailByCond(PcsFlowerDeliveryCond cond) {
        int count = pcsFlowerDeliveryRecipeMapper.getFlowerDeliveryDetailCountByCond(cond);
        Pagination<PcsFlowerDeliveryRecipeVO> page = new Pagination<>(cond.getCurrpage(), cond.getPagenum());
        page.setRecord(count);
        if (NumberUtil.isNullOrZero(count)) return null;
        List<PcsFlowerDeliveryRecipeVO> pcsFlowerDeliveries = pcsFlowerDeliveryRecipeMapper.getFlowerDeliveryDetailByCond(cond);
        if (CollectionUtils.isEmpty(pcsFlowerDeliveries)) {
            return null;
        } else {
            for (PcsFlowerDeliveryRecipeVO pcsFlowerDelivery : pcsFlowerDeliveries) {
                StringBuffer recipeName = new StringBuffer("");
                List<PcsFlowerRecipeSkuVO> pcsFlowerRecipeSkuVOs = new ArrayList<>();
                pcsFlowerRecipeSkuVOs = pcsFlowerRecipeSkuMapper.getFlowerRecipeSkuByCond(pcsFlowerDelivery.getId());
                if (CollectionUtils.isNotEmpty(pcsFlowerRecipeSkuVOs)) {
                    for (PcsFlowerRecipeSkuVO pcsFlowerRecipeSkuVO : pcsFlowerRecipeSkuVOs) {
                        if (pcsFlowerRecipeSkuVO != null) {
                            recipeName = recipeName.append("[").append(pcsFlowerRecipeSkuVO.getSkuCode()).append("]").append(pcsFlowerRecipeSkuVO.getSkuName() == null ? "" : pcsFlowerRecipeSkuVO.getSkuName())
                                    .append("*").append(pcsFlowerRecipeSkuVO.getQuantity()).append("</br>");
                        }
                    }
                    pcsFlowerDelivery.setRecipeName(recipeName.toString());
                } else {
                    pcsFlowerDelivery.setRecipeName("");
                }
            }
            page.setResultList(pcsFlowerDeliveries);
        }
        return page;
    }

    @Override
    @Transactional
    public boolean saveFlowerDelivery(PcsFlowerDeliveryCond cond) {
//        PcsFlowerDeliveryExample pcsFlowerDeliveryExample = new PcsFlowerDeliveryExample();
//        PcsFlowerDeliveryExample.Criteria criteria = pcsFlowerDeliveryExample.createCriteria();
//        criteria.andSkuEqualTo(cond.getSkuCode());
//        List<PcsFlowerDelivery> pcsFlowerDeliveries = pcsFlowerDeliveryMapper.selectByExample(pcsFlowerDeliveryExample);

        PcsFlowerDelivery pcsFlowerDelivery = new PcsFlowerDelivery();
        pcsFlowerDelivery.setSku(cond.getSkuCode());
        pcsFlowerDelivery.setDeliveryDay(cond.getReceiveWeekDay());
        pcsFlowerDelivery.setDeliveryTimes(cond.getSendTimes());
        pcsFlowerDelivery.setRuleNumber(cond.getRuleNumber());
        pcsFlowerDelivery.setCutoffDay(cond.getCutOffWeekDay());
        pcsFlowerDelivery.setCutoffTime(cond.getCutOffTime());
        pcsFlowerDelivery.setIsStockBalance(cond.getIsStockBalance());
        pcsFlowerDelivery.setSafeStock(cond.getSafeStock());
        pcsFlowerDelivery.setProducer(cond.getProducer());
        pcsFlowerDelivery.setDeliveryInterval(cond.getDeliveryInterval());
        if (cond.getRecipeId() == null) {
            pcsFlowerDelivery.setUseableStatue(1);
            pcsFlowerDeliveryMapper.insert(pcsFlowerDelivery);
            Date receiveDate = DateUtil.getCurrWeek(cond.getReceiveWeekDay());
            Calendar receiveCalendar = Calendar.getInstance();
            receiveCalendar.setTime(receiveDate);
            Calendar now = Calendar.getInstance();
            now.set(Calendar.HOUR_OF_DAY, 0);
            now.set(Calendar.MINUTE, 0);
            now.set(Calendar.SECOND, 0);
            if (receiveCalendar.getTimeInMillis() < now.getTimeInMillis()) {
                receiveCalendar.add(Calendar.DATE, 7);
            }
            List<PcsFlowerDeliveryRecipe> list = new ArrayList<>();
            for (int i = 0; i < 260; i++) {
                PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe = new PcsFlowerDeliveryRecipe();
                pcsFlowerDeliveryRecipe.setSkuCode(cond.getSkuCode());
                pcsFlowerDeliveryRecipe.setReceiveDay(receiveCalendar.getTime());
                if (PcsFlowerDeliveryVO.PRODUCER_WAREHOUSE.equals(cond.getProducer())) {
                    pcsFlowerDeliveryRecipe.setSendDay(DateUtils.addDays(receiveCalendar.getTime(), -1));
                } else {
                    pcsFlowerDeliveryRecipe.setSendDay(receiveCalendar.getTime());
                }
                pcsFlowerDeliveryRecipe.setUseableState(1);
                pcsFlowerDeliveryRecipe.setFinishState(0);
                list.add(pcsFlowerDeliveryRecipe);
                //pcsFlowerDeliveryRecipeMapper.insert(pcsFlowerDeliveryRecipe);
                receiveCalendar.add(Calendar.DATE, 7);
            }
            pcsFlowerDeliveryRecipeMapper.batchInsert(list);
            //刷新物理仓产能上限
            pcsFlowerDeliveryRecipePhyWhCapacityService.refreshFlowerDeliveryRecipePhyWhCapacity(pcsFlowerDelivery.getSku());
        } else {
            pcsFlowerDelivery.setId(cond.getRecipeId());
            pcsFlowerDeliveryMapper.updateByPrimaryKeySelective(pcsFlowerDelivery);

        }
        updateFlowerFinishStateChange(pcsFlowerDelivery.getSku());
        return true;
    }

    @Override
    public List<String> getPackageDeliveryDate(Long packageId, Long salesOrderId) {
        return pcsFlowerDeliveryRecipeMapper.selectPackageDeliveryDate(packageId, salesOrderId);
    }

    @Override
    public List<PcsFlowerRecipeSkuVO> getFlowerRecipeSkuByCond(Long recipeId) {
        return pcsFlowerRecipeSkuMapper.getFlowerRecipeSkuByCond(recipeId);
    }

    @Override
    public boolean addFlowerRecipeSku(PcsRecipeSkuVO pcsRecipeSkuVO) {
        try {
            long recipeId = pcsRecipeSkuVO.getRecipeId();
            for (PrdcRecipeMaterialVO prdcRecipeMaterialVO : pcsRecipeSkuVO.getRecipeMaterialVOList()) {
                PcsFlowerRecipeSku pcsFlowerRecipeSku = new PcsFlowerRecipeSku();
                pcsFlowerRecipeSku.setRecipeId(recipeId);
                pcsFlowerRecipeSku.setSkuType(prdcRecipeMaterialVO.getMaterialType());
                pcsFlowerRecipeSku.setSkuCode(prdcRecipeMaterialVO.getSkuCode());
                pcsFlowerRecipeSku.setExpendNumber(prdcRecipeMaterialVO.getQuantity());
                pcsFlowerRecipeSku.setAvailable(1);
                pcsFlowerRecipeSkuMapper.insert(pcsFlowerRecipeSku);
            }
        } catch (Exception e) {
            log.error("保存异常：{}", e);
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updateFlowerRecipeSku(PcsRecipeSkuVO pcsRecipeSkuVO) {
        List<PrdcRecipeMaterialVO> prdcRecipeMaterialVOs = pcsRecipeSkuVO.getRecipeMaterialVOList();
        List<PcsFlowerRecipeSkuVO> pcsFlowerRecipeSkuVOs = pcsFlowerRecipeSkuMapper.getFlowerRecipeSkuByCond(pcsRecipeSkuVO.getRecipeId());
        if (CollectionUtils.isEmpty(prdcRecipeMaterialVOs) && CollectionUtils.isEmpty(pcsFlowerRecipeSkuVOs)) {
            return true;
        } else {
            try {
                if (CollectionUtils.isNotEmpty(pcsFlowerRecipeSkuVOs)) {
                    for (PcsFlowerRecipeSkuVO pcsFlowerRecipeSkuVO : pcsFlowerRecipeSkuVOs) {
                        if (pcsFlowerRecipeSkuVO != null) {
                            PcsFlowerRecipeSku pcsFlowerRecipeSku = new PcsFlowerRecipeSku();
                            pcsFlowerRecipeSku.setId(pcsFlowerRecipeSkuVO.getId());
                            pcsFlowerRecipeSku.setAvailable(0);
                            pcsFlowerRecipeSkuMapper.updateByPrimaryKeySelective(pcsFlowerRecipeSku);
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(prdcRecipeMaterialVOs)) {
                    for (PrdcRecipeMaterialVO prdcRecipeMaterialVO : prdcRecipeMaterialVOs) {
                        PcsFlowerRecipeSku pcsFlowerRecipeSku = new PcsFlowerRecipeSku();
                        pcsFlowerRecipeSku.setRecipeId(pcsRecipeSkuVO.getRecipeId());
                        pcsFlowerRecipeSku.setSkuType(prdcRecipeMaterialVO.getMaterialType());
                        pcsFlowerRecipeSku.setSkuCode(prdcRecipeMaterialVO.getSkuCode());
                        pcsFlowerRecipeSku.setExpendNumber(prdcRecipeMaterialVO.getQuantity());
                        pcsFlowerRecipeSku.setAvailable(1);
                        pcsFlowerRecipeSkuMapper.insert(pcsFlowerRecipeSku);
                    }
                }
            } catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean updateFlowerRecipeById(PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe) {
        pcsFlowerDeliveryRecipeMapper.updateByPrimaryKeySelective(pcsFlowerDeliveryRecipe);
        return true;
    }

    @Override
    @Transactional
    public boolean updateFlowerDeliveryById(PcsFlowerDelivery pcsFlowerDelivery) {
        try {
            pcsFlowerDeliveryMapper.updateByPrimaryKeySelective(pcsFlowerDelivery);
        } catch (Exception e) {
            log.error("保存异常：{}", e);
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean updateFlowerDeliveryUseableById(PcsFlowerDelivery pcsFlowerDelivery) {
        try {
            //启用sku
            pcsFlowerDelivery.setId(pcsFlowerDelivery.getId());
            pcsFlowerDelivery.setUseableStatue(1);
            pcsFlowerDeliveryMapper.updateByPrimaryKeySelective(pcsFlowerDelivery);
            //启用recipe
            pcsFlowerDeliveryRecipeMapper.updateCurrBeforeFinish(pcsFlowerDelivery.getSku());
            pcsFlowerDeliveryRecipeMapper.updateCurrAfterNoFinish(pcsFlowerDelivery.getSku());
            PcsFlowerDeliveryRecipeExample pcsFlowerDeliveryRecipeExample = new PcsFlowerDeliveryRecipeExample();
            pcsFlowerDeliveryRecipeExample.createCriteria().andSendDayGreaterThan(Calendar.getInstance().getTime());
            pcsFlowerDeliveryRecipeExample.setOrderByClause("SEND_DAY asc");
            List<PcsFlowerDeliveryRecipe> pcsFlowerDeliveryRecipeList = pcsFlowerDeliveryRecipeMapper.selectByExample(pcsFlowerDeliveryRecipeExample);
            Date cutDate = DateUtil.getCurrWeek(pcsFlowerDelivery.getCutoffDay());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(cutDate);
            String[] time = pcsFlowerDelivery.getCutoffTime().split(":");
            if (time.length == 3) {
                calendar.set(Calendar.HOUR_OF_DAY, Integer.parseInt(time[0]));
                calendar.set(Calendar.MINUTE, Integer.parseInt(time[1]));
                calendar.set(Calendar.SECOND, Integer.parseInt(time[2]));
            }
            if (Calendar.getInstance().getTimeInMillis() > calendar.getTimeInMillis()) {
                if (pcsFlowerDeliveryRecipeList != null) {
                    PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe = pcsFlowerDeliveryRecipeList.get(0);
                    pcsFlowerDeliveryRecipe.setFinishState(1);
                    pcsFlowerDeliveryRecipeMapper.updateByPrimaryKey(pcsFlowerDeliveryRecipe);
                }
            }
        } catch (Exception e) {
            log.error("保存异常:{}", e);
            return false;
        }
        return true;
    }

    @Override
    public List<PcsFlowerDeliveryRecipeVO> getFlowerDeliveryDate(String skuCode) {
        return pcsFlowerDeliveryRecipeMapper.getFlowerDeliveryDate(null);
    }

    @Override
    public Map<String, PcsFlowerDeliveryDate> getFlowerStockAndDate(List<SFlowerMonthlyQueryDTO> queryList, Date date, String channelCode) {
        Map<String, PcsFlowerDeliveryDate> map = new HashMap<>();
        for (SFlowerMonthlyQueryDTO queryDTO : queryList) {
            map.put(queryDTO.getSkuCode(), getFlowerStockAndDate(queryDTO, date, channelCode));
        }
        return map;
    }

    @Override
    public PcsFlowerDeliveryDate getFlowerStockAndDate(SFlowerMonthlyQueryDTO queryDTO, Date payTime, String channelCode) {
        PcsFlowerDeliveryDate pcsFlowerDeliveryDate;

        String stockProducerKey = queryDTO.getsFlowerProductionTypeEnum().equals(SFlowerProductionTypeEnum.STORE)
                ? String.valueOf(queryDTO.getCityId())
                : SStockFlowerMonConstants.PHYSICAL_WAREHOUSE;

        String deliveryRulesKey = SStockFlowerMonConstants.FLOWER_MONTHLY + "DeliveryRules:" + queryDTO.getSkuCode() + ":" + stockProducerKey;
        Object deliveryRules = redisClient.getCache(deliveryRulesKey);
        if (EmptyUtil.isNotEmpty(deliveryRules)) {
            pcsFlowerDeliveryDate = (PcsFlowerDeliveryDate) deliveryRules;
        } else {
            pcsFlowerDeliveryDate = getFlowerStockAndDateInDB(queryDTO, payTime);
            redisClient.putCache(deliveryRulesKey, pcsFlowerDeliveryDate);
        }
        return pcsFlowerDeliveryDate;

    }

    private void refreshDeliveryCache(String skuCode, Integer flowerProductionType) {
        SFlowerProductionTypeEnum flowerProductionTypeEnum = flowerProductionType == 1 ? SFlowerProductionTypeEnum.STORE : SFlowerProductionTypeEnum.WAREHOUSE;
        SFlowerMonthlyQueryDTO queryDTO = new SFlowerMonthlyQueryDTO();
        queryDTO.setsFlowerProductionTypeEnum(flowerProductionTypeEnum);
        queryDTO.setSkuCode(skuCode);

        String deliveryRulesKey = SStockFlowerMonConstants.FLOWER_MONTHLY + "DeliveryRules:" + queryDTO.getSkuCode() + ":";
        //门店
        if (flowerProductionTypeEnum.equals(SFlowerProductionTypeEnum.STORE)) {
            List<String> skuCodes = new ArrayList<>();
            skuCodes.add(skuCode);
            List<SFlowerMonthlyCityDTO> cityList = flowerMonthlyService.getCityList(skuCodes);
            if (EmptyUtil.isNotEmpty(cityList)) {
                for (SFlowerMonthlyCityDTO flowerMonthlyCityDTO : cityList) {
                    queryDTO.setCityId(flowerMonthlyCityDTO.getCityId());
                    redisClient.putCache(deliveryRulesKey + String.valueOf(flowerMonthlyCityDTO.getCityId()), getFlowerStockAndDateInDB(queryDTO, new Date()));
                }
            }
        } else {
            redisClient.putCache(deliveryRulesKey + SStockFlowerMonConstants.PHYSICAL_WAREHOUSE, getFlowerStockAndDateInDB(queryDTO, new Date()));
        }
    }

    private PcsFlowerDeliveryDate getFlowerStockAndDateInDB(SFlowerMonthlyQueryDTO queryDTO, Date payTime) {
        PcsFlowerDeliveryDate pcsFlowerDeliveryDate = new PcsFlowerDeliveryDate();
        PcsFlowerDeliveryCond skuCond = new PcsFlowerDeliveryCond();
        skuCond.setSkuCode(queryDTO.getSkuCode());
        skuCond.setIsUseable(1);
        skuCond.setFinishState(0);

        int totalStock = 0;
        Integer capacityQuantity = 0;
        PcsFlowerDeliveryVO pcsFlowerDeliveryVO = pcsFlowerDeliveryMapper.getFlowerDeliveryBySku(skuCond);
        if (pcsFlowerDeliveryVO == null) {
            pcsFlowerDeliveryDate.setCanSale(false);
            List<PcsFlowerDeliveryRecipeVO> useableDateList = new ArrayList<>();
            useableDateList.add(new PcsFlowerDeliveryRecipeVO());
            pcsFlowerDeliveryDate.setDeliveryDate(useableDateList);
            refreshSoldCache(queryDTO, capacityQuantity, totalStock);
            return pcsFlowerDeliveryDate;
        }
        //截单时间
        Date cutDate = DateUtil.getCurrWeek(pcsFlowerDeliveryVO.getCutOffWeekDay());
        Calendar cutCalendar = Calendar.getInstance();
        cutCalendar.setTime(cutDate);
        String[] time = pcsFlowerDeliveryVO.getCutOffTime().split(":");
        if (time.length == 3) {
            cutCalendar.set(Calendar.HOUR_OF_DAY, Integer.parseInt(time[0]));
            cutCalendar.set(Calendar.MINUTE, Integer.parseInt(time[1]));
            cutCalendar.set(Calendar.SECOND, Integer.parseInt(time[2]));
        }
        //确定是大于现在的截单时间
        if (cutCalendar.getTimeInMillis() < Calendar.getInstance().getTimeInMillis()) {
            cutCalendar.add(Calendar.DATE, 7);
        }
        Calendar payDateTime = Calendar.getInstance();
        payDateTime.setTime(payTime);
        //确定截单时间要大于支付时间
        if (payDateTime.getTimeInMillis() > cutCalendar.getTimeInMillis()) {
            cutCalendar.add(Calendar.DATE, 7);
        }

        if (!NumberUtil.isNullOrZero(pcsFlowerDeliveryVO.getDeliveryInterval())) {
            cutCalendar.add(Calendar.DATE, 7 * pcsFlowerDeliveryVO.getDeliveryInterval());
        }
        //发送日期大于截单时间的配送日期
        PcsFlowerDeliveryCond cond = new PcsFlowerDeliveryCond();
        cond.setSkuCode(queryDTO.getSkuCode());
        cond.setIsUseable(1);
        cond.setFinishState(0);
        cond.setSendDate(DateUtil.format(cutCalendar.getTime(), "yyyy-MM-dd"));
        cond.setCityId(queryDTO.getCityId());


        List<PcsFlowerDeliveryRecipeVO> pcsFlowerDeliveryRecipes = pcsFlowerDeliveryRecipeMapper.getFlowerDeliveryDate(cond);
        if (CollectionUtils.isNotEmpty(pcsFlowerDeliveryRecipes)) {
            List<PcsFlowerDeliveryRecipeVO> useableDateList = new ArrayList<>();
            ServiceResp<SFlowerMonthlyCityDTO> serviceResp = flowerMonthlyService.getFlowerSkuStock(queryDTO.getSkuCode(), queryDTO.getCityId(), queryDTO.getsFlowerProductionTypeEnum());
            if (serviceResp.isFailure()) {
                throw new PurchaseException("库存查询失败");
            }
            capacityQuantity = serviceResp.getBean().getCapacityQuantity();
            int planQuantity = 0;
            Integer saledQuantity = serviceResp.getBean().getSoldQuantity();
            int count = pcsFlowerDeliveryVO.getRuleNumber();
            int queryStockNum = 0;

            Map<Long, Integer> cityTaskMap = new HashMap<>();

            int recipeNum = 0;
            List<Integer> deliveryRecipeIds = new ArrayList<>();
            for (PcsFlowerDeliveryRecipeVO recip : pcsFlowerDeliveryRecipes) {
                if (recipeNum < count) {
                    deliveryRecipeIds.add(recip.getId().intValue());
                    recipeNum++;
                } else {
                    break;
                }
            }

            List<PcsFlowerMonTaskVO> flowerMonTaskVOList = new ArrayList<>();
            if (queryDTO.getsFlowerProductionTypeEnum().equals(SFlowerProductionTypeEnum.STORE)) {
                List<Integer> cityIds = new ArrayList<>();
                cityIds.add(queryDTO.getCityId());
                flowerMonTaskVOList = pcsFlowerDeliveryRecipeMapper.selectCityDeliveryRecipeTaskList(cityIds, queryDTO.getSkuCode(), deliveryRecipeIds);
            } else {
                flowerMonTaskVOList = pcsFlowerDeliveryRecipeMapper.selectDeliveryRecipeTaskList(queryDTO.getSkuCode(), deliveryRecipeIds);
            }

            if (EmptyUtil.isNotEmpty(flowerMonTaskVOList)) {
                for (PcsFlowerMonTaskVO pcsFlowerMonTaskVO : flowerMonTaskVOList) {
                    cityTaskMap.put(pcsFlowerMonTaskVO.getDeliveryRecipeId().longValue(), pcsFlowerMonTaskVO.getTaskQuantity());
                }
            }
            for (PcsFlowerDeliveryRecipeVO recip : pcsFlowerDeliveryRecipes) {
                if (queryStockNum == count && totalStock <= 0) {
                    pcsFlowerDeliveryDate.setCanSale(false);
                    List<PcsFlowerDeliveryRecipeVO> dateList = new ArrayList<>();
                    dateList.add(new PcsFlowerDeliveryRecipeVO());
                    pcsFlowerDeliveryDate.setDeliveryDate(dateList);
                    refreshSoldCache(queryDTO, capacityQuantity, totalStock);
                    return pcsFlowerDeliveryDate;
                } else {
                    int stock = 0;
                    int soldQuantity = cityTaskMap.containsKey(recip.getId()) ? cityTaskMap.get(recip.getId()) : 0;
                    stock = capacityQuantity - soldQuantity;
                    if (stock > 0 && useableDateList.size() < pcsFlowerDeliveryVO.getSendTimes()) {
                        totalStock = totalStock > 0 ? totalStock : stock;
                        //saledQuantity = totalStock > 0 ? saledQuantity : soldQuantity;
                        planQuantity = planQuantity > 0 ? planQuantity : recip.getPlanQuantity();
                        useableDateList.add(recip);
                    } else if (stock <= 0 && (useableDateList.size() > 0 && useableDateList.size() < pcsFlowerDeliveryVO
                            .getSendTimes())) {
                        useableDateList.add(recip);
                    } else {
                        queryStockNum = queryStockNum + 1;
                    }
                    //}
                }
            }

            pcsFlowerDeliveryDate.setCanSale(totalStock > 0 ? true : false);
            pcsFlowerDeliveryDate.setDeliveryDate(useableDateList);
        } else {
            pcsFlowerDeliveryDate.setCanSale(false);
            List<PcsFlowerDeliveryRecipeVO> dateList = new ArrayList<>();
            dateList.add(new PcsFlowerDeliveryRecipeVO());
            pcsFlowerDeliveryDate.setDeliveryDate(dateList);
        }
        refreshSoldCache(queryDTO, capacityQuantity, totalStock);
        return pcsFlowerDeliveryDate;
    }

    private void refreshSoldCache(SFlowerMonthlyQueryDTO queryDTO, int capacityQuantity, int totalStock) {
        List<SFlowerMonthlyCityDTO> list = new ArrayList<>();
        SFlowerMonthlyCityDTO sFlowerMonthlyCityDTO = new SFlowerMonthlyCityDTO();
        sFlowerMonthlyCityDTO.setCityId(queryDTO.getCityId());
        sFlowerMonthlyCityDTO.setSkuCode(queryDTO.getSkuCode());
        sFlowerMonthlyCityDTO.setSoldQuantity(capacityQuantity - totalStock);
        sFlowerMonthlyCityDTO.setCanUseQuantity(totalStock);
        sFlowerMonthlyCityDTO.setProductionType(queryDTO.getsFlowerProductionTypeEnum().getValue());
        list.add(sFlowerMonthlyCityDTO);
        flowerMonthlyService.refreshCache(list);
    }

    @Override
    public List<PcsFlowerSkuStatisticsVO> requiredSuppliesStatistics(String startDate, String endDate) {
        return pcsFlowerRecipeSkuMapper.requiredSuppliesStatistics(startDate, endDate);
    }

    @Override
    public List<PcsFlowerMerchantibleVO> getFlowerSellNumber() {
        List<PcsFlowerMerchantibleVO> flowerAvailableSkus = new ArrayList<>();
        List<PcsFlowerMerchantibleVO> pcsFlowerMerchantibleVOs = pcsFlowerDeliveryRecipeMapper.getFlowerSellNumber();
        if (CollectionUtils.isNotEmpty(pcsFlowerMerchantibleVOs)) {
            for (PcsFlowerMerchantibleVO flowerAvailableSku : pcsFlowerMerchantibleVOs) {
                Integer selfAvailableQuantity = flowerAvailableSku.getPlanQuantity() - flowerAvailableSku.getSoldQuantity();
                Integer tmallAvailableQuantity = flowerAvailableSku.getTmallPlanQuantity() - flowerAvailableSku.getTmallSoldQuantity();
                Integer safeStock = flowerAvailableSku.getSafeStock();
                if ((selfAvailableQuantity < safeStock && tmallAvailableQuantity >= safeStock) ||
                        (tmallAvailableQuantity < safeStock && selfAvailableQuantity >= safeStock)) {
                    flowerAvailableSku.setSelfAvailableQuantity(selfAvailableQuantity);
                    flowerAvailableSku.setTmallAvailableQuantity(tmallAvailableQuantity);
                    flowerAvailableSkus.add(flowerAvailableSku);
                }
            }
        }
        return flowerAvailableSkus;
    }


    public void updateFlowerFinishStateChange() {
        PcsFlowerDeliveryExample example = new PcsFlowerDeliveryExample();
        example.createCriteria().andUseableStatueEqualTo(1);
        List<PcsFlowerDelivery> list = pcsFlowerDeliveryMapper.selectByExample(example);
        for (PcsFlowerDelivery pcsFlowerDelivery : list) {
            try {
                updateFlowerFinishStateChange(pcsFlowerDelivery);
            } catch (Exception e) {
                log.error(pcsFlowerDelivery.getSku() + "月送鲜花状态转换失败");
                e.printStackTrace();
            }

        }
    }


    public void updateFlowerFinishStateChange(String skuCode) {
        PcsFlowerDeliveryExample example = new PcsFlowerDeliveryExample();
        PcsFlowerDeliveryExample.Criteria deliveryCriteria = example.createCriteria();
        deliveryCriteria.andUseableStatueEqualTo(1);
        deliveryCriteria.andSkuEqualTo(skuCode);
        List<PcsFlowerDelivery> list = pcsFlowerDeliveryMapper.selectByExample(example);
        updateFlowerFinishStateChange(list);
    }

    private void updateFlowerFinishStateChange(List<PcsFlowerDelivery> list) {
        for (PcsFlowerDelivery pcsFlowerDelivery : list) {
            updateFlowerFinishStateChange(pcsFlowerDelivery);
        }
    }

    private void updateFlowerFinishStateChange(PcsFlowerDelivery pcsFlowerDelivery) {
        if (pcsFlowerDelivery.getSku().equals("101180038")) {
            log.info("101180038");
        }
        if (pcsFlowerDelivery.getSku() != null && pcsFlowerDelivery.getCutoffDay() != null && pcsFlowerDelivery.getCutoffTime() != null) {
            Date cutDate = getCurrWeek(pcsFlowerDelivery.getCutoffDay());
            Calendar cutCalendar = Calendar.getInstance();
            cutCalendar.setTime(cutDate);
            String[] time = pcsFlowerDelivery.getCutoffTime().split(":");
            if (time.length == 3) {
                cutCalendar.set(Calendar.HOUR_OF_DAY, Integer.parseInt(time[0]));
                cutCalendar.set(Calendar.MINUTE, Integer.parseInt(time[1]));
                cutCalendar.set(Calendar.SECOND, Integer.parseInt(time[2]));
            }
            if (Calendar.getInstance().getTimeInMillis() > cutCalendar.getTimeInMillis()) {
                cutCalendar.add(Calendar.DATE, 7);
            }
            if (!NumberUtil.isNullOrZero(pcsFlowerDelivery.getDeliveryInterval())) {
                cutCalendar.add(Calendar.DATE, 7 * pcsFlowerDelivery.getDeliveryInterval());
            }
            //更新小于最近大于现在的截单时间的为已完成
            PcsFlowerDeliveryRecipeExample pcsFlowerDeliveryRecipeExample = new PcsFlowerDeliveryRecipeExample();
            PcsFlowerDeliveryRecipeExample.Criteria criteria = pcsFlowerDeliveryRecipeExample.createCriteria();
            criteria.andSendDayLessThan(cutCalendar.getTime());
//                criteria.andSendDayLessThan(DateUtil.parse("2017-03-15","yyyy-MM-dd"));
            criteria.andFinishStateEqualTo(0);
            criteria.andSkuCodeEqualTo(pcsFlowerDelivery.getSku());
            pcsFlowerDeliveryRecipeExample.setOrderByClause("SEND_DAY asc");
            PcsFlowerDeliveryRecipe record = new PcsFlowerDeliveryRecipe();
            record.setFinishState(1);
            //pcsFlowerDeliveryRecipeMapper.selectByExample(pcsFlowerDeliveryRecipeExample);
            int ret = pcsFlowerDeliveryRecipeMapper.updateByExampleSelective(record, pcsFlowerDeliveryRecipeExample);

            refreshDeliveryCache(pcsFlowerDelivery.getSku(), pcsFlowerDelivery.getProducer());

            //refreshSoldQuantityCache(pcsFlowerDelivery.getSku(), pcsFlowerDelivery.getProducer().byteValue());
        }
    }

    //星期天第一天
    private Date getCurrWeek(int week) {
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.setFirstDayOfWeek(Calendar.SUNDAY);
        currentDate.set(GregorianCalendar.DAY_OF_WEEK, week);  // 设置星期为周week
        currentDate.add(GregorianCalendar.WEEK_OF_YEAR, 0); // 加/减weekNum周
        Date nextWeek = currentDate.getTime();
        return nextWeek;
    }


    private void refreshSoldQuantityCache(String skuCode, Byte productionType) {
        int defaultRecipeId = pcsFlowerDeliveryRecipeMapper.selectCurrentRecipeId(skuCode);
        List<SFlowerMonthlyCityDTO> refreshList = new ArrayList<>();
        if (productionType.equals(SFlowerProductionTypeEnum.STORE.getValue())) {
            List<String> skuCodes = new ArrayList<>();
            skuCodes.add(skuCode);
            List<SFlowerMonthlyCityDTO> cityDTOList = flowerMonthlyService.getCityList(skuCodes);
            if (EmptyUtil.isNotEmpty(cityDTOList)) {
                List<Integer> cityIds = new ArrayList<>();
                Map<Integer, Integer> cityCapacityMap = new HashMap<>();
                for (SFlowerMonthlyCityDTO flowerMonthlyCityDTO : cityDTOList) {
                    cityIds.add(flowerMonthlyCityDTO.getCityId());
                    cityCapacityMap.put(flowerMonthlyCityDTO.getCityId(), flowerMonthlyCityDTO.getCapacityQuantity());
                }
                List<PcsFlowerMonTaskVO> flowerMonTaskVOList = pcsFlowerDeliveryRecipeMapper.selectCurrentTaskBySkuAndCity(cityIds, skuCode, defaultRecipeId);

                for (PcsFlowerMonTaskVO flowerMonTaskVO : flowerMonTaskVOList) {
                    SFlowerMonthlyCityDTO sFlowerMonthlyCityDTO = new SFlowerMonthlyCityDTO();
                    sFlowerMonthlyCityDTO.setSoldQuantity(flowerMonTaskVO.getTaskQuantity());
                    sFlowerMonthlyCityDTO.setCapacityQuantity(cityCapacityMap.get(flowerMonTaskVO.getCityId()));
                    sFlowerMonthlyCityDTO.setCityId(flowerMonTaskVO.getCityId());
                    sFlowerMonthlyCityDTO.setSkuCode(skuCode);
                    sFlowerMonthlyCityDTO.setProductionType(SFlowerProductionTypeEnum.STORE.getValue());
                    refreshList.add(sFlowerMonthlyCityDTO);
                }
            }

        } else {
            int soldQuantity = pcsFlowerDeliveryRecipeMapper.selectWhCurrentTask(skuCode, defaultRecipeId);
            SFlowerMonthlyCityDTO fowerMonthlyCityDTO = flowerMonthlyService.getFlowerMonWhData(skuCode);
            if (EmptyUtil.isNotEmpty(fowerMonthlyCityDTO)) {
                SFlowerMonthlyCityDTO sFlowerMonthlyCityDTO = new SFlowerMonthlyCityDTO();
                sFlowerMonthlyCityDTO.setSoldQuantity(soldQuantity);
                sFlowerMonthlyCityDTO.setSkuCode(skuCode);
                sFlowerMonthlyCityDTO.setCapacityQuantity(fowerMonthlyCityDTO.getCapacityQuantity());
                sFlowerMonthlyCityDTO.setProductionType(SFlowerProductionTypeEnum.WAREHOUSE.getValue());
                refreshList.add(sFlowerMonthlyCityDTO);
            }

        }
        if (EmptyUtil.isNotEmpty(refreshList)) {
            flowerMonthlyService.refreshCache(refreshList);
        }
    }

    @Override
    @Transactional
    public void flowerFinishStateChange() {
        PcsFlowerDeliveryExample example = new PcsFlowerDeliveryExample();
        example.createCriteria().andUseableStatueEqualTo(1);
        List<PcsFlowerDelivery> list = pcsFlowerDeliveryMapper.selectByExample(example);
        for (PcsFlowerDelivery pcsFlowerDelivery : list) {
            if (pcsFlowerDelivery.getSku() != null && pcsFlowerDelivery.getCutoffDay() != null && pcsFlowerDelivery.getCutoffTime() != null) {
                pcsFlowerDeliveryRecipeMapper.updateCurrBeforeFinish(pcsFlowerDelivery.getSku());
                pcsFlowerDeliveryRecipeMapper.updateCurrAfterNoFinish(pcsFlowerDelivery.getSku());
                PcsFlowerDeliveryRecipeExample pcsFlowerDeliveryRecipeExample = new PcsFlowerDeliveryRecipeExample();
                PcsFlowerDeliveryRecipeExample.Criteria criteria = pcsFlowerDeliveryRecipeExample.createCriteria();
                criteria.andSendDayGreaterThan(Calendar.getInstance().getTime());
                criteria.andFinishStateEqualTo(0);
                criteria.andSkuCodeEqualTo(pcsFlowerDelivery.getSku());
                pcsFlowerDeliveryRecipeExample.setOrderByClause("SEND_DAY asc");
                List<PcsFlowerDeliveryRecipe> pcsFlowerDeliveryRecipeList = pcsFlowerDeliveryRecipeMapper.selectByExample(pcsFlowerDeliveryRecipeExample);
                Date cutDate = DateUtil.getCurrWeek(pcsFlowerDelivery.getCutoffDay());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(cutDate);
//                if(pcsFlowerDelivery.getCutoffDay() == 1){
//                    calendar.add(Calendar.DAY_OF_MONTH,-7);
//                }
                String[] time = pcsFlowerDelivery.getCutoffTime().split(":");
                if (time.length == 3) {
                    calendar.set(Calendar.HOUR_OF_DAY, Integer.parseInt(time[0]));
                    calendar.set(Calendar.MINUTE, Integer.parseInt(time[1]));
                    calendar.set(Calendar.SECOND, Integer.parseInt(time[2]));
                }
//                System.out.println(DateUtil.format(calendar.getTime(),DateUtil.DEFAULT_DATETIME_FORMAT));
                if (Calendar.getInstance().getTimeInMillis() > calendar.getTimeInMillis()) {
                    if (pcsFlowerDeliveryRecipeList != null) {
                        PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe = pcsFlowerDeliveryRecipeList.get(0);
                        pcsFlowerDeliveryRecipe.setFinishState(1);
                        pcsFlowerDeliveryRecipeMapper.updateByPrimaryKey(pcsFlowerDeliveryRecipe);
                    }
                }
            }
        }
    }

    @Override
    @Transactional
    public void importFlowerRecipeMaterial(List<FlowerRecipeMaterialVO> list, String skuCode, int isCycle, String effectDate) {
        PcsFlowerRecipeSkuCond cond = new PcsFlowerRecipeSkuCond();
        cond.setEffectDate(effectDate);
        cond.setSkuCode(skuCode);
        PcsFlowerDeliveryRecipeExample pcsFlowerDeliveryRecipeExample = new PcsFlowerDeliveryRecipeExample();
        PcsFlowerDeliveryRecipeExample.Criteria criteria = pcsFlowerDeliveryRecipeExample.createCriteria();
        criteria.andSkuCodeEqualTo(skuCode);
        criteria.andSendDayGreaterThanOrEqualTo(DateUtil.parse(effectDate, DateUtil.DEFAULT_DATE_FORMAT));
        criteria.andUseableStateEqualTo(1);
        pcsFlowerDeliveryRecipeExample.setOrderByClause("SEND_DAY ASC");
        List<PcsFlowerDeliveryRecipe> pcsFlowerDeliveryRecipeList = pcsFlowerDeliveryRecipeMapper.selectByExample(pcsFlowerDeliveryRecipeExample);
        List<List<FlowerRecipeMaterialVO>> myList = new ArrayList<>();
        int initNum = 0;
        List<FlowerRecipeMaterialVO> voList = new ArrayList<>();
        for (FlowerRecipeMaterialVO vo : list) {
            if (vo.getId() != initNum) {
                voList = new ArrayList<>();
                voList.add(vo);
                myList.add(voList);
                initNum = vo.getId();
            } else {
                voList.add(vo);
            }
        }
        if (isCycle == 1) {
            //后插入
            for (int i = 0; i < pcsFlowerDeliveryRecipeList.size(); i++) {
                processFlowerRecipeSku(pcsFlowerDeliveryRecipeList, myList, i);
            }
        } else {
            int max = pcsFlowerDeliveryRecipeList.size();
            if (myList.size() < max) {
                max = myList.size();
            }
            for (int i = 0; i < max; i++) {
                processFlowerRecipeSku(pcsFlowerDeliveryRecipeList, myList, i);
            }
        }
    }

    private void processFlowerRecipeSku(List<PcsFlowerDeliveryRecipe> pcsFlowerDeliveryRecipeList, List<List<FlowerRecipeMaterialVO>> myList, int i) {
        PcsFlowerDeliveryRecipe pcsFlowerDeliveryRecipe = pcsFlowerDeliveryRecipeList.get(i);
        List<FlowerRecipeMaterialVO> realList = myList.get(i % myList.size());
        pcsFlowerRecipeSkuMapper.upatePcsFlowerSkuStatisticsCancel(pcsFlowerDeliveryRecipe.getId());
        for (FlowerRecipeMaterialVO vo : realList) {
            PcsFlowerRecipeSku pcsFlowerRecipeSku = new PcsFlowerRecipeSku();
            pcsFlowerRecipeSku.setRecipeId(pcsFlowerDeliveryRecipe.getId());
            pcsFlowerRecipeSku.setAvailable(1);
            pcsFlowerRecipeSku.setExpendNumber(new BigDecimal(vo.getQuantity()).floatValue());
            pcsFlowerRecipeSku.setSkuCode(vo.getSkuCode());
            if ("主".equals(vo.getMaterialType())) {
                pcsFlowerRecipeSku.setSkuType(1);
            } else {
                pcsFlowerRecipeSku.setSkuType(0);
            }
            pcsFlowerRecipeSkuMapper.insert(pcsFlowerRecipeSku);
        }
    }

    @Override
    @Transactional
    public boolean updateTmallFlowerPlanQuantity(PcsFlowerRecipePlanCond cond) throws Exception {
        PcsFlowerDeliveryRecipe selfFlowerRecipe = new PcsFlowerDeliveryRecipe();
        selfFlowerRecipe.setId(cond.getRecipeId());
        selfFlowerRecipe.setPlanQuantity(cond.getPlanQuantity());
        pcsFlowerDeliveryRecipeMapper.updateByPrimaryKeySelective(selfFlowerRecipe);
        PcsFlowerDeliveryRecipe tmallFlowerRecipe = new PcsFlowerDeliveryRecipe();
        tmallFlowerRecipe.setId(cond.getRecipeId());
        tmallFlowerRecipe.setTmallPlanQuantity(cond.getTmallPlanQuantity());
        pcsFlowerDeliveryRecipeMapper.updateByPrimaryKeySelective(tmallFlowerRecipe);
        boolean tmallResult = true;
        try {
            //tmallResult = updateTmallMthFlowerStock(cond.getSkuCode(), cond.getTmallPrePlanQuantity(), cond.getTmallPlanQuantity(), cond.getRecipeId()+"");
        } catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        if (!tmallResult) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }
        return true;
    }

    @Override
    public Boolean updateTmallMthFlowerStock(String skuCode, int prePlanNumber, int afterPlanNumber, String referenceCode, Long operatorId) throws Exception {
        int difference = afterPlanNumber - prePlanNumber;
        if (prePlanNumber == afterPlanNumber) {
            return true;
        } else {
            Long numIid = pegasusUtilFacade.getSkuNumIid(skuCode, Constants.CHN1031CODE);
            wWhCommandService.synCommodityStocks(numIid, skuCode, difference, Constants.CHN1031CODE, 5, referenceCode, operatorId);
            return true;
        }
    }

    @Override
    public List<String> findPhyWhFlowerMonthyCapacitySeted(String skuCode) {
        return pcsFlowerMonthlyCapacitySettingMapper.findPhyWhFlowerMonthyCapacitySeted(skuCode);
    }

    @Override
    public PageInfo findCapacityByCond(PcsFlowerDeliveryCapacityCond cond) {
        int offset = (cond.getCurrpage() - 1) * cond.getPagenum();
        PageRowBounds pageRowBounds = new PageRowBounds(offset, cond.getPagenum());
        PageInfo pageInfo = new PageInfo(pcsFlowerMonthlyCapacitySettingMapper.selectCapacityByCond(cond, pageRowBounds));
        pageInfo.setTotal(pageRowBounds.getTotal());
        return pageInfo;
    }

    @Override
    public Map<Class<?>, List<?>> findFlowerDeliverySaleInfo(Long deliveryRecipeId, String skuCode) {
        Map<Class<?>, List<?>> map = new HashMap<>();
        PcsFlowerDeliveryRecipe flowerDeliveryRecipe = pcsFlowerDeliveryRecipeMapper.selectByPrimaryKey(deliveryRecipeId);
        PcsFlowerDelivery flowerDelivery = findFlowerDelivery(flowerDeliveryRecipe.getSkuCode());
        if (NullUtil.isNull(flowerDelivery)) {
            return map;
        }
        List<PcsFlowerDeliveryShouldSendPackageExcelVO> shouldSendList = pcsFlowerDeliveryRecipeMapper
                .findFlowerDeliveryShouldSendPackageList(deliveryRecipeId);
        if (EmptyUtil.isNotEmpty(shouldSendList)) {
            for (PcsFlowerDeliveryShouldSendPackageExcelVO excel : shouldSendList) {
                if (WhWarehouseGroupVO.WAREHOUSE_YES.equals(excel.getWarehouseGroupType())) {
                    if (PcsFlowerDeliveryVO.PRODUCER_WAREHOUSE.equals(flowerDelivery.getProducer())) {
                        excel.setAbnormal("否");
                    } else {
                        excel.setAbnormal("是");
                    }
                } else if (WhWarehouseGroupVO.WAREHOUSE_NO.equals(excel.getWarehouseGroupType())) {
                    if (PcsFlowerDeliveryVO.PRODUCER_STORE.equals(flowerDelivery.getProducer())) {
                        excel.setAbnormal("否");
                    } else {
                        excel.setAbnormal("是");
                    }
                }
            }
        }
        map.put(PcsFlowerDeliveryShouldSendPackageExcelVO.class, shouldSendList);
        if (PcsFlowerDeliveryVO.PRODUCER_WAREHOUSE.equals(flowerDelivery.getProducer())) {
            List<PcsFlowerDeliveryWhCountExcelVO> whCountList = pcsFlowerDeliveryRecipeMapper
                    .findFlowerDeliveryWhCountList(deliveryRecipeId, skuCode);
            map.put(PcsFlowerDeliveryWhCountExcelVO.class, whCountList);
        } else if (PcsFlowerDeliveryVO.PRODUCER_STORE.equals(flowerDelivery.getProducer())) {
            List<PcsFlowerDeliveryCityCountExcelVO> cityCountList = pcsFlowerDeliveryRecipeMapper
                    .findFlowerDeliveryCityCountList(deliveryRecipeId, skuCode);
            map.put(PcsFlowerDeliveryCityCountExcelVO.class, cityCountList);
            List<PcsFlowerDeliveryStoreCountExcelVO> storeCountList = pcsFlowerDeliveryRecipeMapper
                    .findFlowerDeliveryStoreCountList(deliveryRecipeId, skuCode);
            map.put(PcsFlowerDeliveryStoreCountExcelVO.class, storeCountList);
        }
        List<PcsFlowerDeliveryNotSendPackageExcelVO> notSendList = pcsFlowerDeliveryRecipeMapper
                .findFlowerDeliveryNotSendPackageList(deliveryRecipeId);
        map.put(PcsFlowerDeliveryNotSendPackageExcelVO.class, notSendList);
        return map;
    }

    private PcsFlowerDelivery findFlowerDelivery(String skuCode) {
        PcsFlowerDeliveryExample example = new PcsFlowerDeliveryExample();
        example.createCriteria().andSkuEqualTo(skuCode);
        List<PcsFlowerDelivery> list = pcsFlowerDeliveryMapper.selectByExample(example);
        if (EmptyUtil.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public int saveOrUpdate(List<PcsFlowerMonCapaSettingVO> records) throws Exception {
        pcsFlowerMonthlyCapacitySettingMapper.saveOrUpdate(BeanUtil.buildListFrom(records, PcsFlowerMonthlyCapacitySetting.class));
        pcsFlowerDeliveryRecipePhyWhCapacityService.refreshFlowerDeliveryRecipePhyWhCapacity(records.get(0).getSkuCode());
        final PcsFlowerMonCapaSettingVO pcsFlowerMonCapaSettingVO = records.get(0);
        flowerMonthlyService.refreshCacheBySkuCode(pcsFlowerMonCapaSettingVO.getSkuCode(), pcsFlowerMonCapaSettingVO.getProductionType() == 1 ? SFlowerProductionTypeEnum.STORE : SFlowerProductionTypeEnum.WAREHOUSE);
        return 1;
    }

    @Override
    public List<PcsFlowerMonCapaLogVO> findPcsFlowerMonCapaLogBySkuCode(String skuCode) {
        return BeanUtil.buildListFrom(pcsFlowerMonthlyCapacityLogMapper.selectBySkuCode(skuCode), PcsFlowerMonCapaLogVO.class);
    }

    @Override
    public List<PcsFlowerMonCapaSettingVO> findCityCapacityByCond(PcsFlowerDeliveryCapacityCond cond) {
        return pcsFlowerMonthlyCapacitySettingMapper.selectCityCapacityByCond(cond);
    }

    @Override
    public int saveCapacityChangeLogs(List<PcsFlowerMonthlyCapacityLog> logs) {
        return pcsFlowerMonthlyCapacityLogMapper.batchInsert(logs);
    }

    @Override
    public List<PcsFlowerMonCapaSettingVO> findCapacityByUniqueIndex(List<PcsFlowerDeliveryCapacityCond> conds) {
        List<String> list = new ArrayList<>();
        for (PcsFlowerDeliveryCapacityCond cond : conds) {
            list.add(cond.getSkuCode() + cond.getPhysicalWarehouseCode());
        }
        return pcsFlowerMonthlyCapacitySettingMapper.selectCapacityByUniqueIndex(list);
    }

    @Override
    public Map<String, Integer> findCurrentTaskQuntity(String skuCode, List<Integer> cityIds, SFlowerProductionTypeEnum productionTypeEnum) {
        Map<String, Integer> resultMap = new HashMap<>();
        int defaultRecipeId = pcsFlowerDeliveryRecipeMapper.selectCurrentRecipeId(skuCode);
        if (productionTypeEnum.equals(SFlowerProductionTypeEnum.STORE)) {
            List<PcsFlowerMonTaskVO> flowerMonTaskVOList = pcsFlowerDeliveryRecipeMapper.selectCurrentTaskBySkuAndCity(cityIds, skuCode, defaultRecipeId);
            if (EmptyUtil.isNotEmpty(flowerMonTaskVOList)) {
                for (PcsFlowerMonTaskVO flowerMonTaskVO : flowerMonTaskVOList) {
                    resultMap.put(String.valueOf(flowerMonTaskVO.getCityId()), flowerMonTaskVO.getTaskQuantity());
                }
            }
        } else {
            resultMap.put(skuCode, pcsFlowerDeliveryRecipeMapper.selectWhCurrentTask(skuCode, defaultRecipeId));
        }
        return resultMap;
    }

    @Override
    public List<PcsFlowerMonCapaSettingVO> findAllWhCapacityDataBySkucode(String skuCode) {
        return pcsFlowerMonthlyCapacitySettingMapper.findAllWhCapacityDataBySkucode(skuCode);
    }
}
