package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerDeliveryRecipeMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerDeliveryRecipePhyWhCapacityMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsFlowerMonthlyCapacitySettingMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerDeliveryRecipePhyWhCapacityExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerMonthlyCapacitySetting;
import com.thebeastshop.pegasus.service.purchase.model.PcsFlowerMonthlyCapacitySettingExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsFlowerDeliveryRecipePhyWhCapacityService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerDeliveryRecipePhyWhCapacityVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.ListUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Created by Administrator on 2018/1/25.
 */
@Service("pcsFlowerDeliveryRecipePhyWhCapacityService")
public class PcsFlowerDeliveryRecipePhyWhCapacityServiceImpl implements PcsFlowerDeliveryRecipePhyWhCapacityService {

    @Autowired
    private PcsFlowerDeliveryRecipePhyWhCapacityMapper pcsFlowerDeliveryRecipePhyWhCapacityMapper;

    @Autowired
    private PcsFlowerMonthlyCapacitySettingMapper pcsFlowerMonthlyCapacitySettingMapper;

    @Autowired
    private PcsFlowerDeliveryRecipeMapper pcsFlowerDeliveryRecipeMapper;

    /**
     *  先删除再插入，完成数据刷新
     * */
    @Override
    @Transactional
    public boolean refreshFlowerDeliveryRecipePhyWhCapacity(String skuCode) {
        if(EmptyUtil.isEmpty(skuCode)){
            return false;
        }
        //更新计划数量
        refreshFlowerDeliveryRecipeQuantity(skuCode);
        List<PcsFlowerDeliveryRecipePhyWhCapacityVO> capacityList = pcsFlowerDeliveryRecipePhyWhCapacityMapper.findNeedRefrshRecipeCapacity(skuCode);
        if(EmptyUtil.isEmpty(capacityList)){
            return true;
        }
        List<Long> deleteIdList = new ArrayList<>();//需清除数据
        for(PcsFlowerDeliveryRecipePhyWhCapacityVO capacity : capacityList){
            if(NullUtil.isNotNull(capacity.getId())){
                deleteIdList.add(capacity.getId());
                capacity.setId(null);
            }
        }
        batchDelete(deleteIdList);
        batchInsert(capacityList);
        return true;
    }

    private void batchDelete(List<Long> idList){
        if(EmptyUtil.isEmpty(idList)){
            return;
        }
        PcsFlowerDeliveryRecipePhyWhCapacityExample example = new PcsFlowerDeliveryRecipePhyWhCapacityExample();
        example.createCriteria().andIdIn(idList);
        pcsFlowerDeliveryRecipePhyWhCapacityMapper.deleteByExample(example);
    }

    private void batchInsert(List<PcsFlowerDeliveryRecipePhyWhCapacityVO> capacityList){
        if(EmptyUtil.isEmpty(capacityList)){
            return;
        }
        List<List<PcsFlowerDeliveryRecipePhyWhCapacityVO>> parts = Lists.partition(capacityList,100);
        for(List<PcsFlowerDeliveryRecipePhyWhCapacityVO> part : parts){
            pcsFlowerDeliveryRecipePhyWhCapacityMapper.batchInsert(part);
        }
    }

    private int findSkuCapacity(String skuCode){
        PcsFlowerMonthlyCapacitySettingExample example = new PcsFlowerMonthlyCapacitySettingExample();
        example.createCriteria().andSkuCodeEqualTo(skuCode);
        List<PcsFlowerMonthlyCapacitySetting> list = pcsFlowerMonthlyCapacitySettingMapper.selectByExample(example);
        int totalCapacity = 0;
        if(EmptyUtil.isNotEmpty(list)){
            for(PcsFlowerMonthlyCapacitySetting setting : list){
                totalCapacity += setting.getCapacityQuantity();
            }
        }
        return totalCapacity;
    }

    private boolean refreshFlowerDeliveryRecipeQuantity(String skuCode){
        //统计新产能上线数量
        int capacity = findSkuCapacity(skuCode);
        //更新计划数量
        pcsFlowerDeliveryRecipeMapper.updateFlowerDeliveyRecipePlanQuantityForNotFinished(skuCode,capacity);
        return true;
    }
}
