/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.thebeastshop.pegasus.service.purchase.cond.PcsFinancePaymentCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoCreditNoteCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoCreditNoteMapper;
import com.thebeastshop.pegasus.service.purchase.enums.PoFinancePaymentModeEnum;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoCreditNote;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoCreditNoteVO;
import com.thebeastshop.pegasus.util.PegasusConstants;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thebeastshop.pegasus.service.purchase.dao.PcsFinancePaymentMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsFinancePayment;
import com.thebeastshop.pegasus.service.purchase.model.PcsFinancePaymentExample;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.service.PcsFinancePaymentService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFinancePaymentVO;
import com.thebeastshop.pegasus.util.comm.CodeGenerator;
import com.thebeastshop.pegasus.util.comm.NullUtil;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author Eric.Lou
 * @version $Id: PcsPurchaseOrderServiceImpl.java, v 0.1 2015-08-10 14:18
 */
@Service("pcsFinancePaymentService")
public class PcsFinancePaymentServiceImpl implements PcsFinancePaymentService {

    private final Logger log = LoggerFactory.getLogger(PcsFinancePaymentServiceImpl.class);
    
    @Autowired
    private PcsFinancePaymentMapper pcsFinancePaymentMapper;

    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;

    @Autowired
    private PcsPoCreditNoteMapper pcsPoCreditNoteMapper;

	@Override
	public List<PcsFinancePayment> findPoFinaceVOByPoId(long poId,Integer type) {
        PcsFinancePaymentExample example = new PcsFinancePaymentExample();
        PcsFinancePaymentExample.Criteria criteria = example.createCriteria().andExternalIdEqualTo(poId);
        if(NullUtil.isNotNull(type)){
            criteria.andTypeEqualTo(type);
        }
        example.setOrderByClause("CREATE_TIME DESC");
        final List<PcsFinancePayment> poList = pcsFinancePaymentMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(poList)) {
            return Collections.emptyList();
        } else {
            return poList;
        }
	}
	
	@Override
    public PcsFinancePayment buildFromVO(PcsFinancePaymentVO vo) {
        if (NullUtil.isNull(vo)) {
            return null;
        }
        PcsFinancePayment record = new PcsFinancePayment();
        BeanUtils.copyProperties(vo, record);
        return record;
    }

	@Override
	public PcsFinancePaymentVO buildFromModel(PcsFinancePayment record) {
		if (NullUtil.isNull(record)) {
            return null;
        }
		PcsFinancePaymentVO vo = new PcsFinancePaymentVO();
        BeanUtils.copyProperties(record, vo);
        return vo;
	}

	@Override
	@Transactional
	public Long createFinancePayment(PcsFinancePayment pcsFinancePayment) {
		pcsFinancePayment.setCreateTime(new Date());
        // 前端传值
		// pcsFinancePayment.setType(PcsFinancePaymentVO.TYPE_PURCHASE_ORDER);
		pcsFinancePaymentMapper.insertSelective(pcsFinancePayment);
		final String code = generateCode(pcsFinancePayment.getId());
		pcsFinancePayment.setCode(code);
		pcsFinancePaymentMapper.updateByPrimaryKey(pcsFinancePayment);

        if (PcsFinancePaymentVO.TYPE_PURCHASE_ORDER.equals(pcsFinancePayment.getType())){
            // 更新采购单信息
            updatePoAfterFinancePayment(pcsFinancePayment);

            // 更新Credit Note抵扣
            updateCreditNoteAfterFinancePayment(pcsFinancePayment);
        }
		return pcsFinancePayment.getId();
	}

    private void updateCreditNoteAfterFinancePayment(PcsFinancePayment pcsFinancePayment) {
        // DecimalFormat df = new DecimalFormat("0.0000");//保留4位小数点
        // 如果使用Credit Note抵扣，则更新抵扣信息
        if (EmptyUtil.isNotEmpty(pcsFinancePayment.getByPoCode())
                && PoFinancePaymentModeEnum.credit_note.getKey().equals(pcsFinancePayment.getPaymentMode())){
            PcsPoCreditNoteCond cond = new PcsPoCreditNoteCond();
            cond.setPoCode(pcsFinancePayment.getByPoCode());
            cond.setValid(PegasusConstants.STATUS_AVAILABLE);
            cond.setNotStatus(PcsPoCreditNoteVO.STATUS_USEED);
            List<PcsPoCreditNoteVO> poCreditNoteVOs = pcsPurchaseOrderService.listPcsPoCreditNoteVOByCond(cond);
            if (CollectionUtils.isNotEmpty(poCreditNoteVOs)){
                List<PcsPoCreditNote> needModifyCreditNotes = new ArrayList<>();
                BigDecimal paymentAmount = pcsFinancePayment.getPaymentAmount();
                for (PcsPoCreditNoteVO pc : poCreditNoteVOs){
                    if (paymentAmount.compareTo(pc.getUsableAmount()) >= 0){
                        pc.setUsedAmount(pc.getUsedAmount().add(pc.getUsableAmount()).setScale(4, BigDecimal.ROUND_DOWN));
                        pc.setStatus(PcsPoCreditNoteVO.STATUS_USEED);
                        needModifyCreditNotes.add(BeanUtil.buildFrom(pc, PcsPoCreditNote.class));
                        paymentAmount = paymentAmount.subtract(pc.getUsableAmount());
                    }else{
                        pc.setUsedAmount(pc.getUsedAmount().add(paymentAmount).setScale(4, BigDecimal.ROUND_DOWN));
                        pc.setStatus(PcsPoCreditNoteVO.STATUS_IN_USE);
                        needModifyCreditNotes.add(BeanUtil.buildFrom(pc, PcsPoCreditNote.class));
                        break;
                    }
                }
                if (needModifyCreditNotes.size() > 0){
                    needModifyCreditNotes.forEach(cn -> pcsPoCreditNoteMapper.updateByPrimaryKeySelective(cn));
                }
            }
        }
    }

    private void updatePoAfterFinancePayment(PcsFinancePayment pcsFinancePayment){
        PcsPurchaseOrder pcsPurchaseOrder = new PcsPurchaseOrder();
        pcsPurchaseOrder.setId(pcsFinancePayment.getExternalId());
        // 更新财务状态为付款中
        pcsPurchaseOrder.setPaidAmount(pcsFinancePayment.getPaidAmount());

        // 待付金额为0.0，表明付款完成，则自动结束付款
//    		BigDecimal balance = pcsFinancePaymentVO.getBalanceAmountTemp();
//    		if (balance.doubleValue() == 0.0){
//    			pcsPurchaseOrder.setFinanceStatus(PcsPurchaseOrder.FINANCE_PAYMENT_STATUS_PAID);
//    		}else{
//    			pcsPurchaseOrder.setFinanceStatus(PcsPurchaseOrder.FINANCE_PAYMENT_STATUS_PAYING);
//    		}
        pcsPurchaseOrder.setFinanceStatus(PcsPurchaseOrder.FINANCE_PAYMENT_STATUS_PAYING);
        pcsPurchaseOrderService.updatePurchaseOrder(pcsPurchaseOrder);
    }
	
	@Override
    public String generateCode(Object id) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        String code = CodeGenerator.getInstance().generate("PCS_FINANCE_PAYMENT", params);
        return code;
    }

	@Override
	@Transactional
	public Boolean updateFinancePayment(PcsFinancePayment pcsFinancePayment) {
		return pcsFinancePaymentMapper.updateByPrimaryKey(pcsFinancePayment) != 0;
	}

	@Override
	public Map<String, BigDecimal> getTotalPaymentAmount(Long externalId) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("externalId", externalId);
		params.put("type", PcsFinancePaymentVO.TYPE_PURCHASE_ORDER);
		return pcsFinancePaymentMapper.getTotalPaymentAmount(params);
	}

	@Override
	public PcsFinancePayment findByPrimaryKey(Long id) {
		return pcsFinancePaymentMapper.selectByPrimaryKey(id);
	}

    @Override
    public List<PcsFinancePaymentVO> findPcsFinancePaymentVOByCond(PcsFinancePaymentCond cond){
        return pcsFinancePaymentMapper.findPcsFinancePaymentVOByCond(cond);
    }

    @Override
    public List<PcsFinancePaymentVO> selectNotNotifyPoPaymentInfo() {
        return pcsFinancePaymentMapper.selectNotNotifyPoPaymentInfo();
    }

    @Override
    public int updatePoPaymentNotifyStatus(List<Integer> ids) {
        return pcsFinancePaymentMapper.updatePoPaymentNotifyStatus(ids);
    }

}
