/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service.impl;

import java.util.*;

import com.thebeastshop.message.service.EmailSendService;
import com.thebeastshop.message.vo.EmailVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsPoPlanVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPoPlanMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsPurchaseOrderMapper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.merchandise.cond.PcsBrandCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.merchandise.service.McPcsBrandService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSupplierService;
import com.thebeastshop.pegasus.merchandise.vo.UserInfo;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsPoPlan;
import com.thebeastshop.pegasus.service.purchase.model.PcsPurchaseOrder;
import com.thebeastshop.pegasus.service.purchase.model.PcsSku;
import com.thebeastshop.pegasus.service.purchase.service.PcsCronService;
import com.thebeastshop.pegasus.service.purchase.service.PcsFlowerDeliveryService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPoPlanService;
import com.thebeastshop.pegasus.service.purchase.service.PcsPurchaseOrderService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsFlowerMerchantibleVO;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.model.CommGlobalConfig;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author Eric.Lou
 * @version $Id: PcsCronServiceImpl.java, v 0.1 2015-08-18 21:46
 */
@Service("pcsCronService")
public class PcsCronServiceImpl implements PcsCronService {

    private final Logger log = LoggerFactory.getLogger(PcsCronServiceImpl.class);

    @Autowired
    private PcsPoPlanService pcsPoPlanService;
    
    @Autowired
    private McPcsSkuService mcPcsSkuService;
    
    @Autowired
    private McPcsSupplierService mcPcsSupplierService;
    
    @Autowired
    private PcsPurchaseOrderService pcsPurchaseOrderService;
    
    @Autowired
    private McPcsBrandService mcPcsBrandService;
    
    @Autowired
    private TaskExecutor scheduler;

    @Autowired
    private EmailSendService emailSendService;
    
    @Autowired
    private PcsFlowerDeliveryService pcsFlowerDeliveryService;

		@Autowired
	  private PcsPoPlanMapper pcsPoPlanMapper;

	  @Autowired
	  private PcsPurchaseOrderMapper pcsPurchaseOrderMapper;

    @Override
    public void cronSynPoPlanAndLine() {
        List<PcsPoPlan> poPlanList = pcsPoPlanService.findPoPlanByStatus(PcsPoPlan.PLAN_STATUS_WAITING_IN);
        if (CollectionUtils.isNotEmpty(poPlanList)) {
            for (PcsPoPlan poPlan : poPlanList) {
                try {
                    pcsPoPlanService.synPoPlanAndLine(poPlan);
                } catch (Exception e) {
                    log.error("", e);
                }
            }
        }
    }

    @Override
    public void cronSendEmailByWasteAterPopFinished() {
        PcsPoPlanVO vo = new PcsPoPlanVO();
        vo.setPlanStatus(PcsPoPlan.PLAN_STATUS_FINISHED);
        vo.setWarnFlagStr(String.valueOf(PcsPoPlan.UNSENT_WARN_FLAG));
        vo.setReceiveDateStr(DateUtil.format(DateUtil.getNow(),DateUtil.DEFAULT_DATE_FORMAT));
        vo.setSendPopEmailOrigin(PcsPoPlanVO.SEND_POP_EMAIL_ORIGIN_CRON);
        pcsPoPlanService.sendPopEmailByCond(vo);
    }

    @Override
	public void cronSendApprovalEmail() {
		//SKU审核记录数
		PcsSkuCond cond = new PcsSkuCond();
		cond.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
		//SKU品类经理审核记录数
		PcsSkuCond managerCond = new PcsSkuCond();
		managerCond.setSkuStatus(PcsSku.SKU_STATUS_WAITING_VERIFY);
		long skuManagerQuantity = mcPcsSkuService.countSkuByCond(managerCond);
		//sku售价财务
		PcsSkuCond financeCond = new PcsSkuCond();
		financeCond.setSkuStatus(PcsSku.SKU_STATUS_WAITING_FINANCE_VERIFY);
		long skuQuantity = mcPcsSkuService.countSkuByCond(financeCond);
		//品类经理，待审核采购单
		PcsPurchaseOrderCond managerPurchaseOrderCond = new PcsPurchaseOrderCond();
		managerPurchaseOrderCond.setPoStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAITING_AUDIT);
		long managerPurchaseOrderQuantity = pcsPurchaseOrderService.countByCond(managerPurchaseOrderCond);
		//财务，待审核采购单
		PcsPurchaseOrderCond financePurchaseOrderCond = new PcsPurchaseOrderCond();
		financePurchaseOrderCond.setPoStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_FINANCE_APPROVEL);
		long financePurchaseOrderQuantity = pcsPurchaseOrderService.countByCond(financePurchaseOrderCond);
		//财务审批供应商记录数
		PcsSupplierCond pcsSupplierCond = new PcsSupplierCond();
		pcsSupplierCond.setSupplierOrderStatus(2);
		long financeSupplierQuantity = mcPcsSupplierService.countByCond(pcsSupplierCond);
		String emailContent = "您有";
		if(financeSupplierQuantity != 0L || skuQuantity != 0L) {
			
			if( skuQuantity  != 0L) {
				emailContent += skuQuantity + "个SKU";
			}
			if( skuQuantity  != 0L) {
				emailContent += financePurchaseOrderQuantity + "个采购单";
			}
			if(financeSupplierQuantity != 0L) {
				if( skuQuantity  != 0L) { 
					emailContent += "、";
				}
				emailContent += financeSupplierQuantity + "个供应商";
			}
			emailContent += "需要审批，请尽快审批。</br>去审批：http://scm.thebeastshop.com";
			//emailContent +="(财务)";
			//给财务发送邮件
			sendNotice("finance.Approval.Email", null, emailContent);
		}
		
		//planner，待审核采购单
		PcsPurchaseOrderCond pcsPurchaseOrderCond = new PcsPurchaseOrderCond();
		pcsPurchaseOrderCond.setPoStatus(2);
		long pcsPurchaseOrderQuantity = pcsPurchaseOrderService.countByCond(pcsPurchaseOrderCond);
		emailContent = "您有" + pcsPurchaseOrderQuantity +  "个采购单需要审批，请尽快审批。</br>去审批：http://scm.thebeastshop.com";
		if(pcsPurchaseOrderQuantity != 0L) {
			//emailContent +="(planning)";
			//给planning发送邮件
			sendNotice("planner.Approval.Email", null, emailContent);
		}
		PcsBrandCond pcsBrandCond = new PcsBrandCond();
		pcsBrandCond.setBrandStatus(2);
		long pcsBrandQuantity = mcPcsBrandService.countByCond(pcsBrandCond);
		emailContent = "您有" + pcsBrandQuantity +  "个品牌需要审批，请尽快审批。</br>去审批：http://scm.thebeastshop.com";
		if(pcsBrandQuantity != 0L) {
			//emailContent +="(法务)";
			//给法务发送邮件
			sendNotice("legal.Approval.Email", null, emailContent);
		}
		Map<Long, String> categoryManagerMap = new HashMap<>();

		CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.71");
		categoryManagerMap.put(71L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
		
		commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.351");
		categoryManagerMap.put(351L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
		
		commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.360");
		categoryManagerMap.put(360L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
		
		commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.345");
		categoryManagerMap.put(345L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");

		commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.262");
		categoryManagerMap.put(262L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
		
		/*categoryManagerMap.put(71L, "mingze.xia@thebeastshop.com, feng.guo@thebeastshop.com");
		commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.351");
		categoryManagerMap.put(351L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
		
		commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.360");
		categoryManagerMap.put(360L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
		
		commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.345");
		categoryManagerMap.put(345L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
		
		commGlobalConfig = PegasusUtilFacade.getInstance().findConfigByKey("category.Manager.262");
		categoryManagerMap.put(262L, commGlobalConfig != null ? commGlobalConfig.getConfigValue() : "");
		
		/*categoryManagerMap.put(71L, "mingze.xia@thebeastshop.com, feng.guo@thebeastshop.com");
		categoryManagerMap.put(351L, "mingze.xia@thebeastshop.com, feng.guo@thebeastshop.com");
		categoryManagerMap.put(360L, "mingze.xia@thebeastshop.com, feng.guo@thebeastshop.com");
		categoryManagerMap.put(345L, "mingze.xia@thebeastshop.com, feng.guo@thebeastshop.com");
		categoryManagerMap.put(262L, "mingze.xia@thebeastshop.com, feng.guo@thebeastshop.com");*/
		
		//categoryManagerMap.put(1L, "feng.guo@thebeastshop.com");
		for(Map.Entry<Long, String> entry : categoryManagerMap.entrySet()) {
			pcsSupplierCond.setCategoryManager(entry.getKey());
			pcsSupplierCond.setSupplierOrderStatus(1);
			long supplierQuantity = mcPcsSupplierService.countByCond(pcsSupplierCond);
			pcsBrandCond.setCategoryManager(entry.getKey());
			pcsBrandCond.setBrandStatus(1);
			pcsBrandQuantity = mcPcsBrandService.countByCond(pcsBrandCond);
			emailContent =  "您有";
			UserInfo userInfo = new UserInfo();
			userInfo.setEmail(entry.getValue());
			if(pcsBrandQuantity != 0L || supplierQuantity != 0L) {
				if( skuQuantity  != 0L) {
					emailContent += skuManagerQuantity + "个SKU";
				}
				if( skuQuantity  != 0L) {
					emailContent += managerPurchaseOrderQuantity + "个采购单";
				}
				if(supplierQuantity != 0L) {
					emailContent += supplierQuantity + "个供应商";
				}
				if(pcsBrandQuantity != 0L) {
					if(supplierQuantity != 0L) {
						emailContent += "、";
					}
					emailContent += pcsBrandQuantity + "个品牌";
				}
				emailContent += "需要审批，请尽快审批。</br>去审批：http://scm.thebeastshop.com";
				//emailContent += "(品类经理" + entry.getKey() + ")";
				sendNotice("", userInfo, emailContent);
			}
		}
		
	}
	
	   /**
     * 审批通知
     */
	
    private void  sendNotice(final String configKey, final UserInfo userInfo, final String content) {
    	scheduler.execute(new Runnable() {
			@Override
			public void run() {
				try {
		    		CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance()
		       				.findConfigByKey(configKey);
		    		System.out.println(configKey);
		    		
		     		String[] toNotifyUsers = {};
		     		if(EmptyUtil.isNotEmpty(commGlobalConfig)) {
		     			toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
		     		}
		    	
		    		EmailVO emailVO = new EmailVO();
		    		if(userInfo != null ) {
		     			String[]  categoryManager = userInfo.getEmail().split(",");
		     			emailVO.setToAddressList(Arrays.asList(categoryManager));
		    		} else {
		    			emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
		    		}
		    		emailVO.setSubject("审批提醒");
		    		emailVO.setContent(content);
		    		// 发邮件
		    		if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
		    			// 正式环境发邮件
                        emailSendService.send(emailVO);
		    		}
				} catch (Exception e) {
					e.printStackTrace();
				}
		    	 
			}
		});
    	
    }

	@Override
	public void flowerStockWarning() {
		StringBuffer emailContent = new StringBuffer();
		emailContent.append(
				"<html><style>#table-5 thead th {background-color: rgb(156, 186, 95);color: #fff;border-bottom-width: 0;}");
		emailContent.append("#table-5 td {color: #000;}");
		emailContent.append(
				"#table-5 tr, #table-5 th {border-width: 1px;border-style: solid;border-color: rgb(156, 186, 95);}");
		emailContent.append(
				"#table-5 td, #table-5 th {padding: 5px 10px;font-size: 12px;font-family: Verdana;font-weight: bold;}</style>");
		
		emailContent.append(
				"</br>---------库存提醒--------</br><table id='table-5'><thead><th>SKU</th><th>SKU中文名</th><th>自营可售数量</th><th>天猫可售数量</th></thead>");
		emailContent.append("<tbody>");
		
		List<PcsFlowerMerchantibleVO> voList = pcsFlowerDeliveryService.getFlowerSellNumber();
		if(EmptyUtil.isNotEmpty(voList)) {
			for(PcsFlowerMerchantibleVO vo : voList) {
				emailContent.append("<tr>");
				emailContent.append("<td>" + vo.getSkuCode() + "</td>");
				emailContent.append("<td>" + vo.getSkuName() + "</td>");
				emailContent.append("<td>" + (vo.getPlanQuantity() - vo.getSoldQuantity()) + "</td>");
				emailContent.append("<td>" + (vo.getTmallPlanQuantity() - vo.getTmallSoldQuantity()) + "</td>");
				emailContent.append("</tr>");
			}
			emailContent.append("</tbody></table></html>");
			emailContent.append("<tbody>");
			List<String> toAddressList = new ArrayList<>();
			toAddressList.add( "feng.guo@thebeastshop.com");
			//价格折扣发送不同的邮箱组
			
			CommGlobalConfig commGlobalConfig = PegasusUtilFacade.getInstance()
       				.findConfigByKey("flower.delivery.StockWarn");
			
			String[] toNotifyUsers = {};
     		if(EmptyUtil.isNotEmpty(commGlobalConfig)) {
     			toNotifyUsers = commGlobalConfig.getConfigValue().split(",");
     		}
			// 邮件VO
			EmailVO emailVO = new EmailVO();
			emailVO.setToAddressList(Arrays.asList(toNotifyUsers));
			emailVO.setSubject("月送鲜花库存预警");
			emailVO.setContent(emailContent.toString());
			// 发邮件
			if (CollectionUtils.isNotEmpty(emailVO.getToAddressList())) {
				// 正式环境发邮件
                emailSendService.send(emailVO);
			}
		}
		
		
	}

	@Override
	public void flowerFinishStateChange() {
//		pcsFlowerDeliveryService.flowerFinishStateChange();
		pcsFlowerDeliveryService.updateFlowerFinishStateChange();
	}

	@Override
    @Transactional
	public void closePop() {
		List<PcsPoPlan> poPlanList =  pcsPoPlanMapper.findNeedToClosedPOP();
		if(EmptyUtil.isNotEmpty(poPlanList)) {
            closePopAndCommand(poPlanList,true,false);
		}
	}

    @Override
    @Transactional
    public List<Long> closePoAndPopOnEveryDayTiming(List<PcsPoPlan> poPlanList) {
        if(EmptyUtil.isNotEmpty(poPlanList)) {
            closePopAndCommand(poPlanList,false,true);
        }
        // 此处不再关闭采购单
        // return closePurchaseOrder();
        return Collections.singletonList(1L);
    }

    private void closePopAndCommand(List<PcsPoPlan> poPlanList,boolean checkPop,boolean checkCommand){
        if(EmptyUtil.isNotEmpty(poPlanList)) {
            for(PcsPoPlan pcsPoPlan : poPlanList) {
                try{
                    if (checkPop){
                        pcsPoPlanService.closePoPlanByPlanId(pcsPoPlan.getId());
                        int result = pcsPoPlanMapper.isAllPoPlanFinished(pcsPoPlan.getPoId());
                        //如果po下只存在已关闭或已完成的pop,po状态需变更为待收货
                        PcsPurchaseOrder pcsPurchaseOrder = pcsPurchaseOrderService.findPoById(pcsPoPlan.getPoId());
                        boolean isUpdate = !pcsPurchaseOrder.getPurchaseOrderStatus().equals(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                        if(result == 0 && isUpdate) {
                            pcsPurchaseOrder = new PcsPurchaseOrder();
                            pcsPurchaseOrder.setId(pcsPoPlan.getPoId());
                            pcsPurchaseOrder.setPurchaseOrderStatus(PcsPurchaseOrder.PURCHASE_ORDER_STATUS_WAIT_RECEIVE);
                            pcsPurchaseOrderMapper.updateByPrimaryKeySelective(pcsPurchaseOrder);
                        }
                    }else if(checkCommand){
                        pcsPoPlanService.closePoPlanByPlanIdCheckCommand(pcsPoPlan.getId(),pcsPoPlan.getWhCommandId());
                    }
                }catch (Exception e){
                    e.getMessage();
                }
            }
        }
    }

    @Override
    public List<Long> closePurchaseOrder() {
        List<PcsPurchaseOrder> purchaseOrders = pcsPurchaseOrderService.findNeedToClosedPO();
        List<Long> poIds = new ArrayList<>();
        if (EmptyUtil.isNotEmpty(purchaseOrders)) {
            for (PcsPurchaseOrder pcsPurchaseOrder : purchaseOrders) {
                try {
                    boolean result = pcsPurchaseOrderService.closePurchaseOrder(pcsPurchaseOrder.getId());
                    if (result){
                        poIds.add(pcsPurchaseOrder.getId());
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return poIds;
    }
}
