package com.thebeastshop.pegasus.service.purchase.service.impl;

import java.util.*;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateTplMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTplFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTplService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;

@Service("pcsCertificateTplService")
public class PcsCertificateTplServiceImpl implements PcsCertificateTplService{
	
	@Autowired
	private PcsCertificateTplMapper pcsCertificateTplMapper;
	
	@Autowired
	private PcsCertificateTplFieldService pcsCertificateTplFieldService;
	
	@Override
	public List<PcsCertificateTplVO> findAll(){
		return pcsCertificateTplMapper.findAll();
	}
	
	@Override
	public PcsCertificateTplVO findById(Long id,boolean cascade) {
		PcsCertificateTplVO vo = pcsCertificateTplMapper.findById(id);
		if(cascade){
			findTplCascadeInfo(vo);
		}
		return vo;
	}

    @Override
    public PcsCertificateTplVO findCerTplVOsByCond(PcsCertificateTplVO tplVO) {
        List<PcsCertificateTplVO> tplVOs = listCerTplVOsByCond(tplVO);
        if (CollectionUtils.isNotEmpty(tplVOs)){
            return tplVOs.get(0);
        }
        return null;
    }

    @Override
    public List<PcsCertificateTplVO> listCerTplVOsByCond(PcsCertificateTplVO tplVO) {
        return pcsCertificateTplMapper.listCerTplVOsByCond(tplVO);
    }

    @Override
	public List<PcsCertificateTplVO> findByIds(List<Long> ids, boolean cascade) {
		List<PcsCertificateTplVO> tplList = pcsCertificateTplMapper.findByIds(ids);
		if(EmptyUtil.isEmpty(tplList) || !cascade){
			return tplList;
		}
		Map<Long,List<PcsCertificateTplFieldVO>> cerTplFieldMap = pcsCertificateTplFieldService.findByTplIds(ids);
		for(PcsCertificateTplVO tplVO : tplList){
			tplVO.setTplFieldVOList(cerTplFieldMap.get(tplVO.getId()));
		}
		return tplList;
	}

	@Override
	public PcsCertificateTplVO findByCategoryId(Long categoryId,boolean cascade) {
		PcsCertificateTplVO vo = pcsCertificateTplMapper.findByCategoryId(categoryId);
		if(cascade){
			findTplCascadeInfo(vo);
		}
		return vo;
	}
	
	@Override
	public PcsCertificateTplVO findBySkuCode(String skuCode){
		PcsCertificateTplVO vo = pcsCertificateTplMapper.findBySkuCode(skuCode);
		findTplCascadeInfo(vo);
		return vo;
	}

	@Override
	@Transactional
	public void save(PcsCertificateTplVO vo){
		pcsCertificateTplMapper.insert(vo);
		saveTplCategory(vo);
	}

    @Override
	@Transactional
	public void copyCerTpl(PcsCertificateTplVO vo){
		pcsCertificateTplMapper.insert(vo);
		saveTplCategory(vo);
	}

	@Override
	@Transactional
	public void saveWithTplFields(PcsCertificateTplVO vo) {
		save(vo);
		if(EmptyUtil.isNotEmpty(vo.getTplFieldVOList())){
			for(PcsCertificateTplFieldVO tplFieldVO : vo.getTplFieldVOList()){
				tplFieldVO.setCertificateTplId(vo.getId());
				pcsCertificateTplFieldService.save(tplFieldVO);
			}
		}
	}

	@Override
	@Transactional
	public void update(PcsCertificateTplVO vo) {
		updateTplFieldTypeSet(vo);
		saveTplCategory(vo);
		PcsCertificateTplVO old = pcsCertificateTplMapper.findById(vo.getId());
		vo.setCreateUserId(old.getCreateUserId());
		vo.setCreateTime(old.getCreateTime());
		pcsCertificateTplMapper.updateByPrimaryKey(vo);
	}

	@Override
	@Transactional
	public void updateWithTplFields(PcsCertificateTplVO vo) {
		pcsCertificateTplFieldService.deleteByTplId(vo.getId());
		if(EmptyUtil.isNotEmpty(vo.getTplFieldVOList())){
			for(PcsCertificateTplFieldVO tplFieldVO : vo.getTplFieldVOList()){
				tplFieldVO.setCertificateTplId(vo.getId());
				pcsCertificateTplFieldService.save(tplFieldVO);
			}
		}
		saveTplCategory(vo);
		pcsCertificateTplMapper.updateByPrimaryKeySelective(vo);

	}

	@Override
	@Transactional
	public void updateBasic(PcsCertificateTplVO vo) {
		pcsCertificateTplMapper.updateByPrimaryKeySelective(vo);	
	}
	
	//获取模板级联信息
	private void findTplCascadeInfo(final PcsCertificateTplVO vo){
		if(NullUtil.isNotNull(vo)){
			List<PcsCertificateTplFieldVO> tplFieldList = pcsCertificateTplFieldService.findByTplId(vo.getId());
			vo.setTplFieldVOList(tplFieldList);
			List<Long> categoryIds = pcsCertificateTplMapper.findCategoryIdByTplId(vo.getId());
			vo.setCategoryIds(categoryIds);
		}
	}

	@Override
	public List<Long> findUsedCategoryIds() {
		return pcsCertificateTplMapper.findUsedCategoryIds();
	}

	@Override
	public PcsCertificateTplVO findCommonUseTpl(boolean cascade) {
		PcsCertificateTplVO vo = pcsCertificateTplMapper.findCommonUseTpl();
		if(NullUtil.isNotNull(vo) && cascade){
			findTplCascadeInfo(vo);
		}
		return vo;
	}

	@Override
	public String getFieldDicValue(Long tplFieldDicId, String skuCode, String barCode) {
		return pcsCertificateTplFieldService.getFieldDicValue(tplFieldDicId,skuCode,barCode);
	}

	@Override
	public void fullCerTplDefaultValue(PcsCertificateTplVO cerTplVO, String skuCode) {
		if(EmptyUtil.isEmpty(cerTplVO.getTplFieldVOList())){
			return;
		}
		for(PcsCertificateTplFieldVO tplField : cerTplVO.getTplFieldVOList()){
//			if(PcsCertificateTplFieldVO.WRITE_TYPE_SKUINFO.equals(tplField.getWriteType())){
			if (null != tplField.getFieldDicId()) {
				String value = pcsCertificateTplFieldService.getFieldDicValue(tplField.getFieldDicId(),skuCode,"");
				tplField.setDefaultValue(value);

			}
//			}
		}
	}

	private void updateTplFieldTypeSet(PcsCertificateTplVO vo){
		//跟新标签字段尺寸
		PcsCertificateTplVO oldVO = pcsCertificateTplMapper.findById(vo.getId());
		String avaliableSize = vo.getAvaliableSize(),oldAvaliableSize = oldVO.getAvaliableSize();
		if(EmptyUtil.isEmpty(oldAvaliableSize)){
			return;
		}
		List<String> oldSizeList = Arrays.asList(oldAvaliableSize.split(","));
		if(EmptyUtil.isNotEmpty(avaliableSize)){
			List<String> sizeList = Arrays.asList(avaliableSize.split(","));
			List<String> tmpList = new ArrayList<>();
			for(String  oldSize :oldSizeList){
				if(!sizeList.contains(oldSize)){
					tmpList.add(oldSize);
				}
			}
			oldSizeList = tmpList;
		}
		if(EmptyUtil.isEmpty(oldSizeList)){
			return;
		}
		pcsCertificateTplFieldService.deleteTplFieldTypeSet(vo.getId(),oldSizeList);
	}

	private void saveTplCategory(PcsCertificateTplVO vo){
		pcsCertificateTplMapper.deleteTplCategoryByTplId(vo.getId());
		if(EmptyUtil.isNotEmpty(vo.getCategoryIds())){
			List<Long> usedCategoryIds = findUsedCategoryIds();
			if(EmptyUtil.isNotEmpty(usedCategoryIds)){
				usedCategoryIds.retainAll(vo.getCategoryIds());
				if(EmptyUtil.isNotEmpty(usedCategoryIds)){
					throw new PurchaseException("存在已关联模板的类目");
				}
			}
			for(Long categoryId : vo.getCategoryIds()){
				pcsCertificateTplMapper.insertTplCategory(categoryId, vo.getId());
			}
		}
	}


}
