package com.thebeastshop.pegasus.service.purchase.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateTplFieldDicMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplFieldDicVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateTplFieldMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateTplFieldTypesetMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateTplFieldExample;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateTplFieldService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplFieldTypesetVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTplFieldVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.NullUtil;

@Service("pcsCertificateTplFieldService")
public class PcsCertificateTplFieldServiceImpl implements PcsCertificateTplFieldService{

	@Autowired
	private PcsCertificateTplFieldMapper pcsCertificateTplFieldMapper;
	
	@Autowired
	private PcsCertificateTplFieldTypesetMapper pcsCertificateTplFieldTypesetMapper;

	@Autowired
	private PcsCertificateTplFieldDicMapper pcsCertificateTplFieldDicMapper;
	
	@Override
	@Transactional
	public int save(PcsCertificateTplFieldVO vo) {
		int result = pcsCertificateTplFieldMapper.insert(vo);
		if(EmptyUtil.isNotEmpty(vo.getFieldTypesetList())){
			for(PcsCertificateTplFieldTypesetVO typesetVO : vo.getFieldTypesetList()){
				typesetVO.setTplFieldId(vo.getId());
				pcsCertificateTplFieldTypesetMapper.insert(typesetVO);
			}
		}
		return result;
	}

	@Override
	@Transactional
	public int update(PcsCertificateTplFieldVO vo) {
		pcsCertificateTplFieldTypesetMapper.deleteByTplFieldId(vo.getId());
		if(EmptyUtil.isNotEmpty(vo.getFieldTypesetList())){
			for(PcsCertificateTplFieldTypesetVO typesetVO : vo.getFieldTypesetList()){
				typesetVO.setTplFieldId(vo.getId());
				pcsCertificateTplFieldTypesetMapper.insert(typesetVO);
			}
		}
		return pcsCertificateTplFieldMapper.updateByPrimaryKey(vo);
	}

	@Override
	@Transactional
	public int saveOrUpdate(PcsCertificateTplFieldVO vo) {
		if(NullUtil.isNull(vo.getId())){
			return save(vo);
		}else {
			return update(vo);
		}
	}

	@Override
	@Transactional
	public int deleteByTplId(Long certificateTplId) {
		pcsCertificateTplFieldTypesetMapper.deleteByTplId(certificateTplId);
		PcsCertificateTplFieldExample example = new PcsCertificateTplFieldExample();
		example.createCriteria().andCertificateTplIdEqualTo(certificateTplId);
		return pcsCertificateTplFieldMapper.deleteByExample(example);
	}

	@Override
	@Transactional
	public int deleteByTplFieldId(Long TplFieldId) {
		pcsCertificateTplFieldTypesetMapper.deleteByTplFieldId(TplFieldId);
		return pcsCertificateTplFieldMapper.deleteByPrimaryKey(TplFieldId);
	}

	@Override
	public List<PcsCertificateTplFieldVO> findByTplId(Long certificateTplId) {
		List<PcsCertificateTplFieldVO> fieldList = pcsCertificateTplFieldMapper.findByTplId(certificateTplId);
		if(EmptyUtil.isNotEmpty(fieldList)){
			List<PcsCertificateTplFieldTypesetVO> fieldTypesetList = pcsCertificateTplFieldTypesetMapper.findByTplId(certificateTplId);
			Map<Long,List<PcsCertificateTplFieldTypesetVO>> fieldTypesetMap = new HashMap<>();
			if(EmptyUtil.isNotEmpty(fieldTypesetList)){
				for(PcsCertificateTplFieldTypesetVO typesetVO : fieldTypesetList){
					List<PcsCertificateTplFieldTypesetVO> tmpList = fieldTypesetMap.get(typesetVO.getTplFieldId());
					if(NullUtil.isNull(tmpList)){
						tmpList = new ArrayList<>();
						fieldTypesetMap.put(typesetVO.getTplFieldId(), tmpList);
					}
					tmpList.add(typesetVO);
				}
			}
			for(PcsCertificateTplFieldVO fieldVO : fieldList){
				List<PcsCertificateTplFieldTypesetVO> tmpList = fieldTypesetMap.get(fieldVO.getId());
				if(EmptyUtil.isNotEmpty(tmpList)){
					fieldVO.setFieldTypesetList(tmpList);
				}
			}
		}
		return fieldList;
	}

	@Override
	public Map<Long,List<PcsCertificateTplFieldVO>> findByTplIds(List<Long> tplIds) {
		Map<Long,List<PcsCertificateTplFieldVO>> cerTplFieldMap =new HashMap<>();
		List<PcsCertificateTplFieldVO> fieldList = pcsCertificateTplFieldMapper.findByTplIds(tplIds);
		if(EmptyUtil.isNotEmpty(fieldList)){
			List<PcsCertificateTplFieldTypesetVO> fieldTypesetList = pcsCertificateTplFieldTypesetMapper.findByTplIds(tplIds);
			Map<Long,List<PcsCertificateTplFieldTypesetVO>> fieldTypesetMap = new HashMap<>();
			if(EmptyUtil.isNotEmpty(fieldTypesetList)){
				for(PcsCertificateTplFieldTypesetVO typesetVO : fieldTypesetList){
					List<PcsCertificateTplFieldTypesetVO> tmpList = fieldTypesetMap.get(typesetVO.getTplFieldId());
					if(NullUtil.isNull(tmpList)){
						tmpList = new ArrayList<>();
						fieldTypesetMap.put(typesetVO.getTplFieldId(), tmpList);
					}
					tmpList.add(typesetVO);
				}
			}
			List<PcsCertificateTplFieldDicVO> fieldDicList = findAllCerTplFieldDic();
			Map<Long,PcsCertificateTplFieldDicVO> dicMap = new HashMap<>();
			if(EmptyUtil.isNotEmpty(fieldDicList)){
				for(PcsCertificateTplFieldDicVO dic : fieldDicList){
					dicMap.put(dic.getId(),dic);
				}
			}
			for(PcsCertificateTplFieldVO fieldVO : fieldList){
				List<PcsCertificateTplFieldVO> tmpFieldList = cerTplFieldMap.get(fieldVO.getCertificateTplId());
				if(NullUtil.isNull(tmpFieldList)){
					tmpFieldList = new ArrayList<>();
					cerTplFieldMap.put(fieldVO.getCertificateTplId(),tmpFieldList);
				}
				tmpFieldList.add(fieldVO);
				List<PcsCertificateTplFieldTypesetVO> tmpList = fieldTypesetMap.get(fieldVO.getId());
				if(EmptyUtil.isNotEmpty(tmpList)){
					fieldVO.setFieldTypesetList(tmpList);
				}
				fieldVO.setCertificateTplFieldDicVO(dicMap.get(fieldVO.getFieldDicId()));
			}
		}
		return cerTplFieldMap;
	}


	@Override
	public PcsCertificateTplFieldVO findTplFieldVO(Long tplId, Long tplFieldId) {
		PcsCertificateTplFieldVO tplFieldVO = pcsCertificateTplFieldMapper.findByTplIdTplFieldId(tplId,tplFieldId);
		if(NullUtil.isNotNull(tplFieldVO)){
			List<PcsCertificateTplFieldTypesetVO> fieldTypesetList = pcsCertificateTplFieldTypesetMapper.findByTplFieldId(tplFieldId);
			if (CollectionUtils.isNotEmpty(fieldTypesetList)){
                for (PcsCertificateTplFieldTypesetVO vo : fieldTypesetList){
                    vo.setCerName(vo.getCerSize());
                    vo.setCerSize(EmptyUtil.isNotEmpty(vo.getCerSize())?vo.getCerSize().replaceAll("\\*",""):"");
                }
            }
            tplFieldVO.setFieldTypesetList(fieldTypesetList);
		}
		return tplFieldVO;
	}

	@Override
	public void deleteTplFieldTypeSet(Long tplId, List<String> delTypeSetList) {
		pcsCertificateTplFieldTypesetMapper.deleteTplFieldTypeSet(tplId,delTypeSetList);
	}

	/**
	 * 查询字段字段
	 * */
	@Override
	public List<PcsCertificateTplFieldDicVO> findAllCerTplFieldDic() {
		return pcsCertificateTplFieldDicMapper.findAll();
	}

    @Override
	public PcsCertificateTplFieldDicVO findTplFieldDicById(Long tplFieldDicId) {
		return pcsCertificateTplFieldDicMapper.findTplFieldDicById(tplFieldDicId);
	}

	@Override
	public String getFieldDicValue(Long tplFieldDicId, String skuCode, String barCode) {
		PcsCertificateTplFieldDicVO dic = pcsCertificateTplFieldDicMapper.findTplFieldDicById(tplFieldDicId);
		if(NullUtil.isNull(dic)){
			throw new PurchaseException(PurchaseExceptionErrorCode.STATUS_NOT_EXPECTED,"模板字典不存在");
		}
		String sql = dic.getFieldTable();
		sql = sql.replaceAll("[?]", "'"+skuCode+"'");
		sql = sql.replaceAll("[#]", "'"+barCode+"'");
		return pcsCertificateTplFieldDicMapper.getQueryValue(sql);
	}

	@Override
	public String getFieldDicValue(String sqlTpl, String skuCode) {
		String sql = sqlTpl.replaceAll("[?]", "'"+skuCode+"'");
		return pcsCertificateTplFieldDicMapper.getQueryValue(sql);
	}
}
