package com.thebeastshop.pegasus.service.purchase.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.service.purchase.cond.PcsCertificateFieldCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateFieldMapper;
import com.thebeastshop.pegasus.service.purchase.dao.PcsCertificateSkuFieldMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsCertificateField;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateFieldService;
import com.thebeastshop.pegasus.service.purchase.service.PcsCertificateSkuFieldService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateSkuFieldVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsCertificateTagFieldValueVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

@Service("pcsCertificateFieldService")
public class PcsCertificateFieldServiceImpl implements PcsCertificateFieldService{
	
	
	private static final Logger log = LoggerFactory.getLogger(PcsCertificateFieldServiceImpl.class);
	 
	@Autowired
	private PcsCertificateFieldMapper PcsCertificateFieldMapper;
	 
	@Autowired
	private PcsCertificateSkuFieldMapper pcsCertificateSkuFieldMapper;
	
	@Autowired
	private PcsCertificateSkuFieldService pcsCertificateSkuFieldService;

	@Override
	public boolean create(PcsCertificateField field) {
		boolean result = PcsCertificateFieldMapper.insert(field)==1?true:false;
		if(result){
			field.setFieldCode("CF"+field.getId());
			PcsCertificateFieldMapper.updateByPrimaryKeySelective(field);
		}
		return result;
	}

	@Override
	public boolean update(PcsCertificateField field) {
		return PcsCertificateFieldMapper.updateByPrimaryKey(field)==1?true:false;
	}

	@Override
	public boolean deleteById(int id) {
		PcsCertificateField del = new PcsCertificateField();
		del.setId(id);
		del.setIsDelete(PcsCertificateFieldVO.DELETE_YES);
		return PcsCertificateFieldMapper.updateByPrimaryKey(del)==1?true:false;
	}

	@Override
	public List<PcsCertificateFieldVO> findPcsCertificateField(
			PcsCertificateFieldCond cond) {
		return PcsCertificateFieldMapper.findPcsCertificateField(cond);
	}

	@Override
	public PcsCertificateFieldVO findPcsCertificateFieldById(int id) {
		return PcsCertificateFieldMapper.findPcsCertificateFieldById(id);
	}

	@Override
	public List<PcsCertificateFieldVO> findPcsCertificateField(
			PcsCertificateFieldCond cond, boolean cascade) {
		List<PcsCertificateFieldVO> fields = PcsCertificateFieldMapper.findPcsCertificateField(cond);
		if(!cascade){
			return fields;
		}
		List<Integer> infoFieldIds = new ArrayList<>();
		if(EmptyUtil.isNotEmpty(fields)){
			for(PcsCertificateFieldVO field : fields ){
				Integer infoId = field.getSkuFieldId();
				if(!infoFieldIds.contains(infoId)){
					infoFieldIds.add(infoId);
				}
			}
		}
		if(EmptyUtil.isNotEmpty(infoFieldIds)){
			List<PcsCertificateSkuFieldVO> fieldInfos =pcsCertificateSkuFieldMapper.getPcsCertificateSkuFieldByIds(infoFieldIds);
			if(EmptyUtil.isNotEmpty(fieldInfos)){
				fieldInfos =pcsCertificateSkuFieldMapper.getPcsCertificateSkuFieldByIds(infoFieldIds);
				for(PcsCertificateFieldVO field : fields){
					for(PcsCertificateSkuFieldVO fieldInfo : fieldInfos){
						if(fieldInfo.getId().equals(field.getSkuFieldId())){
							PcsCertificateSkuFieldVO baseInfo = new PcsCertificateSkuFieldVO();
							BeanUtils.copyProperties(fieldInfo, baseInfo);
							field.setFieldInfo(baseInfo);
							break;
						}
					}
				}
			}
		}
		
		//尝试获取系统默认个值
		String skuCode = cond.getSkuCode();
		if(EmptyUtil.isNotEmpty(skuCode) && EmptyUtil.isNotEmpty(fields) ){
			for(PcsCertificateFieldVO field : fields){
				if(PcsCertificateFieldVO.WRITE_TYPE_INPUT.equals(field.getWriteType())
						&& EmptyUtil.isNotEmpty(field.getSkuFieldId())){
					//从sku信息中获取
					PcsCertificateSkuFieldVO fieldInfo = field.getFieldInfo();
					String value = pcsCertificateSkuFieldService.getFieldValueBySkuCode(fieldInfo, skuCode);
					field.setSysDefaultValue(value==null?"":value);
				}else if( PcsCertificateFieldVO.WRITE_TYPE_INPUT.equals(field.getWriteType()) ){
					//使用字段默认值
					field.setSysDefaultValue(field.getDefaultValue()==null?"":field.getDefaultValue());
				}else if(PcsCertificateFieldVO.WRITE_TYPE_SYS.equals(field.getWriteType())){
					//系统获取
//					PcsCertificateSkuFieldVO fieldInfo = field.getFieldInfo();
//					String sql = buildFieldQuerySql(fieldInfo,skuCode);
//					String value = pcsCertificateSkuFieldMapper.getQueryValue(sql);
					String value = "";
					field.setSysDefaultValue(value==null?"":value);
				}
				
			}
		}
		
		
		
		return fields;
	}
	
	private String buildFieldQuerySql(PcsCertificateSkuFieldVO fieldInfo ,String skuCode){
		String sql = fieldInfo.getFieldTable();
		sql = sql.replaceAll("[?]", "'"+skuCode+"'");
		return sql;
	}

	
	@Override
	public List<PcsCertificateTagFieldValueVO> getTagsBySkuCode(List<String> skuCodes) {
		List<PcsCertificateTagFieldValueVO> list = PcsCertificateFieldMapper.getTagsBySkuCode(skuCodes);
		return list;
	}
}
