package com.thebeastshop.pegasus.service.purchase.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.merchandise.cond.PcsBuyerCond;
import com.thebeastshop.pegasus.merchandise.service.McPcsBuyerInfoService;
import com.thebeastshop.pegasus.merchandise.vo.PcsBuyerInfoVO;
import com.thebeastshop.pegasus.service.purchase.dao.PcsCategoryCostCenterMapper;
import com.thebeastshop.pegasus.service.purchase.model.PcsCostCenter;
import com.thebeastshop.pegasus.service.purchase.service.PcsCategoryCostCenterService;

@Service("pcsCategoryCostCenterService")
public class PcsCategoryCostCenterServiceImpl implements PcsCategoryCostCenterService {

	@Autowired
	private McPcsBuyerInfoService mcPcsBuyerInfoService;
	
	@Autowired
	private PcsCategoryCostCenterMapper pcsCategoryCostCenterMapper;

	@Override
	public List<PcsCostCenter> selectPcsCategoryCostCenterByLoginId(Long loginUserId,Boolean isFindAll) {
		PcsBuyerCond cond = new PcsBuyerCond();
		//cond.setLoginUserId(loginUserId);
		List<PcsBuyerInfoVO> pcsBuyerInfoList = mcPcsBuyerInfoService.getBuyerByCond(cond);

		Map<String,Object> params = new HashMap<String, Object>();
		List<Long> categoryIdList = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(pcsBuyerInfoList)){
			for(PcsBuyerInfoVO vo : pcsBuyerInfoList){
				String bc = vo.getBussinessCategory();
				if(StringUtils.isNotBlank(bc)){
					String arr[] = bc.split(",");
					if(arr != null){
						for(String str : arr){
							categoryIdList.add(Long.parseLong(str));
						}
					}
				}
			}
			if(CollectionUtils.isNotEmpty(categoryIdList)){
				params.put("categoryIdList", categoryIdList);
			}
		}

		if(!isFindAll){
			if(params.size() == 0){
				return null; 
			}
		}

		return pcsCategoryCostCenterMapper.findPcsCategoryCostCenterByParams(params);
	}
}
