package com.thebeastshop.pegasus.service.purchase.service.impl;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageRowBounds;
import com.thebeastshop.common.converter.GenericBeanConverter;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.cond.PcsBaseTaxRateCond;
import com.thebeastshop.pegasus.service.purchase.dao.PcsBaseTaxRateMapper;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseException;
import com.thebeastshop.pegasus.service.purchase.exception.PurchaseExceptionErrorCode;
import com.thebeastshop.pegasus.service.purchase.model.PcsBaseTaxRate;
import com.thebeastshop.pegasus.service.purchase.service.PcsBaseTaxRateService;
import com.thebeastshop.pegasus.service.purchase.vo.PcsBaseTaxRateVO;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Service("pcsBaseTaxRateService")
public class PcsBaseTaxRateServiceImpl implements PcsBaseTaxRateService {

  @Autowired
  private McPcsSkuService mcPcsSkuService;
  @Autowired
  private PcsBaseTaxRateMapper pcsBaseTaxRateMapper;
  
  protected GenericBeanConverter beanConverter = new GenericBeanConverter();

  @Override
  @Transactional
  public int batchInsert(List<PcsBaseTaxRateVO> taxRateList, List<PcsBaseTaxRateVO> newTaxRateList) {
    if (EmptyUtil.isEmpty(taxRateList)) {
      throw new PurchaseException(PurchaseExceptionErrorCode.ILLEGAL_PARAM, "批量插入列表不能为空");
    }
    pcsBaseTaxRateMapper.batchInsert(convertVO2PO(taxRateList));
    updateSkuTaxIdInfo(newTaxRateList);
    return 1;
  }

  private void updateSkuTaxIdInfo(List<PcsBaseTaxRateVO> newTaxRateList) {
    List<String> oldTaxIdList = new ArrayList<String>();
    for (PcsBaseTaxRateVO newTaxRate : newTaxRateList) {
      oldTaxIdList.add(newTaxRate.getTaxId());
    }
    if (EmptyUtil.isNotEmpty(oldTaxIdList)) {
      List<PcsSkuVO> skuList = mcPcsSkuService.findSkuByTaxIdList(oldTaxIdList);
      if (EmptyUtil.isNotEmpty(skuList)) {
        for (PcsSkuVO pcsSkuVO : skuList) {
          String taxId = pcsSkuVO.getGoodsHscode();
          for (PcsBaseTaxRateVO newTaxRate : newTaxRateList) {
            if (taxId.equals(newTaxRate.getTaxId())) {
              buildSkuNewTaxIdInfo(pcsSkuVO, newTaxRate);
            }
          }
        }
      }
      mcPcsSkuService.updateSkus(skuList);
    }

  }

  private void buildSkuNewTaxIdInfo(PcsSkuVO pcsSkuVO, PcsBaseTaxRateVO pcsBaseTaxRateVO) {
    pcsSkuVO.setGoodsHscode(pcsBaseTaxRateVO.getNewTaxId());
    pcsSkuVO.setSaleTax(pcsBaseTaxRateVO.getSkuSaleTax());
    pcsSkuVO.setVatRate(pcsBaseTaxRateVO.getSkuVatRate().multiply(new BigDecimal(100)));
    pcsSkuVO.setGoodsLegalUnitcode(pcsBaseTaxRateVO.getGoodsLegalUnitcode());
    pcsSkuVO.setSecondLegalUnitcode(pcsBaseTaxRateVO.getSecondLegalUnitcode());
  }

  @Override
  public PcsBaseTaxRateVO findPcsBaseTaxRateById(String id) {
    PcsBaseTaxRate pcsBaseTaxRate = pcsBaseTaxRateMapper.selectByPrimaryKey(id);
    return convertPO2VO(pcsBaseTaxRate);
  }

  @Override
  public PageInfo<PcsBaseTaxRateVO> findPageBaseTaxRateByCond(PcsBaseTaxRateCond taxRateCond) {
    int offset = taxRateCond.getCurrpage() * taxRateCond.getPagenum();
    PageRowBounds pageRowBounds = new PageRowBounds(offset, taxRateCond.getPagenum());
    List<PcsBaseTaxRate> resultList = pcsBaseTaxRateMapper.selectPageBaseTaxRateByCond(taxRateCond, pageRowBounds);
    PageInfo<PcsBaseTaxRateVO> pageInfo = new PageInfo<PcsBaseTaxRateVO>(convertPO2VO(resultList));
    pageInfo.setTotal(pageRowBounds.getTotal());
    return pageInfo;
  }

  @Override
  public List<PcsBaseTaxRate> convertVO2PO(List<PcsBaseTaxRateVO> taxRateList) {
    List<PcsBaseTaxRate> poList = new ArrayList<PcsBaseTaxRate>();
    for (PcsBaseTaxRateVO vo : taxRateList) {
      PcsBaseTaxRate po = new PcsBaseTaxRate();
      BeanUtils.copyProperties(vo, po);
      if (EmptyUtil.isNotEmpty(vo.getVatRate())) {
        po.setVatRate(new BigDecimal(vo.getVatRate()));
      }
      poList.add(po);
    }
    return poList;
  }

  @Override
  public List<PcsBaseTaxRateVO> convertPO2VO(List<PcsBaseTaxRate> poList) {
    List<PcsBaseTaxRateVO> voList = new ArrayList<PcsBaseTaxRateVO>();
    if (EmptyUtil.isNotEmpty(poList)) {
      for(PcsBaseTaxRate po : poList) {
        voList.add(convertPO2VO(po));
      }
    }
    return voList;
  }

  @Override
  public PcsBaseTaxRateVO convertPO2VO(PcsBaseTaxRate po) {
    PcsBaseTaxRateVO vo = new PcsBaseTaxRateVO();
    BeanUtils.copyProperties(po, vo);
    if (EmptyUtil.isNotEmpty(po.getVatRate())) {
      vo.setVatRate(String.valueOf(po.getVatRate()));
    }
    return vo;
  }

  @Override
  public PcsBaseTaxRateVO findBaseTaxRateByTaxId(String taxId) {
    PcsBaseTaxRate po = pcsBaseTaxRateMapper.selectBaseTaxRateByTaxId(taxId);
    return po == null ? null : convertPO2VO(po);
  }

  @Override
  public List<String> findAllTaxId() {
    return pcsBaseTaxRateMapper.selectAllTaxId();
  }

	@Override
	public List<PcsBaseTaxRateVO> findBaseTaxRateByNameOrCode(String arg0) {
		List<PcsBaseTaxRateVO> pcsBaseTaxRateVOList = new ArrayList<>();
        if (EmptyUtil.isEmpty(arg0)) {
            return Collections.emptyList();
        }
        List<PcsBaseTaxRate> voList = pcsBaseTaxRateMapper.findBaseTaxRateByNameOrCode(arg0);
        pcsBaseTaxRateVOList = beanConverter.converterListFrom(voList, PcsBaseTaxRateVO.class);
        if (CollectionUtils.isEmpty(pcsBaseTaxRateVOList)) {
            return Collections.emptyList();
        } else {
            return pcsBaseTaxRateVOList;
        }
	}
}
