/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeCond;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcRecipeSkuCond;
import com.thebeastshop.pegasus.service.purchase.model.PrdcRecipeSku;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeMaterialVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeSkuVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrdcRecipeVO;

import java.util.List;

public interface PrdcRecipeSkuService {

    /**
     * 根据主键查找配方
     * @param id
     * @return
     */
    PrdcRecipeSkuVO findRecipeSkuVOById(Long id);

    /**
     * 根据配方ID查找配方行
     * @param recipeId
     * @return
     */
    List<PrdcRecipeSkuVO> findRecipeSkuVOByRecipeId(Long recipeId);

    /**
     * 根据配方ID查找配方行
     * @param recipeId
     * @return
     */
    List<PrdcRecipeSkuVO> findRecipeSkuVOByCond(String skuCode,Long recipeId);

    /**
     * 获取配方成品SKU图片
     * @param cond 条件
     * @return
     */
    List<PrdcRecipeSkuVO> findRecipeSkuVOByCond(PrdcRecipeSkuCond cond);

    /**
     * 创建配方
     *
     * @param vo
     * @return
     */
    Long create(PrdcRecipeSkuVO vo);

    /**
     * 更新配方
     * @param vo
     * @return
     */
    Boolean update(PrdcRecipeSkuVO vo);

    /**
     * 删除配方行数据
     * @param recipeId
     * @param recipeId
     * @return
     */
    Boolean deleteRecipeSku(String skuCode, Long recipeId);

    Boolean deleteRecipeSku(Long id);

}
