/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.common.Pagination;
import com.thebeastshop.pegasus.service.purchase.cond.PrdcJobCond;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJob;
import com.thebeastshop.pegasus.service.purchase.model.PrdcJobLine;
import com.thebeastshop.pegasus.service.purchase.model.PrdcPreJob;
import com.thebeastshop.pegasus.service.purchase.vo.*;

import java.util.List;
import java.util.Map;

import com.thebeastshop.wms.vo.*;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author Eric.Lou
 * @version $Id: PrdcJobService.java, v 0.1 2016-01-04 上午11:17
 */
public interface PrdcJobService {

    /**
     * 根据主键查找任务
     * @param id
     * @return
     */
    PrdcJobVO findJobVOById(Long id);

    /**
     * 根据jobCode查找任务
     * @param code
     * @return
     */
    PrdcJobVO findJobVOByCode(String code);
    /**
     * 根据配方主键查找任务
     * @param recipeId
     * @param cascade 是否级联
     * @return
     */
    List<PrdcJobVO> findJobVOByRecipeId(Long recipeId, Boolean cascade);

    /**
     * 根据任务主键查找任务行
     * @param jobId
     * @return
     */
    List<PrdcJobLineVO> findJobLineVOByJobId(Long jobId);

    /**
     * 根据条件查找任务
     * @param cond 条件
     * @param cascade 是否级联
     * @return
     */
    List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond, Boolean cascade);
    List<PrdcPreJobVO> findPreJobListByCond(PrdcJobCond cond);
    List<PrdcPreJobLineVO> findPreJobListListByPreJobId(Long preJobId);
    List<PrdcPreJobDownloadVO> findPreJobDownListByCond(PrdcJobCond cond);
    Long processPrdcPreJob(PrdcPreJobVO vo);

    Pagination<PrdcJobVO> findJobVOByCondPage(PrdcJobCond cond);

    PrdcJobCountInfo countPrdcJobByCond(PrdcJobCond cond);

    /**
     * 根据条件查找任务
     * @param cond 条件
     * @return
     */
    List<PrdcJobVO> findJobVOByCond(PrdcJobCond cond);
    
    /**
     * 查找实体VO
     *
     * @return
     */
    List<PrdcJobVO> findPrdcJobVO(boolean cascade);

    /**
     * 创建任务,并创建占用
     *
     * @param vo
     * @return
     */
    Long create(PrdcJobVO vo);
    Long createPrdcPreJob(PrdcPreJob vo);

    /**
     * 创建鲜花预加工
     * @param vo
     * @return
     */
    String createFlowerPrdcPreJob(PcsPreAllotVO vo);
    
    /**
     * 根据SKU查询加工单是否拆分类型
     * @param skuCode
     * @return
     */
    boolean isSplitBySkuCode(String skuCode);

    Integer updatePrdcPreJobByKey(PrdcPreJob prdcPreJob);
    /**
     * 退回修改任务
     *
     * @param vo
     * @return
     */
    Boolean returnModify(PrdcJobVO vo);

    /**
     * 删除任务行数据
     * @param jobId
     * @param jobLineId
     * @return
     */
    Boolean deleteJobLine(Long jobId,Long jobLineId);

    /**
     * 退回修改_取消任务
     *
     * @param jobId
     * @return
     */
    Boolean cancelJobForStatusReturnModify(Long jobId);

    /**
     * 更新生产状态
     * @param jobVO
     * @param jobVO
     * @return
     */
    Boolean startProduction(PrdcJobVO jobVO);

    /**
     * 释放占用资源并更新JOB
     * @param jobVO
     * @param whReleaseOccupationVOList
     */
    Boolean releaseJobLineOccupyAndUpdate(PrdcJobVO jobVO,List<WhReleaseOccupationVO> whReleaseOccupationVOList);


    /**
     * 更新生产状态
     * @param jobVO
     * @return
     */
    Boolean updateJobVO(PrdcJobVO jobVO);
    
    /**
     * 更新生产任务分配完成标识
     * @param jobVO
     * @return
     */
    Boolean updatePjJobVO(PrdcJobVO jobVO);
    
    /**
     * 更新生产加工分货标识
     * @param id
     * @param sign
     * @return
     */
    boolean updateProdJobById(long id, Integer sign);


    boolean updateJobConfirmToWmsReturnModify(String jobCode);

    /**
     *
     * @param jobVO
     * @param whCommands
     * @param whReleaseOccupationVOList
     * @return
     */
    Boolean createCommandsAfterReleaseThenFinishAndUpdate(PrdcJobVO jobVO,List<WhCommandVO> whCommands,
                                                          List<WhReleaseOccupationVO> whReleaseOccupationVOList)throws Exception;

    /**
     * 创建出库,仓库指令需要的参数
     * @param jobVO
     * @return whCommandList
     */
    public List<WhCommandVO> buildPrdcCommands(PrdcJobVO jobVO);

    /**
     *
     * @param prdcJobLineList
     * @param occupyType
     * @return
     */
    public List<WhReleaseOccupationVO> buildWhRelease(PrdcJob prdcJob,List<PrdcJobLine> prdcJobLineList, Integer occupyType);

    /**
     * 建立库存占用whOccupy
     * @param prdcJobLineList
     * @param warehouseCode
     * @param occupyType
     * @return
     */
    public List<WhInvOccupyVO> buildWhOccupy(PrdcJob prdcJob, List<PrdcJobLine> prdcJobLineList, String warehouseCode, Integer occupyType);

    /**
     * 获取仓库名称/编码键值对
     * @return
     */
    public List<Map<String, String>> getWarehouseList(List<String> warehouseCodeList);

    /**
     * 获取配送仓库名称
     * @return
     */
    public String getWarehouseName(String warehouseCode);


    /**
     * 获取单张生产订单最大可启动子任务数
     * @param vo
     * @return
     */
    public int getPrdcJobMaxTask(WhWmsPrdcJobTaskVO vo);

    /**
     * 计算定制商品库存数
     * */
    Map<String, WhRecipeInvVO> caculateRecipeAmountForAssemble(List<String> skuCodes, String warehouseCode);
    /**
     * 子任务完成时更新加工订单
     * */
    @Transactional
    boolean updatePrdcJobWhenTaskFinish(WhWmsPrdcJobTaskVO vo);

    public List<Map<String,Object>> getWmsPrdcJobTaskFinishedInfo(List<String> prdcJobCodes);

    List<PrdcJob> getPrdcJobProcessingOrPartFinished(List<String> codes);

    /**
     *
     * @param prdcJobLineVOList
     * @param occupyType
     * @return
     */
    public List<WhReleaseOccupationVO> buildWhRelease(List<PrdcJobLineVO> prdcJobLineVOList, Integer occupyType);

    /**
     * 建立库存占用whOccupy
     * @param prdcJobLineVOList
     * @param warehouseCode
     * @param occupyType
     * @return
     */
    public List<WhInvOccupyVO> buildWhOccupy(List<PrdcJobLineVO> prdcJobLineVOList, String warehouseCode, Integer occupyType);
    /**
     * 更新生产状态
     * @param jobVO
     * @param whInvOccupyList
     * @return
     */
    Boolean checkOccupyAndUpdate(PrdcJobVO jobVO,List<WhInvOccupyVO> whInvOccupyList);
    
    List<Long> batchCreate(List<PrdcJobVO> list);

    List<Long> batchCreate(List<PrdcJobVO> list,String allotCode);

    List<Long> batchCreateAndFinishForKafka(List<PrdcJobVO> list) throws Exception;

    boolean batchCreatePrdcJobOrAllot(final List<PrdcJobVO> jobList,final List<WhAllotRcdVO> allotList) throws Exception;

    void sendCusShortMailEmail(List<WhPackageInvVO> packageInvList,String moreInfo);

    boolean buildAllotOrPrdcJob(List<WhPackageInvVO> packageInvList,final List<PrdcJobVO> jobList,final List<WhAllotRcdVO> allotList);

    void bulidJobLine(PrdcJobVO jobVO,PrdcRecipeVO recipeVO);
    
    List<PrdcJob> findSkuReportJobVO();

    String findScmOperatorEmailByOperatorId(Long cond);

    List<PrdcJobVO> findNearestJobBySkuCodes(List<String> skuCodes);

}
