package com.thebeastshop.pegasus.service.purchase.service;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.service.purchase.cond.SkuCerCond;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCertificate;
import com.thebeastshop.pegasus.service.purchase.model.PcsSkuCertificateExample;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCerInfoExcelVO;
import com.thebeastshop.pegasus.service.purchase.vo.PcsSkuCertificateVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintCerVO;
import com.thebeastshop.pegasus.service.purchase.vo.PrintSkuCerVO;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2016/11/22.
 */
public interface PcsSkuCertificateService {

    /**
     * 查询sku 合格证相关信息
     * */
    List<PcsSkuCertificateVO> findSkuCerByCond(SkuCerCond cond);
    List<PcsSkuCertificateVO> findRecipeCerVOByCond(SkuCerCond cond);

    List<PcsSkuCerInfoExcelVO> findSkuCerExportInfoByCond(SkuCerCond cond);

    /**
     * 查询合格证
     * */
    PcsSkuCertificateVO findBySkuCode(String skuCode);

    /**
     * 查询合格证
     * */
    PcsSkuCertificateVO findBySkuCode(String skuCode,boolean cascade);

    /**
     * 查询合格证
     * */
    List<PcsSkuCertificateVO> findBySkuCodes(List<String> skuCodeList,boolean cascade);


    /**
     * 查询打印合格证数据
     * */
    List<PrintSkuCerVO> getPrintCerBySkuCodeBarCode(PrintCerVO cond);

    /**
     * 查询需要自动提交合格证的skuCode
     * */
    List<String> findSkuCodeNeedAutoSubmit();

    void save(PcsSkuCertificateVO cerVO);

    void update(PcsSkuCertificateVO cerVO);

    void saveOrUpdate(PcsSkuCertificateVO cerVO);

    boolean saveOrUpdateSkuCer(PcsSkuCertificateVO cerVO);

    void saveOrUpdate(List<PcsSkuCertificateVO> cerList);

    void saveOrUpdateStatus(PcsSkuCertificateVO cerVO);

    boolean saveSkuCerMpCode(String skuCode,String mpCodeUrl);
    
    boolean batchSaveSkuCerMpCode(Map<String,String> skuCode_mpCodeUrl);

    String findSkuCerMpCode(String skuCode);

    List<String> findSkuCerWithSalesPriceField(List<String> skuCodes);

    List<String> findSkuSalesPriceChangePreDay();

    Map<String,String> findSkuCerMpCodeMap(List<String> skuCodes);

    /**
     * 获取小程序码
     * @param skuCode
     * @return
     */
    String getOrCreateSkuCerMpCode(String skuCode);

    Integer insertOrUpdateByExampleSelective(PcsSkuCertificate record, PcsSkuCertificateExample example);
}
