/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.service.purchase.service;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPoCreditNoteCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseOrderCond;
import com.thebeastshop.pegasus.service.purchase.cond.PcsPurchaseReturnCond;
import com.thebeastshop.pegasus.service.purchase.model.*;
import com.thebeastshop.pegasus.service.purchase.vo.*;
import com.thebeastshop.pegasus.util.model.CommAudit;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * @author Eric.Lou
 * @version $Id: PcsPurchaseOrderService.java, v 0.1 2015-08-10 10:28
 */
public interface PcsPurchaseOrderService {

    /**
     * vo转model
     *
     * @param vo
     * @return
     */
    PcsPurchaseOrder buildFromVO(PcsPurchaseOrderVO vo);

    /**
     * model转vo
     *
     * @param record
     * @return
     */
    PcsPurchaseOrderVO buildFromModel(PcsPurchaseOrder record);

    /**
     * 创建采购单
     *
     * @param record
     * @return
     */
    PcsPurchaseOrder create(PcsPurchaseOrder record,  boolean saveDraft);
    Long addPcsPoCreditNoteVO(PcsPoCreditNoteVO vo);
    void deletePcsPoCreditNoteVO(PcsPoCreditNoteVO vo);
    /**
     * 更新采购单
     *
     * @param record
     * @return
     */
    boolean update(PcsPurchaseOrder record);
    /**
     * 更新采购单(修改交货日期)
     *
     * @param record
     * @return
     */
    boolean updatePurchaseOrder(PcsPurchaseOrder record);

    /**
     * 根据主键查找订购单
     *
     * @param id
     * @return
     */
    PcsPurchaseOrder findPoById(Long id);

    /**
     * 根据条件 查询采购单拥有的 抵扣记录列表
     * @param cond
     * @return
     */
    List<PcsPoCreditNote> listPcsPoCreditNoteByCond(PcsPoCreditNoteCond cond);

    List<PcsPoCreditNoteVO> listPcsPoCreditNoteVOByCond(PcsPoCreditNoteCond cond);

    List<PcsPoCreditNoteVO> listSumPoCreditNoteVOByCond(PcsPoCreditNoteCond cond);

    /**
     * 根据主键查找订购单
     *
     * @param id
     * @return
     */
    PcsPurchaseOrderVO findPoVOById(Long id);

    PcsPurchaseOrderVO findPoVOByCode(String code);

    PcsPurchaseOrder findPoByPoCode(String poCode);

    /**
     * 根据采购单对于出入库指令code查找
     * @author jim.huang
     * @date 2016年4月22日
     * @param commandCode
     * @return
     */
    PcsPurchaseOrderVO findPurchaseOrderByCommandCode(String commandCode);

    /**
     * 根据主键查找订购单
     *
     * @param code
     * @return
     */
    PcsPurchaseOrder findPoByCode(String code);

    /**
     * 根据条件查找采购单
     * @param cond
     * @return
     */
    PageInfo<PcsPurchaseOrderVO> pageQueryPOByCond(PcsPurchaseOrderCond cond);

    Map<String, Integer> countPoGroupByStatus(PcsPurchaseOrderCond cond);

    List<PcsPurchaseOrderVO> findPOVOByCond(PcsPurchaseOrderCond cond);

    /**
     * 创建采购单
     *
     * @param pcsPurchaseOrder
     * @param pcsPoLineList
     * @param saveDraft
     * @return
     */
    Long createPurchaseOrderAndLine(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, boolean saveDraft, 
    			List<PcsPurchaseOrderCost> orderCostList);

    Long createPurchaseOrderAndLine(PcsPurchaseOrderVO pcsPurchaseOrderVO);


    void checkPurchaseOrderBeforeEdit(PcsPurchaseOrderVO editVO);

    PcsPoFieldEditableInfoVO buildPoFieldEditableInfo(PcsPurchaseOrderVO info);

    /**
     * 更新采购单
     *
     * @param
     * @param pcsPoLineList
     * @param
     * @return
     */
    Boolean updatePurchaseOrderAndLine(List<PcsPoLine> pcsPoLineList,
                                       PcsPurchaseOrderVO pcsPurchaseOrderVO);

    void computeTotalPrice(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, List<PcsPurchaseOrderCost> orderCostList);

   /* void computeTotalPrice(PcsPurchaseOrderVO pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, List<PcsPurchaseOrderCost> orderCostList);*/

    /**
     * 获取warehouseCode集合
     *
     * @return
     */
    List<String> findWarehouseCodeGroup();
    List<PcsPurchaseOrderVO> findPoInfoByWarehouseCodeGroup();

    /**
     * 审核采购单
     *
     * @param id
     * @param isPass
     * @return
     */
    Boolean auditPurchaseOrder(long id, Boolean isPass, Integer type);

    /**
     * 关闭采购单,将状态置为已完成
     *
     * @param id
     * @return
     */
    Boolean closePurchaseOrder(long id);

    /**
     * 删除采购单行信息
     *
     * @param poId
     * @param pcsPoLineId
     * @return
     */
    Boolean deletePcsPoLine(long poId, long pcsPoLineId);

    int deletePcsPoLine(long poId, List<Long> delLineIds);

    /**
     * 批量删除采购单行信息
     * @param pcsPoLineVOs
     * @return
     */
    Boolean batchUpdatePcsPoLine(PcsPurchaseOrderVO pcsPoLineVOs,Long operatorId);

    void processReceicePlan(String poPlanCode, Map<String,Integer> liangpinMap, Map<String,Integer> canciMap);
    
    /**
     * 计算采购单数量
     * @param cond
     * @return
     */
    long countByCond(PcsPurchaseOrderCond cond);



    /**
     * 创建采退单
     *
     * @param
     * @return
     */
    Long createPurchaseReturnAndLine(PcsPurchaseReturn pcsPurchaseReturn, List<PcsPurchaseReturnSku> returnSkuVOList, boolean saveDraft) throws Exception;

    /**
     * 更新采退单
     *
     * @param
     * @return
     */
    Boolean updatePurchaseReturnAndLine(PcsPurchaseReturn pcsPurchaseReturn, List<PcsPurchaseReturnSku> returnSkuVOList, boolean saveDraft) throws Exception;

    /**
     * 单独更新采购单，不更新行数据
     * @param
     * @return
     */
	Boolean updatePurchaseReturn(PcsPurchaseReturn pcsPurchaseReturn);

	PcsPurchaseReturn bulidFromVO(PcsPurchaseReturnVO vo);

	PcsPurchaseReturnSku bulidFromVO(PcsPurchaseReturnSkuVO vo);

	/**
	 * 查询采退单
	 * @param cond
	 * @return
	 */
	List<PcsPurchaseReturnVO> findPRVOByCond(PcsPurchaseReturnCond cond);

	Integer countPRVOByCond(PcsPurchaseReturnCond cond);

	PcsPurchaseReturnVO findPRVOById(Long id, boolean withLine);

	List<PcsPurchaseReturnSkuVO> findPrLineByCond(PcsPurchaseReturnSku cond);

	Boolean auditPurchaseReturn(CommAudit commAudit) throws Exception;

	Boolean closePurchaseReturn(Long id);


	 /**
     * 查找供应商下面的所有采购单
     * @param
     * @return
     */
    List<PcsPurchaseOrderVO> findPOVOBySupplierId(Long supplierId);

    /**
     * （财务预算专用）根据参数查询采购成本明细
     * @param params
     * @return
     */
    List<PcsPoLineVO> findFinancePoLineVOByParams(Map<String,Object> params);
    
    /**
     * 创建采购费用
     * @param orderCostList
     * @return
     */
    List<Long> createPurchaseOrderCosts(List<PcsPurchaseOrderCost> orderCostList, Long poId); 
    
    List<Long> updatePurchaseOrderCosts(List<PcsPurchaseOrderCost> orderCostList, Long poId); 
    
    /**
     * 获取采购单付款明细
     * @param id 采购单ID
     * @return
     */
    List<PcsPurchaseOrderVO> findPoCostById(Long id);

    boolean batchUpdatePcsPoCost(PcsPoPlanCostVO pcsPoCostVO,Long operatorId);


    List<PcsCostAdjust> findCostAjustByCostIds(List<Long> costIds,Integer costType);

    /**
     * 根据条件查询进销存报表
     * @param cond
     * @return
     */
    List<PurchaseSellStockReportVO> findPssReportByCond(PcsPurchaseOrderCond cond);

    /**
     * 根据reportIds查询进销存报表
     * @param reportIds
     * @return
     */
    List<PurchaseSellStockReportVO> findPssReportByIds(List<Long> reportIds);

  /**
   * 重新打开采购单
   * @param poId
   * @param sskDeliveryDate
   * @return
   */
    int reopenPurchaseOrder(Long poId, Date sskDeliveryDate);

  /**
   * 获取当前日期已经晚于采购单要求交货日期，且状态为待收货的采购单
   * @return
   */
    List<PcsPurchaseOrder> findNeedToClosedPO();

    List<PcsPurchaseOrderVO> findNearestPurchaseOrderBySkuCodes(List<String> skuCodes);

  /**
   * 采购单进度查询
   * @param cond
   * @return
   */
    PageInfo<PcsPoProgressTrackingVO> pageQueryTrackingProgressByCond(PcsPurchaseOrderCond cond);

    List<PcsPoProgressTrackingDetailVO> queryTrackingProgressDetailByCond(PcsPurchaseOrderCond cond);

    /**
     * SKU首单
     * @param cond
     * @return
     */
    Map<String, Long> mapSkuFirstPO(PcsPurchaseOrderCond cond);

    /**
     * 查询 可自动创建POP 的POID
     * @return
     */
    List<Long> findCanAutoCreatePopPoIds();

    List<PcsPoApprovalRecords> findApprovalRecordsByPoId(Long poId);

    /**
     * 查询 PO  最新的一条审核记录
     * @param poId
     * @return
     */
    PcsPoApprovalRecords findNewestApprovalRecordsByPoId(Long poId);

    /**
     * 保存PO 审核记录
     * @return
     */
    Long savePoApprovalRecord(PcsPurchaseOrder pcsPurchaseOrder);

    Long savePoAndLineApprovalRecord(PcsPurchaseOrder pcsPurchaseOrder, List<PcsPoLine> pcsPoLineList, List<PcsPurchaseOrderCost> orderCostList);

  /**
   * 保存PO line 审核记录
   * @param lineApprovalRecords
   * @return
   */
    int savePoApprovalRecordLine(List<PcsPoLineApprovalRecord> lineApprovalRecords);

    int withdrawApproval(Long poId);

    List<PcsPoLineVO>  findPoApprovalRecordLine(Long poId);

    List<PcsPurchaseOrderCost>  findPoCostApprovalRecords(Long approvalRecordId);

    PcsPurchaseOrderVO findPoVOById(long id, boolean cascadeLine);

    List<PcsPurchaseOrderVO> listPoVOByIds(List<Long> ids, boolean cascadeLine);

  /**
   * 查询 采购单审批数据
   * @param id
   * @param cascadeLine
   * @return
   */
    PcsPurchaseOrderVO findPoVOForApprovalById(long id, boolean cascadeLine);


    PcsPurchaseOrderVO findPoVOByCond(PcsPurchaseOrderCond cond);

    /**
     * 采购单 各个SKU 实际采退良品数量
     * @param poId
     * @return
     */
    Map<String, Integer> mapRefundedGoodQuantityByPoIdAndSkuCode(Long poId);

    Map<String,Integer> computeRealityGoodQuantityByPoId(Long poId);

    List<PcsPoApprovalRecords> listPoApprovalRecords(Long poId, Integer approvalStatus);

  /**
   * 获取 PO 单审核通过次数
   * @param poId
   * @return
   */
  int getPoPassApprovalTimes(Long poId);
}
